/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.CFSMemberCheck;
import com.kingdee.eas.ma.mbg.app.data.DimensionMemberCheck;
import com.kingdee.eas.ma.mbg.app.data.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CFSMemberCheckHelper
extends DimensionMemberCheckHelper {
    private static final Logger logger = Logger.getLogger(CFSMemberCheckHelper.class);

    public CFSMemberCheckHelper(MbgDataManager dataManager) {
        super(dataManager);
    }

    @Override
    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Map<String, Map<String, IMbgData>> mbgDataMap) throws Exception {
        return super.build(schemeInfo, mbgDataMap);
    }

    @Override
    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Map<String, Set<String>> memberNumber) throws Exception {
        return super.build(schemeInfo, orgUnitIds, memberNumber);
    }

    @Override
    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Set<String> formulas, Set<String> versionNum) throws Exception {
        return super.build(schemeInfo, orgUnitIds, formulas, versionNum);
    }

    @Override
    protected DimensionMemberCheck createMemberCheck() {
        return new CFSMemberCheck(this.getDataManager());
    }

    @Override
    protected DimensionMemberCheck build(DimensionMemberCheck check, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Map<String, Set<String>> memberNumber) throws Exception {
        DimensionMemberCheck _check = super.build(check, schemeInfo, orgUnitIds, memberNumber);
        if (_check instanceof CFSMemberCheck) {
            CFSMemberCheck cslCheck = (CFSMemberCheck)_check;
            String bgIndexStr = null;
            String bgDimStr = null;
            String bgMemberStr = null;
            String bgIndex2 = null;
            String field = null;
            String srcNumber = null;
            String[] tmpIndexs = null;
            String[] tmpMembers = null;
            MbgDimInfo mbgDim = null;
            Map<Object, Object> dimMemberMap = null;
            Set<String> memberSet = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                conn = BgDBUtils.getConnection((Context)this.getDataManager().getCtx());
                pstmt = conn.prepareStatement("select FAccMemNumberData, FMbgDimNumber, FMbgMemNumberData from T_MBG_DimGroup where FBgSchemeID = ?");
                pstmt.setString(1, schemeInfo.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgIndexStr = (String)BgAnalyseHelper.getObject(rst.getBytes("FAccMemNumberData"));
                    bgDimStr = rst.getString("FMbgDimNumber");
                    bgMemberStr = (String)BgAnalyseHelper.getObject(rst.getBytes("FMbgMemNumberData"));
                    tmpIndexs = bgIndexStr != null ? bgIndexStr.split(",") : null;
                    String[] stringArray = tmpMembers = bgMemberStr != null ? bgMemberStr.split(",") : null;
                    if (tmpIndexs == null) continue;
                    for (String bgIndex2 : tmpIndexs) {
                        bgIndex2 = DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":" + bgIndex2;
                        if (cslCheck.getCslMemberCheck().containsKey(bgIndex2)) {
                            dimMemberMap = cslCheck.getCslMemberCheck().get(bgIndex2);
                        } else {
                            dimMemberMap = new HashMap();
                            cslCheck.getCslMemberCheck().put(bgIndex2, dimMemberMap);
                        }
                        mbgDim = this.getDataManager().getMbgDimMap().get(bgDimStr);
                        field = mbgDim.getRefField();
                        srcNumber = mbgDim.getSrcNumber();
                        if (dimMemberMap.containsKey(field)) {
                            memberSet = (Set)dimMemberMap.get(field);
                        } else {
                            memberSet = new HashSet();
                            dimMemberMap.put(field, memberSet);
                        }
                        if (tmpMembers == null) continue;
                        int jn = tmpMembers.length;
                        for (int j = 0; j < jn; ++j) {
                            memberSet.add(srcNumber + ":" + tmpMembers[j]);
                        }
                    }
                }
            }
            catch (SQLDataException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        return _check;
    }

    @Override
    protected void queryLeafMember(DimensionMemberCheck check, Connection conn, String field, String srcNumber, BOSUuid viewId, Collection<String> members) throws Exception {
        super.queryLeafMember(check, conn, field, srcNumber, viewId, members);
        if (check instanceof CFSMemberCheck) {
            CFSMemberCheck cslCheck = (CFSMemberCheck)check;
            if (!(DimUtils.checkBaseDimensionByField(field) || DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field) || DimensionBaseConstants.DEF_CSL_FIELD.equals(field))) {
                IRowSet rst;
                block6: {
                    rst = null;
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_MbgMember where FViewId = ? and FParentId is null", (Object[])new Object[]{viewId.toString()});
                        if (!rst.next()) break block6;
                        cslCheck.getCslDimMemberMap().put(field, srcNumber + ":" + rst.getString("FNumber"));
                    }
                    catch (SQLException ex) {
                        try {
                            logger.error((Object)"sql error:", (Throwable)ex);
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
    }
}

