/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DimensionMemberCheck {
    private MbgDataManager dataManager = null;
    private Map<String, Set<String>> dimMemberMap = new HashMap<String, Set<String>>();

    protected void setDataManager(MbgDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected MbgDataManager getDataManager() {
        return this.dataManager;
    }

    public Map<String, Set<String>> getDimMemberMap() {
        return this.dimMemberMap;
    }

    public DimensionMemberCheck(MbgDataManager dataManager) {
        this.setDataManager(dataManager);
    }

    public boolean canSave(IMbgData mbgData) {
        if (mbgData == null) {
            return false;
        }
        if (mbgData.getDimNumber() != null && mbgData.getBgPeriodNum() != null && mbgData.getBgElementNum() != null && mbgData.getBgScenarioNum() != null) {
            return this.canSave(mbgData.getOrgUnitId(), mbgData.getDimNumber(), mbgData.getBgPeriodNum(), mbgData.getBgElementNum(), mbgData.getBgScenarioNum(), mbgData.getVersionNum());
        }
        return this.canSave(mbgData, mbgData.getOrgUnitId(), mbgData.getFormula(), mbgData.getVersionNum());
    }

    public boolean canSave(IMbgData mbgData, String orgUnitId, String formula, String versionNum) {
        if (StringUtils.isEmpty((String)formula)) {
            return false;
        }
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        if (params != null && params.length >= 6) {
            mbgData.setDimNumber(params[0]);
            mbgData.setBgPeriodNum(params[1]);
            mbgData.setBgElementNum(params[2]);
            mbgData.setBgScenarioNum(params[3]);
            mbgData.setCurrencyNum(params[5]);
            return this.canSave(orgUnitId, params[0], params[1], params[2], params[3], versionNum);
        }
        return false;
    }

    public boolean canSave(String orgUnitId, String dimNumber, String periodNum, String elementNum, String scenarioNum, String versionNum) {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)periodNum) || StringUtils.isEmpty((String)elementNum) || StringUtils.isEmpty((String)scenarioNum) || StringUtils.isEmpty((String)versionNum)) {
            return false;
        }
        boolean re = true;
        re = this.checkOrg(this.getDimMemberMap(), orgUnitId);
        if (!re) {
            return re;
        }
        re = this.checkPeriod(this.getDimMemberMap(), periodNum);
        if (!re) {
            return re;
        }
        re = this.checkScenario(this.getDimMemberMap(), scenarioNum);
        if (!re) {
            return re;
        }
        re = this.checkVersion(this.getDimMemberMap(), versionNum);
        if (!re) {
            return re;
        }
        re = this.checkElement(this.getDimMemberMap(), elementNum);
        if (!re) {
            return re;
        }
        return this.checkDimNumber(this.getDimMemberMap(), dimNumber);
    }

    protected boolean checkOrg(Map<String, Set<String>> dimMemberMap, String orgUnitId) {
        boolean re = true;
        if (dimMemberMap == null || orgUnitId == null) {
            return false;
        }
        Set<String> tmpSet = dimMemberMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
        if (tmpSet == null || !tmpSet.contains(orgUnitId)) {
            re = false;
        }
        return re;
    }

    protected boolean checkPeriod(Map<String, Set<String>> dimMemberMap, String periodNum) {
        boolean re = true;
        if (dimMemberMap == null || periodNum == null) {
            return false;
        }
        Set<String> tmpSet = dimMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
        if (tmpSet == null || !tmpSet.contains(periodNum)) {
            re = false;
        }
        return re;
    }

    protected boolean checkScenario(Map<String, Set<String>> dimMemberMap, String scenarioNum) {
        boolean re = true;
        if (dimMemberMap == null || scenarioNum == null) {
            return false;
        }
        Set<String> tmpSet = dimMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
        if (tmpSet == null || !tmpSet.contains(scenarioNum)) {
            re = false;
        }
        return re;
    }

    protected boolean checkVersion(Map<String, Set<String>> dimMemberMap, String versionNum) {
        boolean re = true;
        if (dimMemberMap == null || versionNum == null) {
            return false;
        }
        Set<String> tmpSet = dimMemberMap.get(DimensionBaseConstants.DEF_VERSION_FIELD);
        if (tmpSet == null || !tmpSet.contains(versionNum)) {
            re = false;
        }
        return re;
    }

    protected boolean checkElement(Map<String, Set<String>> dimMemberMap, String elementNum) {
        boolean re = true;
        if (dimMemberMap == null || elementNum == null) {
            return false;
        }
        Set<String> tmpSet = dimMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
        if (tmpSet == null || !tmpSet.contains(elementNum)) {
            re = false;
        }
        return re;
    }

    protected boolean checkDimNumber(Map<String, Set<String>> dimMemberMap, String dimNumber) {
        boolean re = true;
        if (dimMemberMap == null || dimNumber == null) {
            return false;
        }
        String field = null;
        String bgIndexNum = null;
        String[] dimNums = dimNumber.split(",");
        if (dimNums != null) {
            int in = dimNums.length;
            for (int i = 0; i < in && re; ++i) {
                String[] tmpStr = dimNums[i].split(":");
                if (tmpStr != null) {
                    field = this.getDataManager().getSrcFieldMap().get(tmpStr[0]);
                    if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                        bgIndexNum = dimNums[i];
                        re = this.checkBgIndexNum(dimMemberMap, field, bgIndexNum);
                        continue;
                    }
                    re = this.checkExtDimNum(dimMemberMap, field, bgIndexNum, dimNums[i]);
                    continue;
                }
                re = false;
            }
        }
        return re;
    }

    protected boolean checkBgIndexNum(Map<String, Set<String>> dimMemberMap, String field, String bgIndexNum) {
        boolean re = false;
        if (dimMemberMap == null || field == null || bgIndexNum == null) {
            return re;
        }
        Set<String> tmpSet = dimMemberMap.get(field);
        if (tmpSet != null && tmpSet.contains(bgIndexNum)) {
            re = true;
        }
        return re;
    }

    protected boolean checkExtDimNum(Map<String, Set<String>> dimMemberMap, String field, String bgIndexNum, String extDimNum) {
        boolean re = false;
        if (dimMemberMap == null || field == null || extDimNum == null) {
            return re;
        }
        Set<String> tmpSet = dimMemberMap.get(field);
        if (tmpSet != null && tmpSet.contains(extDimNum)) {
            re = true;
        }
        return re;
    }
}

