/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.DimensionMemberCheck;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionMemberCheckHelper {
    private static final Logger logger = Logger.getLogger(DimensionMemberCheckHelper.class);
    private MbgDataManager dataManager = null;

    protected void setDataManager(MbgDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected MbgDataManager getDataManager() {
        return this.dataManager;
    }

    public DimensionMemberCheckHelper(MbgDataManager dataManager) {
        this.setDataManager(dataManager);
    }

    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Map<String, Map<String, IMbgData>> mbgDataMap) throws Exception {
        DimensionMemberCheck check = this.createMemberCheck();
        if (schemeInfo == null || mbgDataMap == null || mbgDataMap.isEmpty()) {
            return check;
        }
        Map<String, IMbgData> dataMap2 = null;
        IMbgData mbgData2 = null;
        HashSet<String> formulas = new HashSet<String>();
        HashSet<String> versionNum = new HashSet<String>();
        for (Map<String, IMbgData> dataMap2 : mbgDataMap.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                formulas.add(mbgData2.getFormula());
                versionNum.add(mbgData2.getVersionNum());
            }
        }
        return this.build(check, schemeInfo, mbgDataMap.keySet(), formulas, versionNum);
    }

    protected DimensionMemberCheck createMemberCheck() {
        return new DimensionMemberCheck(this.getDataManager());
    }

    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Set<String> formulas, Set<String> versionNum) throws Exception {
        return this.build(null, schemeInfo, orgUnitIds, formulas, versionNum);
    }

    public DimensionMemberCheck build(BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Map<String, Set<String>> memberNumber) throws Exception {
        return this.build(null, schemeInfo, orgUnitIds, memberNumber);
    }

    private DimensionMemberCheck build(DimensionMemberCheck check, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Set<String> formulas, Set<String> versionNum) throws Exception {
        if (check == null) {
            check = this.createMemberCheck();
        }
        if (schemeInfo == null || orgUnitIds == null || orgUnitIds.isEmpty() || formulas == null || formulas.isEmpty() || versionNum == null || versionNum.isEmpty()) {
            return check;
        }
        HashMap<String, Set<String>> memberNumber = new HashMap<String, Set<String>>();
        memberNumber.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, orgUnitIds);
        memberNumber.put(DimensionBaseConstants.DEF_VERSION_FIELD, versionNum);
        HashSet<String> periodNums = new HashSet<String>();
        HashSet<String> elementNums = new HashSet<String>();
        HashSet<String> scenarioNums = new HashSet<String>();
        Set<String> memberSet = null;
        String dimNumber2 = null;
        String srcNumber = null;
        String field = null;
        String[] params = null;
        String[] tmpStrs = null;
        for (String formula : formulas) {
            params = BgNFSHelper.parseFormulaPara(formula);
            tmpStrs = params[0].split(",");
            if (tmpStrs != null) {
                for (String dimNumber2 : tmpStrs) {
                    srcNumber = DimUtils.getSrcNumber(dimNumber2);
                    field = this.getDataManager().getSrcFieldMap().get(srcNumber);
                    if (memberNumber.containsKey(field)) {
                        memberSet = (Set)memberNumber.get(field);
                    } else {
                        memberSet = new HashSet();
                        memberNumber.put(field, memberSet);
                    }
                    memberSet.add(DimUtils.getNumber(dimNumber2));
                }
            }
            periodNums.add(params[1]);
            elementNums.add(params[2]);
            scenarioNums.add(params[3]);
        }
        memberNumber.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, elementNums);
        memberNumber.put(DimensionBaseConstants.DEF_PERIOD_FIELD, periodNums);
        memberNumber.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, scenarioNums);
        return this.build(check, schemeInfo, orgUnitIds, memberNumber);
    }

    protected DimensionMemberCheck build(DimensionMemberCheck check, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Map<String, Set<String>> memberNumber) throws Exception {
        if (check == null) {
            check = this.createMemberCheck();
        }
        if (schemeInfo == null || orgUnitIds == null || orgUnitIds.isEmpty() || memberNumber == null || memberNumber.isEmpty()) {
            return check;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getDataManager().getCtx());
            if (schemeInfo.getBgDimSettings().isEmpty() || schemeInfo.getEditOrgViewId() == null) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo(conn, this.getDataManager().getCtx().getLocale(), schemeInfo.getId());
            }
            check.getDimMemberMap().put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, this.queryLeafMember(conn, DimensionBaseConstants.DEF_ORGUNIT_FIELD, DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER, schemeInfo.getEditOrgViewId(), orgUnitIds));
            Map.Entry<String, Set<String>> entry2 = null;
            String field = null;
            Set<String> members = null;
            for (Map.Entry<String, Set<String>> entry2 : memberNumber.entrySet()) {
                if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(entry2.getKey())) continue;
                field = entry2.getKey();
                members = entry2.getValue();
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER, schemeInfo.getEditOrgViewId(), members);
                    continue;
                }
                if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_INDEX_SRCNUMBER, schemeInfo.getViewId(DimensionBaseConstants.DEF_INDEX_NUMBER), members);
                    continue;
                }
                if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_PERIOD_SRCNUMBER, null, members);
                    continue;
                }
                if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER, null, members);
                    continue;
                }
                if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER, null, members);
                    continue;
                }
                if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
                    this.queryLeafMember(check, conn, field, DimensionBaseConstants.DEF_VERSION_SRCNUMBER, null, members);
                    continue;
                }
                this.queryLeafMember(check, conn, field, this.getDataManager().getFieldSrcMap().get(field), schemeInfo.getViewId(this.getDataManager().getFieldNumMap().get(field)), members);
            }
        }
        catch (SQLDataException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return check;
    }

    protected void queryLeafMember(DimensionMemberCheck check, Connection conn, String field, String srcNumber, BOSUuid viewId, Collection<String> members) throws Exception {
        check.getDimMemberMap().put(field, this.queryLeafMember(conn, field, srcNumber, viewId, members));
    }

    protected Set<String> queryLeafMember(Connection conn, String field, String srcNumber, BOSUuid viewId, Collection<String> members) throws Exception {
        HashSet<String> memberSet = new HashSet<String>();
        if (conn == null || field == null || srcNumber == null || members == null) {
            return memberSet;
        }
        if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
            return memberSet;
        }
        List<String> _members = null;
        if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
            _members = this.getDataManager().getSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
            _members = this.getDataManager().getSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
            _members = this.getDataManager().getSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_VERSION_NUMBER);
        }
        if (_members != null) {
            members.addAll(_members);
        }
        ArrayList<Object> firstParams = new ArrayList<Object>();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        if (viewId != null) {
            firstParams.add(viewId.toString());
            sqlParams.addAll(members);
        } else {
            sqlParams.addAll(members);
        }
        List<Object[]> rst = null;
        try {
            rst = this.getQueryResult(conn, field, firstParams, sqlParams);
            if (rst != null) {
                this.checkLeafMember(rst, field);
                if (DimUtils.checkBaseDimensionByField(field)) {
                    int in = rst.size();
                    for (int i = 0; i < in; ++i) {
                        memberSet.add((String)rst.get(i)[0]);
                    }
                } else {
                    int in = rst.size();
                    for (int i = 0; i < in; ++i) {
                        memberSet.add(srcNumber + ":" + (String)rst.get(i)[0]);
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return memberSet;
    }

    protected List<Object[]> getQueryResult(Connection conn, String field, List<Object> firstParams, List<Object> sqlParams) throws SQLException {
        List rst = null;
        rst = firstParams.isEmpty() ? BgDBUtils.executeBatchQuery((Connection)conn, (String)this.getQueryLeafMemberSql(field), sqlParams) : BgDBUtils.executeBatchQuery((Connection)conn, (String)this.getQueryLeafMemberSql(field), firstParams, sqlParams);
        return rst;
    }

    private boolean isDecompose() {
        boolean isDecompose = DimensionConstants.DECOMPOSE_DATA_TYPE == this.getDataManager().getValueType() || DimensionConstants.DECOMPOSE_SENDDOWN_DATA_TYPE == this.getDataManager().getValueType() || DimensionConstants.DECOMPOSE_GATHER_DATA_TYPE == this.getDataManager().getValueType() || this.getDataManager().processType != null && DimensionCommonHelper.isDecompose(this.getDataManager().processType);
        return isDecompose;
    }

    protected String getQueryLeafMemberSql(String field) {
        StringBuffer sql = new StringBuffer();
        if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
            if (this.isDecompose()) {
                sql.append("select FOrgUnitID from T_MBG_BgOrgUnit where FIsVirtual = 0 AND FViewId = ? and FOrgUnitID IN (" + BgDBUtils.getSqlParam((int)50) + ") and FIsLeaf = 0");
            } else {
                sql.append("select FOrgUnitID from T_MBG_BgOrgUnit where FIsVirtual = 0 AND FViewId = ? and FOrgUnitID IN (" + BgDBUtils.getSqlParam((int)50) + ") and FIsLeaf = 1");
            }
        } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
            sql.append("select FNumber from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FIsLeaf = 1");
        } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
            sql.append("select FNumber from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FIsLeaf = 1");
        } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
            sql.append(this.getQueryElementSql());
        } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
            sql.append(this.getQueryScenarioSql());
        } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
            sql.append(this.getQueryVersionSql());
        } else {
            sql.append("select FNumber from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FIsLeaf = 1");
        }
        return sql.toString();
    }

    protected String getQueryScenarioSql() {
        return "select FNumber, FLongNumber from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")";
    }

    protected String getQueryVersionSql() {
        return "select FNumber, FLongNumber from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")";
    }

    protected String getQueryElementSql() {
        return "select FNumber, FLongNumber from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")";
    }

    protected void checkLeafMember(List<Object[]> rst, String field) {
        if (rst == null || rst.isEmpty()) {
            return;
        }
        if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field) || DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field) || DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
            ArrayList<String> longNums = new ArrayList<String>();
            Object[] objs = null;
            int in = rst.size();
            for (int i = 0; i < in; ++i) {
                objs = rst.get(i);
                if (objs.length <= 1) continue;
                longNums.add((String)objs[1]);
            }
            if (!longNums.isEmpty()) {
                String longNumber = null;
                String _longNumber = null;
                ArrayList<Object[]> remove = new ArrayList<Object[]>();
                int in2 = rst.size();
                for (int i = 0; i < in2; ++i) {
                    objs = rst.get(i);
                    if (objs.length <= 1) continue;
                    longNumber = (String)objs[1];
                    int jn = longNums.size();
                    for (int j = 0; j < jn; ++j) {
                        _longNumber = (String)longNums.get(j);
                        if (longNumber.equals(_longNumber) || !_longNumber.startsWith(longNumber + "!")) continue;
                        remove.add(objs);
                    }
                }
                if (!remove.isEmpty()) {
                    rst.removeAll(remove);
                }
            }
        }
    }
}

