/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.query.IAdjustData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgDataAddnew {
    private static final Logger logger = Logger.getLogger(MbgDataAddnew.class);

    public static MbgDataAddnew getInstance() {
        return new MbgDataAddnew();
    }

    public void addnew(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> addnew) throws Exception {
        if (dataManager == null || addnew == null || addnew.isEmpty()) {
            return;
        }
        if (BgNSHelper.isMSSQL(dataManager.getCtx())) {
            this.addnewBySql(dataManager, addnew);
        } else {
            this.addnewByOra(dataManager, addnew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addnewBySql(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> addnew) throws Exception {
        Connection conn;
        long beginTime;
        block12: {
            if (dataManager == null || addnew == null || addnew.isEmpty()) {
                return;
            }
            beginTime = System.currentTimeMillis();
            logger.debug((Object)"invoke begin addnew mbgData!");
            boolean hasCfs = DimensionConstants.CFS_DATA_TYPE == dataManager.getValueType() || DimensionConstants.CFS_ADJUST_DATA_TYPE == dataManager.getValueType();
            String tmpCubeName = null;
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FCreatorID VARCHAR(44), FCreateTime DateTime, FLastUpdateUserID VARCHAR(44), FLastUpdateTime DateTime, ");
            if (hasCfs) {
                sql.append("FUnionID VARCHAR(44), ");
            }
            sql.append("FOrgUnitID VARCHAR(44), FFormula NVARCHAR(300), FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, F2 NVARCHAR(84), ");
            for (String dimNumber : dataManager.getSchemeInfo().getExtDimNums(dataManager.getValueType())) {
                sql.append(dataManager.getMbgDimMap().get(dimNumber).getRefField() + " NVARCHAR(84), ");
            }
            sql.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44), FBgElementID VARCHAR(44), FCurrencyID VARCHAR(44), FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FDataSource NUMERIC(21,8) )");
            conn = null;
            TempTablePool pool = TempTablePool.getInstance((Context)dataManager.getCtx());
            try {
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                tmpCubeName = pool.createDBSystemTempTable(sql.toString(), conn);
                if (tmpCubeName != null) {
                    this.addnewMbgData(conn, dataManager, tmpCubeName, addnew);
                    StringBuffer fields = new StringBuffer();
                    fields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, " + (hasCfs ? "FUnionID, " : "") + "FOrgUnitID, FFormula, FValue, FTmpValue, F2, ");
                    for (String dimNumber : dataManager.getSchemeInfo().getExtDimNums(dataManager.getValueType())) {
                        fields.append(dataManager.getMbgDimMap().get(dimNumber).getRefField() + ",");
                    }
                    fields.append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FDataSource");
                    sql.setLength(0);
                    sql.append("Insert Into " + dataManager.getCube() + " (").append(fields).append(") select ").append(fields).append(" from " + tmpCubeName + " where not exists (select FID from " + dataManager.getCube() + " where " + (hasCfs ? "FUnionID = " + tmpCubeName + ".FUnionID and " : "") + "FOrgUnitID = " + tmpCubeName + ".FOrgUnitID and FFormula = " + tmpCubeName + ".FFormula and FVersion = " + tmpCubeName + ".FVersion)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                }
                if (pool == null) break block12;
            }
            catch (Throwable throwable) {
                if (pool != null) {
                    try {
                        pool.releaseDBSystemTempTable(tmpCubeName, conn);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"drop TempTable Error:", (Throwable)ex);
                    }
                }
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            try {
                pool.releaseDBSystemTempTable(tmpCubeName, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"drop TempTable Error:", (Throwable)ex);
            }
        }
        SQLUtils.cleanup((Connection)conn);
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end addnew mbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addnewByOra(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> addnew) throws Exception {
        if (dataManager == null || addnew == null || addnew.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin addnew mbgData!");
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
            this.addnewMbgData(conn, dataManager, dataManager.getCube(), addnew);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end addnew mbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }

    private void addnewMbgData(Connection conn, MbgDataManager dataManager, String mbgDataCube, Map<String, Map<String, IMbgData>> addnew) throws Exception {
        if (conn == null || dataManager == null || addnew == null || addnew.isEmpty()) {
            return;
        }
        HashSet<String> periodSet = new HashSet<String>();
        HashSet<String> elementSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        HashMap<String, IMbgData> mbgDatas = new HashMap<String, IMbgData>();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(DimensionBaseConstants.DEF_BGINDEX_FIELD);
        for (String dimNumber : dataManager.getSchemeInfo().getExtDimNums(dataManager.getValueType())) {
            fields.add(dataManager.getMbgDimMap().get(dimNumber).getRefField());
        }
        Map<String, IMbgData> dataMap2 = null;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        IMbgData mbgData2 = null;
        String tmpId = null;
        String dimNumber2 = null;
        String srcNumber = null;
        String field = null;
        String[] tmpStrs = null;
        int index = 0;
        int paramIndex = 1;
        boolean hasAdjust = DimensionConstants.ADJUST_DATA_TYPE == dataManager.getValueType();
        boolean hasCfs = DimensionConstants.CFS_DATA_TYPE == dataManager.getValueType() || DimensionConstants.CFS_ADJUST_DATA_TYPE == dataManager.getValueType();
        int curState = this.getCurrDataState(dataManager, conn);
        BOSObjectType type = new BgDataInfo().getBOSType();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map<String, IMbgData> dataMap2 : addnew.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                if (mbgData2.getMbgDataId() == null) {
                    mbgData2.setMbgDataId(BOSUuid.create((BOSObjectType)type).toString());
                }
                mbgDatas.put(mbgData2.getMbgDataId(), mbgData2);
                periodSet.add(mbgData2.getBgPeriodNum());
                elementSet.add(mbgData2.getBgElementNum());
                currencySet.add(mbgData2.getCurrencyNum());
            }
        }
        if (!mbgDatas.isEmpty()) {
            PreparedStatement pstmt = null;
            try {
                Map<String, String> periodMap = MbgDataHelper.getBgPeriodMap(conn, periodSet);
                Map<String, String> elementMap = MbgDataHelper.getBgElementMap(conn, elementSet);
                Map<String, String> currencyMap = MbgDataHelper.getCurrencyMap(conn, currencySet);
                Map splitDataMap = dataManager.getAccIntHelper().splitBgDatas(conn, mbgDatas, dataManager.getHasFormuls());
                for (String cube : splitDataMap.keySet()) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("Insert Into " + cube + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, ");
                    if (hasCfs) {
                        sql.append("FUnionID, ");
                    }
                    sql.append("FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FDataSource ");
                    int in = fields.size();
                    for (int i = 0; i < in; ++i) {
                        sql.append(", " + (String)fields.get(i));
                    }
                    sql.append(") values (" + BgDBUtils.getSqlParam((int)((hasCfs ? 18 : 17) + fields.size())) + ")");
                    pstmt = conn.prepareStatement(sql.toString());
                    for (IMbgData mbgData2 : splitDataMap.get(cube).values()) {
                        int state;
                        paramIndex = 1;
                        pstmt.setString(paramIndex++, mbgData2.getMbgDataId());
                        pstmt.setString(paramIndex++, dataManager.getUserId());
                        pstmt.setTimestamp(paramIndex++, timestamp);
                        pstmt.setString(paramIndex++, dataManager.getUserId());
                        pstmt.setTimestamp(paramIndex++, timestamp);
                        if (hasCfs) {
                            pstmt.setString(paramIndex++, mbgData2.getUnionId());
                        }
                        dataManager.getAccIntHelper().setParam(pstmt, paramIndex++, mbgData2.getOrgUnitId(), DimensionConstants.DEF_ORGUNIT_FIELD);
                        pstmt.setString(paramIndex++, mbgData2.getFormula());
                        pstmt.setBigDecimal(paramIndex++, hasAdjust ? BigDecimal.ZERO : mbgData2.getValue());
                        pstmt.setBigDecimal(paramIndex++, mbgData2.getValue());
                        pstmt.setString(paramIndex++, mbgData2.getDimNumber());
                        tmpId = periodMap.get(mbgData2.getBgPeriodNum());
                        if (tmpId == null) {
                            logger.debug((Object)("bgPeriod number error:" + mbgData2.getBgPeriodNum()));
                            throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{mbgData2.getBgPeriodNum()});
                        }
                        dataManager.getAccIntHelper().setParam(pstmt, paramIndex++, tmpId, DimensionConstants.DEF_PERIOD_FIELD);
                        tmpId = elementMap.get(mbgData2.getBgElementNum());
                        if (tmpId == null) {
                            logger.debug((Object)("bgElement number error:" + mbgData2.getBgElementNum()));
                            throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{mbgData2.getBgElementNum()});
                        }
                        dataManager.getAccIntHelper().setParam(pstmt, paramIndex++, tmpId, DimensionConstants.DEF_ELEMENT_FIELD);
                        tmpId = currencyMap.get(mbgData2.getCurrencyNum());
                        if (tmpId == null) {
                            logger.debug((Object)("currency number error:" + mbgData2.getCurrencyNum()));
                            throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{mbgData2.getCurrencyNum()});
                        }
                        pstmt.setString(paramIndex++, tmpId);
                        pstmt.setInt(paramIndex++, dataManager.getScenarioNumMap().get(mbgData2.getBgScenarioNum()));
                        pstmt.setInt(paramIndex++, dataManager.getVersionNumMap().get(mbgData2.getVersionNum()));
                        int n = state = curState >= this.getStateByAddnew(dataManager, mbgData2) ? curState : this.getStateByAddnew(dataManager, mbgData2);
                        if (dataManager.getAcScenario().contains(mbgData2.getBgScenarioNum()) && dataManager.getValueType() == DimensionConstants.ADJUST_DATA_TYPE) {
                            state = 9;
                        }
                        pstmt.setInt(paramIndex++, state);
                        pstmt.setInt(paramIndex++, mbgData2.getBgDataSource());
                        valueMap.clear();
                        tmpStrs = mbgData2.getDimNumber().split(",");
                        if (tmpStrs != null) {
                            for (String dimNumber2 : tmpStrs) {
                                srcNumber = dimNumber2.substring(0, dimNumber2.indexOf(":"));
                                field = dataManager.getSrcFieldMap().get(srcNumber);
                                valueMap.put(field, dimNumber2);
                            }
                        }
                        int jn = fields.size();
                        for (int j = 0; j < jn; ++j) {
                            field = (String)fields.get(j);
                            dataManager.getAccIntHelper().setParam(pstmt, paramIndex++, (String)valueMap.get(field), field);
                        }
                        pstmt.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"addnew sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup(pstmt);
            }
        }
    }

    public void addnewTmpMbgData(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> addnew) throws Exception {
        if (dataManager == null || addnew == null || addnew.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin addnew tmpMbgData!");
        HashSet<String> periodSet = new HashSet<String>();
        HashSet<String> elementSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        HashMap<String, IMbgData> mbgDatas = new HashMap<String, IMbgData>();
        Map<String, IMbgData> dataMap2 = null;
        IMbgData mbgData2 = null;
        String tmpId = null;
        int index = 0;
        BOSObjectType type = new BgDataInfo().getBOSType();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String bgSchemeId = dataManager.getSchemeInfo().getId().toString();
        for (Map<String, IMbgData> dataMap2 : addnew.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                mbgDatas.put(mbgData2.getOrgDimKey(), mbgData2);
                periodSet.add(mbgData2.getBgPeriodNum());
                elementSet.add(mbgData2.getBgElementNum());
                currencySet.add(mbgData2.getCurrencyNum());
            }
        }
        if (!mbgDatas.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            PreparedStatement pstup = null;
            try {
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                Map<String, String> periodMap = MbgDataHelper.getBgPeriodMap(conn, periodSet);
                Map<String, String> elementMap = MbgDataHelper.getBgElementMap(conn, elementSet);
                Map<String, String> currencyMap = MbgDataHelper.getCurrencyMap(conn, currencySet);
                Map<String, Map<String, IMbgData>> tmpDataMap = dataManager.getAccIntHelper().splitBgDatas(conn, dataMap2, dataManager.getHasFormuls());
                for (String cube : tmpDataMap.keySet()) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("Insert Into " + dataManager.getTmpCube() + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootId, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FAdjustReason, FProcessType) values (" + BgDBUtils.getSqlParam((int)19) + ")");
                    StringBuffer upSql = new StringBuffer();
                    upSql.append("update " + cube + " set FDetail = 1 where FID = ?");
                    pstmt = conn.prepareStatement(sql.toString());
                    pstup = conn.prepareStatement(upSql.toString());
                    for (IMbgData mbgData2 : tmpDataMap.get(cube).values()) {
                        if (mbgData2.getMbgDataId() == null) {
                            mbgData2.setMbgDataId(BOSUuid.create((BOSObjectType)type).toString());
                        }
                        pstmt.setString(1, mbgData2.getMbgDataId());
                        pstmt.setString(2, dataManager.getUserId());
                        pstmt.setTimestamp(3, timestamp);
                        pstmt.setString(4, dataManager.getUserId());
                        pstmt.setTimestamp(5, timestamp);
                        pstmt.setString(6, bgSchemeId);
                        pstmt.setString(7, mbgData2.getOrgUnitId());
                        pstmt.setString(8, mbgData2.getFormula());
                        pstmt.setBigDecimal(9, mbgData2.getValue());
                        pstmt.setBigDecimal(10, mbgData2.getOldValue() != null ? mbgData2.getOldValue() : BigDecimal.ZERO);
                        pstmt.setString(11, mbgData2.getDimNumber());
                        tmpId = periodMap.get(mbgData2.getBgPeriodNum());
                        if (tmpId == null) {
                            logger.debug((Object)("bgPeriod number error:" + mbgData2.getBgPeriodNum()));
                            throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{mbgData2.getBgPeriodNum()});
                        }
                        pstmt.setString(12, tmpId);
                        tmpId = elementMap.get(mbgData2.getBgElementNum());
                        if (tmpId == null) {
                            logger.debug((Object)("bgElement number error:" + mbgData2.getBgElementNum()));
                            throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{mbgData2.getBgElementNum()});
                        }
                        pstmt.setString(13, tmpId);
                        tmpId = currencyMap.get(mbgData2.getCurrencyNum());
                        if (tmpId == null) {
                            logger.debug((Object)("currency number error:" + mbgData2.getCurrencyNum()));
                            throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{mbgData2.getCurrencyNum()});
                        }
                        pstmt.setString(14, tmpId);
                        pstmt.setInt(15, dataManager.getScenarioNumMap().get(mbgData2.getBgScenarioNum()));
                        pstmt.setInt(16, dataManager.getVersionNumMap().get(mbgData2.getVersionNum()));
                        pstmt.setInt(17, 5);
                        pstmt.setString(18, mbgData2 instanceof IAdjustData ? ((IAdjustData)mbgData2).getAdjustReason() : null);
                        pstmt.setInt(19, dataManager.processType != null ? dataManager.processType.getValue() : 1);
                        pstmt.addBatch();
                        pstup.setString(1, mbgData2.getMbgDataId());
                        pstup.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        pstup.executeBatch();
                        index = 0;
                    }
                    if (index <= 0) continue;
                    pstmt.executeBatch();
                    pstup.executeBatch();
                }
            }
            catch (SQLDataException ex) {
                throw new BOSException((Throwable)ex);
            }
            catch (SQLException ex) {
                logger.error((Object)"addnew sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup(pstup);
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end addnew tmpMbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }

    private int getStateByAddnew(MbgDataManager dataManager, IMbgData mbgData) {
        if (mbgData == null) {
            return 1;
        }
        int dataState = 1;
        if (dataManager.getAcScenario().contains(mbgData.getBgScenarioNum())) {
            if (dataManager.getValueType() == DimensionConstants.DEFAULT_DATA_TYPE || dataManager.getValueType() == DimensionConstants.ACTUAL_DATA_TYPE) {
                dataState = 9;
            }
        } else if (dataManager.getValueType() == DimensionConstants.ADJUST_DATA_TYPE) {
            dataState = 5;
        }
        if (dataManager.isAudit) {
            dataState = 9;
        }
        return dataState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrDataState(MbgDataManager dataManager, Connection conn) {
        int state = 1;
        if (dataManager.getValueType() == DimensionConstants.ADJUST_DATA_TYPE) {
            state = 5;
        } else if (dataManager.getBillId() != null) {
            String sql = null;
            BOSObjectType type = BOSUuid.read((String)dataManager.getBillId()).getType();
            BgFormInfo bgForm = new BgFormInfo();
            BOSObjectType bgType = bgForm.getBOSType();
            BgActualRecordInfo acRecord = new BgActualRecordInfo();
            BOSObjectType acType = acRecord.getBOSType();
            if (type.equals((Object)bgType)) {
                sql = "select FID, FState from T_MBG_BgForm where FID = ?";
            } else if (type.equals((Object)acType)) {
                sql = "select FID, FState from T_MBG_BgActualRecord where FID = ?";
            }
            if (!StringUtils.isEmpty((String)sql)) {
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dataManager.getBillId()});
                    if (rst.next()) {
                        if (type.equals((Object)bgType)) {
                            bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                            bgForm.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                            state = rst.getInt("FState");
                        } else if (type.equals((Object)acType)) {
                            acRecord.setId(BOSUuid.read((String)rst.getString("FID")));
                            acRecord.setState(BgActualRecordStateEnum.getEnum(rst.getInt("FState")));
                        }
                        state = rst.getInt("FState");
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                catch (Exception ex) {
                    logger.error((Object)"query model state error:", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            state = state == 2 ? 9 : (state == 50 ? 11 : (state == 51 ? 13 : (state == 4 ? 5 : 1)));
        }
        return state;
    }
}

