/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataDelete {
    private static final Logger logger = Logger.getLogger(MbgDataDelete.class);

    public static MbgDataDelete getInstance() {
        return new MbgDataDelete();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> delete) throws Exception {
        if (dataManager == null || delete == null || delete.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke delete mbgData!");
        ArrayList<IMbgData> mbgDatas = new ArrayList<IMbgData>();
        Map<String, IMbgData> dataMap2222222 = null;
        IMbgData mbgData2222222 = null;
        ArrayList<String> dataIds = new ArrayList<String>();
        for (Map<String, IMbgData> dataMap2222222 : delete.values()) {
            for (IMbgData mbgData2222222 : dataMap2222222.values()) {
                mbgDatas.add(mbgData2222222);
                dataIds.add(mbgData2222222.getMbgDataId());
            }
        }
        if (!mbgDatas.isEmpty()) {
            int index = 0;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                Map<String, Set<String>> refMap = this.queryOtherFormRef(dataManager, conn, dataIds);
                pstmt = conn.prepareStatement("delete from " + dataManager.getCube() + " where FID = ? and (FState = " + 1 + " OR FState = " + 3 + " OR FState = " + 5 + ")");
                int in = mbgDatas.size();
                for (int i = 0; i < in; ++i) {
                    mbgData2222222 = (IMbgData)mbgDatas.get(i);
                    if (refMap.containsKey(mbgData2222222.getMbgDataId()) && refMap.get(mbgData2222222.getMbgDataId()).size() > 0 && BgParamUtils.removeDataCheckRef(dataManager.getCtx()) || mbgData2222222.getState() != 1 && mbgData2222222.getState() != 5) continue;
                    pstmt.setString(1, mbgData2222222.getMbgDataId());
                    pstmt.addBatch();
                    if (++index < 100) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        logger.error((Object)"delete sql error:", (Throwable)ex2);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end delete mbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }

    protected Map<String, Set<String>> queryOtherFormRef(MbgDataManager dataManager, Connection conn, List<String> dataIds) throws BgException {
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        if (dataManager.getBillId() != null) {
            String formId = null;
            String dataId = null;
            String noFindStr = "#";
            String billId = dataManager.getBillId();
            int ind = 0;
            int size = 0;
            int count = 0;
            int pos = 0;
            StringBuffer sql = new StringBuffer(1024);
            sql.append("select FDataId, FFormID from " + dataManager.getCubeEntry() + " where FFormID <> '" + billId + "' and FDataId IN (");
            for (ind = 1; ind < 50; ++ind) {
                sql.append("?,");
            }
            sql.append("?)");
            size = dataIds.size();
            count = (size - 1) / 50 + 1;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (int index = 0; index < count; ++index) {
                    int k = 1;
                    while (k <= 50) {
                        if (pos < size) {
                            pstmt.setString(k, dataIds.get(pos));
                        } else {
                            pstmt.setString(k, noFindStr);
                        }
                        ++k;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        formId = rst.getString("FFormID");
                        dataId = rst.getString("FDataId");
                        if (!refMap.containsKey(dataId)) {
                            refMap.put(dataId, new HashSet());
                        }
                        ((Set)refMap.get(dataId)).add(formId);
                    }
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        return refMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteTmpMbgData(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> delete) throws Exception {
        if (dataManager == null || delete == null || delete.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke delete tmpMbgData!");
        HashMap<String, IMbgData> mbgDatas = new HashMap<String, IMbgData>();
        Map<String, IMbgData> dataMap2222222 = null;
        IMbgData mbgData2222222 = null;
        String bgSchemeId = dataManager.getSchemeInfo().getId().toString();
        int dataIndex = 0;
        for (Map<String, IMbgData> dataMap2222222 : delete.values()) {
            for (IMbgData mbgData2222222 : dataMap2222222.values()) {
                mbgDatas.put(String.valueOf(dataIndex), mbgData2222222);
                ++dataIndex;
            }
        }
        if (!mbgDatas.isEmpty()) {
            int index = 0;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                pstmt = conn.prepareStatement("delete from " + dataManager.getTmpCube() + " where FID = ? and FBgSchemeRootId = ?");
                for (IMbgData mbgData2222222 : mbgDatas.values()) {
                    pstmt.setString(1, mbgData2222222.getMbgDataId());
                    pstmt.setString(2, bgSchemeId);
                    pstmt.addBatch();
                    if (++index < 100) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                Map splitDataMap = dataManager.getAccIntHelper().splitBgDatas(conn, mbgDatas, dataManager.getHasFormuls());
                for (String cubeName : splitDataMap.keySet()) {
                    index = 0;
                    pstmt = conn.prepareStatement("update " + cubeName + " set FTmpValue = FValue where FID = ?");
                    for (IMbgData mbgData2222222 : splitDataMap.get(cubeName).values()) {
                        pstmt.setString(1, mbgData2222222.getMbgDataId());
                        pstmt.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        logger.error((Object)"delete sql error:", (Throwable)ex2);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end delete tmpMbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }
}

