/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.IMbgBizFacade;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.app.data.MbgDataQuery;
import com.kingdee.eas.ma.mbg.app.data.QueryResult;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.MbgData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MbgDataFacade
implements IMbgDataFacade {
    private MbgDataManager dataManager = null;
    private MbgDataQuery query = null;
    private List<IMbgBizFacade> facades = new ArrayList<IMbgBizFacade>();

    public void setDataManager(MbgDataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public MbgDataManager getDataManager() {
        return this.dataManager;
    }

    public void setQuery(MbgDataQuery query) {
        this.query = query;
    }

    public MbgDataQuery getQuery() {
        return this.query;
    }

    @Override
    public void setCanRemoveData(boolean canRemoveData) {
        this.getDataManager().canRemoveData = canRemoveData;
    }

    @Override
    public void setAudit(boolean isAudit) {
        this.getDataManager().isAudit = isAudit;
    }

    @Override
    public void setIgnoreDataState(boolean IgnoreDataState) {
        this.getDataManager().ignoreDataState = IgnoreDataState;
    }

    protected List<IMbgBizFacade> getFacades() {
        return this.facades;
    }

    @Override
    public void registerFacade(IMbgBizFacade facade) {
        if (facade != null) {
            facade.setMbgDataFacade(this);
            this.getFacades().add(facade);
        }
    }

    @Override
    public void registerFacades(List<IMbgBizFacade> bizFacades) {
        if (bizFacades != null) {
            for (IMbgBizFacade mbgBizFacade : bizFacades) {
                mbgBizFacade.setMbgDataFacade(this);
                this.getFacades().add(mbgBizFacade);
            }
        }
    }

    public static IMbgDataFacade getInstance(Context ctx, String userId, String bgSchemeId, int valueType, boolean isAudit) throws BOSException, EASBizException {
        MbgDataFacade facade = new MbgDataFacade(ctx, userId, bgSchemeId, valueType);
        facade.setAudit(isAudit);
        return facade;
    }

    public static IMbgDataFacade getInstance(Context ctx, String userId, String bgSchemeId, int valueType) throws BOSException, EASBizException {
        return new MbgDataFacade(ctx, userId, bgSchemeId, valueType);
    }

    public static IMbgDataFacade getInstance(Context ctx, String userId, BgSchemeInfo bgScheme, int valueType) throws BOSException, EASBizException {
        return new MbgDataFacade(ctx, userId, bgScheme, valueType);
    }

    public static int getDataType(int valueType) {
        int dataType = DimensionConstants.DEFAULT_DATA_TYPE;
        if (valueType != 1 && valueType != 2) {
            if (valueType == 4) {
                dataType = DimensionConstants.ACTUAL_DATA_TYPE;
            } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
                dataType = DimensionConstants.ADDACTUAL_DATA_TYPE;
            } else if (valueType == 64) {
                dataType = DimensionConstants.CFS_DATA_TYPE;
            } else if (valueType == 128) {
                dataType = DimensionConstants.CFS_ADJUST_DATA_TYPE;
            }
        }
        return dataType;
    }

    @Override
    public void setBillId(String billId) {
        if (!StringUtils.isEmpty((String)billId)) {
            this.getDataManager().setBillId(billId);
        }
    }

    @Override
    public void setUnionId(String unionId) {
        if (!StringUtils.isEmpty((String)unionId)) {
            this.getDataManager().setUnionId(unionId);
        }
    }

    @Override
    public void setMbgDimMap(Map<String, MbgDimInfo> mbgDimMap) {
        if (mbgDimMap == null || mbgDimMap.isEmpty()) {
            return;
        }
        this.getDataManager().getMbgDimMap().putAll(mbgDimMap);
    }

    public void addCslData(String unionId, String orgUnitId, String formula, String versionNum, BigDecimal value) {
        if (StringUtils.isEmpty((String)unionId) || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)versionNum)) {
            return;
        }
        MbgData cslData = new MbgData();
        cslData.setUnionId(unionId);
        cslData.setOrgUnitId(orgUnitId);
        cslData.setFormula(formula);
        cslData.setVersionNum(versionNum);
        cslData.setValue(value);
        this.addMbgData(cslData);
    }

    @Override
    public void addMbgData(String orgUnitId, String formula, String versionNum, BigDecimal value) {
        this.addMbgData(orgUnitId, formula, versionNum, value, 1);
    }

    @Override
    public void addMbgData(String orgUnitId, String formula, String versionNum, BigDecimal value, int dataSource) {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)versionNum)) {
            return;
        }
        MbgData mbgData = new MbgData();
        mbgData.setOrgUnitId(orgUnitId);
        mbgData.setFormula(formula);
        mbgData.setVersionNum(versionNum);
        mbgData.setValue(value);
        mbgData.setBgDataSource(dataSource);
        if (this.getDataManager().getUnionId() != null) {
            mbgData.setUnionId(this.getDataManager().getUnionId());
        }
        this.addMbgData(mbgData);
    }

    @Override
    public void addMbgData(IMbgData mbgData) {
        if (mbgData == null) {
            return;
        }
        mbgData.parse();
        boolean verify = true;
        if (this.getDataManager().getValueType() == DimensionConstants.BUDGET_DATA_TYPE) {
            if (this.getDataManager().getAcScenario().contains(mbgData.getBgScenarioNum())) {
                verify = false;
            }
        } else if ((this.getDataManager().getValueType() == DimensionConstants.ACTUAL_DATA_TYPE || this.getDataManager().getValueType() == DimensionConstants.ADDACTUAL_DATA_TYPE) && this.getDataManager().getBgScenario().contains(mbgData.getBgScenarioNum())) {
            verify = false;
        }
        if (verify) {
            Map<Object, Object> dataMap = null;
            if (this.getDataManager().getMbgDataMap().containsKey(mbgData.getOrgUnitKey())) {
                dataMap = this.getDataManager().getMbgDataMap().get(mbgData.getOrgUnitKey());
            } else {
                dataMap = new HashMap();
                this.getDataManager().getMbgDataMap().put(mbgData.getOrgUnitKey(), dataMap);
            }
            dataMap.put(mbgData.getDimKey(), mbgData);
        }
    }

    @Override
    public void submit() throws Exception {
        QueryResult tmpResult;
        if (this.getDataManager().getMbgDataMap().isEmpty()) {
            return;
        }
        this.initData();
        this.executeBefore();
        QueryResult result = this.getQuery().compareMBgData();
        if (result != null) {
            this.getQuery().addnew.addnew(result.addnew);
            this.getQuery().update.update(result.update);
            this.getQuery().delete.delete(result.delete);
            this.getQuery().refData.refData(result);
        }
        if (this.getDataManager().getValueType() == DimensionConstants.ADJUST_DATA_TYPE && (tmpResult = this.getQuery().compareTmpMBgData()) != null) {
            tmpResult.synchMbgData(result);
            this.getQuery().addnew.addnewTmpData(tmpResult.addnew);
            this.getQuery().update.updateTmpData(tmpResult.update);
            this.getQuery().delete.deleteTmpData(tmpResult.delete);
            this.getQuery().refData.refTmpData(tmpResult);
        }
        this.executeAfter();
    }

    protected void initData() throws BOSException {
        if (this.getDataManager().getMbgDimMap().isEmpty()) {
            this.getDataManager().getMbgDimMap().putAll(this.queryMbgDim(this.getDataManager().getCtx()));
        }
        MbgDimInfo mbgDim2 = null;
        for (MbgDimInfo mbgDim2 : this.getDataManager().getMbgDimMap().values()) {
            this.getDataManager().getSrcFieldMap().put(mbgDim2.getSrcNumber(), mbgDim2.getRefField());
            this.getDataManager().getFieldSrcMap().put(mbgDim2.getRefField(), mbgDim2.getSrcNumber());
            this.getDataManager().getFieldNumMap().put(mbgDim2.getRefField(), mbgDim2.getNumber());
        }
    }

    protected void executeBefore() throws Exception {
        IMbgBizFacade iMbgFacade = null;
        int in = this.getFacades().size();
        for (int i = 0; i < in; ++i) {
            iMbgFacade = this.getFacades().get(i);
            if (!iMbgFacade.isBefore()) continue;
            iMbgFacade.executeBefore();
        }
    }

    protected void executeAfter() throws Exception {
        IMbgBizFacade iMbgFacade = null;
        int in = this.getFacades().size();
        for (int i = 0; i < in; ++i) {
            iMbgFacade = this.getFacades().get(i);
            if (!iMbgFacade.isAfter()) continue;
            iMbgFacade.executeAfter();
        }
    }

    protected MbgDataFacade(Context ctx, String userId, String bgSchemeId, int valueType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId) || ctx == null || StringUtils.isEmpty((String)userId)) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)bgSchemeId));
        this.init(ctx, userId, schemeInfo, valueType);
    }

    protected MbgDataFacade(Context ctx, String userId, BgSchemeInfo bgScheme, int valueType) throws BOSException, EASBizException {
        this.init(ctx, userId, bgScheme, valueType);
    }

    protected void init(Context ctx, String userId, BgSchemeInfo bgScheme, int valueType) throws BOSException, EASBizException {
        List versions;
        if (ctx == null || StringUtils.isEmpty((String)userId) || bgScheme == null) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        this.setDataManager(new MbgDataManager(ctx));
        this.getDataManager().setUserId(userId);
        this.getDataManager().setSchemeInfo(bgScheme);
        if (valueType != DimensionConstants.DEFAULT_DATA_TYPE && valueType != DimensionConstants.ADDACTUAL_DATA_TYPE && valueType != DimensionConstants.ADJUST_DATA_TYPE && valueType != DimensionConstants.CFS_DATA_TYPE && valueType != DimensionConstants.CFS_ADJUST_DATA_TYPE && valueType != DimensionConstants.DECOMPOSE_DATA_TYPE && valueType != DimensionConstants.DECOMPOSE_SENDDOWN_DATA_TYPE && valueType != DimensionConstants.DECOMPOSE_GATHER_DATA_TYPE) {
            valueType = DimensionConstants.DEFAULT_DATA_TYPE;
        }
        this.getDataManager().setValueType(valueType);
        List scenarios = BgScenarioHelper.getAllScenario((Context)ctx);
        if (scenarios != null) {
            for (BgScenarioInfo scenario : scenarios) {
                if (1 == scenario.getType().getValue()) {
                    this.getDataManager().getAcScenario().add(scenario.getNumber());
                } else {
                    this.getDataManager().getBgScenario().add(scenario.getNumber());
                }
                this.getDataManager().getScenarioNumMap().put(scenario.getNumber(), scenario.getScenarioId());
                this.getDataManager().getScenarioIndMap().put(scenario.getScenarioId(), scenario.getNumber());
            }
        }
        if ((versions = BgVersionHelper.getAllVersion((Context)ctx)) != null) {
            for (BgVersionInfo version : versions) {
                this.getDataManager().getVersionNumMap().put(version.getNumber(), version.getVersionId());
                this.getDataManager().getVersionIndMap().put(version.getVersionId(), version.getNumber());
            }
        }
        this.check();
        this.setQuery(new MbgDataQuery(this.getDataManager()));
    }

    protected void check() throws BOSException, EASBizException {
        BgCubeUtils.checkTable(this.getDataManager().getCtx());
    }

    private Map<String, MbgDimInfo> queryMbgDim(Context ctx) throws BOSException {
        HashMap<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                mbgDimMap.put(mbgDim.getNumber(), mbgDim);
            }
        }
        return mbgDimMap;
    }

    @Override
    public void setProcessType(BgProcessEnum processType) {
        this.getDataManager().processType = processType;
    }

    @Override
    public void setRef(boolean isSetRef) {
        this.getDataManager().setSetRef(isSetRef);
    }
}

