/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MbgDataManager {
    private Context ctx = null;
    private String userId = null;
    private BgSchemeInfo schemeInfo = null;
    private String billId = null;
    private String unionId = null;
    private int valueType = DimensionConstants.DEFAULT_DATA_TYPE;
    private Map<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
    private Map<String, String> srcFieldMap = new HashMap<String, String>();
    private Map<String, String> fieldSrcMap = new HashMap<String, String>();
    private Map<String, String> fieldNumMap = new HashMap<String, String>();
    private Set<String> bgScenario = new HashSet<String>();
    private Set<String> acScenario = new HashSet<String>();
    private Map<String, Integer> scenarioNumMap = new HashMap<String, Integer>();
    private Map<Integer, String> scenarioIndMap = new HashMap<Integer, String>();
    private Map<String, Integer> versionNumMap = new HashMap<String, Integer>();
    private Map<Integer, String> versionIndMap = new HashMap<Integer, String>();
    private Map<String, Map<String, IMbgData>> mbgDataMap = new HashMap<String, Map<String, IMbgData>>();
    private Set<String> hasFormuls = new HashSet<String>();
    public Map<String, Set<String>> clearDataMap = new HashMap<String, Set<String>>();
    public boolean hasClearData = false;
    public boolean canRemoveData = true;
    public boolean isAudit = false;
    public boolean ignoreDataState = false;
    public Map<String, Map<String, Set<String>>> mbgMemNumMap = new HashMap<String, Map<String, Set<String>>>();
    public BgProcessEnum processType = null;
    private BgSchemeAccIntHelper accIntHelper = null;
    private boolean isSetRef = true;

    public MbgDataManager(Context ctx) {
        this.setCtx(ctx);
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setSchemeInfo(BgSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public BgSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public String getCube() {
        String cube = this.getSchemeInfo().getRefCube();
        if (DimensionConstants.ADDACTUAL_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getDailyActualCubeName(cube);
        } else if (DimensionConstants.CFS_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getCFSCubeName(cube);
        } else if (DimensionConstants.CFS_ADJUST_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getCFSAdjustCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getDecomposeCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_SENDDOWN_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getDecomposeSendDownCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_GATHER_DATA_TYPE == this.getValueType()) {
            cube = BgCubeUtils.getDecomposeGatherCubeName(cube);
        }
        if (DimensionConstants.ADJUST_DATA_TYPE == this.getValueType() && this.processType != null) {
            cube = BgCubeUtils.getCubeName(cube, this.processType);
        }
        return cube;
    }

    public String getCubeEntry() {
        String cube = this.getSchemeInfo().getRefCube();
        String entry = BgCubeUtils.getBudgetEntryCubeName(cube);
        if (DimensionConstants.ADDACTUAL_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getDailyActualEntryCubeName(cube);
        } else if (DimensionConstants.CFS_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getCFSEntryCubeName(cube);
        } else if (DimensionConstants.CFS_ADJUST_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getCFSAdjustEntryCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getDecomposeEntryCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_SENDDOWN_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getDecomposeSendDownEntryCubeName(cube);
        } else if (DimensionConstants.DECOMPOSE_GATHER_DATA_TYPE == this.getValueType()) {
            entry = BgCubeUtils.getDecomposeGatherEntryCubeName(cube);
        }
        if (DimensionConstants.ADJUST_DATA_TYPE == this.getValueType() && this.processType != null) {
            if (this.processType.equals((Object)BgProcessEnum.C02)) {
                entry = BgCubeUtils.getDecomposeEntryCubeName(cube);
            } else if (this.processType.equals((Object)BgProcessEnum.C03)) {
                entry = BgCubeUtils.getDecomposeSendDownEntryCubeName(cube);
            } else if (this.processType.equals((Object)BgProcessEnum.C04)) {
                entry = BgCubeUtils.getDecomposeGatherEntryCubeName(cube);
            }
        }
        return entry;
    }

    public String getTmpCube() {
        return "T_MBG_BGTMPDATA";
    }

    public String getTmpCubeEntry() {
        return "T_MBG_BGTMPDATAENTRY";
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public int getValueType() {
        return this.valueType;
    }

    public Map<String, MbgDimInfo> getMbgDimMap() {
        return this.mbgDimMap;
    }

    public Map<String, String> getSrcFieldMap() {
        return this.srcFieldMap;
    }

    public Map<String, String> getFieldSrcMap() {
        return this.fieldSrcMap;
    }

    public Map<String, String> getFieldNumMap() {
        return this.fieldNumMap;
    }

    public Set<String> getBgScenario() {
        return this.bgScenario;
    }

    public Set<String> getAcScenario() {
        return this.acScenario;
    }

    public Map<String, Integer> getScenarioNumMap() {
        return this.scenarioNumMap;
    }

    public Map<Integer, String> getScenarioIndMap() {
        return this.scenarioIndMap;
    }

    public Map<String, Integer> getVersionNumMap() {
        return this.versionNumMap;
    }

    public Map<Integer, String> getVersionIndMap() {
        return this.versionIndMap;
    }

    public Map<String, Map<String, IMbgData>> getMbgDataMap() {
        return this.mbgDataMap;
    }

    public Set<String> getHasFormuls() {
        return this.hasFormuls;
    }

    public Map<String, Set<String>> getClearDataMap() {
        return this.clearDataMap;
    }

    public boolean hasCsl() {
        return DimensionConstants.CFS_DATA_TYPE == this.getValueType() || DimensionConstants.CFS_ADJUST_DATA_TYPE == this.getValueType();
    }

    public Map<String, Map<String, Set<String>>> getMbgMemNumMap() {
        return this.mbgMemNumMap;
    }

    public BgSchemeAccIntHelper getAccIntHelper() {
        if (this.accIntHelper == null) {
            this.accIntHelper = new BgSchemeAccIntHelper(this.getCtx(), this.getSchemeInfo().getId().toString(), this.getCube());
        }
        return this.accIntHelper;
    }

    public boolean isSetRef() {
        return this.isSetRef;
    }

    public void setSetRef(boolean isSetRef) {
        this.isSetRef = isSetRef;
    }
}

