/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.CFSMemberCheckHelper;
import com.kingdee.eas.ma.mbg.app.data.DimensionMemberCheck;
import com.kingdee.eas.ma.mbg.app.data.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.app.data.MbgDataAddnew;
import com.kingdee.eas.ma.mbg.app.data.MbgDataDelete;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.app.data.MbgDataRefData;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUpdate;
import com.kingdee.eas.ma.mbg.app.data.QueryResult;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.MbgData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataQuery {
    private static final Logger logger = Logger.getLogger(MbgDataQuery.class);
    public QueryResult result = null;
    public QueryResult tmpResult = null;
    public AddNew addnew = new AddNew();
    public Update update = new Update();
    public Delete delete = new Delete();
    public RefData refData = new RefData();
    private MbgDataManager dataManager = null;

    protected void setDataManager(MbgDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected MbgDataManager getDataManager() {
        return this.dataManager;
    }

    public MbgDataQuery(MbgDataManager dataManager) {
        this.setDataManager(dataManager);
    }

    public QueryResult compareMBgData() throws Exception {
        this.result = this.compareData(false);
        return this.result;
    }

    public QueryResult compareTmpMBgData() throws Exception {
        this.tmpResult = this.compareData(true);
        return this.tmpResult;
    }

    private QueryResult compareData(boolean hasQueryTmpTable) throws Exception {
        if (this.getDataManager().getMbgDataMap().isEmpty()) {
            return null;
        }
        QueryResult result = new QueryResult();
        String orgUnitId = null;
        String dimKey = null;
        String billId = null;
        Map.Entry<String, Map<String, IMbgData>> entry2 = null;
        Map.Entry<String, IMbgData> dEntry2 = null;
        Map<String, IMbgData> dataMap = null;
        Map<String, IMbgData> mbgMap = null;
        Map<String, IMbgData> schemaMap = null;
        IMbgData mbgData = null;
        billId = this.getDataManager().getBillId();
        Map<String, Map<String, IMbgData>> mbgDataMap = this.queryBillData(hasQueryTmpTable);
        Map<String, Map<String, IMbgData>> schemaDataMap = this.querySchemaData(mbgDataMap, hasQueryTmpTable);
        DimensionMemberCheck memberCheck = this.queryMemberData(this.getDataManager().getSchemeInfo(), this.getDataManager().getMbgDataMap());
        for (Map.Entry<String, Map<String, IMbgData>> entry2 : this.getDataManager().getMbgDataMap().entrySet()) {
            orgUnitId = entry2.getKey();
            dataMap = entry2.getValue();
            mbgMap = mbgDataMap != null ? mbgDataMap.get(orgUnitId) : null;
            schemaMap = schemaDataMap != null ? schemaDataMap.get(orgUnitId) : null;
            for (Map.Entry<String, IMbgData> dEntry2 : dataMap.entrySet()) {
                dimKey = dEntry2.getKey();
                mbgData = dEntry2.getValue();
                mbgData.setBillId(billId);
                if (hasQueryTmpTable && this.getDataManager().getAcScenario().contains(mbgData.getBgScenarioNum()) || !memberCheck.canSave(mbgData)) continue;
                this.updateMbgData(hasQueryTmpTable, orgUnitId, dimKey, mbgMap, schemaMap, mbgData, result);
            }
        }
        return result;
    }

    private void updateMbgData(boolean hasQueryTmpTable, String orgUnitId, String dimKey, Map<String, IMbgData> mbgMap, Map<String, IMbgData> schemaMap, IMbgData mbgData, QueryResult result) {
        if (orgUnitId == null || dimKey == null || mbgData == null || result == null) {
            return;
        }
        boolean hasRef = false;
        IMbgData oldData = null;
        if (mbgMap != null && mbgMap.containsKey(dimKey)) {
            oldData = mbgMap.get(dimKey);
            hasRef = true;
        } else if (schemaMap != null && schemaMap.containsKey(dimKey)) {
            oldData = schemaMap.get(dimKey);
        }
        if (oldData != null) {
            mbgData.setMbgDataId(oldData.getMbgDataId());
            mbgData.setState(oldData.getState());
        }
        if (mbgData.getValue() == null) {
            if (oldData != null && this.checkMbgDataState(mbgData)) {
                this.addMbgData(result.delete, orgUnitId, mbgData);
            }
        } else {
            if (oldData == null) {
                this.addMbgData(result.addnew, orgUnitId, mbgData);
            } else if (!this.compareValue(hasQueryTmpTable, mbgData, oldData) && (this.checkMbgDataState(mbgData) || this.dataManager.ignoreDataState)) {
                mbgData.setOldValue(oldData.getValue() != null ? oldData.getValue() : BigDecimal.ZERO);
                this.addMbgData(result.update, orgUnitId, mbgData);
            } else if (hasQueryTmpTable) {
                this.addMbgData(result.delete, orgUnitId, mbgData);
            }
            if (!hasRef && this.getDataManager().isSetRef()) {
                this.addMbgData(result.refData, orgUnitId, mbgData);
            }
        }
    }

    private boolean checkMbgDataState(IMbgData mbgData) {
        boolean check = false;
        if (this.getDataManager().getAcScenario().contains(mbgData.getBgScenarioNum())) {
            if (this.getDataManager().getValueType() == DimensionConstants.DEFAULT_DATA_TYPE || this.getDataManager().getValueType() == DimensionConstants.ACTUAL_DATA_TYPE) {
                check = true;
            } else if (this.getDataManager().getValueType() == DimensionConstants.ADDACTUAL_DATA_TYPE) {
                check = mbgData.getState() == 1 || mbgData.getState() == 3;
            } else if (this.getDataManager().getValueType() == DimensionConstants.CFS_DATA_TYPE || this.getDataManager().getValueType() == DimensionConstants.CFS_ADJUST_DATA_TYPE) {
                check = mbgData.getState() == 1;
            }
        } else {
            check = this.getDataManager().ignoreDataState ? true : (this.getDataManager().getValueType() == DimensionConstants.ADJUST_DATA_TYPE ? mbgData.getState() == 5 || mbgData.getState() == 9 || mbgData.getState() == 11 || mbgData.getState() == 13 : mbgData.getState() == 1 || mbgData.getState() == 3);
        }
        return check;
    }

    private boolean compareValue(boolean hasQueryTmpTable, IMbgData mbgData, IMbgData oldData) {
        if (hasQueryTmpTable) {
            return mbgData.getValue().setScale(8, 4).compareTo(oldData.getOldValue()) == 0;
        }
        return mbgData.getValue().setScale(8, 4).compareTo(oldData.getValue()) == 0;
    }

    private void addMbgData(Map<String, Map<String, IMbgData>> mbgDataMap, String orgUnitId, IMbgData mbgData) {
        if (mbgDataMap == null || orgUnitId == null || mbgData == null) {
            return;
        }
        Map<Object, Object> dataMap = null;
        if (mbgDataMap.containsKey(orgUnitId)) {
            dataMap = mbgDataMap.get(orgUnitId);
        } else {
            dataMap = new HashMap();
            mbgDataMap.put(orgUnitId, dataMap);
        }
        dataMap.put(mbgData.getDimKey(), mbgData);
    }

    protected Map<String, Map<String, IMbgData>> queryBillData(boolean hasQueryTmpTable) throws Exception {
        if (!hasQueryTmpTable) {
            this.getDataManager().getHasFormuls().clear();
        }
        HashMap<String, Map<String, IMbgData>> mbgDataMap = new HashMap<String, Map<String, IMbgData>>();
        if (StringUtils.isEmpty((String)this.getDataManager().getBillId())) {
            return mbgDataMap;
        }
        MbgData mbgData = null;
        Map<String, MbgData> dataMap = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        boolean hasCsl = this.getDataManager().hasCsl();
        try {
            conn = EJBFactory.getConnection((Context)this.getDataManager().getCtx());
            String queryCube = this.getQueryTable(hasQueryTmpTable);
            boolean isUseInt = this.getDataManager().getAccIntHelper().isUseAccInt();
            HashSet<String> cubes = new HashSet<String>();
            if (isUseInt && !hasQueryTmpTable) {
                cubes.addAll(this.getDataManager().getAccIntHelper().getSplitMap().values());
            } else {
                cubes.add(queryCube);
            }
            for (String cube : cubes) {
                String sql = this.getQueryBillSql(hasQueryTmpTable);
                if (isUseInt) {
                    sql = sql.replace(queryCube, cube);
                }
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, this.getDataManager().getBillId());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    mbgData = new MbgData();
                    mbgData.setMbgDataId(rst.getString("FID"));
                    mbgData.setOrgUnitId(this.getDataManager().getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                    mbgData.setFormula(rst.getString("FFormula"));
                    mbgData.setValue(rst.getBigDecimal("FValue"));
                    if (hasQueryTmpTable) {
                        mbgData.setOldValue(rst.getBigDecimal("FOldValue"));
                    }
                    mbgData.setState(rst.getInt("FState"));
                    mbgData.setVersionNum(rst.getString("FNumber"));
                    if (hasCsl) {
                        mbgData.setUnionId(rst.getString("FUnionID"));
                    }
                    if (mbgDataMap.containsKey(mbgData.getOrgUnitKey())) {
                        dataMap = (Map)mbgDataMap.get(mbgData.getOrgUnitKey());
                    } else {
                        dataMap = new HashMap();
                        mbgDataMap.put(mbgData.getOrgUnitKey(), dataMap);
                    }
                    dataMap.put(mbgData.getDimKey(), mbgData);
                    this.getDataManager().getHasFormuls().add(mbgData.getFormula());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"queryBillData sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return mbgDataMap;
    }

    protected String getQueryBillSql(boolean hasQueryTmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, " + (this.getDataManager().hasCsl() ? "t.FUnionID, " : "") + "t.FOrgUnitId, t.FFormula, " + this.getQueryValueField(hasQueryTmpTable) + ", t.FState, v.FNumber from " + this.getQueryTable(hasQueryTmpTable) + " t join T_MBG_BgVersion v on t.FVersion = v.FVersionid where t.Fid in (select FDataId From " + this.getQueryTableEntry(hasQueryTmpTable) + " Where FFormId = ?) ");
        if (hasQueryTmpTable && this.getDataManager().processType != null) {
            sql.append(" And FProcessType = " + this.getDataManager().processType.getValue());
        }
        return sql.toString();
    }

    protected String getQueryValueField(boolean hasQueryTmpTable) {
        return hasQueryTmpTable ? "t.FValue AS FValue, t.FOldValue" : "t.FValue AS FValue";
    }

    protected String getQueryTable(boolean hasQueryTmpTable) {
        if (hasQueryTmpTable) {
            return this.getDataManager().getTmpCube();
        }
        return this.getDataManager().getCube();
    }

    protected String getQueryTableEntry(boolean hasQueryTmpTable) {
        if (hasQueryTmpTable) {
            return this.getDataManager().getTmpCubeEntry();
        }
        return this.getDataManager().getCubeEntry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, IMbgData>> querySchemaData(Map<String, Map<String, IMbgData>> mbgDataMap, boolean hasQueryTmpTable) throws Exception {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        String ixBoTable;
        String tmpVersionTable;
        String tmpFormulaTable;
        String tmpOrgTable;
        String tmpUnionTable;
        TempTablePool pool;
        HashMap<String, Map<String, IMbgData>> schemaDataMap;
        block58: {
            IMbgData mbgData2222;
            Map<String, IMbgData> dataMap;
            block57: {
                schemaDataMap = new HashMap<String, Map<String, IMbgData>>();
                Map.Entry<String, Map<String, IMbgData>> entry2222 = null;
                Object var5_5 = null;
                dataMap = null;
                Map<String, IMbgData> billDataMap = null;
                HashSet<String> unionIds = new HashSet<String>();
                HashSet<String> orgUnitIds = new HashSet<String>();
                HashSet<String> formulas = new HashSet<String>();
                HashSet<Integer> versionInds = new HashSet<Integer>();
                String orgUnitKey = null;
                mbgData2222 = null;
                boolean hasCsl = this.getDataManager().hasCsl();
                for (Map.Entry<String, Map<String, IMbgData>> entry2222 : this.getDataManager().getMbgDataMap().entrySet()) {
                    orgUnitKey = entry2222.getKey();
                    dataMap = entry2222.getValue();
                    if (mbgDataMap != null && mbgDataMap.containsKey(orgUnitKey)) {
                        billDataMap = mbgDataMap.get(orgUnitKey);
                        for (Map.Entry entry : dataMap.entrySet()) {
                            if (billDataMap.containsKey(entry.getKey())) continue;
                            mbgData2222 = (IMbgData)entry.getValue();
                            if (mbgData2222.getUnionId() != null) {
                                unionIds.add(mbgData2222.getUnionId());
                            }
                            orgUnitIds.add(mbgData2222.getOrgUnitId());
                            formulas.add(mbgData2222.getFormula());
                            versionInds.add(this.getDataManager().getVersionNumMap().get(mbgData2222.getVersionNum()));
                        }
                        continue;
                    }
                    for (IMbgData mbgData2222 : dataMap.values()) {
                        if (mbgData2222.getUnionId() != null) {
                            unionIds.add(mbgData2222.getUnionId());
                        }
                        orgUnitIds.add(mbgData2222.getOrgUnitId());
                        formulas.add(mbgData2222.getFormula());
                        versionInds.add(this.getDataManager().getVersionNumMap().get(mbgData2222.getVersionNum()));
                    }
                }
                if (orgUnitIds.isEmpty()) return schemaDataMap;
                if (formulas.isEmpty()) {
                    return schemaDataMap;
                }
                pool = TempTablePool.getInstance((Context)this.getDataManager().getCtx());
                tmpUnionTable = null;
                tmpOrgTable = null;
                tmpFormulaTable = null;
                tmpVersionTable = null;
                ixBoTable = null;
                conn = null;
                pstmt = null;
                rst = null;
                try {
                    conn = EJBFactory.getConnection((Context)this.getDataManager().getCtx());
                    BgCubeUtils.checkTable(conn);
                    if (hasCsl) {
                        tmpUnionTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpUnionTable + " (FID) values (?)"), unionIds);
                    }
                    tmpOrgTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)", conn);
                    if (this.getDataManager().getAccIntHelper().isUseAccInt()) {
                        this.getDataManager().getAccIntHelper().insertToTmpTable(conn, tmpOrgTable, orgUnitIds, DimensionConstants.DEF_ORGUNIT_FIELD, true);
                    } else {
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID) values (?)"), orgUnitIds);
                    }
                    tmpFormulaTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))", conn);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormulaTable + " (FFormula) values (?)"), formulas);
                    tmpVersionTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FVersion INT DEFAULT 0)", conn);
                    BgDBUtils.insertKey1((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FVersion) values (?)"), versionInds);
                    StringBuffer sql = new StringBuffer();
                    if (hasQueryTmpTable) {
                        sql.append("select t.FID, t.FOrgUnitId, t.FFormula, " + this.getQueryValueField(hasQueryTmpTable) + ", t.FState, t.FVersion from " + this.getDataManager().getTmpCube() + " t where t.FBgSchemeRootId = ? and exists (select FID from " + tmpOrgTable + " where t.FOrgUnitId = FID) and exists (select FFormula from " + tmpFormulaTable + " where t.FFormula = FFormula) and exists (select FVersion from " + tmpVersionTable + " where t.FVersion = FVersion) ");
                        if (this.getDataManager().processType != null) {
                            sql.append(" and FProcessType = " + this.getDataManager().processType.getValue());
                        }
                        pstmt = conn.prepareStatement(sql.toString());
                        pstmt.setString(1, this.getDataManager().getSchemeInfo().getId().toString());
                        rst = pstmt.executeQuery();
                        break block57;
                    }
                    ixBoTable = pool.createTempTable("Create Table T_MBG_BgDataTmpId(FID Varchar(44), FOrgUnitId Varchar(44) NOT NULL, FOrgUnitIntId INT, FFormula NVARCHAR(300) NOT NULL, FVersion INT NOT NULL)");
                    Set<String> bgDataTables = this.getDataManager().getAccIntHelper().getSplitTablesByFormula(formulas);
                    for (String cube : bgDataTables) {
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + ixBoTable + "(FOrgUnitId, FOrgUnitIntId, FFormula, FVersion) Select t0.FID, t0.FIntId, t1.FFormula, t2.FVersion FROM " + tmpOrgTable + " t0, " + tmpFormulaTable + " t1, " + tmpVersionTable + " t2"));
                        String sqlTmp = "Update " + ixBoTable + " t0 Set FID = (Select " + BgCubeUtils.getBgDataHint(cube, "t1", "IX_MBG_BO", this.getDataManager().getAccIntHelper().isUseAccInt()) + "FID FROM " + cube + " t1 Where FOrgUnitId = t0." + (this.getDataManager().getAccIntHelper().isUseAccInt() ? "FOrgUnitIntId" : "FOrgUnitId") + " AND FFormula = t0.FFormula AND FVersion = t0.FVersion";
                        if (hasCsl) {
                            sqlTmp = sqlTmp + " and exists (select FID from " + tmpUnionTable + " where t1.FUnionID = FID)";
                        }
                        sqlTmp = sqlTmp + ")";
                        BgDBUtils.executeUpdate((Connection)conn, (String)sqlTmp);
                        sql.setLength(0);
                        sql.append("select t.FID, " + (hasCsl ? "t.FUnionID, " : "") + "t.FOrgUnitId, t.FFormula, " + this.getQueryValueField(hasQueryTmpTable) + ", t.FState, t.FVersion from " + cube + " t where FID IN(Select FID FROM " + ixBoTable + " Where FID IS NOT NULL)");
                        pstmt = conn.prepareStatement(sql.toString());
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            mbgData2222 = new MbgData();
                            mbgData2222.setMbgDataId(rst.getString("FID"));
                            mbgData2222.setOrgUnitId(this.getDataManager().getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                            mbgData2222.setFormula(rst.getString("FFormula"));
                            mbgData2222.setValue(rst.getBigDecimal("FValue"));
                            mbgData2222.setState(rst.getInt("FState"));
                            mbgData2222.setVersionNum(this.getDataManager().getVersionIndMap().get(rst.getInt("FVersion")));
                            if (hasCsl) {
                                mbgData2222.setUnionId(rst.getString("FUnionID"));
                            }
                            if (schemaDataMap.containsKey(mbgData2222.getOrgUnitKey())) {
                                dataMap = (Map)schemaDataMap.get(mbgData2222.getOrgUnitKey());
                            } else {
                                dataMap = new HashMap<String, IMbgData>();
                                schemaDataMap.put(mbgData2222.getOrgUnitKey(), dataMap);
                            }
                            dataMap.put(mbgData2222.getDimKey(), mbgData2222);
                        }
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    }
                    break block58;
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"queryBillData sql error:", (Throwable)ex);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        if (pool != null && tmpUnionTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpUnionTable, conn);
                            }
                            catch (Exception ex2) {
                                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex2);
                            }
                        }
                        if (pool != null && tmpOrgTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpOrgTable, conn);
                            }
                            catch (Exception ex3) {
                                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex3);
                            }
                        }
                        if (pool != null && tmpFormulaTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
                            }
                            catch (Exception ex4) {
                                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex4);
                            }
                        }
                        if (pool != null && tmpVersionTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpVersionTable, conn);
                            }
                            catch (Exception ex5) {
                                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex5);
                            }
                        }
                        if (pool != null && ixBoTable != null) {
                            try {
                                pool.releaseTable(ixBoTable);
                            }
                            catch (Exception ex6) {
                                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex6);
                            }
                        }
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            while (rst.next()) {
                mbgData2222 = new MbgData();
                mbgData2222.setMbgDataId(rst.getString("FID"));
                if (hasQueryTmpTable) {
                    mbgData2222.setOrgUnitId(rst.getString("FOrgUnitId"));
                } else {
                    mbgData2222.setOrgUnitId(this.getDataManager().getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                }
                mbgData2222.setFormula(rst.getString("FFormula"));
                mbgData2222.setValue(rst.getBigDecimal("FValue"));
                mbgData2222.setOldValue(rst.getBigDecimal("FOldValue"));
                mbgData2222.setState(rst.getInt("FState"));
                mbgData2222.setVersionNum(this.getDataManager().getVersionIndMap().get(rst.getInt("FVersion")));
                if (schemaDataMap.containsKey(mbgData2222.getOrgUnitId())) {
                    dataMap = (HashMap<String, IMbgData>)schemaDataMap.get(mbgData2222.getOrgUnitId());
                } else {
                    dataMap = new HashMap<String, IMbgData>();
                    schemaDataMap.put(mbgData2222.getOrgUnitId(), dataMap);
                }
                dataMap.put(mbgData2222.getDimKey(), mbgData2222);
            }
        }
        if (pool != null && tmpUnionTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpUnionTable, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            }
        }
        if (pool != null && tmpOrgTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpOrgTable, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            }
        }
        if (pool != null && tmpFormulaTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            }
        }
        if (pool != null && tmpVersionTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpVersionTable, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            }
        }
        if (pool != null && ixBoTable != null) {
            try {
                pool.releaseTable(ixBoTable);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            }
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        return schemaDataMap;
    }

    private boolean checkCslCacheData(DimensionMemberCheck memberCheck, IMbgData mbgData, Map<String, IMbgData> tmpDataMap) {
        if (memberCheck == null || mbgData == null) {
            return false;
        }
        return !memberCheck.canSave(mbgData) && this.checkCslCacheData(mbgData) && (tmpDataMap == null || !tmpDataMap.containsKey(mbgData.getDimKey()));
    }

    private boolean checkCslCacheData(IMbgData mbgData) {
        if (mbgData == null) {
            return false;
        }
        if (mbgData.getDimNumber() != null) {
            return mbgData.getDimNumber().indexOf(BgCslDimConstants.csl01) > 0 || mbgData.getDimNumber().indexOf(BgCslDimConstants.csl02) > 0 || mbgData.getDimNumber().indexOf(BgCslDimConstants.csl03) > 0;
        }
        return mbgData.getFormula().indexOf(BgCslDimConstants.csl01) > 0 || mbgData.getFormula().indexOf(BgCslDimConstants.csl02) > 0 || mbgData.getFormula().indexOf(BgCslDimConstants.csl03) > 0;
    }

    private DimensionMemberCheck queryMemberData(BgSchemeInfo schemeInfo, Map<String, Map<String, IMbgData>> mbgDataMap) throws Exception {
        if (this.getDataManager().getValueType() == DimensionConstants.CFS_DATA_TYPE || this.getDataManager().getValueType() == DimensionConstants.CFS_ADJUST_DATA_TYPE) {
            return new CFSMemberCheckHelper(this.getDataManager()).build(schemeInfo, mbgDataMap);
        }
        return new DimensionMemberCheckHelper(this.getDataManager()).build(schemeInfo, mbgDataMap);
    }

    class RefData {
        private MbgDataRefData face = null;

        RefData() {
        }

        private MbgDataRefData getInstance() {
            if (this.face == null) {
                this.face = MbgDataRefData.getInstance();
            }
            return this.face;
        }

        public void refData(QueryResult result) throws Exception {
            this.getInstance().refData(MbgDataQuery.this.getDataManager(), result);
        }

        public void refTmpData(QueryResult result) throws Exception {
            this.getInstance().refTmpData(MbgDataQuery.this.getDataManager(), result);
        }
    }

    class Delete {
        private MbgDataDelete face = null;

        Delete() {
        }

        private MbgDataDelete getInterface() {
            if (this.face == null) {
                this.face = MbgDataDelete.getInstance();
            }
            return this.face;
        }

        public void delete(Map<String, Map<String, IMbgData>> delete) throws Exception {
            if (MbgDataQuery.this.getDataManager().canRemoveData) {
                this.getInterface().delete(MbgDataQuery.this.getDataManager(), delete);
            }
        }

        public void deleteTmpData(Map<String, Map<String, IMbgData>> delete) throws Exception {
            this.getInterface().deleteTmpMbgData(MbgDataQuery.this.getDataManager(), delete);
        }
    }

    class Update {
        private MbgDataUpdate face = null;

        Update() {
        }

        private MbgDataUpdate getInterface() {
            if (this.face == null) {
                this.face = MbgDataUpdate.getInstance();
            }
            return this.face;
        }

        public void update(Map<String, Map<String, IMbgData>> update) throws Exception {
            this.getInterface().update(MbgDataQuery.this.getDataManager(), update);
        }

        public void updateTmpData(Map<String, Map<String, IMbgData>> update) throws Exception {
            this.getInterface().updateTmpMbgData(MbgDataQuery.this.getDataManager(), update);
        }
    }

    class AddNew {
        private MbgDataAddnew face = null;

        AddNew() {
        }

        private MbgDataAddnew getInterface() {
            if (this.face == null) {
                this.face = MbgDataAddnew.getInstance();
            }
            return this.face;
        }

        public void addnew(Map<String, Map<String, IMbgData>> addnew) throws Exception {
            this.getInterface().addnew(MbgDataQuery.this.getDataManager(), addnew);
        }

        public void addnewTmpData(Map<String, Map<String, IMbgData>> addnew) throws Exception {
            this.getInterface().addnewTmpMbgData(MbgDataQuery.this.getDataManager(), addnew);
        }
    }
}

