/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.app.data.QueryResult;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.MbgData;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataRefData {
    private static final Logger logger = Logger.getLogger(MbgDataRefData.class);

    public static MbgDataRefData getInstance() {
        return new MbgDataRefData();
    }

    public void refData(MbgDataManager dataManager, QueryResult result) throws Exception {
        if (dataManager == null || dataManager.getBillId() == null || result == null) {
            return;
        }
        String type = BOSUuid.read((String)dataManager.getBillId()).getType().toString();
        if (type.equals("3BA5F027") || type.equals("655ADD42") || type.equals("9E7BD5E2") || type.equals("AD34C4CD")) {
            this.refDataByForm(dataManager, result);
        }
    }

    private void refDataByForm(MbgDataManager dataManager, QueryResult result) throws Exception {
        if (dataManager == null || result == null || StringUtils.isEmpty((String)dataManager.getBillId())) {
            return;
        }
        String refKey = null;
        HashSet<String> refKeySet = new HashSet<String>();
        ArrayList<IMbgData> mbgDatas = new ArrayList<IMbgData>();
        ArrayList<IMbgData> delDatas = new ArrayList<IMbgData>();
        Map<String, IMbgData> dataMap2 = null;
        IMbgData mbgData2 = null;
        for (Map<String, IMbgData> dataMap2 : result.addnew.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                mbgData2.setBillId(dataManager.getBillId());
                refKey = mbgData2.getBillId() + "_" + mbgData2.getMbgDataId();
                if (refKeySet.contains(refKey)) continue;
                refKeySet.add(refKey);
                mbgDatas.add(mbgData2);
            }
        }
        for (Map<String, IMbgData> dataMap2 : result.update.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                mbgData2.setBillId(dataManager.getBillId());
                refKey = mbgData2.getBillId() + "_" + mbgData2.getMbgDataId();
                if (refKeySet.contains(refKey)) continue;
                refKeySet.add(refKey);
                mbgDatas.add(mbgData2);
            }
        }
        for (Map<String, IMbgData> dataMap2 : result.refData.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                mbgData2.setBillId(dataManager.getBillId());
                refKey = mbgData2.getBillId() + "_" + mbgData2.getMbgDataId();
                if (refKeySet.contains(refKey)) continue;
                refKeySet.add(refKey);
                mbgDatas.add(mbgData2);
            }
        }
        for (Map<String, IMbgData> dataMap2 : result.delete.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                delDatas.add(mbgData2);
            }
        }
        if (!mbgDatas.isEmpty() || !delDatas.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            TempTablePool pool = TempTablePool.getInstance((Context)dataManager.getCtx());
            String tmpTable = null;
            String entry = dataManager.getCubeEntry();
            int index = 0;
            try {
                int i;
                int in;
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormID VARCHAR(44), FDataID VARCHAR(44))", conn);
                if (!mbgDatas.isEmpty()) {
                    pstmt = conn.prepareStatement("Insert Into " + tmpTable + " (FFormID, FDataID) values (?,?)");
                    in = mbgDatas.size();
                    for (i = 0; i < in; ++i) {
                        mbgData2 = (IMbgData)mbgDatas.get(i);
                        pstmt.setString(1, mbgData2.getBillId());
                        pstmt.setString(2, mbgData2.getMbgDataId());
                        pstmt.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                        index = 0;
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + entry + " (FFormID, FDataID) Select t.FFormID, t.FDataID from " + tmpTable + " t where not exists (select * from " + entry + " where FFormID = t.FFormID and FDataID = t.FDataID)"));
                }
                if (!delDatas.isEmpty()) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + tmpTable));
                    pstmt = conn.prepareStatement("Insert Into " + tmpTable + " (FFormID, FDataID) values (?,?)");
                    in = delDatas.size();
                    for (i = 0; i < in; ++i) {
                        mbgData2 = (IMbgData)delDatas.get(i);
                        if (mbgData2.getBillId() == null) continue;
                        pstmt.setString(1, mbgData2.getBillId());
                        pstmt.setString(2, mbgData2.getMbgDataId());
                        pstmt.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                        index = 0;
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + entry + " where exists (select * from " + tmpTable + " where FFormID = " + entry + ".FFormID and FDataID = " + entry + ".FDataID)"));
                }
            }
            catch (SQLDataException ex) {
                throw new BOSException((Throwable)ex);
            }
            catch (SQLException ex) {
                logger.error((Object)"refData sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                if (pool != null && tmpTable != null) {
                    try {
                        pool.releaseDBSystemTempTable(tmpTable, conn);
                    }
                    catch (Exception exception) {}
                }
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
    }

    public void refTmpData(MbgDataManager dataManager, QueryResult result) throws Exception {
        if (dataManager == null || dataManager.getBillId() == null || result == null) {
            return;
        }
        this.refTmpDataCommon(dataManager, result);
        BOSObjectType type = BOSUuid.read((String)dataManager.getBillId()).getType();
        if (type.equals((Object)new BgAdjustBillInfo().getBOSType())) {
            this.refTmpDataByAdjust(dataManager, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refTmpDataByAdjust(MbgDataManager dataManager, QueryResult result) throws Exception {
        if (dataManager == null) return;
        if (dataManager.getBillId() == null) return;
        if (result == null) {
            return;
        }
        Map<String, IMbgData> mbgDataMap2222222 = null;
        ArrayList<IMbgData> refDatas = new ArrayList<IMbgData>();
        for (Map<String, IMbgData> mbgDataMap2222222 : result.addnew.values()) {
            refDatas.addAll(mbgDataMap2222222.values());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IDimData dimData = null;
        try {
            conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
            HashSet<String> formulaSet = new HashSet<String>();
            if (!refDatas.isEmpty()) {
                try {
                    pstmt = conn.prepareStatement("update T_MBG_BgAdjustBillEntry Set FBgDataId = ? where FBgAdjustBill = ? and FOrgUnit = ? and FFormula = ? and FBgDataId is null");
                    for (IMbgData iMbgData : refDatas) {
                        if (!(iMbgData instanceof IDimData)) continue;
                        dimData = (IDimData)iMbgData;
                        pstmt.setString(1, dimData.getMbgDataId());
                        pstmt.setString(2, dataManager.getBillId());
                        pstmt.setString(3, dimData.getBgOrgUnitId());
                        pstmt.setString(4, iMbgData.getFormula());
                        formulaSet.add(iMbgData.getFormula());
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            pstmt = conn.prepareStatement("Select FOrgUnit, FFormula FROM T_MBG_BgAdjustBillEntry Where FBgAdjustBill = ? AND FBgDataId is null");
            pstmt.setString(1, dataManager.getBillId());
            rst = pstmt.executeQuery();
            boolean hasException = false;
            while (rst.next()) {
                hasException = true;
                logger.error((Object)("refTmpDataByAdjust Error OrgUnitId:" + rst.getString(1) + " Formula:" + rst.getString(2)));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (hasException) {
                Iterator iterator = refDatas.iterator();
                while (iterator.hasNext()) {
                    IMbgData mbgData = (IMbgData)iterator.next();
                    if (!(mbgData instanceof IDimData)) continue;
                    logger.error((Object)("refTmpDataByAdjust refDatas OrgUnitId:" + mbgData.getOrgUnitId() + " Formula:" + mbgData.getFormula()));
                }
                throw new BgAdjustException(BgAdjustException.CHECKBGDATAID);
            }
            if (!formulaSet.isEmpty()) {
                Set<String> set = dataManager.getAccIntHelper().getSplitTablesByFormula(formulaSet);
                for (String cube : set) {
                    pstmt = conn.prepareStatement("Select FOrgUnit, FFormula FROM T_MBG_BgAdjustBillEntry t0 Where FBgAdjustBill = ?  AND Exists(Select FID FROM " + cube + " Where FID = t0.FBgDataId AND FState IN(" + 1 + "," + 3 + "))");
                    pstmt.setString(1, dataManager.getBillId());
                    rst = pstmt.executeQuery();
                    if (!rst.next()) continue;
                    throw new BgAdjustException(BgAdjustException.CHECKDATASTATE);
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"refTmpDataByAdjust sql error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refTmpDataCommon(MbgDataManager dataManager, QueryResult result) throws Exception {
        block22: {
            if (dataManager == null || dataManager.getBillId() == null || result == null) {
                return;
            }
            Map<String, IMbgData> mbgDataMap2 = null;
            ArrayList<IMbgData> newDatas = new ArrayList<IMbgData>();
            ArrayList<IMbgData> delDatas = new ArrayList<IMbgData>();
            for (Map<String, IMbgData> mbgDataMap2 : result.addnew.values()) {
                newDatas.addAll(mbgDataMap2.values());
            }
            for (Map<String, IMbgData> mbgDataMap2 : result.delete.values()) {
                delDatas.addAll(mbgDataMap2.values());
            }
            if (!newDatas.isEmpty() || !delDatas.isEmpty()) {
                Connection conn = null;
                PreparedStatement pstmt = null;
                IDimData dimData = null;
                MbgData mbgDataTmp = null;
                String tmpTable = null;
                try {
                    conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                    if (!newDatas.isEmpty()) {
                        Object[] objs = null;
                        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
                        for (IMbgData mbgData : newDatas) {
                            if (mbgData instanceof IDimData) {
                                dimData = (IDimData)mbgData;
                                objs = new Object[]{dataManager.getBillId(), dimData.getMbgDataId()};
                                sqlParams.add(objs);
                            }
                            if (!(mbgData instanceof MbgData) || mbgData instanceof IDimData) continue;
                            mbgDataTmp = (MbgData)mbgData;
                            objs = new Object[2];
                            if (dataManager == null || dataManager.getBillId() == null || mbgDataTmp.getMbgDataId() == null) continue;
                            objs[0] = dataManager.getBillId();
                            objs[1] = mbgDataTmp.getMbgDataId();
                            sqlParams.add(objs);
                        }
                        TempTablePool pool = TempTablePool.getInstance((Context)dataManager.getCtx());
                        try {
                            tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormId VARCHAR(44), FDataId VARCHAR(44))", conn);
                            BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTable + " (FFormId, FDataId) values (?,?)"), sqlParams);
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into T_MBG_BgTmpDataEntry (FFormId, FDataId) select t.FFormId, t.FDataId from " + tmpTable + " t where not exists (select * from T_MBG_BgTmpDataEntry where FFormId = t.FFormId and FDataId = t.FDataId)"));
                        }
                        finally {
                            if (pool != null && tmpTable != null) {
                                pool.releaseDBSystemTempTable(tmpTable, conn);
                            }
                        }
                    }
                    if (delDatas.isEmpty()) break block22;
                    try {
                        pstmt = conn.prepareStatement("delete T_MBG_BgTmpDataEntry where FFormId = ? and FDataId = ?");
                        for (IMbgData mbgData : delDatas) {
                            if (!(mbgData instanceof IDimData)) continue;
                            dimData = (IDimData)mbgData;
                            pstmt.setString(1, dataManager.getBillId());
                            pstmt.setString(2, dimData.getMbgDataId());
                            pstmt.addBatch();
                        }
                        pstmt.executeBatch();
                    }
                    finally {
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                }
                catch (SQLDataException ex) {
                    throw new BOSException((Throwable)ex);
                }
                catch (SQLException ex) {
                    logger.error((Object)"refTmpDataCommon sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                }
            }
        }
    }
}

