/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.util.app.DbUtil;

public class MbgDataTempTableUtils {
    private boolean isBatch = false;
    private TempTablePool pool = null;
    private Context ctx = null;
    private String indexTable = null;
    private String periodTable = null;
    private String elementTable = null;
    private String currencyTable = null;
    private String scenarioTable = null;

    public MbgDataTempTableUtils(Context ctx) {
        this.ctx = ctx;
        this.pool = TempTablePool.getInstance((Context)ctx);
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public String getIndexTable() throws EASBizException, BOSException {
        if (this.indexTable == null) {
            this.indexTable = this.createTmpTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntId INT)");
        } else {
            this.clearData(this.indexTable);
        }
        return this.indexTable;
    }

    public String getPeriodTable() throws EASBizException, BOSException {
        if (this.periodTable == null) {
            this.periodTable = this.createTmpTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)");
        } else {
            this.clearData(this.periodTable);
        }
        return this.periodTable;
    }

    public String getElementTable() throws EASBizException, BOSException {
        if (this.elementTable == null) {
            this.elementTable = this.createTmpTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)");
        } else {
            this.clearData(this.elementTable);
        }
        return this.elementTable;
    }

    public String getCurrencyTable() throws EASBizException, BOSException {
        if (this.currencyTable == null) {
            this.currencyTable = this.createTmpTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
        } else {
            this.clearData(this.currencyTable);
        }
        return this.currencyTable;
    }

    public String getScenarioTable() throws EASBizException, BOSException {
        if (this.scenarioTable == null) {
            this.scenarioTable = this.createTmpTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
        } else {
            this.clearData(this.scenarioTable);
        }
        return this.scenarioTable;
    }

    public void onRelease() {
        if (!this.isBatch) {
            this.batchRelease();
        }
    }

    public void batchRelease() {
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.indexTable);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.periodTable);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.elementTable);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.currencyTable);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.scenarioTable);
    }

    private String createTmpTable(String createSql) throws EASBizException, BOSException {
        return BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)createSql);
    }

    private void clearData(String table) throws BOSException {
        DbUtil.execute((Context)this.ctx, (String)("Delete FROM " + table));
    }
}

