/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgPastDataInfo;
import com.kingdee.eas.ma.mbg.BgPastRecordFactory;
import com.kingdee.eas.ma.mbg.BgPastRecordInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.app.data.MbgDataManager;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgDataUpdate {
    private static final Logger logger = Logger.getLogger(MbgDataUpdate.class);

    public static MbgDataUpdate getInstance() {
        return new MbgDataUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> update) throws Exception {
        if (dataManager == null || update == null || update.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin update mbgData!");
        HashMap<String, IMbgData> bgDatas = new HashMap<String, IMbgData>();
        HashMap<String, IMbgData> acDatas = new HashMap<String, IMbgData>();
        Map<String, IMbgData> dataMap2 = null;
        IMbgData mbgData2 = null;
        int index = 0;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map<String, IMbgData> dataMap2 : update.values()) {
            for (IMbgData mbgData2 : dataMap2.values()) {
                if (dataManager.getAcScenario().contains(mbgData2.getBgScenarioNum())) {
                    acDatas.put(mbgData2.getOrgDimKey(), mbgData2);
                    continue;
                }
                bgDatas.put(mbgData2.getOrgDimKey(), mbgData2);
            }
        }
        Map tmpDataMap = null;
        if (!bgDatas.isEmpty() || !acDatas.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            StringBuffer sql = new StringBuffer();
            try {
                conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                ArrayList<IMbgData> divDatas = new ArrayList<IMbgData>();
                if (!bgDatas.isEmpty()) {
                    tmpDataMap = dataManager.getAccIntHelper().splitBgDatas(conn, bgDatas, dataManager.getHasFormuls());
                    for (String cube : tmpDataMap.keySet()) {
                        if (dataManager.getValueType() == DimensionConstants.ADJUST_DATA_TYPE) {
                            block32: {
                                try {
                                    pstmt = dataManager.ignoreDataState ? conn.prepareStatement("Update " + cube + " Set FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ? and (FState = " + 5 + " OR FState = " + 9 + " OR FState = " + 11 + " OR FState = " + 13 + " OR FState = " + 1 + ")") : conn.prepareStatement("Update " + cube + " Set FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ? and (FState = " + 5 + " OR FState = " + 9 + " OR FState = " + 11 + " OR FState = " + 13 + ")");
                                    for (IMbgData mbgData2 : tmpDataMap.get(cube).values()) {
                                        pstmt.setBigDecimal(1, mbgData2.getValue());
                                        pstmt.setString(2, dataManager.getUserId());
                                        pstmt.setTimestamp(3, timestamp);
                                        pstmt.setString(4, mbgData2.getMbgDataId());
                                        pstmt.addBatch();
                                        if (++index < 100) continue;
                                        pstmt.executeBatch();
                                        index = 0;
                                    }
                                    if (index <= 0) break block32;
                                    pstmt.executeBatch();
                                    index = 0;
                                }
                                catch (Throwable throwable) {
                                    SQLUtils.cleanup(pstmt);
                                    throw throwable;
                                }
                            }
                            SQLUtils.cleanup((Statement)pstmt);
                            continue;
                        }
                        sql.setLength(0);
                        sql.append("Update " + cube + " Set FValue = ?, FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? " + (dataManager.isAudit ? ", FState = 9" : "") + " where FID = ?");
                        if (!dataManager.ignoreDataState) {
                            sql.append(" and (FState = 1 OR FState = 3)");
                        }
                        try {
                            pstmt = conn.prepareStatement(sql.toString());
                            for (IMbgData mbgData2 : tmpDataMap.get(cube).values()) {
                                if (dataManager.ignoreDataState && (mbgData2.getState() == 9 || mbgData2.getState() == 11 || mbgData2.getState() == 13) && !divDatas.contains(mbgData2)) {
                                    divDatas.add(mbgData2);
                                }
                                pstmt.setBigDecimal(1, mbgData2.getValue());
                                pstmt.setBigDecimal(2, mbgData2.getValue());
                                pstmt.setString(3, dataManager.getUserId());
                                pstmt.setTimestamp(4, timestamp);
                                pstmt.setString(5, mbgData2.getMbgDataId());
                                pstmt.addBatch();
                                if (++index < 100) continue;
                                pstmt.executeBatch();
                                index = 0;
                            }
                            if (index <= 0) continue;
                            pstmt.executeBatch();
                            index = 0;
                        }
                        finally {
                            SQLUtils.cleanup((Statement)pstmt);
                        }
                    }
                }
                if (!acDatas.isEmpty()) {
                    tmpDataMap = dataManager.getAccIntHelper().splitBgDatas(conn, acDatas, dataManager.getHasFormuls());
                    for (String cube : tmpDataMap.keySet()) {
                        block33: {
                            sql.setLength(0);
                            sql.append("Update " + cube + " Set FValue = ?, FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ?");
                            if (dataManager.getValueType() == DimensionConstants.ADDACTUAL_DATA_TYPE) {
                                sql.append(" and (FState = 1 OR FState = 3)");
                            }
                            try {
                                pstmt = conn.prepareStatement(sql.toString());
                                for (IMbgData mbgData2 : tmpDataMap.get(cube).values()) {
                                    pstmt.setBigDecimal(1, mbgData2.getValue());
                                    pstmt.setBigDecimal(2, mbgData2.getValue());
                                    pstmt.setString(3, dataManager.getUserId());
                                    pstmt.setTimestamp(4, timestamp);
                                    pstmt.setString(5, mbgData2.getMbgDataId());
                                    pstmt.addBatch();
                                    if (++index < 100) continue;
                                    pstmt.executeBatch();
                                    index = 0;
                                }
                                if (index <= 0) break block33;
                                pstmt.executeBatch();
                                index = 0;
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(pstmt);
                                throw throwable;
                            }
                        }
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                }
                if (!divDatas.isEmpty() && (dataManager.ignoreDataState && StringUtils.isEmpty((String)dataManager.getBillId()) || !StringUtils.isEmpty((String)dataManager.getBillId()) && "3BA5F027".equals(BOSUuid.read((String)dataManager.getBillId()).getType().toString()))) {
                    BgPastRecordInfo record = new BgPastRecordInfo();
                    record.setId(BOSUuid.create((BOSObjectType)record.getBOSType()));
                    record.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    record.setLastUpdateTime(record.getCreateTime());
                    record.setCreator(new UserInfo());
                    record.getCreator().setId(BOSUuid.read((String)dataManager.getUserId()));
                    record.setLastUpdateUser(record.getCreator());
                    record.setCU(new CtrlUnitInfo());
                    record.getCU().setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                    record.setSeq(0);
                    record.setPastSource(BgPastSourceEnum.BIZCALC);
                    record.setBgFormId(dataManager.getBillId());
                    record.setVersionNo(BgNConstants.ONE);
                    BgFormInfo bgFormInfo = BgViewServerHelper.getBgFormVer(conn, dataManager.getBillId());
                    if (bgFormInfo != null) {
                        record.setVersionNo(bgFormInfo.getVersionNo());
                    }
                    BgPastDataInfo bgPastData = null;
                    for (IMbgData divData : divDatas) {
                        bgPastData = new BgPastDataInfo();
                        bgPastData.setBalance(divData.getOldValue());
                        bgPastData.setAdjValue(divData.getValue());
                        bgPastData.setPastValue(divData.getValue().subtract(divData.getOldValue()));
                        bgPastData.setFormula(divData.getFormula());
                        bgPastData.setBgData(divData.getMbgDataId());
                        bgPastData.setAdjustor(record.getCreator());
                        bgPastData.setAdjusttime(record.getCreateTime());
                        record.getPastDatas().add(bgPastData);
                    }
                    BgPastRecordFactory.getLocalInstance(dataManager.getCtx()).addnew((CoreBaseInfo)record);
                }
            }
            catch (SQLDataException ex) {
                throw new BOSException((Throwable)ex);
            }
            catch (SQLException ex) {
                logger.error((Object)"update sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end update mbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTmpMbgData(MbgDataManager dataManager, Map<String, Map<String, IMbgData>> update) throws Exception {
        if (dataManager == null || update == null || update.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin update tmpMbgData!");
        ArrayList<IMbgData> mbgDatas = new ArrayList<IMbgData>();
        ArrayList<IMbgData> factDatas = new ArrayList<IMbgData>();
        Map<String, IMbgData> dataMap2222222 = null;
        IMbgData mbgData2222222 = null;
        int index = 0;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String bgSchemeId = dataManager.getSchemeInfo().getId().toString();
        for (Map<String, IMbgData> dataMap2222222 : update.values()) {
            for (IMbgData mbgData2222222 : dataMap2222222.values()) {
                mbgDatas.add(mbgData2222222);
            }
        }
        if (!mbgDatas.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block14: {
                conn = null;
                pstmt = null;
                try {
                    int i;
                    conn = BgDBUtils.getConnection((Context)dataManager.getCtx());
                    pstmt = conn.prepareStatement("Update " + dataManager.getTmpCube() + " Set FValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ? and FBgSchemeRootId = ?");
                    int in = mbgDatas.size();
                    for (i = 0; i < in; ++i) {
                        mbgData2222222 = (IMbgData)mbgDatas.get(i);
                        pstmt.setBigDecimal(1, mbgData2222222.getValue());
                        pstmt.setString(2, dataManager.getUserId());
                        pstmt.setTimestamp(3, timestamp);
                        pstmt.setString(4, mbgData2222222.getMbgDataId());
                        pstmt.setString(5, bgSchemeId);
                        pstmt.addBatch();
                        if (mbgData2222222.getValue().compareTo(BigDecimal.ZERO) == 0) {
                            factDatas.add(mbgData2222222);
                        }
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                        index = 0;
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                    if (factDatas.isEmpty()) break block14;
                    pstmt = conn.prepareStatement("Update " + dataManager.getCube() + " Set FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ?");
                    in = factDatas.size();
                    for (i = 0; i < in; ++i) {
                        mbgData2222222 = (IMbgData)factDatas.get(i);
                        pstmt.setBigDecimal(1, mbgData2222222.getValue());
                        pstmt.setString(2, dataManager.getUserId());
                        pstmt.setTimestamp(3, timestamp);
                        pstmt.setString(4, mbgData2222222.getMbgDataId());
                        pstmt.addBatch();
                        if (++index < 100) continue;
                        pstmt.executeBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                        index = 0;
                    }
                }
                catch (SQLDataException ex) {
                    try {
                        throw new BOSException((Throwable)ex);
                        catch (SQLException ex2) {
                            logger.error((Object)"update sql error:", (Throwable)ex2);
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("invoke end update tmpMbgData! invoke process use = " + (beginTime - endTime) + "ms"));
    }
}

