/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.MbgDataTempTableUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class MbgDataUtils {
    private static final Logger logger = Logger.getLogger(MbgDataUtils.class);

    public static boolean checkHasDataByOrgUnit(Context ctx, boolean isUseAccInt, String cubeName, Set<String> subCubes, String orgUnitId, String bgOrgViewId) throws BOSException, EASBizException {
        HashSet<String> orgUnitIds = new HashSet<String>(1);
        orgUnitIds.add(orgUnitId);
        return MbgDataUtils.checkHasDataByOrgUnit(ctx, isUseAccInt, cubeName, subCubes, orgUnitIds, bgOrgViewId);
    }

    public static boolean checkHasDataByOrgUnit(Context ctx, boolean isUseAccInt, String cubeName, Set<String> subCubes, Set<String> orgUnitIds, String bgOrgViewId) throws BOSException, EASBizException {
        boolean check = false;
        if (ctx == null || StringUtils.isEmpty((String)cubeName) || orgUnitIds.isEmpty()) {
            return check;
        }
        Connection conn = null;
        TempTablePool pool = null;
        String tmpTable = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), orgUnitIds);
            check = MbgDataUtils.checkHasDataByOrgUnit(conn, isUseAccInt, cubeName, subCubes, bgOrgViewId, tmpTable);
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable(pool, tmpTable);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        SQLUtils.cleanup((Connection)conn);
        return check;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkHasDataByOrgUnit(Connection conn, boolean isUseAccInt, String cubeName, Set<String> subCubes, String bgOrgViewId, String tmpTable) throws BOSException, EASBizException {
        block10: {
            block9: {
                check = false;
                if (conn == null) return check;
                if (StringUtils.isEmpty((String)cubeName)) {
                    return check;
                }
                if (subCubes == null) {
                    subCubes = BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, cubeName, null, null);
                }
                rst = null;
                try lbl-1000:
                // 2 sources

                {
                    for (String cube : subCubes) {
                        rst = isUseAccInt != false ? BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cube + " where FOrgUnitId IN(Select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FOrgUnitId in (select FID from " + tmpTable + "))"), (Object[])new Object[]{bgOrgViewId}) : BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cube + " where FOrgUnitId in (select FID from " + tmpTable + ")"));
                        if (rst.next()) {
                            var10_11 = true;
                            break block9;
                        }
                        ** GOTO lbl-1000
                    }
                    break block10;
                }
                catch (SQLException ex) {
                    try {
                        MbgDataUtils.logger.error((Object)"checkHasDataByOrgUnit sql error:", (Throwable)ex);
                        throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                    }
                    catch (Throwable var11_12) {
                        SQLUtils.cleanup(rst);
                        throw var11_12;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return var10_11;
lbl-1000:
            // 1 sources

            {
                SQLUtils.cleanup((ResultSet)rst);
                ** GOTO lbl-1000
            }
        }
        SQLUtils.cleanup(rst);
        return check;
    }

    public static Map<String, Map<String, IBgNData>> querySchemeData(Context ctx, BgSchemeInfo schemeInfo, String orgUnitId, Collection<String> formulas, BgVersionInfo version, int valueType, MbgDataTempTableUtils utils) throws BOSException, EASBizException {
        HashSet<String> orgUnitIds = new HashSet<String>(1);
        orgUnitIds.add(orgUnitId);
        ArrayList<BgVersionInfo> bgVersionInfos = new ArrayList<BgVersionInfo>(1);
        bgVersionInfos.add(version);
        return MbgDataUtils.querySchemeData(ctx, schemeInfo, orgUnitIds, formulas, bgVersionInfos, valueType, utils);
    }

    public static Map<String, Map<String, IBgNData>> querySchemeData(Context ctx, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Collection<String> formulas, List<BgVersionInfo> versionInfos, int valueType, MbgDataTempTableUtils utils) throws BOSException, EASBizException {
        HashMap<String, Map<String, IBgNData>> schemeMap = new HashMap<String, Map<String, IBgNData>>();
        for (String orgUnitId : orgUnitIds) {
            schemeMap.put(orgUnitId, new HashMap());
        }
        if (ctx == null || schemeInfo == null || orgUnitIds.isEmpty() || formulas == null || formulas.isEmpty() || versionInfos.isEmpty()) {
            return schemeMap;
        }
        HashSet<String> bgPeriodNums = new HashSet<String>();
        HashSet<String> bgElementNums = new HashSet<String>();
        HashSet<String> currencyNums = new HashSet<String>();
        HashSet<String> bgScenarioNums = new HashSet<String>();
        HashSet<String> mbgMemSet = null;
        HashMap<String, HashSet<String>> dimMemMap = new HashMap<String, HashSet<String>>();
        String dimNumber2 = null;
        String srcNumber = null;
        String field = null;
        String[] tmpStrs = null;
        String[] params = null;
        Map<String, String> srcFieldMap = MbgDataUtils.getSrcFieldMap(ctx);
        MBgTemplateHelper.logTime("End Query Src Map");
        for (String formula : formulas) {
            params = BgNFSHelper.parseFormulaPara(formula);
            for (String dimNumber2 : params[0].split(",")) {
                srcNumber = DimUtils.getSrcNumber(dimNumber2);
                field = srcFieldMap.get(srcNumber);
                mbgMemSet = (HashSet<String>)dimMemMap.get(field);
                if (mbgMemSet == null) {
                    mbgMemSet = new HashSet<String>();
                    dimMemMap.put(field, mbgMemSet);
                }
                mbgMemSet.add(dimNumber2);
            }
            bgPeriodNums.add(params[1]);
            bgElementNums.add(params[2]);
            currencyNums.add(params[5]);
            bgScenarioNums.add(params[3]);
        }
        return MbgDataUtils.querySchemeData(ctx, schemeInfo, orgUnitIds, versionInfos, bgPeriodNums, bgElementNums, currencyNums, bgScenarioNums, (Set)dimMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), valueType, utils);
    }

    private static Map<String, String> getSrcFieldMap(Context ctx) throws BOSException {
        IRowSet rst = null;
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FSrcNumber, FRefField from T_MBG_MbgDim");
            while (rst.next()) {
                srcFieldMap.put(rst.getString("FSrcNumber"), rst.getString("FRefField"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        srcFieldMap.put(DimensionBaseConstants.DEF_INDEX_SRCNUMBER, DimensionBaseConstants.DEF_BGINDEX_FIELD);
        return srcFieldMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Map<String, IBgNData>> querySchemeData(Context ctx, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, List<BgVersionInfo> versionInfos, Set<String> bgPeriodNums, Set<String> bgElementNums, Set<String> currencyNums, Set<String> bgScenarioNums, Set<String> BgAccountNums, int valueType, MbgDataTempTableUtils utils) throws EASBizException, BOSException {
        String orgViewid;
        Set<String> bgDataTables;
        HashSet<String> accNumbers;
        ResultSet rst;
        PreparedStatement pstmt;
        TempTablePool pool;
        Connection conn;
        ArrayList<String> tmpNums;
        StringBuffer sql;
        boolean isUseAccInt;
        HashMap<String, Map<String, IBgNData>> schemeMap;
        block20: {
            schemeMap = new HashMap<String, Map<String, IBgNData>>();
            for (String orgUnitId : orgUnitIds) {
                schemeMap.put(orgUnitId, new HashMap());
            }
            String cubeName = BgCubeUtils.getCubeName(schemeInfo.getRefCube(), valueType);
            isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt(ctx, schemeInfo.getId().toString()) && cubeName.equals(schemeInfo.getRefCube());
            sql = new StringBuffer();
            tmpNums = new ArrayList<String>();
            conn = null;
            if (utils == null) {
                utils = new MbgDataTempTableUtils(ctx);
            }
            MBgTemplateHelper.startLog("Start querySchemeData");
            pool = null;
            pstmt = null;
            rst = null;
            accNumbers = new HashSet<String>();
            for (String number : BgAccountNums) {
                accNumbers.add(DimensionFormulaHelper.getMemberNumber(number));
            }
            conn = BgDBUtils.getConnection((Context)ctx);
            bgDataTables = BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, cubeName, accNumbers, !isUseAccInt ? null : BgSchemeConvertToAccIntUtils.querySplit(conn, cubeName));
            if (MbgDataUtils.checkHasDataByOrgUnit(ctx, isUseAccInt, cubeName, bgDataTables, orgUnitIds, orgViewid = BgSchemeInfo.getViewId(ctx, schemeInfo.getId().toString(), DimensionConstants.DEF_ORGUNIT_NUMBER))) break block20;
            HashMap<String, Map<String, IBgNData>> hashMap = schemeMap;
            utils.onRelease();
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            return hashMap;
        }
        try {
            String tmpIndex = utils.getIndexTable();
            if (isUseAccInt) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), accNumbers);
            } else {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), BgAccountNums);
            }
            String tmpPeriod = utils.getPeriodTable();
            tmpNums.clear();
            tmpNums.addAll(bgPeriodNums);
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
            String tmpElement = utils.getElementTable();
            tmpNums.clear();
            tmpNums.addAll(bgElementNums);
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
            String tmpCurrency = utils.getCurrencyTable();
            tmpNums.clear();
            tmpNums.addAll(currencyNums);
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
            String tmpScenario = utils.getScenarioTable();
            tmpNums.clear();
            tmpNums.addAll(bgScenarioNums);
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
            MBgTemplateHelper.logTime("End Build TempTable");
            pool = TempTablePool.getInstance((Context)ctx);
            String tmpOrgTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID) values (?)"), orgUnitIds);
            HashMap<Integer, BgVersionInfo> versionIds = new HashMap<Integer, BgVersionInfo>();
            for (BgVersionInfo info : versionInfos) {
                versionIds.put(info.getVersionId(), info);
            }
            String tmpVersionTable = pool.createTempTable("CREATE TABLE TEML_KSQL_1 (FID INT DEFAULT 0)");
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (Integer id : versionIds.keySet()) {
                Object[] verObjects = new Object[]{id};
                list.add(verObjects);
            }
            if (isUseAccInt) {
                String bgAccountViewId = BgSchemeInfo.getViewId(ctx, schemeInfo.getId().toString(), DimensionConstants.DEF_INDEX_NUMBER);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpIndex + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgAccount Where FNumber = t0.FNumber AND FBGACCOUNTVIEWID = ?)"), (Object[])new Object[]{bgAccountViewId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpPeriod + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgPeriod Where FID = t0.FID)"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpElement + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgElement Where FID = t0.FID)"));
            }
            BgDBUtils.executeBatch((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FID) values (?)"), list);
            for (String bgDataTable : bgDataTables) {
                sql.setLength(0);
                if (isUseAccInt) {
                    sql.append("select FID, FFormula, FVersion, FValue, FState,FOrgUnitID from " + bgDataTable + " where FOrgUnitId in (Select FIntID FROM T_MBG_BgOrgUnit Where FViewID = ? AND FOrgUnitId in (select FID from " + tmpOrgTable + ") AND FIsVirtual = 0)  and exists (select FNumber from " + tmpIndex + " where FIntId = " + bgDataTable + ".F2)  and exists (select FID from " + tmpPeriod + " where FIntId = " + bgDataTable + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FIntId = " + bgDataTable + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + bgDataTable + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + bgDataTable + ".FScenario)  and exists (select FID from " + tmpVersionTable + " where FID  = " + bgDataTable + ".FVersion)");
                } else {
                    sql.append("select FID, FFormula, FVersion, FValue, FState,FOrgUnitID from " + bgDataTable + " where FOrgUnitId in (select FID from " + tmpOrgTable + ")  and exists (select FNumber from " + tmpIndex + " where FNumber = " + bgDataTable + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + bgDataTable + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + bgDataTable + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + bgDataTable + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + bgDataTable + ".FScenario)  and exists (select FID from " + tmpVersionTable + " where FID  = " + bgDataTable + ".FVersion)");
                }
                pstmt = conn.prepareStatement(sql.toString());
                if (isUseAccInt) {
                    pstmt.setString(1, orgViewid);
                }
                rst = pstmt.executeQuery();
                MBgTemplateHelper.logTime("End Execute Query");
                while (rst.next()) {
                    String orgUnitId;
                    BgNDataInfo mbgData = new BgNDataInfo();
                    mbgData.setBgDataId(rst.getString("FID"));
                    mbgData.setFormula(rst.getString("FFormula"));
                    mbgData.setBgVersion(((BgVersionInfo)versionIds.get(rst.getInt("FVersion"))).getNumber());
                    DimUtils.setValue(mbgData, rst.getBigDecimal("FValue"), valueType, null);
                    mbgData.setState(rst.getInt("FState"));
                    orgUnitId = rst.getString("FOrgUnitID");
                    String dimDataKey = DimUtils.getDimDataKey(mbgData);
                    if (!schemeMap.containsKey(orgUnitId)) {
                        schemeMap.put(orgUnitId, new HashMap());
                    }
                    ((Map)schemeMap.get(orgUnitId)).put(dimDataKey, mbgData);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                MBgTemplateHelper.logTime("End Get Result");
            }
            utils.onRelease();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"query DataState Error:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                utils.onRelease();
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        return schemeMap;
    }
}

