/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.MbgData;
import com.kingdee.eas.ma.mbg.cube.query.DimData;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgTmpDataUtils {
    private static final Logger logger = Logger.getLogger(MbgTmpDataUtils.class);

    public static List<IMbgData> queryTmpData(Context ctx, BOSUuid bgSchemeId, BgAdjustBillInfo bgAdjustBillInfo) throws BOSException, EASBizException {
        List<IMbgData> mbgDatas = MbgTmpDataUtils.queryTmpData(ctx, bgSchemeId, bgAdjustBillInfo.getId());
        String dimKey = "";
        BgDataInfo bgDataInfo = new BgDataInfo();
        BOSObjectType bOSObjectType = bgDataInfo.getBOSType();
        IMbgData mbgData = null;
        HashMap<String, IMbgData> mbgDataMap = new HashMap<String, IMbgData>();
        if (mbgDatas != null && !mbgDatas.isEmpty()) {
            for (int i = 0; i < mbgDatas.size(); ++i) {
                mbgData = mbgDatas.get(i);
                if (StringUtils.isEmpty((String)mbgData.getOrgUnitId()) || StringUtils.isEmpty((String)mbgData.getVersionNum()) || StringUtils.isEmpty((String)mbgData.getFormula())) continue;
                dimKey = mbgData.getOrgUnitId() + ";" + mbgData.getVersionNum() + ";" + mbgData.getFormula();
                mbgDataMap.put(dimKey, mbgData);
            }
        }
        if (bgAdjustBillInfo.getEntity() != null && !bgAdjustBillInfo.getEntity().isEmpty()) {
            BgAdjustBillEntryInfo entryInfo = null;
            for (int i = 0; i < bgAdjustBillInfo.getEntity().size(); ++i) {
                entryInfo = bgAdjustBillInfo.getEntity().get(i);
                if (entryInfo.getBgDataId() != null || entryInfo.getOrgUnit() == null || StringUtils.isEmpty((String)entryInfo.getOrgUnit().getOrgUnitID()) || bgAdjustBillInfo.getBgVersion() == null || StringUtils.isEmpty((String)bgAdjustBillInfo.getBgVersion().getNumber()) || StringUtils.isEmpty((String)entryInfo.getFormula())) continue;
                dimKey = entryInfo.getOrgUnit().getOrgUnitID() + ";" + bgAdjustBillInfo.getBgVersion().getNumber() + ";" + entryInfo.getFormula();
                if (mbgDataMap.containsKey(dimKey) && !StringUtils.isEmpty((String)((IMbgData)mbgDataMap.get(dimKey)).getMbgDataId())) {
                    entryInfo.setBgDataId(BOSUuid.read((String)((IMbgData)mbgDataMap.get(dimKey)).getMbgDataId()));
                    continue;
                }
                entryInfo.setBgDataId(BOSUuid.create((BOSObjectType)bOSObjectType));
            }
        }
        return mbgDatas;
    }

    public static List<IMbgData> queryTmpData(Context ctx, BOSUuid bgSchemeId, BOSUuid bgAdjustBillId) throws BOSException, EASBizException {
        ArrayList<IMbgData> mbgDatas = new ArrayList<IMbgData>();
        if (ctx == null || bgSchemeId == null || bgAdjustBillId == null) {
            return mbgDatas;
        }
        String _bgSchemeId = bgSchemeId.toString();
        String _bgAdjustBillId = bgAdjustBillId.toString();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        MbgData mbgData = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44), FFormula NVARCHAR(300), FVersion INT)", conn);
            if (tmpTable != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTable + " (FOrgUnitId, FFormula, FVersion) select u.FOrgUnitID, e.FFormula, v.FVersionId from T_MBG_BgAdjustBill b left join T_MBG_BgVersion v on b.FBgVersionId = v.FID left join T_MBG_BgAdjustBillEntry e on b.FID = e.FBgAdjustBill left join T_MBG_BgOrgUnit u on e.FOrgUnit = u.FID where b.FID = ?"), (Object[])new Object[]{_bgAdjustBillId});
                pstmt = conn.prepareStatement("select t.FID, t.FOrgUnitId, t.FFormula, t.FValue, t.FOldValue, v.FNumber AS FVNumber from T_MBG_BgTmpData t left join T_MBG_BgVersion v on t.FVersion = v.FVersionId where t.FBgSchemeRootId = ? and exists (select * from " + tmpTable + " where FOrgUnitId = t.FOrgUnitId and FFormula = t.FFormula and FVersion = t.FVersion)");
                pstmt.setString(1, _bgSchemeId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    mbgData = new MbgData();
                    mbgData.setMbgDataId(rst.getString("FID"));
                    mbgData.setOrgUnitId(rst.getString("FOrgUnitId"));
                    mbgData.setFormula(rst.getString("FFormula"));
                    mbgData.setValue(rst.getBigDecimal("FValue"));
                    mbgData.setOldValue(rst.getBigDecimal("FOldValue"));
                    mbgData.setVersionNum(rst.getString("FVNumber"));
                    mbgData.parse();
                    mbgDatas.add(mbgData);
                }
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (pool != null && tmpTable != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpTable, conn);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return mbgDatas;
    }

    public static List<IDimData> queryTmpDataByBillInfo(BgAdjustBillInfo bgAdjustBill) {
        ArrayList<IDimData> mbgDatas = new ArrayList<IDimData>();
        if (bgAdjustBill == null || bgAdjustBill.getEntity() == null || bgAdjustBill.getEntity().isEmpty()) {
            return mbgDatas;
        }
        BgAdjustBillEntryInfo entry = null;
        DimData mbgData = null;
        int size = bgAdjustBill.getEntity().size();
        for (int index = 0; index < size; ++index) {
            entry = bgAdjustBill.getEntity().get(index);
            mbgData = new DimData();
            if (entry.getBgDataId() != null) {
                mbgData.setMbgDataId(entry.getBgDataId().toString());
            }
            mbgData.setBgOrgUnitId(entry.getOrgUnit().getId().toString());
            mbgData.setOrgUnitId(entry.getOrgUnit().getOrgUnitID());
            mbgData.setFormula(entry.getFormula());
            mbgData.setVersionId(bgAdjustBill.getBgVersion().getId().toString());
            mbgData.setVersionNum(bgAdjustBill.getBgVersion().getNumber());
            mbgData.setVersionInnId(bgAdjustBill.getBgVersion().getVersionId());
            mbgData.setValue(entry.getAdjustValue());
            mbgData.setOldValue(entry.getOldValue());
            mbgData.parse();
            mbgDatas.add(mbgData);
        }
        return mbgDatas;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, IDimData> queryTmpDataByBgForm(Context ctx, BgFormInfo bgForm) throws BOSException, EASBizException {
        HashMap<String, IDimData> mbgDataMap = new HashMap<String, IDimData>();
        if (ctx == null) return mbgDataMap;
        if (bgForm == null) {
            return mbgDataMap;
        }
        String cubeName = bgForm.getBgScheme().getRefCube();
        String cubeEntry = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        if (bgForm.getProcessType() != null) {
            cubeName = BgCubeUtils.getCubeName(bgForm.getBgScheme().getRefCube(), bgForm.getProcessType());
            cubeEntry = BgCubeUtils.getEntryCubeName(bgForm.getBgScheme().getRefCube(), bgForm.getProcessType());
        }
        List formulas = null;
        try {
            Book book = bgForm.getBook();
            formulas = BgNFSHelper.getFormulaListOfBook(book);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        DimData mbgData = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String tmpFormulaTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            tmpFormulaTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))", conn);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormulaTable + " (FFormula) values (?)"), (Collection)formulas);
            pstmt = conn.prepareStatement("select t.FID, t.FOrgUnitId, t.FFormula, t.FValue, t.FTmpValue, FState from " + cubeName + " t where forgUnitId ='" + bgForm.getOrgUnit().getId().toString() + "' and fversion = " + bgForm.getBgVersion().getVersionId() + " and FFormula in (select FFormula from " + tmpFormulaTable + ")");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                mbgData = new DimData();
                mbgData.setMbgDataId(rst.getString("FID"));
                mbgData.setOrgUnitId(rst.getString("FOrgUnitId"));
                mbgData.setFormula(rst.getString("FFormula"));
                mbgData.setVersionId(bgForm.getBgVersion().getId().toString());
                mbgData.setVersionNum(bgForm.getBgVersion().getNumber());
                mbgData.setVersionInnId(bgForm.getBgVersion().getVersionId());
                mbgData.setValue(rst.getBigDecimal("FTmpValue"));
                mbgData.setOldValue(rst.getBigDecimal("FValue"));
                mbgData.setState(rst.getInt("FState"));
                mbgData.parse();
                mbgDataMap.put(mbgData.getFormula(), mbgData);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"queryDataByBgForm sql error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                if (pool == null) throw throwable;
                if (tmpFormulaTable == null) throw throwable;
                try {
                    pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
                    throw throwable;
                }
                catch (Exception ex3) {
                    logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex3);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (pool == null) return mbgDataMap;
        if (tmpFormulaTable == null) return mbgDataMap;
        try {
            pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
            return mbgDataMap;
        }
        catch (Exception ex) {
            logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)ex);
            return mbgDataMap;
        }
    }

    public static Map<String, IDimData> queryTmpDataBySchemeAndOrg(Context ctx, BgFormInfo bgForm) throws BOSException, EASBizException {
        HashMap<String, IDimData> mbgDataMap = new HashMap<String, IDimData>();
        if (ctx == null || bgForm == null) {
            return mbgDataMap;
        }
        String cubeName = bgForm.getBgScheme().getRefCube();
        String cubeEntry = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        if (bgForm.getProcessType() != null) {
            cubeName = BgCubeUtils.getCubeName(bgForm.getBgScheme().getRefCube(), bgForm.getProcessType());
            cubeEntry = BgCubeUtils.getEntryCubeName(bgForm.getBgScheme().getRefCube(), bgForm.getProcessType());
        }
        DimData mbgData = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgForm.getBgScheme().getId().toString(), cubeName);
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            for (String cube : cubeNames) {
                pstmt = conn.prepareStatement("select t.FID, t.FOrgUnitId, t.FFormula, t.FValue, t.FTmpValue, FState from " + cube + " t where forgUnitId ='" + bgForm.getOrgUnit().getId().toString() + "' and FVersion = '" + bgForm.getBgVersion().getVersionId() + "'");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    mbgData = new DimData();
                    mbgData.setMbgDataId(rst.getString("FID"));
                    mbgData.setOrgUnitId(rst.getString("FOrgUnitId"));
                    mbgData.setFormula(rst.getString("FFormula"));
                    mbgData.setVersionId(bgForm.getBgVersion().getId().toString());
                    mbgData.setVersionNum(bgForm.getBgVersion().getNumber());
                    mbgData.setVersionInnId(bgForm.getBgVersion().getVersionId());
                    mbgData.setValue(rst.getBigDecimal("FTmpValue"));
                    mbgData.setOldValue(rst.getBigDecimal("FValue"));
                    mbgData.setState(rst.getInt("FState"));
                    mbgData.parse();
                    mbgDataMap.put(mbgData.getFormula(), mbgData);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"queryDataByBgForm sql error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return mbgDataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkTmpData(Context ctx, BgAdjustBillInfo bgAdjustBill, List<IDimData> mbgDatas) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block39: {
            if (ctx == null) return;
            if (bgAdjustBill == null) return;
            if (mbgDatas == null) return;
            if (mbgDatas.isEmpty()) {
                return;
            }
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgAdjustBill.getBgScheme().getId().toString(), bgAdjustBill.getBgScheme().getRefCube());
            String extNumber = null;
            String bgIndexName = null;
            String extName = null;
            BgAdjustBillEntryInfo entry = null;
            HashMap<String, String[]> dimDataMap = new HashMap<String, String[]>();
            HashSet<String> accNumbers = new HashSet<String>();
            int in = bgAdjustBill.getEntity().size();
            for (int i = 0; i < in; ++i) {
                entry = bgAdjustBill.getEntity().get(i);
                String bgIndexNum = entry.getIndexMemberNumber();
                accNumbers.add(bgIndexNum);
                bgIndexName = entry.getIndexMemberName();
                extNumber = entry.getMemberCombinNumber();
                extName = entry.getMemberCombinName();
                if (!StringUtils.isEmpty((String)extNumber)) {
                    bgIndexNum = bgIndexNum + "," + extNumber;
                    bgIndexName = bgIndexName + "," + extName;
                }
                dimDataMap.put(bgIndexNum + "," + entry.getPeriod().getNumber(), new String[]{entry.getPeriod().getName(), bgIndexName});
            }
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(accNumbers);
            conn = null;
            pstmt = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            int type = 0;
            int state = 0;
            Object[] objs = null;
            Object[] adjObjs = null;
            String adjustId = bgAdjustBill.getId().toString();
            String tmpTable = null;
            String keyStr = null;
            String formulaStr = null;
            String number = null;
            String formId = null;
            String orgNumber = null;
            String orgName = null;
            String[] tmpStrs = null;
            StringBuffer strs = new StringBuffer();
            BOSUuid billID = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44), FOrgUnitIntId Int Not NULL, FFormula NVARCHAR(300), FVersionID VARCHAR(44), FVersion INT)", conn);
                ArrayList<Object[]> sqlParams222 = new ArrayList<Object[]>();
                for (IDimData dimData : mbgDatas) {
                    objs = new Object[]{dimData.getOrgUnitId(), dimData.getFormula(), dimData.getVersionId(), dimData.getVersionInnId(), accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, dimData.getOrgUnitId())};
                    sqlParams222.add(objs);
                }
                BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTable + " (FOrgUnitId, FFormula, FVersionID, FVersion, ForgUnitIntId) values (?,?,?,?,?)"), sqlParams222);
                strs.setLength(0);
                pstmt = conn.prepareStatement("select t.FNumber, t.FType, e.FFormula , u.FNumber AS ForgNum ,u.FName_" + ctx.getLocale() + " AS ForgName, o.fnumber orgNumber, o.fname_" + ctx.getLocale() + " orgName  from T_MBG_BgAdjustbill t join T_MBG_BgAdjustBillEntry e on t.FID = e.FBgAdjustBill join T_MBG_BgOrgUnit u on u.FID = e.FOrgUnit join T_ORG_BaseUnit o on t.FOrgUnit = o.FID where t.FBgScheme = ? and exists (select * from " + tmpTable + " where FOrgUnitId = u.FOrgUnitId and FFormula = e.FFormula and FVersionID = t.FBgVersionId) and t.FState IN (" + 0 + "," + 1 + "," + 2 + ") and t.FID <> ?  and t.fprocesstype= ? ");
                pstmt.setString(1, bgAdjustBill.getBgScheme().getId().toString());
                pstmt.setString(2, adjustId);
                pstmt.setInt(3, bgAdjustBill.getProcessType().getValue());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    number = rst.getString("FNumber");
                    type = rst.getInt("FType");
                    formulaStr = rst.getString("FFormula");
                    orgNumber = rst.getString("ForgNum");
                    orgName = rst.getString("ForgName");
                    tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                    keyStr = tmpStrs[0] + "," + tmpStrs[1];
                    if (!dimDataMap.containsKey(keyStr)) continue;
                    objs = (Object[])dimDataMap.get(keyStr);
                    adjObjs = new Object[]{objs[0], objs[1], number, orgNumber, orgName, rst.getString("orgNumber"), rst.getString("orgName")};
                    if (type == 0 || type == 1) {
                        strs.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)ctx.getLocale(), (Object[])adjObjs));
                    } else {
                        strs.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)ctx.getLocale(), (Object[])adjObjs));
                    }
                    strs.append("\r\n");
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                strs.setLength(0);
                HashMap adjustBillMap = new HashMap();
                HashMap adjustFormMap = new HashMap();
                pstmt = conn.prepareStatement("select t.FFormula, e.FFormId, u.fnumber ForgNum, u.fname_" + ctx.getLocale() + " ForgName from T_MBG_BgTmpData t left join T_MBG_BgTmpDataEntry e on t.FID = e.FDataId join T_ORG_BaseUnit u on t.FOrgUnitId = u.FID where FBgSchemeRootId = ? and t.fprocesstype = ? and exists (select * from " + tmpTable + " where FOrgUnitId = t.FOrgUnitId and FFormula = t.FFormula and FVersion = t.FVersion)");
                pstmt.setString(1, bgAdjustBill.getBgScheme().getId().toString());
                pstmt.setInt(2, bgAdjustBill.getProcessType().getValue());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ArrayList<Object[]> list;
                    formulaStr = rst.getString("FFormula");
                    formId = rst.getString("FFormId");
                    orgNumber = rst.getString("ForgNum");
                    orgName = rst.getString("ForgName");
                    if (formId == null || adjustId.equals(formId) || !dimDataMap.containsKey(keyStr = (tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr))[0] + "," + tmpStrs[1])) continue;
                    objs = (Object[])dimDataMap.get(keyStr);
                    adjObjs = new Object[]{objs[0], objs[1], null, orgNumber, orgName, null, null};
                    billID = BOSUuid.read((String)formId);
                    if (billID.getType().toString().equals("210CFD59")) {
                        if (adjustBillMap.containsKey(billID.toString())) {
                            ((List)adjustBillMap.get(billID.toString())).add(adjObjs);
                            continue;
                        }
                        list = new ArrayList<Object[]>();
                        list.add(adjObjs);
                        adjustBillMap.put(billID.toString(), list);
                        continue;
                    }
                    if (!billID.getType().toString().equals("3BA5F027")) continue;
                    if (adjustFormMap.containsKey(billID.toString())) {
                        ((List)adjustFormMap.get(billID.toString())).add(adjObjs);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(adjObjs);
                    adjustFormMap.put(billID.toString(), list);
                }
                HashSet<String> adjustBillSet = new HashSet<String>();
                for (String key : adjustBillMap.keySet()) {
                    adjustBillSet.add(key);
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("type");
                sic.add("number");
                sic.add("orgUnit.id");
                sic.add("orgUnit.number");
                sic.add("orgUnit.name");
                view.setSelector(sic);
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", adjustBillSet, CompareType.INCLUDE));
                view.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)5, CompareType.NOTEQUALS));
                BgAdjustBillCollection billColl = BgAdjustBillFactory.getLocalInstance(ctx).getBgAdjustBillCollection(view);
                BgAdjustBillInfo billInfo = null;
                for (int i = 0; i < billColl.size(); ++i) {
                    String tmpStr;
                    int j;
                    billInfo = billColl.get(i);
                    if (!adjustBillMap.containsKey(billInfo.getId().toString())) continue;
                    if (billInfo.getType().getValue() == 0 || billInfo.getType().getValue() == 1) {
                        for (j = 0; j < ((List)adjustBillMap.get(billInfo.getId().toString())).size(); ++j) {
                            objs = (Object[])((List)adjustBillMap.get(billInfo.getId().toString())).get(j);
                            objs[2] = billInfo.getNumber();
                            objs[5] = billInfo.getOrgUnit().getNumber();
                            objs[6] = billInfo.getOrgUnit().getName();
                            tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                            strs.append(tmpStr + "\r\n");
                        }
                        continue;
                    }
                    for (j = 0; j < ((List)adjustBillMap.get(billInfo.getId().toString())).size(); ++j) {
                        objs = (Object[])((List)adjustBillMap.get(billInfo.getId().toString())).get(j);
                        objs[2] = billInfo.getNumber();
                        objs[5] = billInfo.getOrgUnit().getNumber();
                        objs[6] = billInfo.getOrgUnit().getName();
                        tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                        strs.append(tmpStr + "\r\n");
                    }
                }
                HashSet<String> adjustFormSet = new HashSet<String>();
                for (String key : adjustFormMap.keySet()) {
                    adjustFormSet.add(key);
                }
                view = new EntityViewInfo();
                view.setSelector(sic);
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", adjustFormSet, CompareType.INCLUDE));
                BgFormCollection formColl = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
                BgFormInfo formInfo = null;
                for (int i = 0; i < formColl.size(); ++i) {
                    formInfo = formColl.get(i);
                    if (!adjustFormMap.containsKey(formInfo.getId().toString())) continue;
                    for (int j = 0; j < ((List)adjustFormMap.get(formInfo.getId().toString())).size(); ++j) {
                        objs = (Object[])((List)adjustFormMap.get(formInfo.getId().toString())).get(j);
                        objs[2] = formInfo.getNumber();
                        objs[5] = formInfo.getOrgUnit().getNumber();
                        objs[6] = formInfo.getOrgUnit().getName();
                        String tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkTmpDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                        strs.append(tmpStr + "\r\n");
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                strs.setLength(0);
                for (String cubeName : cubeNames) {
                    String orgIdField = "FOrgUnitId";
                    if (accIntHelper.isUseAccInt()) {
                        orgIdField = "FOrgUnitIntId";
                    }
                    pstmt = conn.prepareStatement("select t.FFormula, t.FState from " + cubeName + " t  where exists (select * from " + tmpTable + " where " + orgIdField + " = t.FOrgUnitId and FFormula = t.FFormula and FVersion = t.FVersion)  and t.FState IN (" + 11 + "," + 13 + ")");
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        formulaStr = rst.getString("FFormula");
                        state = rst.getInt("FState");
                        tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                        keyStr = tmpStrs[0] + "," + tmpStrs[1];
                        if (!dimDataMap.containsKey(keyStr)) continue;
                        objs = (Object[])dimDataMap.get(keyStr);
                        if (state == 11 || state == 13) {
                            strs.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkDataState", (Locale)ctx.getLocale(), (Object[])objs));
                        } else if (state == 1 || state == 3) {
                            strs.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkDataState1", (Locale)ctx.getLocale(), (Object[])objs));
                        }
                        strs.append("\r\n");
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                if (pool == null) break block39;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"checkTmpData sql error:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        throw new BOSException((Throwable)ex3);
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpTable, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception sqlParams222) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkTmpData(Context ctx, BgFormInfo bgForm, Map adjustMap, Set<String> formIdSet) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block26: {
            if (ctx == null) return;
            if (bgForm == null) return;
            if (adjustMap == null) return;
            if (adjustMap.isEmpty()) return;
            if (formIdSet == null) return;
            if (formIdSet.isEmpty()) {
                return;
            }
            conn = null;
            pstmt = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            Object[] objs = null;
            Object[] adjObjs = null;
            String[] tmpStrs = null;
            int version = bgForm.getBgVersion().getVersionId();
            String tmpTable = null;
            String formulaStr = null;
            Object keyStr = null;
            Object number = null;
            String orgNumber = null;
            String orgName = null;
            String formId = null;
            String adjustId = bgForm.getAdjust().getId().toString();
            StringBuffer strs = new StringBuffer();
            Object divData = null;
            BOSUuid billID = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44), FFormula NVARCHAR(300), FVersion INT)", conn);
                Map dataMap2333332 = null;
                String orgUnitId = null;
                BgAdjustFormDiversityData adjustData = null;
                MbgTmpDataUtils.insertTmpTableForMutil(bgForm, adjustMap, conn, version, tmpTable);
                HashMap adjustBillMap = new HashMap();
                HashMap adjustFormMap = new HashMap();
                pstmt = conn.prepareStatement("select t.FOrgUnitId, t.FFormula, e.FFormId, u.fnumber ForgNum, u.fname_" + ctx.getLocale() + " ForgName from T_MBG_BgTmpData t left join T_MBG_BgTmpDataEntry e on t.FID = e.FDataId join T_ORG_BaseUnit u on t.FOrgUnitId = u.FID where FBgSchemeRootId = ? and t.fprocesstype = ? and exists (select * from " + tmpTable + " where FOrgUnitId = t.FOrgUnitId and FFormula = t.FFormula and FVersion = t.FVersion)");
                pstmt.setString(1, bgForm.getBgScheme().getId().toString());
                pstmt.setInt(2, bgForm.getProcessType().getValue());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ArrayList<Object[]> list;
                    orgUnitId = rst.getString("FOrgUnitId");
                    formulaStr = rst.getString("FFormula");
                    formId = rst.getString("FFormId");
                    orgNumber = rst.getString("ForgNum");
                    orgName = rst.getString("ForgName");
                    if (adjustMap.get(orgUnitId) != null && adjustMap.get(orgUnitId) instanceof Map && (dataMap2333332 = (Map)adjustMap.get(orgUnitId)) != null && dataMap2333332.get(formulaStr) instanceof BgAdjustFormDiversityData && (adjustData = (BgAdjustFormDiversityData)dataMap2333332.get(formulaStr)).getOldValue() != null && BigDecimal.ZERO.compareTo(adjustData.getOldValue()) != 0 && adjustData.getNewValue() == null) {
                        dataMap2333332.remove(formulaStr);
                        continue;
                    }
                    if (formId == null || formIdSet.contains(formId)) continue;
                    tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                    adjObjs = new Object[]{tmpStrs[1], tmpStrs[0], null, orgNumber, orgName, null, null};
                    billID = BOSUuid.read((String)formId);
                    if (billID.getType().toString().equals("210CFD59")) {
                        if (adjustBillMap.containsKey(billID.toString())) {
                            ((List)adjustBillMap.get(billID.toString())).add(adjObjs);
                            continue;
                        }
                        list = new ArrayList<Object[]>();
                        list.add(adjObjs);
                        adjustBillMap.put(billID.toString(), list);
                        continue;
                    }
                    if (!billID.getType().toString().equals("3BA5F027")) continue;
                    if (adjustFormMap.containsKey(billID.toString())) {
                        ((List)adjustFormMap.get(billID.toString())).add(adjObjs);
                        continue;
                    }
                    list = new ArrayList();
                    list.add(adjObjs);
                    adjustFormMap.put(billID.toString(), list);
                }
                HashSet<String> adjustBillSet = new HashSet<String>();
                for (String key : adjustBillMap.keySet()) {
                    adjustBillSet.add(key);
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("type");
                sic.add("number");
                sic.add("orgUnit.id");
                sic.add("orgUnit.number");
                sic.add("orgUnit.name");
                view.setSelector(sic);
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", adjustBillSet, CompareType.INCLUDE));
                BgAdjustBillCollection billColl = BgAdjustBillFactory.getLocalInstance(ctx).getBgAdjustBillCollection(view);
                BgAdjustBillInfo billInfo = null;
                for (int i = 0; i < billColl.size(); ++i) {
                    String tmpStr;
                    int j;
                    billInfo = billColl.get(i);
                    if (!adjustBillMap.containsKey(billInfo.getId().toString())) continue;
                    if (billInfo.getType().getValue() == 0 || billInfo.getType().getValue() == 1) {
                        for (j = 0; j < ((List)adjustBillMap.get(billInfo.getId().toString())).size(); ++j) {
                            objs = (Object[])((List)adjustBillMap.get(billInfo.getId().toString())).get(j);
                            objs[2] = billInfo.getNumber();
                            objs[5] = billInfo.getOrgUnit().getNumber();
                            objs[6] = billInfo.getOrgUnit().getName();
                            tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                            strs.append(tmpStr + "\r\n");
                        }
                        continue;
                    }
                    for (j = 0; j < ((List)adjustBillMap.get(billInfo.getId().toString())).size(); ++j) {
                        objs = (Object[])((List)adjustBillMap.get(billInfo.getId().toString())).get(j);
                        objs[2] = billInfo.getNumber();
                        objs[5] = billInfo.getOrgUnit().getNumber();
                        objs[6] = billInfo.getOrgUnit().getName();
                        tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                        strs.append(tmpStr + "\r\n");
                    }
                }
                HashSet<String> adjustFormSet = new HashSet<String>();
                for (String key : adjustFormMap.keySet()) {
                    adjustFormSet.add(key);
                }
                view = new EntityViewInfo();
                view.setSelector(sic);
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", adjustFormSet, CompareType.INCLUDE));
                BgFormCollection formColl = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
                BgFormInfo formInfo = null;
                for (int i = 0; i < formColl.size(); ++i) {
                    formInfo = formColl.get(i);
                    if (!adjustFormMap.containsKey(formInfo.getId().toString())) continue;
                    for (int j = 0; j < ((List)adjustFormMap.get(formInfo.getId().toString())).size(); ++j) {
                        objs = (Object[])((List)adjustFormMap.get(formInfo.getId().toString())).get(j);
                        objs[2] = formInfo.getNumber();
                        objs[5] = formInfo.getOrgUnit().getNumber();
                        objs[6] = formInfo.getOrgUnit().getName();
                        String tmpStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkTmpDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                        strs.append(tmpStr + "\r\n");
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                if (pool == null) break block26;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"checkTmpData sql error:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        throw new BOSException((Throwable)ex3);
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpTable, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception dataMap2333332) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private static String insertTmpTableForMutil(BgFormInfo bgForm, Map<String, Map<String, BgFormDiversityData>> adjustMap, Connection conn, int version, String tmpTable) throws SQLException {
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        String orgId2 = null;
        Map<String, BgFormDiversityData> item = null;
        for (String orgId2 : adjustMap.keySet()) {
            item = adjustMap.get(orgId2);
            if (StringUtils.isEmpty((String)orgId2) || item == null || item.isEmpty()) continue;
            for (BgFormDiversityData divData : item.values()) {
                Object[] objs = new Object[]{orgId2, divData.getFormula(), version};
                sqlParams.add(objs);
            }
        }
        BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTable + " (FOrgUnitId, FFormula, FVersion) values (?,?,?)"), sqlParams);
        return tmpTable;
    }

    public static void deleteTmpEntryData(Context ctx, List<String> bgAdjustBillIds) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            for (String bgAdjustBillId : bgAdjustBillIds) {
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgTmpDataEntry where FFormId = ?", (Object[])new Object[]{bgAdjustBillId});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"deleteTmpEntryData sql error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void deleteTmpData(Context ctx, List<String> bgAdjustBillIds) throws SQLDataException, EASBizException, BOSException, BgFormException {
        if (ctx == null || bgAdjustBillIds == null || bgAdjustBillIds.isEmpty()) {
            return;
        }
        String bgAdjustBillId = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<BgAdjustBillInfo> bgAdjustBills = MbgDataHelper.getBgAdjustBillBase(conn, ctx.getLocale(), bgAdjustBillIds);
            HashMap<String, BgSchemeAccIntHelper> accIntMap = new HashMap<String, BgSchemeAccIntHelper>();
            for (BgAdjustBillInfo bgAdjustBill : bgAdjustBills) {
                bgAdjustBillId = bgAdjustBill.getId().toString();
                String cubTableName = BgCubeUtils.getCubeName(bgAdjustBill.getBgScheme().getRefCube(), bgAdjustBill.getProcessType());
                BgSchemeAccIntHelper accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(cubTableName);
                if (accIntHelper == null) {
                    accIntHelper = new BgSchemeAccIntHelper(ctx, bgAdjustBill.getBgScheme().getId().toString(), cubTableName);
                    accIntMap.put(cubTableName, accIntHelper);
                }
                Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
                for (String cubeName : cubeNames) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cubeName + " where FID IN (select FBgDataId from T_MBG_BgAdjustBillEntry where FBgAdjustBill = ?) and FState = " + 5), (Object[])new Object[]{bgAdjustBillId});
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FTmpValue = FValue where FID IN (select FBgDataId from T_MBG_BgAdjustBillEntry where FBgAdjustBill = ?) and FTmpValue <> FValue"), (Object[])new Object[]{bgAdjustBillId});
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgTmpData where FID IN (select FBgDataId from T_MBG_BgAdjustBillEntry where FBgAdjustBill = ?)", (Object[])new Object[]{bgAdjustBillId});
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgTmpDataEntry where FFormId = ?", (Object[])new Object[]{bgAdjustBillId});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"deleteTmpData sql error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void afterAudit(Context ctx, List<String> bgAdjustBillIds) throws BOSException, EASBizException {
        if (ctx == null || bgAdjustBillIds == null || bgAdjustBillIds.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            for (String bgAdjustBillId : bgAdjustBillIds) {
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgTmpData where FID IN (select FBgDataId from T_MBG_BgAdjustBillEntry where FBgAdjustBill = ?)", (Object[])new Object[]{bgAdjustBillId});
                BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgTmpDataEntry where FFormId = ?", (Object[])new Object[]{bgAdjustBillId});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"deleteTmpData sql error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

