/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.IDimension;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpressionUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, IBgNData>> calcExpression(IBgCalculator calculator, int valueType) throws Exception {
        TempTablePool pool;
        HashMap<String, Integer> bgVersionInnMap;
        HashMap<Integer, String> bgVersionMap;
        HashMap<String, String> cubeMap;
        Map<String, List<IFormula>> batchMap;
        Map<String, String[]> orgCacheMap;
        ActualRecordSourceTypeEnum type;
        FormulaInfo formula;
        Map<String, IBgNData> value;
        ArrayList<Object[]> params;
        List<IFormula> formulaList;
        Object[] objs;
        String[] orgAndSchStr;
        String orgUnitNum;
        String cubeName;
        String tableName;
        String batchKey;
        HashMap<String, Map<String, IBgNData>> valueMap;
        block17: {
            valueMap = new HashMap<String, Map<String, IBgNData>>();
            if (calculator == null) {
                return valueMap;
            }
            batchKey = null;
            tableName = null;
            cubeName = null;
            orgUnitNum = null;
            orgAndSchStr = null;
            objs = null;
            formulaList = null;
            params = new ArrayList<Object[]>();
            Map.Entry<String, List<IFormula>> entry = null;
            value = null;
            formula = null;
            type = null;
            orgCacheMap = calculator.getCacheManager().getBgSchemeNumberMap();
            batchMap = calculator.getCacheManager().getBatchKeyMap();
            cubeMap = new HashMap<String, String>();
            bgVersionMap = new HashMap<Integer, String>();
            bgVersionInnMap = new HashMap<String, Integer>();
            BgVersionInfo version = null;
            BgVersionCollection colls = BgVersionHelper.getVersionColls((Context)calculator.getContext());
            int in22 = colls.size();
            for (int i = 0; i < in22; ++i) {
                version = colls.get(i);
                bgVersionMap.put(version.getVersionId(), version.getNumber());
                bgVersionInnMap.put(version.getNumber(), version.getVersionId());
            }
            pool = null;
            pool = TempTablePool.getInstance((Context)calculator.getContext());
            tableName = BgDBUtils.createTmpTable((Context)calculator.getContext(), (TempTablePool)pool, (String)ExpressionUtils.getTmpTable());
            if (!StringUtils.isEmpty((String)tableName)) break block17;
            HashMap<String, Map<String, IBgNData>> in22 = valueMap;
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tableName);
            return in22;
        }
        try {
            for (Map.Entry<String, List<IFormula>> entry : batchMap.entrySet()) {
                batchKey = entry.getKey();
                orgAndSchStr = batchKey.split("!");
                if (orgAndSchStr.length > 2) {
                    type = ExpressionUtils.getEnum(orgAndSchStr[2]);
                    if ("1".equals(type.getValue())) {
                        valueType = 4;
                    } else if ("3".equals(type.getValue())) {
                        valueType = 16;
                    }
                }
                orgAndSchStr = orgCacheMap.get(orgAndSchStr[0] + "!" + orgAndSchStr[1]);
                cubeName = ExpressionUtils.getCubeName(calculator.getContext(), orgAndSchStr, cubeMap);
                if (StringUtils.isEmpty((String)cubeName)) continue;
                formulaList = entry.getValue();
                params.clear();
                int in = formulaList.size();
                for (int i = 0; i < in; ++i) {
                    formula = (FormulaInfo)formulaList.get(i);
                    if (formula.getFormulas() == null) continue;
                    for (int j = 0; j < formula.getFormulas().length; ++j) {
                        objs = new Object[]{orgAndSchStr[2], formula.getFormulas()[j], bgVersionInnMap.get(formula.getBgVersionNumber())};
                        params.add(objs);
                    }
                }
                try {
                    BgDBUtils.executeUpdate((Context)calculator.getContext(), (String)("Truncate Table " + tableName));
                    BgDBUtils.executeBatch((Context)calculator.getContext(), (String)ExpressionUtils.getInsertSql(tableName), params);
                    value = ExpressionUtils.queryBgData(calculator.getContext(), ExpressionUtils.getQuerySql(tableName, valueType, cubeName), valueType, bgVersionMap);
                }
                catch (Exception ex) {
                    logger.error((Object)"bgFormula Calculate Error:", (Throwable)ex);
                }
                if (value == null) continue;
                orgUnitNum = orgAndSchStr[3];
                if (valueMap.containsKey(orgUnitNum)) {
                    Map tmpValue = (Map)valueMap.get(orgUnitNum);
                    for (String key : value.keySet()) {
                        if (!tmpValue.containsKey(key)) {
                            tmpValue.put(key, value.get(key));
                            continue;
                        }
                        ((IBgNData)tmpValue.get(key)).copyValue(value.get(key));
                    }
                    continue;
                }
                valueMap.put(orgUnitNum, value);
            }
        }
        catch (Throwable throwable) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tableName);
            throw throwable;
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tableName);
        return valueMap;
    }

    private static ActualRecordSourceTypeEnum getEnum(String dataType) {
        if (StringUtils.isEmpty((String)dataType)) {
            return null;
        }
        ActualRecordSourceTypeEnum _enum = null;
        List list = ActualRecordSourceTypeEnum.getEnumList();
        int in = list.size();
        for (int i = 0; i < in; ++i) {
            _enum = (ActualRecordSourceTypeEnum)((Object)list.get(i));
            if (!_enum.getName().equals(dataType)) continue;
            return _enum;
        }
        return null;
    }

    private static String getCubeName(Context context, String[] orgAndSchStr, Map<String, String> cubeMap) throws Exception {
        if (orgAndSchStr == null || cubeMap == null) {
            return null;
        }
        String schemeId = orgAndSchStr[0];
        String cubeName = null;
        if (cubeMap.containsKey(schemeId)) {
            cubeName = cubeMap.get(schemeId);
        } else {
            BgSchemeCollection col = BgSchemeFactory.getLocalInstance(context).getBgSchemeCollection("select refCube where id = '" + schemeId + "'");
            if (col != null && !col.isEmpty()) {
                cubeName = col.get(0).getRefCube();
            }
            cubeMap.put(schemeId, cubeName);
        }
        return cubeName;
    }

    private static String getTmpTable() {
        return "Create Table TMP_TABEL_NAME (FOrgUnitId VARCHAR(44), FFormula NVARCHAR(300), FVersion INT)";
    }

    private static String getInsertSql(String tableName) {
        return "Insert Into " + tableName + " (FOrgUnitId, FFormula, FVersion) values (?,?,?)";
    }

    private static String getQuerySql(String tableName, int valueType, String cuboName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (valueType == 1) {
            sql.append("select t.FFormula, t.FValue, t.FVersion from " + cuboName + " t join " + tableName + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
        } else if (valueType == 4) {
            sql.append("select t.FFormula, t.FValue, t.FVersion from " + BgCubeUtils.getActualCubeName(cuboName) + " t join " + tableName + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            sql.append("select t.FFormula, t.FValue, t.FVersion from " + BgCubeUtils.getDailyActualCubeName(cuboName) + " t join " + tableName + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
            if (valueType == 32) {
                sql.append(" where t.FState = 9");
            }
            if (valueType == 2048) {
                sql.append(" where t.FState = 1");
            }
        }
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, IBgNData> queryBgData(Context ctx, String sql, int valueType, Map<Integer, String> bgVersionMap) throws BOSException, EASBizException {
        HashMap<String, IBgNData> value = new HashMap<String, IBgNData>();
        if (ctx == null) return value;
        if (sql == null) return value;
        if (bgVersionMap == null) {
            return value;
        }
        BgNDataInfo data = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                data = new BgNDataInfo();
                data.setFormula(rst.getString("FFormula"));
                data.setBgVersion(bgVersionMap.get(rst.getInt("FVersion")));
                if (valueType == 1) {
                    data.setBudgetValue(rst.getBigDecimal("FValue"));
                } else if (valueType == 4) {
                    data.setBizActual(rst.getBigDecimal("FValue"));
                } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
                    data.setAddActualValue(rst.getBigDecimal("FValue"));
                }
                value.put(DimUtils.getDimDataKey(data), data);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"sql Error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return value;
    }

    public static Map<String, Map<String, IBgNData>> calcDimension(IBgCalculator calculator, int valueType) throws Exception {
        IDimensionParameter parameter = null;
        String batchKey = null;
        String orgUnitNum = null;
        String bgSchemeNum = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        Map<String, Map<String, IBgNData>> valueMap = new HashMap<String, Map<String, IBgNData>>();
        IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance(calculator.getContext());
        Map<String, List<IFormula>> batchMap = calculator.getCacheManager().getBatchKeyMap();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            batchKey = entry2.getKey();
            formulaList = entry2.getValue();
            orgAndSchStr = batchKey.split("!");
            orgUnitNum = orgAndSchStr[0];
            parameter = ExpressionUtils.transDimParameter(calculator, orgUnitNum, bgSchemeNum = orgAndSchStr[1], formulaList, valueType);
            if (parameter == null) continue;
            parameter.getControlManager().setHasQueryDataState(false);
            try {
                valueMap = (Map)facade.dimensionQuery(parameter);
            }
            catch (Exception ex) {
                logger.error((Object)"bgFormula Calculate Error:", (Throwable)ex);
            }
        }
        return valueMap;
    }

    public static IDimensionParameter transCslDimParameter(IBgCalculator calculator, OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo, String bgSchemeNumber, List<IFormula> formulas, int valueType) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        IDimensionParameter parameter = ExpressionUtils.transDimParameter(calculator, orgUnitInfo.getNumber(), bgSchemeNumber, formulas, valueType);
        parameter.setUnionId(orgTreeInfo.getId());
        parameter.setOrgUnitId(orgUnitInfo.getId());
        parameter.getDataManager().setOrgUnit(orgUnitInfo);
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDimensionParameter transDimParameter(IBgCalculator calculator, String orgUnitNumber, String bgSchemeNumber, List<IFormula> formulas, int valueType) throws Exception {
        int j;
        int jn;
        int i;
        if (calculator == null || StringUtils.isEmpty((String)orgUnitNumber) || StringUtils.isEmpty((String)bgSchemeNumber) || formulas == null || formulas.isEmpty()) {
            return null;
        }
        Context ctx = calculator.getContext();
        DimensionParameter parameter = new DimensionParameter();
        parameter.getControlManager().setExpressionCalc(true);
        parameter.setValueType(valueType);
        com.kingdee.eas.ma.mbg.dimension.face.IDimension itemDim2 = null;
        IMember member = null;
        String[] orgSchStrs = calculator.getCacheManager().getBgSchemeNumberMap().get(orgUnitNumber + "!" + bgSchemeNumber);
        if (orgSchStrs == null) {
            return null;
        }
        BOSUuid schemeId = BOSUuid.read((String)orgSchStrs[0]);
        BOSUuid orgUnitId = orgSchStrs[2] == null ? null : BOSUuid.read((String)orgSchStrs[2]);
        String orgUnitNum = orgSchStrs[3];
        parameter.setOrgUnitId(orgUnitId);
        parameter.setBgSchemeId(schemeId);
        BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), BgCubeUtils.getRefDimSelector());
        parameter.setBgOrgViewId(schemeInfo.getEditOrgViewId());
        BgOrgUnitInfo bgOrgUnit = null;
        if (orgUnitId != null) {
            bgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getValue(parameter.getBgOrgViewId(), orgUnitId);
            parameter.getDataManager().setBgOrgUnit(bgOrgUnit);
            if (bgOrgUnit != null) {
                parameter.getDataManager().setOrgUnit(CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId)));
            }
        }
        DimensionObject orgUnitDim = new DimensionObject();
        orgUnitDim.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
        orgUnitDim.setField(DimensionConstants.DEF_ORGUNIT_FIELD);
        orgUnitDim.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        member = new MemberObject();
        member.setNumber(orgUnitNum);
        orgUnitDim.getDimensionMember().add(member);
        DimUtils.queryItemLongNumber(ctx, parameter, orgUnitDim);
        DimUtils.transMdxMemberNumber(ctx, parameter, orgUnitDim);
        DimensionObject periodDim = new DimensionObject();
        periodDim.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
        periodDim.setField(DimensionBaseConstants.DEF_PERIOD_FIELD);
        DimensionObject elementDim = new DimensionObject();
        elementDim.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
        elementDim.setField(DimensionConstants.DEF_ELEMENT_FIELD);
        DimensionObject currencyDim = new DimensionObject();
        currencyDim.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
        currencyDim.setField(DimensionConstants.DEF_CURRENCY_FIELD);
        DimensionObject scenarioDim = new DimensionObject();
        scenarioDim.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
        scenarioDim.setField(DimensionConstants.DEF_SCENARIO_FIELD);
        DimensionObject versionDim = new DimensionObject();
        versionDim.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
        versionDim.setField(DimensionConstants.DEF_VERSION_FIELD);
        HashSet<String> hasPeriodSet = new HashSet<String>();
        HashSet<String> hasElementSet = new HashSet<String>();
        HashSet<String> hasCurrencySet = new HashSet<String>();
        HashSet<String> hasScenarioSet = new HashSet<String>();
        HashSet<String> hasVersionSet = new HashSet<String>();
        HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IDimension> dimMap = new HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        HashMap dimNumMap = new HashMap();
        HashSet<String> dimNumSet = null;
        List<String> tmpList = null;
        ArrayList<String[]> calcParams = new ArrayList<String[]>();
        HashSet<String> mbgItemNums = new HashSet<String>();
        FormulaInfo formula = null;
        MbgDimInfo dimensionInfo = null;
        String itemNumber = null;
        String number2 = null;
        String refField = null;
        String[] numStrs = null;
        String[] tmpStrs = null;
        String[] calcData = null;
        int calcSize = 0;
        IFormulaCacheManager cache = calculator.getCacheManager();
        List<BOSUuid> viewIds = schemeInfo.getExtDimViewIds();
        StringBuffer query = new StringBuffer();
        query.append("Select distinct m.FRefField, m.FSrcNumber, t.FNumber from T_MBG_MbgMember t left join T_MBG_MbgDim m on t.FDimId = m.FID where");
        if (viewIds != null && !viewIds.isEmpty()) {
            query.append(" t.FViewId IN (");
            int in = viewIds.size();
            for (int i2 = 0; i2 < in; ++i2) {
                query.append("'" + viewIds.get(i2) + "',");
            }
            query = query.delete(query.length() - 1, query.length());
            query.append(") and");
        }
        query.append(" t.FIsSystemDefault = 1 and t.FParentId is null");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)query.toString());
            while (rst.next()) {
                cache.getDefaultMember().put(rst.getString("FRefField"), rst.getString("FSrcNumber") + ":" + rst.getString("FNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        Set<String> extDims = schemeInfo.getExtDimNums(parameter.getValueType());
        calcSize = extDims.size() + 1;
        List<String> refFields = schemeInfo.getRefFields(ctx, valueType);
        for (String _refField : refFields) {
            if (DimUtils.checkBaseDimensionByField(_refField) || cache.getRefFields(schemeInfo.getNumber()).contains(_refField)) continue;
            cache.getRefFields(schemeInfo.getNumber()).add(_refField);
        }
        HashMap<String, String> dimMember = new HashMap<String, String>();
        int in = formulas.size();
        block5: for (int i3 = 0; i3 < in; ++i3) {
            formula = (FormulaInfo)formulas.get(i3);
            dimMember.clear();
            itemNumber = formula.getBgItemNumber();
            if ("@".equals(itemNumber)) {
                formula.getParameter().setValue(null);
                continue;
            }
            if (!mbgItemNums.contains(itemNumber)) {
                mbgItemNums.add(itemNumber);
                numStrs = itemNumber.split(",");
                if (numStrs != null) {
                    for (String number2 : numStrs) {
                        if (StringUtils.isEmpty((String)number2) || number2.indexOf(":") <= 0) {
                            formula.getParameter().setValue((Object)FormulaInfo.badException);
                            continue block5;
                        }
                        tmpStrs = number2.split(":");
                        if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = cache.getMbgDimMap().get(tmpStrs[0])) == null) continue;
                        dimMember.put(dimensionInfo.getRefField(), number2);
                    }
                }
                calcData = new String[calcSize];
                int jn2 = cache.getRefFields(schemeInfo.getNumber()).size();
                for (int j2 = 0; j2 < jn2; ++j2) {
                    refField = cache.getRefFields(schemeInfo.getNumber()).get(j2);
                    number2 = dimMember.containsKey(refField) ? (String)dimMember.get(refField) : cache.getDefaultMember().get(refField);
                    if (StringUtils.isEmpty((String)number2)) {
                        formula.getParameter().setValue((Object)FormulaInfo.badException);
                        continue block5;
                    }
                    calcData[j2] = number2;
                    tmpStrs = number2.split(":");
                    if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = cache.getMbgDimMap().get(tmpStrs[0])) == null) continue;
                    if (dimMap.containsKey(dimensionInfo.getRefField())) {
                        itemDim2 = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimMap.get(dimensionInfo.getRefField());
                        dimNumSet = (HashSet<String>)dimNumMap.get(dimensionInfo.getRefField());
                    } else {
                        itemDim2 = new DimensionObject();
                        itemDim2.setNumber(dimensionInfo.getNumber());
                        itemDim2.setField(dimensionInfo.getRefField());
                        itemDim2.setSrcNumber(tmpStrs[0]);
                        dimMap.put(dimensionInfo.getRefField(), itemDim2);
                        dimNumSet = new HashSet<String>();
                        dimNumMap.put(dimensionInfo.getRefField(), dimNumSet);
                    }
                    member = new MemberObject();
                    member.setSrcNumber(tmpStrs[0]);
                    member.setNumber(tmpStrs[1]);
                    if (dimNumSet.contains(member.getDimNumber())) continue;
                    itemDim2.getDimensionMember().add(member);
                    dimNumSet.add(member.getDimNumber());
                }
                calcParams.add(calcData);
            }
            if (!hasElementSet.contains(number2 = formula.getBgElementNumber())) {
                hasElementSet.add(number2);
                member = new MemberObject();
                member.setNumber(number2);
                elementDim.getDimensionMember().add(member);
            }
            if (!hasCurrencySet.contains(number2 = formula.getCurrencyNumber())) {
                hasCurrencySet.add(number2);
                member = new MemberObject();
                member.setNumber(number2);
                currencyDim.getDimensionMember().add(member);
            }
            if (!hasScenarioSet.contains(number2 = formula.getBgScenarioNumber())) {
                hasScenarioSet.add(number2);
                member = new MemberObject();
                member.setNumber(number2);
                scenarioDim.getDimensionMember().add(member);
            }
            if (!hasVersionSet.contains(number2 = formula.getBgVersionNumber())) {
                hasVersionSet.add(number2);
                member = new MemberObject();
                member.setNumber(number2);
                versionDim.getDimensionMember().add(member);
            }
            String periodKey = formula.getBeginPeriodNumber() + "!" + formula.getEndPeriodNumber();
            tmpList = cache.getPeriodBEMap().get(periodKey);
            int jn3 = tmpList.size();
            for (int j3 = 0; j3 < jn3; ++j3) {
                number2 = tmpList.get(j3);
                if (hasPeriodSet.contains(number2)) continue;
                hasPeriodSet.add(number2);
                member = new MemberObject();
                member.setNumber(number2);
                periodDim.getDimensionMember().add(member);
            }
        }
        parameter.getPageDims().add(orgUnitDim);
        parameter.getDimensionMap().put(orgUnitDim.getNumber(), orgUnitDim);
        parameter.getDataManager().setBgScheme(schemeInfo);
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension itemDim2 : dimMap.values()) {
            DimUtils.queryItemLongNumber(ctx, parameter, itemDim2);
            DimUtils.transMdxMemberNumber(ctx, parameter, itemDim2);
            parameter.getRowDims().add(itemDim2);
            parameter.getDimensionMap().put(itemDim2.getNumber(), itemDim2);
        }
        Collections.sort(parameter.getRowDims(), new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                String index1 = o1.getField().substring(1);
                String index2 = o2.getField().substring(1);
                return Integer.valueOf(index1).compareTo(Integer.valueOf(index2));
            }
        });
        DimUtils.transMdxMemberNumber(ctx, parameter, periodDim);
        parameter.getColDims().add(periodDim);
        parameter.getDimensionMap().put(periodDim.getNumber(), periodDim);
        DimUtils.queryItemLongNumber(ctx, parameter, elementDim);
        parameter.getColDims().add(elementDim);
        parameter.getDimensionMap().put(elementDim.getNumber(), elementDim);
        parameter.getColDims().add(currencyDim);
        parameter.getDimensionMap().put(currencyDim.getNumber(), currencyDim);
        DimUtils.queryItemLongNumber(ctx, parameter, scenarioDim);
        DimUtils.transScenarioNumber(ctx, scenarioDim);
        parameter.getColDims().add(scenarioDim);
        parameter.getDimensionMap().put(scenarioDim.getNumber(), scenarioDim);
        DimUtils.queryItemLongNumber(ctx, parameter, versionDim);
        DimUtils.transVersionNumber(ctx, versionDim);
        parameter.getColDims().add(versionDim);
        parameter.getDimensionMap().put(versionDim.getNumber(), versionDim);
        com.kingdee.eas.ma.mbg.dimension.face.IDimension _dimension = null;
        String dimNumber = null;
        String mdxNumber = null;
        HashMap<String, Map<String, String>> dimMemNumMap = new HashMap<String, Map<String, String>>();
        Map memberMap = null;
        int in2 = parameter.getRowDims().size();
        for (i = 0; i < in2; ++i) {
            int j4;
            int jn4;
            _dimension = parameter.getRowDims().get(i);
            dimNumber = DimUtils.getDimensionNumber(_dimension);
            if (!DimUtils.checkBaseDimension(_dimension)) {
                memberMap = dimMemNumMap.containsKey(DimensionConstants.DEF_INDEX_NUMBER) ? (Map)dimMemNumMap.get(DimensionConstants.DEF_INDEX_NUMBER) : new HashMap();
                jn = _dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    member = _dimension.getDimensionMember().get(j);
                    number2 = member.getDimNumber();
                    mdxNumber = DimUtils.getMdxItemMember(dimNumber, member);
                    memberMap.put(number2, mdxNumber);
                }
                dimMemNumMap.put(DimensionConstants.DEF_INDEX_NUMBER, memberMap);
                continue;
            }
            memberMap = new HashMap();
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(_dimension.getNumber())) {
                Map bgScenNumMap = BgScenarioHelper.getScenarioMap((Context)ctx);
                jn4 = _dimension.getDimensionMember().size();
                for (j4 = 0; j4 < jn4; ++j4) {
                    member = _dimension.getDimensionMember().get(j4);
                    number2 = member.getDimNumber();
                    mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                    memberMap.put(bgScenNumMap.get(number2), mdxNumber);
                }
            } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(_dimension.getNumber())) {
                Map bgVersionNumMap = BgVersionHelper.getVersionMap((Context)ctx);
                jn4 = _dimension.getDimensionMember().size();
                for (j4 = 0; j4 < jn4; ++j4) {
                    member = _dimension.getDimensionMember().get(j4);
                    number2 = member.getDimNumber();
                    mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                    memberMap.put(bgVersionNumMap.get(number2), mdxNumber);
                }
            } else {
                jn = _dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    member = _dimension.getDimensionMember().get(j);
                    number2 = member.getDimNumber();
                    mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                    memberMap.put(number2, mdxNumber);
                }
            }
            dimMemNumMap.put(_dimension.getNumber(), memberMap);
        }
        in2 = calcParams.size();
        for (i = 0; i < in2; ++i) {
            calcData = (String[])calcParams.get(i);
            memberMap = (Map)dimMemNumMap.get(DimensionConstants.DEF_INDEX_NUMBER);
            jn = calcData.length;
            for (j = 0; j < jn; ++j) {
                calcData[j] = (String)memberMap.get(calcData[j]);
            }
        }
        parameter.setExpressionParams(calcParams);
        return parameter;
    }

    public static IDimensionParameter transDimParameter(Context ctx, BOSUuid bgSchemeId, OrgUnitInfo orgUnitInfo, List<BgNDataInfo> bgDatas, Map<String, MbgDimInfo> dimsMap) throws Exception {
        int j;
        int jn;
        int i;
        if (ctx == null || bgSchemeId == null || orgUnitInfo == null || bgDatas == null || bgDatas.isEmpty() || dimsMap == null) {
            return null;
        }
        DimensionParameter parameter = new DimensionParameter();
        parameter.getControlManager().setExpressionCalc(true);
        com.kingdee.eas.ma.mbg.dimension.face.IDimension itemDim2 = null;
        IMember member = null;
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setOrgUnitId(orgUnitInfo.getId());
        BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), BgCubeUtils.getRefDimSelector());
        parameter.setBgOrgViewId(schemeInfo.getEditOrgViewId());
        DimensionObject orgUnitDim = new DimensionObject();
        orgUnitDim.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
        orgUnitDim.setField(DimensionConstants.DEF_ORGUNIT_FIELD);
        member = new MemberObject();
        member.setNumber(orgUnitInfo.getNumber());
        orgUnitDim.getDimensionMember().add(member);
        DimUtils.queryItemLongNumber(ctx, parameter, orgUnitDim);
        DimUtils.transMdxMemberNumber(ctx, parameter, orgUnitDim);
        DimensionObject periodDim = new DimensionObject();
        periodDim.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
        DimensionObject elementDim = new DimensionObject();
        elementDim.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
        DimensionObject currencyDim = new DimensionObject();
        currencyDim.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
        DimensionObject scenarioDim = new DimensionObject();
        scenarioDim.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
        DimensionObject versionDim = new DimensionObject();
        versionDim.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
        HashSet<String> hasPeriodSet = new HashSet<String>();
        HashSet<String> hasElementSet = new HashSet<String>();
        HashSet<String> hasCurrencySet = new HashSet<String>();
        HashSet<String> hasScenarioSet = new HashSet<String>();
        HashSet<String> hasVersionSet = new HashSet<String>();
        HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IDimension> dimMap = new HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        HashMap dimNumMap = new HashMap();
        HashSet<String> dimNumSet = null;
        HashSet<String> mbgItemNums = new HashSet<String>();
        ArrayList<String[]> calcParams = new ArrayList<String[]>();
        MbgDimInfo dimensionInfo = null;
        String itemNumber = null;
        String number = null;
        String[] numStrs = null;
        String[] tmpStrs = null;
        String[] calcData = null;
        int calcSize = 0;
        for (BgNDataInfo bgData : bgDatas) {
            itemNumber = bgData.getBgItemNumber();
            if (!mbgItemNums.contains(itemNumber)) {
                mbgItemNums.add(itemNumber);
                numStrs = itemNumber.split(",");
                calcSize = numStrs.length;
                calcData = new String[calcSize];
                if (numStrs != null) {
                    int jn2 = numStrs.length;
                    for (int j2 = 0; j2 < jn2; ++j2) {
                        calcData[j2] = number = numStrs[j2];
                        tmpStrs = number.split(":");
                        if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = dimsMap.get(tmpStrs[0])) == null) continue;
                        if (dimMap.containsKey(dimensionInfo.getRefField())) {
                            itemDim2 = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimMap.get(dimensionInfo.getRefField());
                            dimNumSet = (HashSet<String>)dimNumMap.get(dimensionInfo.getRefField());
                        } else {
                            itemDim2 = new DimensionObject();
                            itemDim2.setNumber(dimensionInfo.getNumber());
                            itemDim2.setField(dimensionInfo.getRefField());
                            dimMap.put(dimensionInfo.getRefField(), itemDim2);
                            dimNumSet = new HashSet<String>();
                            dimNumMap.put(dimensionInfo.getRefField(), dimNumSet);
                        }
                        member = new MemberObject();
                        member.setSrcNumber(tmpStrs[0]);
                        member.setNumber(tmpStrs[1]);
                        if (dimNumSet.contains(member.getDimNumber())) continue;
                        itemDim2.getDimensionMember().add(member);
                        dimNumSet.add(member.getDimNumber());
                    }
                }
                calcParams.add(calcData);
            }
            if (!hasPeriodSet.contains(number = bgData.getBgPeriodNumber())) {
                hasPeriodSet.add(number);
                member = new MemberObject();
                member.setNumber(number);
                periodDim.getDimensionMember().add(member);
            }
            if (!hasElementSet.contains(number = bgData.getBgElementNumber())) {
                hasElementSet.add(number);
                member = new MemberObject();
                member.setNumber(number);
                elementDim.getDimensionMember().add(member);
            }
            if (!hasCurrencySet.contains(number = bgData.getCurrencyNumber())) {
                hasCurrencySet.add(number);
                member = new MemberObject();
                member.setNumber(number);
                currencyDim.getDimensionMember().add(member);
            }
            if (!hasScenarioSet.contains(number = bgData.getBgScenario())) {
                hasScenarioSet.add(number);
                member = new MemberObject();
                member.setSrcNumber(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
                member.setNumber(number);
                scenarioDim.getDimensionMember().add(member);
            }
            if (hasVersionSet.contains(number = bgData.getBgVersion())) continue;
            hasVersionSet.add(number);
            member = new MemberObject();
            member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
            member.setNumber(number);
            versionDim.getDimensionMember().add(member);
        }
        if (periodDim.getDimensionMember().isEmpty() || elementDim.getDimensionMember().isEmpty() || currencyDim.getDimensionMember().isEmpty()) {
            return null;
        }
        parameter.getPageDims().add(orgUnitDim);
        parameter.getDimensionMap().put(orgUnitDim.getNumber(), orgUnitDim);
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension itemDim2 : dimMap.values()) {
            DimUtils.queryItemLongNumber(ctx, parameter, itemDim2);
            DimUtils.transMdxMemberNumber(ctx, parameter, itemDim2);
            parameter.getRowDims().add(itemDim2);
            parameter.getDimensionMap().put(itemDim2.getNumber(), itemDim2);
        }
        Collections.sort(parameter.getRowDims(), new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                String index1 = o1.getField().substring(1);
                String index2 = o2.getField().substring(1);
                return Integer.valueOf(index1).compareTo(Integer.valueOf(index2));
            }
        });
        DimUtils.transMdxMemberNumber(ctx, parameter, periodDim);
        parameter.getColDims().add(periodDim);
        parameter.getDimensionMap().put(periodDim.getNumber(), periodDim);
        DimUtils.queryItemLongNumber(ctx, parameter, elementDim);
        parameter.getColDims().add(elementDim);
        parameter.getDimensionMap().put(elementDim.getNumber(), elementDim);
        parameter.getColDims().add(currencyDim);
        parameter.getDimensionMap().put(currencyDim.getNumber(), currencyDim);
        DimUtils.queryItemLongNumber(ctx, parameter, scenarioDim);
        DimUtils.transScenarioNumber(ctx, scenarioDim);
        parameter.getColDims().add(scenarioDim);
        parameter.getDimensionMap().put(scenarioDim.getNumber(), scenarioDim);
        DimUtils.queryItemLongNumber(ctx, parameter, versionDim);
        DimUtils.transVersionNumber(ctx, versionDim);
        parameter.getColDims().add(versionDim);
        parameter.getDimensionMap().put(versionDim.getNumber(), versionDim);
        com.kingdee.eas.ma.mbg.dimension.face.IDimension _dimension = null;
        String dimNumber = null;
        String mdxNumber = null;
        HashMap<String, Map<String, String>> dimMemNumMap = new HashMap<String, Map<String, String>>();
        Map memberMap = null;
        int in = parameter.getRowDims().size();
        for (i = 0; i < in; ++i) {
            _dimension = parameter.getRowDims().get(i);
            dimNumber = DimUtils.getDimensionNumber(_dimension);
            if (!DimUtils.checkBaseDimension(_dimension)) {
                memberMap = dimMemNumMap.containsKey(DimensionConstants.DEF_INDEX_NUMBER) ? (Map)dimMemNumMap.get(DimensionConstants.DEF_INDEX_NUMBER) : new HashMap();
                jn = _dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    member = _dimension.getDimensionMember().get(j);
                    number = member.getDimNumber();
                    mdxNumber = DimUtils.getMdxItemMember(dimNumber, member);
                    memberMap.put(number, mdxNumber);
                }
                dimMemNumMap.put(DimensionConstants.DEF_INDEX_NUMBER, memberMap);
                continue;
            }
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(_dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(_dimension.getNumber())) {
                memberMap = new HashMap();
                jn = _dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    member = _dimension.getDimensionMember().get(j);
                    number = member.getNumber();
                    mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                    memberMap.put(number, mdxNumber);
                }
                dimMemNumMap.put(_dimension.getNumber(), memberMap);
                continue;
            }
            memberMap = new HashMap();
            jn = _dimension.getDimensionMember().size();
            for (j = 0; j < jn; ++j) {
                member = _dimension.getDimensionMember().get(j);
                number = member.getDimNumber();
                mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                memberMap.put(number, mdxNumber);
            }
            dimMemNumMap.put(_dimension.getNumber(), memberMap);
        }
        in = calcParams.size();
        for (i = 0; i < in; ++i) {
            calcData = (String[])calcParams.get(i);
            memberMap = (HashMap)dimMemNumMap.get(DimensionConstants.DEF_INDEX_NUMBER);
            jn = calcData.length;
            for (j = 0; j < jn; ++j) {
                calcData[j] = (String)memberMap.get(calcData[j]);
            }
        }
        parameter.setExpressionParams(calcParams);
        return parameter;
    }

    public static void queryBgPeriodInfo(IBgCalculator calculator) throws Exception {
        IFormulaCacheManager cache = calculator.getCacheManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        List<Object> periodNum = null;
        String periodkey = null;
        try {
            conn = EJBFactory.getConnection((Context)calculator.getContext());
            pstmt = conn.prepareStatement("select p.FNumber, t.FNumber, t.FPeriodType from T_MBG_BgPeriodDisp t join T_MBG_BgPeriodType p on t.FTypeId = p.FID ORDER BY p.FNumber, t.FNumber ASC");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                periodkey = rst.getString(1) + "_" + rst.getInt("FPeriodType");
                if (cache.getPeriodMap().containsKey(periodkey)) {
                    periodNum = cache.getPeriodMap().get(periodkey);
                } else {
                    periodNum = new ArrayList();
                    cache.getPeriodMap().put(periodkey, periodNum);
                }
                periodNum.add(rst.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgPeriodInfo error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    public static void queryDimInfo(IBgCalculator calculator) throws Exception {
        IFormulaCacheManager cache = calculator.getCacheManager();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)DimUtils.getDimSelector());
        Map<String, MbgDimInfo> dimInfoMap = DimUtils.getDimInfoMap(calculator.getContext());
        cache.getMbgDimMap().putAll(dimInfoMap);
    }

    private static IDimension getDimensionInterface(Context ctx) throws Exception {
        return DimensionFactory.getLocalInstance(ctx);
    }

    public static void queryOrgUnitInfo(IBgCalculator calculator) throws Exception {
        Map<String, String[]> orgANDSchMap = calculator.getCacheManager().getBgSchemeNumberMap();
        if (orgANDSchMap.isEmpty()) {
            return;
        }
        ArrayList<String> number = new ArrayList<String>();
        number.addAll(orgANDSchMap.keySet());
        int tmpIndex = 0;
        int batchSize = 50;
        int size = number.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _key = null;
        String[] _tmpStr = null;
        String[] orgSchStrs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.FID, t.FNumber, u.FOrgUnitID, u.FNumber FROM T_MBG_BgScheme t join T_MBG_BgDimSettings ds on ds.FBgSchemeId = t.FID join T_MBG_BgDimSettingsMember dsm on dsm.FBgDimSettingsId = ds.FID join T_MBG_BgOrgView v on dsm.FMemberId = v.FID join T_MBG_BgOrgUnit u on v.FID = u.FViewId where dsm.Ftype = 2 and ");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("(u.FNumber = ? and t.FNumber = ?) or ");
        }
        sql.append("(u.FNumber = ? and t.FNumber = ?)");
        try {
            conn = EJBFactory.getConnection((Context)calculator.getContext());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    tmpIndex = x * 2;
                    if (pos < size) {
                        _tmpStr = ((String)number.get(pos)).split("!");
                        pstmt.setString(tmpIndex - 1, _tmpStr[0]);
                        pstmt.setString(tmpIndex, _tmpStr[1]);
                    } else {
                        pstmt.setString(tmpIndex - 1, "#");
                        pstmt.setString(tmpIndex, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgSchStrs = new String[]{rst.getString(1), rst.getString(2), rst.getString(3), rst.getString(4)};
                    _key = orgSchStrs[3] + "!" + orgSchStrs[1];
                    orgANDSchMap.put(_key, orgSchStrs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryOrgUnitInfo Error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    public static Expression clone(Expression expr) {
        Expression _expr = expr;
        if (_expr instanceof FunctionExpr) {
            FunctionExpr _funExpr = (FunctionExpr)_expr;
            FunctionExpr clone = new FunctionExpr(_funExpr.funcionName);
            clone.parameters = ExpressionUtils.cloneParam(_funExpr.parameters);
            _expr = clone;
        } else if (_expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr _binaryExpr = (BinaryOperationExpr)_expr;
            BinaryOperationExpr clone = new BinaryOperationExpr(_binaryExpr.operationType);
            clone.left = ExpressionUtils.clone(_binaryExpr.left);
            clone.right = ExpressionUtils.clone(_binaryExpr.right);
            _expr = clone;
        }
        return _expr;
    }

    public static Expression clone(FormulaExpr expr) {
        FunctionExpr _expr = new FunctionExpr(expr.formulaName);
        _expr.parameters = ExpressionUtils.cloneParam(expr.params);
        return _expr;
    }

    private static List cloneParam(List parameters) {
        if (parameters == null) {
            return null;
        }
        Object obj = null;
        ArrayList<Object> clones = new ArrayList<Object>();
        int in = parameters.size();
        for (int i = 0; i < in; ++i) {
            StringExpr _expr;
            obj = parameters.get(i);
            if (obj instanceof StringExpr) {
                _expr = (StringExpr)obj;
                clones.add(new StringExpr(_expr.value));
                continue;
            }
            if (obj instanceof IntExpr) {
                _expr = (IntExpr)obj;
                clones.add(new IntExpr(_expr.value));
                continue;
            }
            if (obj instanceof NumberExpr) {
                _expr = (NumberExpr)obj;
                clones.add(new NumberExpr(_expr.value));
                continue;
            }
            if (obj instanceof BoolExpr) {
                _expr = (BoolExpr)obj;
                clones.add(new BoolExpr(_expr.value));
                continue;
            }
            if (obj instanceof UnaryOperationExpr) {
                _expr = (UnaryOperationExpr)obj;
                if (_expr.operationType != 2 || !(_expr.operand instanceof IntExpr)) continue;
                IntExpr tmp = (IntExpr)_expr.operand;
                BigInteger tmpValue = tmp.value.negate();
                clones.add(new IntExpr(tmpValue));
                continue;
            }
            clones.add(obj);
        }
        return clones;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIsCostCenter(IBgCalculator calculator, String orgID) throws Exception {
        block7: {
            if (calculator == null || orgID == null) {
                return false;
            }
            conn = null;
            pstmt = null;
            rst = null;
            _key = null;
            _tmpStr = null;
            orgSchStrs = null;
            sql = new StringBuffer();
            sql.append("SELECT FISCOSTORGUNIT  FROM T_Org_Baseunit where FID = ? ");
            try {
                conn = EJBFactory.getConnection((Context)calculator.getContext());
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, orgID);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (rst.getInt("FISCOSTORGUNIT") != 1) continue;
                    var9_9 = true;
                    break block7;
                }
                ** GOTO lbl-1000
            }
            catch (SQLException ex) {
                try {
                    ExpressionUtils.logger.error((Object)"checkIsCostCenter Error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable var10_12) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw var10_12;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return var9_9;
lbl-1000:
        // 1 sources

        {
            var9_10 = false;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return var9_10;
    }
}

