/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.ICalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaCacheManager;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractBgCalculator
implements IBgCalculator {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.AbstractBgCalculator");
    private Context context = null;
    private ICalculateContextProvider provider = null;
    private IFormulaCacheManager cacheManager = null;
    private ICalculateUtils utils = null;
    private List<IFormula> formula = null;
    private Object returnValue = null;
    private boolean isClearFormula = true;
    private static final String LOGUSESTR = "invoke process use = {0} ms; alluse = {1} ms;";
    private static final String LOGENDSTR = "invoke process alluse = {0} ms;";
    private static final MessageFormat useFormat = new MessageFormat("invoke process use = {0} ms; alluse = {1} ms;");
    private static final MessageFormat endFormat = new MessageFormat("invoke process alluse = {0} ms;");

    public AbstractBgCalculator(Context context, ICalculateContextProvider provider) {
        this.setContext(context);
        this.setProvider(provider);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object value) {
        this.returnValue = value;
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    @Override
    public ICalculateContextProvider getProvider() {
        return this.provider;
    }

    public void setFormula(List<IFormula> formula) {
        this.formula = formula;
    }

    @Override
    public List<IFormula> getFormula() {
        return this.formula;
    }

    public void setCacheManager(IFormulaCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public IFormulaCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new FormulaCacheManager();
        }
        return this.cacheManager;
    }

    @Override
    public void setClearFormula(boolean isClearFormula) {
        this.isClearFormula = isClearFormula;
    }

    @Override
    public boolean isClearFormula() {
        return this.isClearFormula;
    }

    public void setUtils(ICalculateUtils utils) {
        this.utils = utils;
    }

    public ICalculateUtils getUtils() {
        if (this.utils == null) {
            this.utils = this.createCalcUtils();
        }
        return this.utils;
    }

    public abstract ICalculateUtils createCalcUtils();

    public abstract String getExpressionName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        long _startTime = 0L;
        long _beginTime = 0L;
        _startTime = _beginTime = System.currentTimeMillis();
        logger.info((Object)("invoke batch calculate " + this.getExpressionName() + " start!"));
        Object value = null;
        try {
            this.getUtils().beforeCommonInit();
            List<IFormula> tmpList = this.getUtils().parseCalculateParam(params);
            if (tmpList != null) {
                this.setFormula(tmpList);
            }
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.useTime(_startTime, _beginTime));
            _beginTime = System.currentTimeMillis();
            value = this.getUtils().calculate();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.useTime(_startTime, _beginTime));
            _beginTime = System.currentTimeMillis();
            this.getUtils().fillValue(value);
            if (!this.getFormula().isEmpty()) {
                this.setReturnValue(this.getFormula().get(0).getParameter().getValue());
            }
        }
        catch (Exception ex) {
            logger.info((Object)"calculate execute error:", (Throwable)ex);
            this.getUtils().errorFillValue(ex);
        }
        finally {
            this.getUtils().clear();
        }
        logger.info((Object)("invoke batch calculate " + this.getExpressionName() + " finished!"));
        logger.info((Object)this.endTime(_startTime));
    }

    @Override
    public void clear() {
        this.setContext(null);
        this.setProvider(null);
        this.setUtils(null);
        if (this.isClearFormula()) {
            this.getFormula().clear();
            this.getCacheManager().clear();
        }
    }

    private MessageFormat getUseLog() {
        return useFormat;
    }

    private MessageFormat getEndLog() {
        return endFormat;
    }

    protected String useTime(long startTime, long beginTime) {
        long endTime = System.currentTimeMillis();
        Long[] times = new Long[]{endTime - beginTime, endTime - startTime};
        return this.getUseLog().format(times);
    }

    protected String endTime(long startTime) {
        long endTime = System.currentTimeMillis();
        Long[] times = new Long[]{endTime - startTime};
        return this.getEndLog().format(times);
    }
}

