/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.IDimension;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.ICalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.util.StringUtils;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractCalculateUtils
implements ICalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.formula.AbstractCalculateUtils");
    private IBgCalculator calculator = null;
    private DefaultFormulaValue value = null;

    public AbstractCalculateUtils(IBgCalculator calculator) {
        this.setCalculator(calculator);
    }

    public void setCalculator(IBgCalculator calculator) {
        this.calculator = calculator;
    }

    public IBgCalculator getCalculator() {
        return this.calculator;
    }

    public IBgDimensionFacade getDimensionFacadeInterface() throws Exception {
        return BgDimensionFacadeFactory.getLocalInstance(this.getCalculator().getContext());
    }

    public IDimension getDimensionInterface() throws Exception {
        return DimensionFactory.getLocalInstance(this.getCalculator().getContext());
    }

    @Override
    public void beforeCommonInit() throws Exception {
        ExpressionUtils.queryBgPeriodInfo(this.getCalculator());
    }

    @Override
    public List<IFormula> parseCalculateParam(SortedParameterArray params) throws Exception {
        String companyID;
        Object createDate;
        Object periodId;
        Object bgFormId;
        Object type;
        if (params == null || params.isEmpty()) {
            return null;
        }
        Parameter parameter = null;
        IFormula formula = null;
        IReportPropertyAdapter adapter = null;
        DefaultFormulaValue value = this.getDefaultValue();
        if (this.getDefaultValue() == null) {
            value = this.getDefaultFormulaValue();
            this.setDefaultValue(value);
        }
        adapter = this.getCalculator().getProvider().getReportAdapter();
        value.setCompanyNumber((String)adapter.getReportProperty("Company.Number"));
        value.setOrgUnitNumber((String)adapter.getReportProperty("BG_ORG_NUMBER"));
        value.setBgSchemeNumber((String)adapter.getReportProperty("BG_SCHEME_NUMBER"));
        value.setBgPeriodNumber((String)adapter.getReportProperty("BG_PERIOD_NUMBER"));
        value.setBgVersionNumber((String)adapter.getReportProperty("BG_VERSION_NUMBER"));
        value.setCurrencyNumber((String)adapter.getReportProperty("Currency.Number"));
        if (!StringUtils.isEmpty((String)((String)adapter.getReportProperty("BG_FORM_PROCESSTYPE")))) {
            value.setProcessType(BgProcessEnum.getEnum((String)adapter.getReportProperty("BG_FORM_PROCESSTYPE")));
        }
        this.afterSetDefaultValue(adapter, value);
        if (StringUtils.isEmpty((String)value.getBgPeriodNumber())) {
            value.setBgPeriodNumber(this.getDefaultPeriodNumByReport(adapter));
        }
        if ((type = adapter.getReportProperty("BG_PERIOD_TYPE")) != null && adapter.getReportProperty("PeriodType") != null) {
            value.setPeriodType((Integer)adapter.getReportProperty("PeriodType"));
            value.setYear((Integer)adapter.getReportProperty("Report.Year"));
            value.setPeriod((Integer)adapter.getReportProperty("Report.Period"));
        }
        if ((bgFormId = adapter.getReportProperty("BG_FORM_ID")) != null) {
            value.setBgFormId(bgFormId.toString());
        }
        if ((periodId = adapter.getReportProperty("BG_PERIOD_ID")) != null) {
            value.setBgPeriodId(periodId.toString());
        }
        if ((createDate = adapter.getReportProperty("bg_create_date")) != null) {
            value.setCreateDate((Date)createDate);
        }
        if (StringUtils.isEmpty((String)value.getOrgUnitNumber()) && !StringUtils.isEmpty((String)(companyID = (String)adapter.getReportProperty("Company.ID"))) && ExpressionUtils.checkIsCostCenter(this.getCalculator(), companyID)) {
            value.setOrgUnitNumber((String)adapter.getReportProperty("Company.Number"));
        }
        if (StringUtils.isEmpty((String)value.getBgPeriodNumber())) {
            int periodType = -1;
            int currYear = -1;
            int currPeriod = -1;
            if (adapter.getReportProperty("PeriodType") != null) {
                periodType = (Integer)adapter.getReportProperty("PeriodType");
                currYear = (Integer)adapter.getReportProperty("Report.Year");
                currPeriod = (Integer)adapter.getReportProperty("Report.Period");
                String peroidNumber = this.getOffsetBgPeriodNumber(periodType, currYear, currPeriod, 0);
                value.setBgPeriodNumber(peroidNumber);
            }
        }
        ArrayList<IFormula> formulaObjs = new ArrayList<IFormula>(params.size());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            parameter = params.getParameter(i);
            try {
                formula = this.createFormula(parameter);
                formula.parse(value);
            }
            catch (Exception ex) {
                FormulaValueBackfill.setException((Parameter)params.getParameter(i), (Throwable)ex);
                continue;
            }
            if (!formula.isCalculate()) continue;
            this.cacheFormulaProperty(formula);
            formulaObjs.add(formula);
        }
        return formulaObjs;
    }

    protected void afterSetDefaultValue(IReportPropertyAdapter adapter, DefaultFormulaValue value2) {
    }

    protected String getDefaultPeriodNumByReport(IReportPropertyAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        Integer year = (Integer)adapter.getReportProperty("Report.Year");
        Integer period = (Integer)adapter.getReportProperty("Report.Period");
        CalendarHelper helper = new CalendarHelper();
        return "MONT." + BgNPeriodHelper.getPeriodNum((Date)helper.setDay(year.intValue(), period.intValue(), 1), (BgPeriodEnum)BgPeriodEnum.MONTH);
    }

    protected DefaultFormulaValue getDefaultFormulaValue() {
        return new DefaultFormulaValue();
    }

    public void setDefaultValue(DefaultFormulaValue value) {
        this.value = value;
    }

    public DefaultFormulaValue getDefaultValue() {
        return this.value;
    }

    protected void cacheFormulaProperty(IFormula formula) {
        if (formula == null) {
            return;
        }
        List<Object> tmpList = null;
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        String batchKey = formula.getBatchCalculateKey();
        if (cache.getBatchKeyMap().containsKey(batchKey)) {
            tmpList = cache.getBatchKeyMap().get(batchKey);
        } else {
            tmpList = new ArrayList();
            cache.getBatchKeyMap().put(batchKey, tmpList);
        }
        tmpList.add(formula);
        if (!cache.getBgSchemeNumberMap().containsKey(batchKey)) {
            cache.getBgSchemeNumberMap().put(batchKey, null);
        }
    }

    @Override
    public Object calculate() throws Exception {
        this.beforeCalculate();
        Object value = this.invokeCalculate();
        this.afterCalculate();
        return value;
    }

    protected void beforeCalculate() throws Exception {
        this.queryBaseInfo();
    }

    protected abstract Object invokeCalculate() throws Exception;

    protected void afterCalculate() throws Exception {
    }

    @Override
    public abstract void fillValue(Object var1);

    @Override
    public void clear() {
        this.getCalculator().clear();
        this.setCalculator(null);
    }

    @Override
    public void errorFillValue(Object exception) {
        IFormula formula = null;
        SyntaxErrorException error = new SyntaxErrorException(128L, exception);
        if (exception instanceof EASBizException) {
            error = new SyntaxErrorException(128L, (Object)((EASBizException)((Object)exception)).getMessage());
        }
        int in = this.getCalculator().getFormula().size();
        for (int i = 0; i < in; ++i) {
            formula = this.getCalculator().getFormula().get(i);
            formula.getParameter().setValue((Object)error);
        }
    }

    public void queryBaseInfo() throws Exception {
        ExpressionUtils.queryDimInfo(this.getCalculator());
        ExpressionUtils.queryOrgUnitInfo(this.getCalculator());
    }

    public String getOffsetBgPeriodNumber(int bgPeriodType, int currYear, int currPeriod, int offset) {
        String _bgPeriodNumber = null;
        if (bgPeriodType == 6) {
            _bgPeriodNumber = "YEAR." + new DecimalFormat("0000").format(currYear + offset) + "Y";
        } else if (bgPeriodType == 5) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 2 ? 2 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, (offset - 1) * 6);
            } else {
                _calendar.set(2, (currPeriod - 1) * 6);
                _calendar.add(2, offset * 6);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currHalfYear = _currMonth < 7 ? 1 : 2;
            _bgPeriodNumber = new StringBuffer("HALF").append(".").append(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currHalfYear)).append("HY").toString();
        } else if (bgPeriodType == 4) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 4 ? 4 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, (offset - 1) * 3);
            } else {
                _calendar.set(2, (currPeriod - 1) * 3);
                _calendar.add(2, offset * 3);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            int _currQuarter = 0;
            _currQuarter = _currMonth < 7 ? (_currMonth < 4 ? 1 : 2) : (_currMonth < 10 ? 3 : 4);
            _bgPeriodNumber = new StringBuffer("QUAR").append(".").append(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currQuarter)).append("Q").toString();
        } else if (bgPeriodType == 3) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 12 ? 12 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(2, offset - 1);
            } else {
                _calendar.set(2, currPeriod - 1);
                _calendar.add(2, offset);
            }
            int _currYear = _calendar.get(1);
            int _currMonth = _calendar.get(2) + 1;
            _bgPeriodNumber = new StringBuffer("MONT").append(".").append(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currMonth)).append("M").toString();
        } else if (bgPeriodType == 2) {
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > 52 ? 52 : currPeriod;
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(3, offset);
            } else {
                _calendar.set(3, currPeriod);
                _calendar.add(3, offset);
            }
            int _currYear = _calendar.get(1);
            int _currWeek = _calendar.get(3);
            _bgPeriodNumber = new StringBuffer("YWEE").append(".").append(new DecimalFormat("0000").format(_currYear)).append("Y").append(".").append(new DecimalFormat("00").format(_currWeek)).append("W").toString();
        } else if (bgPeriodType == 1) {
            CalendarHelper _calendarHelper = new CalendarHelper();
            int _maxDays = _calendarHelper.getDaysOfYear(currYear);
            currPeriod = currPeriod < 1 ? 1 : currPeriod;
            currPeriod = currPeriod > _maxDays ? _maxDays : currPeriod;
            String _key = new StringBuffer("MDAY").append(".").append("yyyy'").append("Y").append(".").append("'MM'").append("M").append(".").append("'dd'").append("D").toString();
            Calendar _calendar = Calendar.getInstance();
            _calendar.set(1, currYear);
            if (offset > 0) {
                _calendar.set(6, offset);
            } else {
                _calendar.set(6, currPeriod);
                _calendar.add(6, offset);
            }
            _bgPeriodNumber = new SimpleDateFormat(_key).format(_calendar.getTime());
        }
        return _bgPeriodNumber;
    }
}

