/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractFormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.common.ISplitData;
import com.kingdee.eas.ma.mbg.utils.BgExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaInfo
extends AbstractFormulaInfo
implements ISplitData {
    private static final Logger logger = Logger.getLogger(FormulaInfo.class);
    private String batchKey = null;
    private String[] formulas = null;
    private String orgUnitNumber = null;
    private String bgSchemeNumber = null;
    private String bgScenarioNumber = null;
    private String bgItemNumber = null;
    private String beginPeriodNumber = null;
    private String endPeriodNumber = null;
    private String bgVersionNumber = null;
    private String currencyNumber = null;
    private String bgElementNumber = null;

    public FormulaInfo() {
    }

    public void setFormulas(String[] formulas) {
        this.formulas = formulas;
    }

    public String[] getFormulas() {
        return this.formulas;
    }

    public String getOrgUnitNumber() {
        return this.orgUnitNumber;
    }

    public void setOrgUnitNumber(String orgUnitNumber) {
        this.orgUnitNumber = orgUnitNumber;
    }

    public String getBgSchemeNumber() {
        return this.bgSchemeNumber;
    }

    public void setBgSchemeNumber(String bgSchemeNumber) {
        this.bgSchemeNumber = bgSchemeNumber;
    }

    public String getBgScenarioNumber() {
        return this.bgScenarioNumber;
    }

    public void setBgScenarioNumber(String bgScenarioNumber) {
        this.bgScenarioNumber = bgScenarioNumber;
    }

    public String getBgItemNumber() {
        return this.bgItemNumber;
    }

    public void setBgItemNumber(String bgItemNumber) {
        this.bgItemNumber = bgItemNumber;
    }

    public String getBeginPeriodNumber() {
        return this.beginPeriodNumber;
    }

    public void setBeginPeriodNumber(String beginPeriodNumber) {
        this.beginPeriodNumber = beginPeriodNumber;
    }

    public String getEndPeriodNumber() {
        return this.endPeriodNumber;
    }

    public void setEndPeriodNumber(String endPeriodNumber) {
        this.endPeriodNumber = endPeriodNumber;
    }

    public String getBgVersionNumber() {
        return this.bgVersionNumber;
    }

    public void setBgVersionNumber(String bgVersionNumber) {
        this.bgVersionNumber = bgVersionNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getBgElementNumber() {
        return this.bgElementNumber;
    }

    public void setBgElementNumber(String bgElementNumber) {
        this.bgElementNumber = bgElementNumber;
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber();
        }
        return this.batchKey;
    }

    public FormulaInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = this.getParameter().getArgs();
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgItemNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            this.setBeginPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            this.setEndPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setBgVersionNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        String _bgPeriodNumber;
        String sheetPeriodNumber;
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber())) {
            this.setOrgUnitNumber(value.getOrgUnitNumber());
        }
        if (StringUtils.isEmpty((String)this.getBgSchemeNumber())) {
            this.setBgSchemeNumber(value.getBgSchemeNumber());
        }
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        ReportVariables rv = this.getCalculator().getProvider().getReportVariables();
        if (StringUtils.isEmpty((String)this.getBeginPeriodNumber())) {
            sheetPeriodNumber = null;
            if (rv != null && rv.contains("StartBgPeriod", this.getParameter().getSheetName())) {
                sheetPeriodNumber = rv.getStringValue("StartBgPeriod", this.getParameter().getSheetName());
            }
            if (!StringUtils.isEmpty(sheetPeriodNumber)) {
                this.setBeginPeriodNumber(sheetPeriodNumber);
            } else {
                this.setBeginPeriodNumber(value.getBgPeriodNumber());
            }
        } else if (BgNFSHelper.isNumerical(this.getBeginPeriodNumber())) {
            this.setBeginPeriodNumber(this.getBgPeriodNumberOfNumeric(cache, this.getBeginPeriodNumber(), value));
        } else {
            _bgPeriodNumber = this.getBgPeriodNumberOfVariable(cache, this.getBeginPeriodNumber(), value);
            if (_bgPeriodNumber != null) {
                this.setBeginPeriodNumber(_bgPeriodNumber);
            }
        }
        if (StringUtils.isEmpty((String)this.getEndPeriodNumber())) {
            sheetPeriodNumber = null;
            if (rv != null && rv.contains("EndBgPeriod", this.getParameter().getSheetName())) {
                sheetPeriodNumber = rv.getStringValue("EndBgPeriod", this.getParameter().getSheetName());
            }
            if (!StringUtils.isEmpty((String)sheetPeriodNumber)) {
                this.setEndPeriodNumber(sheetPeriodNumber);
            } else {
                this.setEndPeriodNumber(value.getBgPeriodNumber());
            }
        } else if (BgNFSHelper.isNumerical(this.getEndPeriodNumber())) {
            this.setEndPeriodNumber(this.getBgPeriodNumberOfNumeric(cache, this.getEndPeriodNumber(), value));
        } else {
            _bgPeriodNumber = this.getBgPeriodNumberOfVariable(cache, this.getEndPeriodNumber(), value);
            if (_bgPeriodNumber != null) {
                this.setEndPeriodNumber(_bgPeriodNumber);
            }
        }
        if (StringUtils.isEmpty((String)this.getBgVersionNumber())) {
            this.setBgVersionNumber(value.getBgVersionNumber());
        }
        if (StringUtils.isEmpty((String)this.getCurrencyNumber())) {
            this.setCurrencyNumber(value.getCurrencyNumber());
        }
    }

    protected String getBgPeriodNumberOfNumeric(IFormulaCacheManager cache, String bgPeriodNumber, DefaultFormulaValue value) {
        Integer offset = BgNFSHelper.getNumeric(this.getEndPeriodNumber());
        String offsetPeriodNumber = null;
        if (cache.getOffsetPeriodMap().containsKey(offset)) {
            offsetPeriodNumber = cache.getOffsetPeriodMap().get(offset);
        } else {
            offsetPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber((String)value.getBgPeriodNumber(), (int)offset);
            cache.getOffsetPeriodMap().put(offset, offsetPeriodNumber);
        }
        return offsetPeriodNumber;
    }

    protected String getBgPeriodNumberOfVariable(IFormulaCacheManager cache, String bgPeriodNumber, DefaultFormulaValue value) {
        if (cache == null || bgPeriodNumber == null) {
            return null;
        }
        String offsetPeriodNumber = null;
        if (cache.getVariablePeriodMap().containsKey(bgPeriodNumber)) {
            offsetPeriodNumber = cache.getVariablePeriodMap().get(bgPeriodNumber);
        } else {
            int periodType = BgNPeriodHelper.parserBgPeriodType((String)value.getBgPeriodNumber());
            try {
                offsetPeriodNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)value.getBgPeriodNumber(), (String)bgPeriodNumber, (int)periodType);
            }
            catch (BgPeriodException bgPeriodException) {
                // empty catch block
            }
            if (offsetPeriodNumber != null) {
                cache.getVariablePeriodMap().put(bgPeriodNumber, offsetPeriodNumber);
            }
        }
        return offsetPeriodNumber;
    }

    @Override
    protected boolean checkParseParameter(DefaultFormulaValue value) {
        boolean isSameBgPeriodGroup;
        if (this.getParameter() == null) {
            return false;
        }
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        Map<String, MbgDimInfo> mbgDimMap = this.getCalculator().getCacheManager().getMbgDimMap();
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber()) || StringUtils.isEmpty((String)this.getBgSchemeNumber()) || StringUtils.isEmpty((String)this.getBgItemNumber()) || StringUtils.isEmpty((String)this.getBgElementNumber()) || StringUtils.isEmpty((String)this.getBeginPeriodNumber()) || StringUtils.isEmpty((String)this.getEndPeriodNumber()) || StringUtils.isEmpty((String)this.getCurrencyNumber())) {
            this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED).getMessage()));
            return false;
        }
        if (!StringUtils.isEmpty((String)this.getBgItemNumber())) {
            String[] tmpNums = this.getBgItemNumber().split(",");
            int in = tmpNums.length;
            for (int i = 0; i < in; ++i) {
                if (StringUtils.isEmpty((String)tmpNums[i]) || !tmpNums[i].equals("@")) continue;
                this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED).getMessage()));
                return false;
            }
        }
        int beginType = 0;
        int endType = 0;
        if (cache.getPeriodTypeMap().containsKey(this.getBeginPeriodNumber())) {
            beginType = cache.getPeriodTypeMap().get(this.getBeginPeriodNumber());
        } else {
            beginType = BgNPeriodHelper.parserBgPeriodType((String)this.getBeginPeriodNumber());
            cache.getPeriodTypeMap().put(this.getBeginPeriodNumber(), beginType);
        }
        if (cache.getPeriodTypeMap().containsKey(this.getEndPeriodNumber())) {
            endType = cache.getPeriodTypeMap().get(this.getEndPeriodNumber());
        } else {
            endType = BgNPeriodHelper.parserBgPeriodType((String)this.getEndPeriodNumber());
            cache.getPeriodTypeMap().put(this.getEndPeriodNumber(), endType);
        }
        if (this.getBeginPeriodNumber() != null && this.getEndPeriodNumber() != null && !(isSameBgPeriodGroup = BgNPeriodHelper.isSameBgPeriodGroup((String)this.getBeginPeriodNumber(), (String)this.getEndPeriodNumber()))) {
            this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_periodGroup", (Locale)this.getCalculator().getContext().getLocale())));
            return false;
        }
        if (beginType != endType) {
            this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_periodType", (Locale)this.getCalculator().getContext().getLocale())));
            return false;
        }
        return !this.getBgItemNumber().equals("@");
    }

    @Override
    protected void pretreatmentParameter() {
        if (!this.isCalculate()) {
            return;
        }
        List<String> tmpList = null;
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        String periodKey = this.getPeriodKey();
        if (cache.getPeriodBEMap().containsKey(periodKey)) {
            tmpList = cache.getPeriodBEMap().get(periodKey);
        } else {
            tmpList = this.parseBgPeriod(this.getBeginPeriodNumber(), this.getEndPeriodNumber());
            cache.getPeriodBEMap().put(periodKey, tmpList);
        }
        this.setFormulas(new String[tmpList.size()]);
        int in = tmpList.size();
        for (int i = 0; i < in; ++i) {
            this.getFormulas()[i] = BgNFSHelper.getFormulaFromParam(this.getBgItemNumber(), tmpList.get(i), this.getBgElementNumber(), this.getCurrencyNumber(), this.getBgScenarioNumber());
        }
        String[] orgSchStrs = new String[4];
        String bgschemeId = null;
        try {
            if (cache.getBgSchemeNumberIdMap().containsKey(this.getBgSchemeNumber())) {
                bgschemeId = cache.getBgSchemeNumberIdMap().get(this.getBgSchemeNumber());
            } else {
                bgschemeId = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeInfo("select id where number = '" + this.getBgSchemeNumber() + "'").getId().toString();
                cache.getBgSchemeNumberIdMap().put(this.getBgSchemeNumber(), bgschemeId);
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)"error : ", (Throwable)ex);
        }
        catch (BOSException ex) {
            logger.error((Object)"error : ", (Throwable)ex);
        }
        orgSchStrs[0] = bgschemeId;
        orgSchStrs[1] = this.getBgSchemeNumber();
        orgSchStrs[2] = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("bg_org_id");
        orgSchStrs[3] = this.getOrgUnitNumber();
        cache.getBgSchemeNumberMap().put(this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber(), orgSchStrs);
        if (this.getOrgUnitNumber().contains(";")) {
            String[] orgNums;
            for (String orgStr : orgNums = this.getOrgUnitNumber().split(";")) {
                orgSchStrs = new String[]{bgschemeId, this.getBgSchemeNumber(), (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("bg_org_id"), orgStr};
                cache.getBgSchemeNumberMap().put(orgStr.trim() + "!" + this.getBgSchemeNumber(), orgSchStrs);
            }
        }
    }

    public String getPeriodKey() {
        return this.getBeginPeriodNumber() + "!" + this.getEndPeriodNumber();
    }

    protected List<String> parseBgPeriod(String beginBgPeriodNumber, String endBgPeriodNumber) {
        ArrayList<String> bgPeriodList = new ArrayList<String>();
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        if (StringUtils.isEmpty((String)beginBgPeriodNumber) || StringUtils.isEmpty((String)endBgPeriodNumber) || cache.getPeriodMap().isEmpty()) {
            return bgPeriodList;
        }
        if (beginBgPeriodNumber.equals(endBgPeriodNumber)) {
            bgPeriodList.add(beginBgPeriodNumber);
            return bgPeriodList;
        }
        int type = BgNPeriodHelper.parserBgPeriodType((String)beginBgPeriodNumber);
        List<String> _tmpList = cache.getPeriodMap().get(beginBgPeriodNumber.split("\\.")[0] + "_" + type);
        if (_tmpList == null) {
            return bgPeriodList;
        }
        boolean include = false;
        String numbr = null;
        int size = _tmpList.size();
        for (int index = 0; index < size; ++index) {
            numbr = _tmpList.get(index);
            if (beginBgPeriodNumber.equals(numbr)) {
                include = true;
            }
            if (include) {
                bgPeriodList.add(numbr);
            }
            if (!endBgPeriodNumber.equals(numbr)) continue;
            include = false;
            break;
        }
        return bgPeriodList;
    }

    @Override
    public String getDimItemNumber() {
        return this.getBgItemNumber();
    }

    @Override
    public BigDecimal getValue() {
        return BgNConstants.ONE;
    }
}

