/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.MbgActualDay;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.MbgActualDay.MbgActualDayInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.impl.CubeSqlStrategy;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgActualDayCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate.MbgActualDayCalculateUtils");

    public MbgActualDayCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new MbgActualDayInfo(this.getCalculator(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        HashMap<Integer, BigDecimal> hashMap;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block18: {
            Map<String, MbgDimInfo> sources;
            Map<String, List<IFormula>> batchKeyMap;
            Map<String, List<String>> allRefFields;
            boolean isPostgresql;
            Map<String, BgSchemeInfo> bgSchemeMap;
            ArrayList<Object[]> paramList;
            String mainTable;
            StringBuilder sql;
            TempTablePool pool;
            block16: {
                Object var30_15;
                block17: {
                    block14: {
                        Object var26_10;
                        block15: {
                            if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
                                return null;
                            }
                            conn = null;
                            pstmt = null;
                            rst = null;
                            pool = TempTablePool.getInstance((Context)this.getCalculator().getContext());
                            sql = new StringBuilder();
                            StringBuilder sql2 = new StringBuilder();
                            mainTable = null;
                            paramList = new ArrayList<Object[]>();
                            conn = EJBFactory.getConnection((Context)this.getCalculator().getContext());
                            sql.setLength(0);
                            sql.append("Create Table T_MBG_TmpActualDateCal (");
                            sql.append("FID INT NOT NULL, ");
                            sql.append("FBgDataId VARCHAR(44) NOT NULl, ");
                            sql.append("FActualValue NUMERIC(21,8) , ");
                            sql.append("CONSTRAINT PK_MBG_TAJ" + Math.abs(this.getCalculator().hashCode()) + " PRIMARY KEY(FID, FBgDataId))");
                            mainTable = pool.createTempTable(sql.toString());
                            bgSchemeMap = this.queryBgSchemeInfo();
                            if (!bgSchemeMap.isEmpty()) break block14;
                            var26_10 = null;
                            if (mainTable == null) break block15;
                            pool.releaseTable(mainTable);
                        }
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        return var26_10;
                    }
                    isPostgresql = BgDBUtils.isPostgresql((Connection)conn);
                    allRefFields = MbgActualDayCalculateUtils.queryBgDataFields(conn, bgSchemeMap, isPostgresql);
                    batchKeyMap = this.getBatchKeyMap();
                    sources = BgNExpressionHelper.queryDimensionSources(this.getCalculator().getContext(), batchKeyMap);
                    if (!sources.isEmpty()) break block16;
                    var30_15 = null;
                    if (mainTable == null) break block17;
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                return var30_15;
            }
            try {
                long time = System.currentTimeMillis();
                block4: for (String batchKey : batchKeyMap.keySet()) {
                    List<String> refFields;
                    Map<String, BgOrgUnitInfo> orgUnitMap;
                    String bgSchemeId = MbgActualDayInfo.getBgSchemeRootId(batchKey);
                    String srcNumber = MbgActualDayInfo.getSrcNumbers(batchKey);
                    BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getCalculator().getContext(), bgSchemeId);
                    List<IFormula> formulas = batchKeyMap.get(batchKey);
                    Map bgPeriodType = this.getBgPeriodType(formulas);
                    BgSchemeInfo bgSchemeInfo = bgSchemeMap.get(bgSchemeId);
                    String cubeName = bgSchemeInfo.getRefCube();
                    String controlCubeName = BgCubeUtils.getControlCubeName(cubeName);
                    CubeSqlStrategy cubeSqlStrategy = new CubeSqlStrategy();
                    String[] controlIndexSql = cubeSqlStrategy.getControlIndexSql(conn, cubeName);
                    BgDBUtils.executeUpdate((Connection)conn, (String[])controlIndexSql);
                    if (formulas == null || bgSchemeInfo == null || StringUtils.isEmpty((String)srcNumber) || "null".equals(srcNumber) || (orgUnitMap = BgNExpressionHelper.queryOrgUnit(this.getCalculator(), bgSchemeInfo)).isEmpty() || (refFields = isPostgresql ? allRefFields.get(cubeName.toLowerCase()) : allRefFields.get(cubeName)) == null || refFields.isEmpty()) continue;
                    sql.setLength(0);
                    sql.append("Insert Into ").append(mainTable).append("(FID, FBgDataId,FActualValue) ");
                    sql.append(" Select distinct ? , bgControlRecord.FID, bgControlRecord.FActaulAmount FROM ").append(controlCubeName).append(" bgControlRecord ");
                    sql.append("where bgControlRecord.FBIZORGUNITID in (Select FOrgUnitId FROM T_MBG_BgOrgUnit Where (FNumber = ? OR FLongNumber like ?) AND FViewId = ?)");
                    sql.append(" AND bgControlRecord.FBillType <> '87500EF6'");
                    sql.append(" AND (bgControlRecord.FBizDate >= ? and bgControlRecord.FBizDate <= ?)");
                    if (isPostgresql) {
                        sql.append("AND bgControlRecord.Fformula in (Select  bgData.Fformula from ").append(cubeName);
                    } else {
                        sql.append("AND bgControlRecord.Fformula in (Select ").append(BgCubeUtils.getBgDataHint(cubeName, "bgData", false)).append(" bgData.Fformula from ").append(cubeName);
                    }
                    sql.append(" bgData Where  FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where (FNumber = ? OR FLongNumber like ?) AND FViewId = ?) ");
                    String[] srcNumbers = srcNumber.split(",");
                    Map<String, BgDimensionInfo> srcMap = schemeHelper.getDimensionBySrcNumber();
                    for (int i = 0; i < srcNumbers.length; ++i) {
                        sql.append(" AND ");
                        MbgDimInfo source = sources.get(srcNumbers[i]);
                        String viewId = srcMap.get(srcNumbers[i]).getViewId();
                        String closureTable = MbgVirtualView.getClosureTable((String)MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)BOSUuid.read((String)viewId)));
                        if (isPostgresql ? source == null || !refFields.contains(source.getRefField().toLowerCase()) : source == null || !refFields.contains(source.getRefField())) continue block4;
                        sql.append("bgdata.").append(source.getRefField());
                        sql.append(" IN (Select FChildId From ").append(closureTable).append(" Where FID = ?)");
                    }
                    sql.append("and FBgPeriodId in (select FBgPeriodId from T_MBG_BgPerioddisp where ftypeid in(SELECT fid FROM T_mbg_bgPeriodType where exists(SELECT FID FROM T_mbg_bgPeriodType where FNUMBER = ? and FISCALYEAR =2) or FNUMBER = ?)) ");
                    sql.append("and FBgElementId in (select bgElement.FID from T_MBG_BgElement bgElement where  bgElement.FNumber = ? ) ");
                    sql.append("and FCurrencyId in (select currency.FID  from T_BD_Currency currency where currency.FNumber = ? )");
                    sql.append("and FScenario in (select scen.FScenarioID from T_MBG_BgScenario scen where  scen.FNumber = ?))");
                    paramList.clear();
                    int length = 0;
                    for (int f = 0; f < formulas.size(); ++f) {
                        MbgActualDayInfo actualDayInfo = (MbgActualDayInfo)formulas.get(f);
                        if (!actualDayInfo.isCalculate() || !orgUnitMap.containsKey(actualDayInfo.getOrgUnitNumber())) continue;
                        for (int p = 0; p < actualDayInfo.getFormulas().length; ++p) {
                            Object[] params = new Object[14 + srcNumbers.length];
                            paramList.add(params);
                            params[0] = actualDayInfo.getId();
                            params[1] = actualDayInfo.getOrgUnitNumber();
                            params[2] = orgUnitMap.get(actualDayInfo.getOrgUnitNumber()).getLongNumber() + "!%";
                            params[3] = bgSchemeInfo.getEditOrgViewId().toString();
                            params[4] = actualDayInfo.getBeginDate();
                            params[5] = actualDayInfo.getEndDate();
                            params[6] = actualDayInfo.getOrgUnitNumber();
                            params[7] = orgUnitMap.get(actualDayInfo.getOrgUnitNumber()).getLongNumber() + "!%";
                            params[8] = bgSchemeInfo.getEditOrgViewId().toString();
                            String[] dimNumbers = actualDayInfo.getBgItemNumber().split(",");
                            length = dimNumbers.length;
                            for (int d = 0; d < dimNumbers.length; ++d) {
                                params[9 + d] = dimNumbers[d];
                            }
                            params[9 + length] = actualDayInfo.getBgPeriodTypeNumber();
                            params[10 + length] = actualDayInfo.getBgPeriodTypeNumber();
                            params[11 + length] = actualDayInfo.getBgElementNumber();
                            params[12 + length] = actualDayInfo.getCurrencyNumber();
                            params[13 + length] = actualDayInfo.getBgScenarioNumber();
                        }
                    }
                    MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
                }
                logger.info((Object)(" mbgActualDayCalculate invokeCalculate sql,cost: " + (System.currentTimeMillis() - time) + ".ms"));
                HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
                pstmt = conn.prepareStatement("Select FID, SUM(FActualValue) FActualValue FROM " + mainTable + " Where FActualValue IS NOT NULL GROUP BY FID");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    result.put(rst.getInt("FID"), rst.getBigDecimal("FActualValue"));
                }
                hashMap = result;
                if (mainTable == null) break block18;
            }
            catch (Throwable throwable) {
                if (mainTable != null) {
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            pool.releaseTable(mainTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }

    @Override
    public void fillValue(Object value) {
        if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
            return;
        }
        Map data = (Map)value;
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            MbgActualDayInfo actualDayInfo = (MbgActualDayInfo)this.getCalculator().getFormula().get(i);
            if (!actualDayInfo.isCalculate()) continue;
            if (data != null && data.containsKey(actualDayInfo.getId())) {
                actualDayInfo.getParameter().setValue(data.get(actualDayInfo.getId()));
                continue;
            }
            actualDayInfo.getParameter().setValue((Object)BgNConstants.ZERO);
        }
    }

    private Map<String, BgSchemeInfo> queryBgSchemeInfo() throws BOSException {
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        HashSet<String> bgSchemeIds = new HashSet<String>();
        Iterator<String> it = this.getCalculator().getCacheManager().getBatchKeyMap().keySet().iterator();
        while (it.hasNext()) {
            bgSchemeIds.add(this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(it.next())[0]);
        }
        if (bgSchemeIds.isEmpty()) {
            return bgSchemeMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgSchemeIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("refCube");
        evi.getSelector().add("periodType");
        evi.getSelector().add("bgDimSettings");
        evi.getSelector().add("bgDimSettings.dimnumber");
        evi.getSelector().add("bgDimSettings.members.type");
        evi.getSelector().add("bgDimSettings.members.memberID");
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                bgSchemeMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return bgSchemeMap;
    }

    private Map<String, List<IFormula>> getBatchKeyMap() {
        HashMap<String, List<IFormula>> batchKeyMap = new HashMap<String, List<IFormula>>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            MbgActualDayInfo actualInfo = (MbgActualDayInfo)this.getCalculator().getFormula().get(i);
            actualInfo.setBgSchemeInfo();
            String key = actualInfo.getExecCalKey();
            if (!batchKeyMap.containsKey(key)) {
                batchKeyMap.put(key, new ArrayList());
            }
            ((List)batchKeyMap.get(key)).add(actualInfo);
        }
        return batchKeyMap;
    }

    private Map getBgPeriodType(List<IFormula> formulas) throws BOSException {
        HashMap<BgPeriodTypeInfo, Boolean> bgPeriodTypeMap = new HashMap<BgPeriodTypeInfo, Boolean>();
        HashSet<String> numberSet = new HashSet<String>();
        for (IFormula tmp : formulas) {
            numberSet.add(((MbgActualDayInfo)tmp).getBgPeriodTypeNumber());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("fiscalYear");
        BgPeriodTypeCollection col = BgPeriodTypeFactory.getLocalInstance((Context)this.getCalculator().getContext()).getBgPeriodTypeCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            bgPeriodTypeMap.put(col.get(i), col.get(i).getFiscalYear().getValue() == 2);
        }
        return bgPeriodTypeMap;
    }

    public static Map<String, List<String>> queryBgDataFields(Connection conn, Map<String, BgSchemeInfo> bgSchemeMap, boolean isPostgresql) throws BOSException {
        final HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        if (isPostgresql) {
            sql.append("select c.relname,a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where a.attnum > 0 and c.relname  in(");
        } else {
            sql.append("SELECT KSQL_COL_TABNAME,KSQL_COL_NAME from KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME IN(");
        }
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        ArrayList<String> bgDataTableNames = new ArrayList<String>();
        for (BgSchemeInfo bgSchemeInfo : bgSchemeMap.values()) {
            if (StringUtils.isEmpty((String)bgSchemeInfo.getRefCube())) continue;
            if (isPostgresql) {
                bgDataTableNames.add(bgSchemeInfo.getRefCube().toLowerCase());
                continue;
            }
            bgDataTableNames.add(bgSchemeInfo.getRefCube());
        }
        List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgDataTableNames.toArray(), (int)50);
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String tableName = res.getString(1);
                String field = res.getString(2);
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new ArrayList());
                }
                ((List)result.get(tableName)).add(field);
            }
        });
        return result;
    }
}

