/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.MbgActualDay;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.MbgActualDay.MbgActualDayCalculator;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MbgActualDayInfo
extends FormulaInfo {
    private int id = 0;
    private String[] bgSchemeInfo = null;
    private Timestamp beginDate = null;
    private Timestamp endDate = null;
    private String srcNumbers;
    private String bgPeriodTypeNumber;
    private String batchKey = null;

    public String getBgPeriodTypeNumber() {
        return this.bgPeriodTypeNumber;
    }

    public void setBgPeriodTypeNumber(String bgPeriodTypeNumber) {
        this.bgPeriodTypeNumber = bgPeriodTypeNumber;
    }

    public int getId() {
        return this.id;
    }

    public String[] getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public String getBgSchemeRootId() {
        return this.bgSchemeInfo == null ? null : this.bgSchemeInfo[0];
    }

    public Timestamp getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Timestamp beginDate) {
        this.beginDate = beginDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp endDate) {
        this.endDate = endDate;
    }

    public MbgActualDayInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    public String getExecCalKey() {
        return this.getBgSchemeRootId() + "!" + this.srcNumbers;
    }

    public static String getBgSchemeRootId(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0) {
            return key.substring(0, key.indexOf("!"));
        }
        return key;
    }

    public static String getSrcNumbers(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0 && !key.endsWith("!")) {
            return key.substring(key.lastIndexOf("!") + 1);
        }
        return null;
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber();
        }
        return this.batchKey;
    }

    public static String getSchemeMapKey(String batchKey) {
        if (!StringUtils.isEmpty((String)batchKey)) {
            return batchKey.substring(0, batchKey.lastIndexOf("!"));
        }
        return batchKey;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = FormulaUtils.updateParams("MbgActualDay", this.getParameter());
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgItemNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            try {
                this.beginDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(variant.toString()).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            try {
                this.endDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(variant.toString()).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setBgPeriodTypeNumber(variant.getValue().toString());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        if (this.getBeginDate() == null) {
            Date startDate = (Date)this.getCalculator().getProvider().getReportAdapter().getReportProperty("Report_StartDate");
            this.setBeginDate(new Timestamp(BgNPeriodHelper.getDayBegin((Date)startDate).getTime()));
        } else {
            this.setBeginDate(new Timestamp(BgNPeriodHelper.getDayBegin((Date)new Date(this.getBeginDate().getTime())).getTime()));
        }
        if (this.getEndDate() == null) {
            Date endDate = (Date)this.getCalculator().getProvider().getReportAdapter().getReportProperty("Report_EndDate");
            this.setEndDate(new Timestamp(BgNPeriodHelper.getDayEnd((Date)endDate).getTime()));
        } else {
            this.setEndDate(new Timestamp(BgNPeriodHelper.getDayEnd((Date)new Date(this.getEndDate().getTime())).getTime()));
        }
    }

    @Override
    protected void pretreatmentParameter() {
        super.pretreatmentParameter();
        this.id = ((MbgActualDayCalculator)this.getCalculator()).index++;
    }

    public void setBgSchemeInfo() {
        this.bgSchemeInfo = this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(this.getBatchCalculateKey());
        if (this.getBgItemNumber() != null) {
            StringBuffer str = new StringBuffer();
            String[] numbers = DimensionFormulaHelper.splitCombinations(this.getBgItemNumber());
            for (int i = 0; i < numbers.length; ++i) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(DimensionFormulaHelper.getSrcNumber(numbers[i]));
            }
            this.srcNumbers = str.toString();
        }
    }
}

