/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.MbgGetMember;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.MbgGetMember.MbgGetMemberInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MbgGetMemberCalculateUtils
extends AbstractCalculateUtils {
    public MbgGetMemberCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new MbgGetMemberInfo(this.getCalculator(), parameter);
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        HashMap result = new HashMap();
        if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
            return null;
        }
        String formId = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("BG_FORM_ID");
        if (formId == null) {
            return result;
        }
        BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(this.getCalculator().getContext()).getBgFormInfo("select id,name,bgSpecialItems.*,bgscheme.id,bgScheme.number,orgUnit.number where id='" + formId + "'");
        if (bgFormInfo == null || bgFormInfo.getBgSpecialItems() == null || bgFormInfo.getBgSpecialItems().isEmpty()) {
            return result;
        }
        Map<String, String> numberToSrcNumberMap = this.getNumberToSrcNumberMap();
        HashMap<String, String> dimName = new HashMap<String, String>();
        HashMap<String, String> dimNumber = new HashMap<String, String>();
        BgSpecialItemsInfo bgSpecialItemsInfo = bgFormInfo.getBgSpecialItems().get(0);
        String[] dimensionNames = bgSpecialItemsInfo.getMemberDisplayName().split(DimensionConstants.COMMA_SEPARATOR);
        String[] dimensionNumbers = bgSpecialItemsInfo.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        for (int i = 0; i < dimensionNumbers.length; ++i) {
            String[] temp = dimensionNumbers[i].split(DimensionConstants.COLON_SEPARATOR);
            String[] tempName = dimensionNames[i].split(DimensionConstants.COLON_SEPARATOR);
            dimNumber.put(temp[0], temp[1]);
            dimName.put(temp[0], tempName[1]);
        }
        Map<String, List<IFormula>> batchKeyMap = this.getBatchKeyMap();
        for (String batchKey : batchKeyMap.keySet()) {
            List<IFormula> formulas = batchKeyMap.get(batchKey);
            for (int i = 0; i < formulas.size(); ++i) {
                MbgGetMemberInfo mbgGetMemberInfo = (MbgGetMemberInfo)formulas.get(i);
                String dimsrcNumber = numberToSrcNumberMap.get(mbgGetMemberInfo.getDimSrcNumber());
                if (mbgGetMemberInfo.getdimProperty().equalsIgnoreCase("name")) {
                    result.put(mbgGetMemberInfo.getId(), dimName.get(dimsrcNumber));
                    continue;
                }
                result.put(mbgGetMemberInfo.getId(), dimNumber.get(dimsrcNumber));
            }
        }
        return result;
    }

    private Map<String, List<IFormula>> getBatchKeyMap() {
        HashMap<String, List<IFormula>> batchKeyMap = new HashMap<String, List<IFormula>>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            MbgGetMemberInfo mbgGetMemberInfo = (MbgGetMemberInfo)this.getCalculator().getFormula().get(i);
            String key = mbgGetMemberInfo.getBatchCalculateKey();
            if (!batchKeyMap.containsKey(key)) {
                batchKeyMap.put(key, new ArrayList());
            }
            ((List)batchKeyMap.get(key)).add(mbgGetMemberInfo);
        }
        return batchKeyMap;
    }

    @Override
    public void fillValue(Object value) {
        if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
            return;
        }
        Map data = (Map)value;
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            MbgGetMemberInfo mbgGetMemberInfo = (MbgGetMemberInfo)this.getCalculator().getFormula().get(i);
            if (data != null && data.containsKey(mbgGetMemberInfo.getId())) {
                String temp = (String)data.get(mbgGetMemberInfo.getId());
                mbgGetMemberInfo.getParameter().setValue((Object)temp);
                continue;
            }
            mbgGetMemberInfo.getParameter().setValue((Object)"");
        }
    }

    @Override
    protected void beforeCalculate() throws Exception {
    }

    private String getDimsrcNumber(String number) {
        if (number == null) {
            return null;
        }
        if (number.length() < 3) {
            number = number + "D177852B";
        }
        return number.substring(0, 3);
    }

    private boolean checkOrgAndScheme(BgFormInfo info, String key) {
        if (key == null || info == null) {
            return false;
        }
        String[] split = key.split("_");
        return info.getBgScheme().getNumber().equals(split[0]) && info.getOrgUnit().getNumber().equals(split[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, String> getNumberToSrcNumberMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getContext());
            pstmt = conn.prepareStatement("select fnumber,FSrcNumber from T_MBG_MbgDim where (FSrcNumber IS NOT NULL )");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }
}

