/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.actual;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.actual.BgActualInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgActualCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.actual.BgActualCalculateUtils");

    public BgActualCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgActualInfo(this.getCalculator(), parameter);
    }

    public boolean isQueryData() {
        return true;
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        if (this.isQueryData()) {
            return ExpressionUtils.calcExpression(this.getCalculator(), 4);
        }
        return this.invokeDimCalculate();
    }

    protected Object invokeDimCalculate() throws Exception {
        IDimensionParameter parameter = null;
        String batchKey = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap valueMap = new HashMap();
        Map value = null;
        ActualRecordSourceTypeEnum type = null;
        IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance(this.getCalculator().getContext());
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            batchKey = entry2.getKey();
            formulaList = entry2.getValue();
            orgAndSchStr = batchKey.split("!");
            type = this.getEnum(orgAndSchStr[2]);
            if (type == null || !"1".equals(type.getValue()) && !"3".equals(type.getValue())) continue;
            int valueType = 0;
            if ("1".equals(type.getValue())) {
                valueType = 4;
            } else if ("3".equals(type.getValue())) {
                valueType = 32;
            }
            if ((parameter = ExpressionUtils.transDimParameter(this.getCalculator(), orgAndSchStr[0], orgAndSchStr[1], formulaList, valueType)) == null) continue;
            try {
                value = (Map)facade.dimensionQuery(parameter);
                MultiThreadQuery.mergeData(valueMap, value);
            }
            catch (Exception ex) {
                logger.error((Object)"bgFormula Calculate Error:", (Throwable)ex);
            }
        }
        return valueMap;
    }

    private ActualRecordSourceTypeEnum getEnum(String dataType) {
        if (StringUtils.isEmpty((String)dataType)) {
            return null;
        }
        ActualRecordSourceTypeEnum _enum = null;
        List list = ActualRecordSourceTypeEnum.getEnumList();
        int in = list.size();
        for (int i = 0; i < in; ++i) {
            _enum = (ActualRecordSourceTypeEnum)((Object)list.get(i));
            if (!_enum.getName().equals(dataType)) continue;
            return _enum;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map orgValMap = null;
            Map dataMap = (Map)value;
            IBgNData bgData = null;
            BgActualInfo formula = null;
            BigDecimal val = null;
            String[] formulas = null;
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
                Map<String, OrgUnitInfo> orgUnitMap = MbgDataHelper.getOrgUnitMapByNum(this.getCalculator().getContext(), conn, dataMap.keySet());
                int in = this.getCalculator().getFormula().size();
                for (int i = 0; i < in; ++i) {
                    formula = (BgActualInfo)this.getCalculator().getFormula().get(i);
                    val = BgNConstants.ZERO;
                    if (!formula.isCalculate() || !orgUnitMap.containsKey(formula.getOrgUnitNumber())) continue;
                    orgValMap = (Map)dataMap.get(orgUnitMap.get(formula.getOrgUnitNumber()).getId().toString());
                    if (orgValMap == null) {
                        formula.getParameter().setValue((Object)val);
                        continue;
                    }
                    formulas = formula.getFormulas();
                    int jn = formulas.length;
                    for (int j = 0; j < jn; ++j) {
                        bgData = (IBgNData)orgValMap.get(DimUtils.getDimDataKey(formulas[j], formula.getBgVersionNumber()));
                        if (bgData == null) continue;
                        val = formula.getDataType().equals(ActualRecordSourceTypeEnum.all.getName()) ? val.add(bgData.getBizActual()) : val.add(bgData.getAddActualValue());
                    }
                    formula.getParameter().setValue((Object)val);
                }
            }
            catch (SQLDataException ex) {
                logger.error((Object)"", (Throwable)ex);
                SQLUtils.cleanup((Connection)conn);
            }
            catch (Exception ex2) {
                logger.error((Object)"", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

