/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.actual;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;

public class BgActualInfo
extends FormulaInfo {
    private String batchKey = null;
    private String dataType = null;

    public BgActualInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getDataType();
        }
        return this.batchKey;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = this.getParameter().getArgs();
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgItemNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            this.setBeginPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            this.setEndPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setDataType(variant.getValue().toString());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        if (StringUtils.isEmpty((String)this.getDataType())) {
            this.setDataType(ActualRecordSourceTypeEnum.all.getName());
        }
        this.setBgVersionNumber("Ve");
    }

    @Override
    protected boolean checkParseParameter(DefaultFormulaValue value) {
        boolean re = super.checkParseParameter(value);
        if (re && StringUtils.isEmpty((String)this.getDataType())) {
            this.getParameter().setValue((Object)badException);
            return false;
        }
        return re;
    }
}

