/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.adjust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.adjust.BgAdjustInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAdjustCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)BgAdjustCalculateUtils.class.getName());
    public static final String ISTREE = "isTreeData";

    public BgAdjustCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgAdjustInfo(this.getCalculator(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        HashMap<Integer, BigDecimal> hashMap;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block20: {
            Map<String, MbgDimInfo> sources;
            Map<String, List<IFormula>> batchKeyMap;
            Map<String, List<String>> allRefFields;
            boolean isPostgresql;
            Map<String, BgSchemeInfo> bgSchemeMap;
            Map versionMap;
            Map scenarioMap;
            int processType;
            ArrayList<Object[]> paramList;
            String mainTable;
            StringBuffer sql;
            TempTablePool pool;
            block18: {
                Object var32_18;
                block19: {
                    block16: {
                        Object var27_12;
                        block17: {
                            if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
                                return null;
                            }
                            conn = null;
                            pstmt = null;
                            rst = null;
                            pool = TempTablePool.getInstance((Context)this.getCalculator().getContext());
                            sql = new StringBuffer();
                            mainTable = null;
                            paramList = new ArrayList<Object[]>();
                            processType = -1;
                            scenarioMap = BgScenarioHelper.getScenarioInnMap((Context)this.getCalculator().getContext());
                            versionMap = BgVersionHelper.getVersionInnMap((Context)this.getCalculator().getContext());
                            conn = EJBFactory.getConnection((Context)this.getCalculator().getContext());
                            sql.setLength(0);
                            sql.append("Create Table T_MBG_TmpAdjustCal (");
                            sql.append("FID INT NOT NULL, ");
                            sql.append("FBgDataId VARCHAR(44) NOT NULl, ");
                            sql.append("FAdjustType VARCHAR(20), ");
                            sql.append("FAdjustValue NUMERIC(21,8), ");
                            sql.append("FAdjustTime DateTime, ");
                            sql.append("CONSTRAINT PK_MBG_TAJ" + Math.abs(this.getCalculator().hashCode()) + " PRIMARY KEY(FID, FBgDataId))");
                            mainTable = pool.createTempTable(sql.toString());
                            bgSchemeMap = this.queryBgSchemeInfo();
                            if (!bgSchemeMap.isEmpty()) break block16;
                            var27_12 = null;
                            if (mainTable == null) break block17;
                            pool.releaseTable(mainTable);
                        }
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        return var27_12;
                    }
                    isPostgresql = BgDBUtils.isPostgresql((Connection)conn);
                    boolean isKingBaseES = BgDBUtils.isKingBaseES((Connection)conn);
                    isPostgresql = isPostgresql || isKingBaseES;
                    allRefFields = this.queryBgDataFields(conn, bgSchemeMap, isPostgresql);
                    batchKeyMap = this.getBatchKeyMap();
                    sources = this.queryDimensionSources(batchKeyMap);
                    if (!sources.isEmpty()) break block18;
                    var32_18 = null;
                    if (mainTable == null) break block19;
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                return var32_18;
            }
            try {
                block4: for (String batchKey : batchKeyMap.keySet()) {
                    List<String> refFields;
                    Map<String, BgOrgUnitInfo> orgUnitMap;
                    String bgSchemeId = BgAdjustInfo.getBgSchemeRootId(batchKey);
                    processType = BgAdjustInfo.getProcessType(batchKey);
                    String srcNumber = BgAdjustInfo.getSrcNumbers(batchKey);
                    BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getCalculator().getContext(), bgSchemeId);
                    List<IFormula> formulas = batchKeyMap.get(batchKey);
                    BgSchemeInfo bgSchemeInfo = bgSchemeMap.get(bgSchemeId);
                    if (formulas == null || bgSchemeInfo == null || srcNumber == null || (orgUnitMap = this.queryOrgUnit(bgSchemeInfo)).isEmpty() || (refFields = isPostgresql ? allRefFields.get(bgSchemeInfo.getRefCube().toLowerCase()) : allRefFields.get(bgSchemeInfo.getRefCube())) == null || refFields.isEmpty()) continue;
                    String cubeName = BgCubeUtils.getCubeName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(BgProcessEnum.getEnum(processType)));
                    sql.setLength(0);
                    sql.append("Insert Into ").append(mainTable).append(" (FID, FAdjustTime, FAdjustType, FBgDataId) ");
                    if (isPostgresql) {
                        sql.append(" Select ?, ?, ?, bgData.FID FROM ").append(cubeName).append(" bgData ");
                    } else {
                        sql.append(" Select ").append(BgCubeUtils.getBgDataHint(cubeName, "bgData", false)).append(" ?, ?, ?, bgData.FID FROM ").append(cubeName).append(" bgData ");
                    }
                    sql.append(" Where bgData.FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where (FNumber = ? OR FLongNumber like ?) AND FViewId = ?)");
                    if (srcNumber != null && srcNumber.indexOf("Acc") < 0) {
                        for (IFormula formula : formulas) {
                            formula.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)new BgTemplateException(BgTemplateException.NEEDBGACC).getMessage()));
                        }
                        continue;
                    }
                    String[] srcNumbers = srcNumber.split(",");
                    Map<String, BgDimensionInfo> srcMap = schemeHelper.getDimensionBySrcNumber();
                    for (int i = 0; i < srcNumbers.length; ++i) {
                        sql.append(" AND ");
                        MbgDimInfo source = sources.get(srcNumbers[i]);
                        String viewId = srcMap.get(srcNumbers[i]).getViewId();
                        String closureTable = MbgVirtualView.getClosureTable((String)MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)BOSUuid.read((String)viewId)));
                        if (isPostgresql ? source == null || !refFields.contains(source.getRefField().toLowerCase()) : source == null || !refFields.contains(source.getRefField())) continue block4;
                        sql.append(source.getRefField());
                        sql.append(" IN (Select FChildId From ").append(closureTable).append(" Where FID = ?)");
                    }
                    sql.append(" and FBgPeriodId in (select bgPeriod.FID from T_MBG_BgPeriod bgPeriod where  bgPeriod.FLongNumber like ?) ");
                    sql.append(" and FBgElementId in (select bgElement.FID from T_MBG_BgElement bgElement where  bgElement.FNumber = ? ) ");
                    sql.append(" and FCurrencyId in (select currency.FID  from T_BD_Currency currency where currency.FNumber = ? ) ");
                    sql.append(" and FScenario = ? ");
                    sql.append(" and FVersion = ? ");
                    paramList.clear();
                    for (int f = 0; f < formulas.size(); ++f) {
                        BgAdjustInfo adjustInfo = (BgAdjustInfo)formulas.get(f);
                        if (!adjustInfo.isCalculate() || !orgUnitMap.containsKey(adjustInfo.getOrgUnitNumber())) continue;
                        for (int p = 0; p < adjustInfo.getFormulas().length; ++p) {
                            Object[] params = new Object[11 + srcNumbers.length];
                            params[0] = adjustInfo.getId();
                            params[1] = adjustInfo.getAdjustDate();
                            params[2] = adjustInfo.getAdjustType();
                            params[3] = adjustInfo.getOrgUnitNumber();
                            params[4] = orgUnitMap.get(adjustInfo.getOrgUnitNumber()).getLongNumber() + (BgProcessEnum.C01.getName().equals(adjustInfo.getProcessType()) ? "!%" : "");
                            params[5] = bgSchemeInfo.getEditOrgViewId().toString();
                            String[] dimNumbers = adjustInfo.getBgItemNumber().split(",");
                            int dimSize = dimNumbers.length;
                            for (int d = 0; d < dimNumbers.length; ++d) {
                                params[6 + d] = dimNumbers[d];
                            }
                            params[6 + dimSize] = BgNFSHelper.parseFormulaPara(adjustInfo.getFormulas()[p])[1];
                            params[7 + dimSize] = adjustInfo.getBgElementNumber();
                            params[8 + dimSize] = adjustInfo.getCurrencyNumber();
                            params[9 + dimSize] = scenarioMap.get(adjustInfo.getBgScenarioNumber());
                            params[10 + dimSize] = versionMap.get(adjustInfo.getBgVersionNumber());
                            paramList.add(params);
                        }
                    }
                    this.replacePeriodLongNumber(conn, paramList);
                    MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
                }
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2 Where t2.FBgDataId = t1.FBgDataId AND (t1.FAdjustTime IS NULL OR t2.FAdjustTime >= t1.FAdjustTime)) Where FAdjustType = '" + "all" + "'"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource not in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t1.FAdjustTime IS NULL OR t2.FAdjustTime >= t1.FAdjustTime)) Where FAdjustType = '" + "adjustForm" + "'"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t1.FAdjustTime IS NULL OR t2.FAdjustTime >= t1.FAdjustTime)) Where FAdjustType = '" + "rollForm" + "'"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 0 + "," + 1 + ") AND (t1.FAdjustTime IS NULL OR t2.FAdjustTime >= t1.FAdjustTime)) Where FAdjustType = '" + "regulateBill" + "'"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 2 + "," + 3 + ") AND (t1.FAdjustTime IS NULL OR t2.FAdjustTime >= t1.FAdjustTime)) Where FAdjustType = '" + "adjustBill" + "'"));
                HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
                pstmt = conn.prepareStatement("Select FID, SUM(FAdjustValue) FAdjustValue FROM " + mainTable + " Where FAdjustValue IS NOT NULL GROUP BY FID");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    result.put(rst.getInt("FID"), rst.getBigDecimal("FAdjustValue"));
                }
                hashMap = result;
                if (mainTable == null) break block20;
            }
            catch (Throwable throwable) {
                if (mainTable != null) {
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            pool.releaseTable(mainTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }

    private void replacePeriodLongNumber(Connection conn, List<Object[]> paramList) {
        int i;
        Object[] params;
        if (paramList.isEmpty()) {
            return;
        }
        Object periodNumber = null;
        HashSet<String> periodNumSet = new HashSet<String>();
        HashMap<String, String> numMap = new HashMap<String, String>();
        BgPeriodCollection bgPeriodColls = null;
        for (int i2 = 0; i2 < paramList.size(); ++i2) {
            params = paramList.get(i2);
            periodNumSet.add(params[params.length - 5].toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        filter.getFilterItems().add(new FilterItemInfo("number", periodNumSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        try {
            bgPeriodColls = BgPeriodFactory.getLocalInstance((Context)this.getCalculator().getContext()).getBgPeriodCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        for (i = 0; i < bgPeriodColls.size(); ++i) {
            numMap.put(bgPeriodColls.get(i).getNumber(), bgPeriodColls.get(i).getLongNumber());
        }
        for (i = 0; i < paramList.size(); ++i) {
            params = paramList.get(i);
            params[params.length - 5] = (String)numMap.get(params[params.length - 5]) + "%";
        }
    }

    private Map<String, BgOrgUnitInfo> queryOrgUnit(BgSchemeInfo schemeInfo) throws BOSException {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (schemeInfo == null || schemeInfo.getEditOrgViewId() == null) {
            return orgUnitMap;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustInfo adjustInfo = (BgAdjustInfo)this.getCalculator().getFormula().get(i);
            if (!adjustInfo.isCalculate() || !adjustInfo.getBgSchemeNumber().equals(schemeInfo.getNumber())) continue;
            numbers.add(adjustInfo.getOrgUnitNumber());
        }
        if (!numbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)schemeInfo.getEditOrgViewId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("longNumber");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(this.getCalculator().getContext()).getBgOrgUnitCollection(view);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    orgUnitMap.put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        return orgUnitMap;
    }

    private Map<String, List<IFormula>> getBatchKeyMap() {
        HashMap<String, List<IFormula>> batchKeyMap = new HashMap<String, List<IFormula>>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustInfo adjustInfo = (BgAdjustInfo)this.getCalculator().getFormula().get(i);
            adjustInfo.setBgSchemeInfo();
            String key = adjustInfo.getExecCalKey();
            if (!batchKeyMap.containsKey(key)) {
                batchKeyMap.put(key, new ArrayList());
            }
            ((List)batchKeyMap.get(key)).add(adjustInfo);
        }
        return batchKeyMap;
    }

    private Map<String, List<String>> queryBgDataFields(Connection conn, Map<String, BgSchemeInfo> bgSchemeMap, final boolean isPostgresql) throws BOSException {
        final HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        if (isPostgresql) {
            sql.append("select c.relname,a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where a.attnum > 0 and c.relname  in(");
        } else {
            sql.append("SELECT KSQL_COL_TABNAME,KSQL_COL_NAME from KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME IN(");
        }
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        ArrayList<String> bgDataTableNames = new ArrayList<String>();
        for (BgSchemeInfo bgSchemeInfo : bgSchemeMap.values()) {
            if (StringUtils.isEmpty((String)bgSchemeInfo.getRefCube())) continue;
            if (isPostgresql) {
                bgDataTableNames.add(bgSchemeInfo.getRefCube().toLowerCase());
                continue;
            }
            bgDataTableNames.add(bgSchemeInfo.getRefCube());
        }
        List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgDataTableNames.toArray(), (int)50);
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String tableName = res.getString(1).toUpperCase();
                if (isPostgresql) {
                    tableName = tableName.toLowerCase();
                }
                String field = res.getString(2);
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new ArrayList());
                }
                ((List)result.get(tableName)).add(field);
            }
        });
        return result;
    }

    private Map<String, MbgDimInfo> queryDimensionSources(Map<String, List<IFormula>> batchKeyMap) throws BOSException {
        HashSet dimSrcNumbers = new HashSet();
        HashMap<String, MbgDimInfo> sources = new HashMap<String, MbgDimInfo>();
        Map<String, MbgDimInfo> tmpSources = null;
        String tmpKey = null;
        Iterator<String> it = batchKeyMap.keySet().iterator();
        while (it.hasNext()) {
            String srcNumbers = BgAdjustInfo.getSrcNumbers(it.next());
            if (srcNumbers == null) continue;
            dimSrcNumbers.addAll(Arrays.asList((Object[])srcNumbers.split(",")));
        }
        if (!dimSrcNumbers.isEmpty()) {
            tmpSources = DimUtils.getDimInfoMap(this.getCalculator().getContext());
            it = dimSrcNumbers.iterator();
            while (it.hasNext()) {
                tmpKey = it.next().toString();
                if (!tmpSources.containsKey(tmpKey)) continue;
                sources.put(tmpKey, tmpSources.get(tmpKey));
            }
        }
        return sources;
    }

    private Map<String, BgSchemeInfo> queryBgSchemeInfo() throws BOSException {
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        HashSet<String> bgSchemeIds = new HashSet<String>();
        Iterator<String> it = this.getCalculator().getCacheManager().getBatchKeyMap().keySet().iterator();
        while (it.hasNext()) {
            bgSchemeIds.add(this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(BgAdjustInfo.getSchemeMapKey(it.next()))[0]);
        }
        if (bgSchemeIds.isEmpty()) {
            return bgSchemeMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgSchemeIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("refCube");
        evi.getSelector().add("periodType");
        evi.getSelector().add("bgDimSettings");
        evi.getSelector().add("bgDimSettings.dimnumber");
        evi.getSelector().add("bgDimSettings.members.type");
        evi.getSelector().add("bgDimSettings.members.memberID");
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                bgSchemeMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return bgSchemeMap;
    }

    @Override
    public void fillValue(Object value) {
        if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
            return;
        }
        Map data = (Map)value;
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustInfo adjustInfo = (BgAdjustInfo)this.getCalculator().getFormula().get(i);
            if (!adjustInfo.isCalculate() || adjustInfo.getParameter().getValue() != null) continue;
            if (data != null && data.containsKey(adjustInfo.getId())) {
                adjustInfo.getParameter().setValue(data.get(adjustInfo.getId()));
                continue;
            }
            adjustInfo.getParameter().setValue((Object)BgNConstants.ZERO);
        }
    }
}

