/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.adjust;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.adjust.BgAdjustCalculator;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class BgAdjustInfo
extends FormulaInfo {
    private int id = 0;
    private String adjustType = "all";
    private Timestamp adjustDate = null;
    private String[] bgSchemeInfo = null;
    private String processType = null;
    private String srcNumbers;
    private String batchKey = null;

    public int getId() {
        return this.id;
    }

    public String[] getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public String getBgSchemeRootId() {
        return this.bgSchemeInfo == null ? null : this.bgSchemeInfo[0];
    }

    public void setAdjustDate(Timestamp adjustDate) {
        this.adjustDate = adjustDate;
    }

    public Timestamp getAdjustDate() {
        return this.adjustDate;
    }

    public void setAdjustType(String adjustType) {
        this.adjustType = adjustType;
    }

    public String getAdjustType() {
        return this.adjustType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public int getProcessTypeValue() {
        if (StringUtils.isEmpty((String)this.processType)) {
            return -1;
        }
        BgProcessEnum process = BgProcessEnum.getEnum(this.getProcessType());
        if (process == null) {
            return -1;
        }
        return process.getValue();
    }

    public BgAdjustInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    public String getExecCalKey() {
        return this.getBgSchemeRootId() + "!" + this.getProcessTypeValue() + "!" + this.srcNumbers;
    }

    public static String getBgSchemeRootId(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0) {
            return key.substring(0, key.indexOf("!"));
        }
        return key;
    }

    public static String getSrcNumbers(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0 && !key.endsWith("!")) {
            return key.substring(key.lastIndexOf("!") + 1);
        }
        return null;
    }

    public static int getProcessType(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return 1;
        }
        if (key.indexOf("!") > 0 && !key.endsWith("!")) {
            return Integer.parseInt(key.substring(key.indexOf("!") + 1, key.lastIndexOf("!")));
        }
        return 1;
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getProcessTypeValue();
        }
        return this.batchKey;
    }

    public static String getSchemeMapKey(String batchKey) {
        if (!StringUtils.isEmpty((String)batchKey)) {
            return batchKey.substring(0, batchKey.lastIndexOf("!"));
        }
        return batchKey;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        super.parseParameter(value);
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = FormulaUtils.updateParams("Mbgadjust", this.getParameter());
        Variant variant = (Variant)params[9];
        if (variant.getValue() != null) {
            this.adjustType = variant.getValue().toString();
        }
        if ((variant = (Variant)params[10]).getValue() != null) {
            try {
                this.adjustDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(variant.toString()).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)(variant = (Variant)params[11]).getValue()))) {
            this.setProcessType(StringUtils.cnulls((Object)variant.getValue()).toUpperCase());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        if (this.getProcessType() == null) {
            this.setProcessType(value.getProcessType().getName());
        }
    }

    @Override
    protected void pretreatmentParameter() {
        super.pretreatmentParameter();
        this.id = ((BgAdjustCalculator)this.getCalculator()).index++;
    }

    public void setBgSchemeInfo() {
        this.bgSchemeInfo = this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(BgAdjustInfo.getSchemeMapKey(this.getBatchCalculateKey()));
        if (this.getBgItemNumber() != null) {
            StringBuffer str = new StringBuffer();
            String[] numbers = DimensionFormulaHelper.splitCombinations(this.getBgItemNumber());
            for (int i = 0; i < numbers.length; ++i) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(DimensionFormulaHelper.getSrcNumber(numbers[i]));
            }
            this.srcNumbers = str.toString();
        }
    }
}

