/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate.BgAdjustDateInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustDateCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate.BgAdjustDateCalculateUtils");

    public BgAdjustDateCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgAdjustDateInfo(this.getCalculator(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        HashMap<Integer, BigDecimal> hashMap;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block16: {
            Map<String, MbgDimInfo> sources;
            Map<String, List<IFormula>> batchKeyMap;
            Map<String, List<String>> allRefFields;
            boolean isPostgresql;
            Map<String, BgSchemeInfo> bgSchemeMap;
            int processType;
            ArrayList<Object[]> paramList;
            String mainTable;
            StringBuilder sql;
            TempTablePool pool;
            block14: {
                Object var31_17;
                block15: {
                    block12: {
                        Object var26_11;
                        block13: {
                            if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
                                return null;
                            }
                            conn = null;
                            pstmt = null;
                            rst = null;
                            pool = TempTablePool.getInstance((Context)this.getCalculator().getContext());
                            sql = new StringBuilder();
                            StringBuilder sql2 = new StringBuilder();
                            mainTable = null;
                            paramList = new ArrayList<Object[]>();
                            processType = -1;
                            conn = EJBFactory.getConnection((Context)this.getCalculator().getContext());
                            sql.setLength(0);
                            sql.append("Create Table T_MBG_TmpAdjustDateCal (");
                            sql.append("FID INT NOT NULL, ");
                            sql.append("FBgDataId VARCHAR(44) NOT NULl, ");
                            sql.append("FAdjustType VARCHAR(20), ");
                            sql.append("FAdjustValue NUMERIC(21,8) DEFAULT 0, ");
                            sql.append("FBeginAdjustTime DateTime, ");
                            sql.append("FEndAdjustTime DateTime, ");
                            sql.append("FAdjustDateType INT NOT NULL, ");
                            sql.append("FAdjustDateState INT NOT NULL, ");
                            sql.append("CONSTRAINT PK_MBG_TAJ" + Math.abs(this.getCalculator().hashCode()) + " PRIMARY KEY(FID, FBgDataId))");
                            mainTable = pool.createTempTable(sql.toString());
                            bgSchemeMap = this.queryBgSchemeInfo();
                            if (!bgSchemeMap.isEmpty()) break block12;
                            var26_11 = null;
                            if (mainTable == null) break block13;
                            pool.releaseTable(mainTable);
                        }
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        return var26_11;
                    }
                    isPostgresql = BgDBUtils.isPostgresql((Connection)conn);
                    boolean isKingBaseES = BgDBUtils.isKingBaseES((Connection)conn);
                    isPostgresql = isPostgresql || isKingBaseES;
                    allRefFields = this.queryBgDataFields(conn, bgSchemeMap, isPostgresql);
                    batchKeyMap = this.getBatchKeyMap();
                    sources = this.queryDimensionSources(batchKeyMap);
                    if (!sources.isEmpty()) break block14;
                    var31_17 = null;
                    if (mainTable == null) break block15;
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                return var31_17;
            }
            try {
                block4: for (String batchKey : batchKeyMap.keySet()) {
                    List<String> refFields;
                    Map<String, BgOrgUnitInfo> orgUnitMap;
                    String bgSchemeId = BgAdjustDateInfo.getBgSchemeRootId(batchKey);
                    processType = BgAdjustDateInfo.getProcessType(batchKey);
                    String srcNumber = BgAdjustDateInfo.getSrcNumbers(batchKey);
                    BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getCalculator().getContext(), bgSchemeId);
                    List<IFormula> formulas = batchKeyMap.get(batchKey);
                    BgSchemeInfo bgSchemeInfo = bgSchemeMap.get(bgSchemeId);
                    if (formulas == null || bgSchemeInfo == null || srcNumber == null || (orgUnitMap = this.queryOrgUnit(bgSchemeInfo)).isEmpty() || (refFields = isPostgresql ? allRefFields.get(bgSchemeInfo.getRefCube().toLowerCase()) : allRefFields.get(bgSchemeInfo.getRefCube())) == null || refFields.isEmpty()) continue;
                    sql.setLength(0);
                    sql.append("Insert Into ").append(mainTable).append("(FID,FAdjustType,FAdjustDateType,FAdjustDateState, FBeginAdjustTime,FEndAdjustTime, FBgDataId) ");
                    sql.append(" Select ?, ?, ?, ? ,? ,? ,bgData.FID FROM ").append(BgCubeUtils.getCubeName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(BgProcessEnum.getEnum(processType)))).append(" bgData ");
                    sql.append(" inner join T_MBG_BgElement bgElement on bgElement.FID = bgData.FBgElementId");
                    sql.append(" inner join T_BD_Currency currency on currency.FID = bgData.FCurrencyId");
                    sql.append(" inner join T_MBG_BgScenario scen on scen.FScenarioID = bgData.FScenario");
                    sql.append(" inner join T_MBG_BgVersion ver on ver.FVersionID = bgData.FVersion");
                    sql.append(" Where bgData.FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where (FNumber = ? OR FLongNumber like ?) AND FViewId = ?)");
                    sql.append(" AND bgElement.FNumber = ?");
                    sql.append(" AND currency.FNumber = ?");
                    sql.append(" AND scen.FNumber = ?");
                    sql.append(" AND ver.FNumber = ?");
                    String[] srcNumbers = srcNumber.split(",");
                    Map<String, BgDimensionInfo> srcMap = schemeHelper.getDimensionBySrcNumber();
                    for (int i = 0; i < srcNumbers.length; ++i) {
                        sql.append(" AND ");
                        MbgDimInfo source = sources.get(srcNumbers[i]);
                        if (!srcMap.containsKey(srcNumbers[i])) continue block4;
                        String viewId = srcMap.get(srcNumbers[i]).getViewId();
                        String closureTable = MbgVirtualView.getClosureTable((String)MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)BOSUuid.read((String)viewId)));
                        if (isPostgresql ? source == null || !refFields.contains(source.getRefField().toLowerCase()) : source == null || !refFields.contains(source.getRefField())) continue block4;
                        sql.append(source.getRefField());
                        sql.append(" IN (Select FChildId From ").append(closureTable).append(" Where FID = ?)");
                    }
                    paramList.clear();
                    for (int f = 0; f < formulas.size(); ++f) {
                        BgAdjustDateInfo adjustDateInfo = (BgAdjustDateInfo)formulas.get(f);
                        if (!adjustDateInfo.isCalculate() || !orgUnitMap.containsKey(adjustDateInfo.getOrgUnitNumber())) continue;
                        for (int p = 0; p < adjustDateInfo.getFormulas().length; ++p) {
                            Object[] params = new Object[13 + srcNumbers.length];
                            paramList.add(params);
                            params[0] = adjustDateInfo.getId();
                            params[1] = adjustDateInfo.getAdjustType();
                            params[2] = adjustDateInfo.getAdjustDateType().getValue();
                            params[3] = adjustDateInfo.getAdjustDateState().getValue();
                            params[4] = adjustDateInfo.getBeginDate();
                            params[5] = adjustDateInfo.getEndDate();
                            params[6] = adjustDateInfo.getOrgUnitNumber();
                            params[7] = orgUnitMap.get(adjustDateInfo.getOrgUnitNumber()).getLongNumber() + (BgProcessEnum.C01.getName().equals(adjustDateInfo.getProcessType()) ? "!%" : "");
                            params[8] = bgSchemeInfo.getEditOrgViewId().toString();
                            params[9] = adjustDateInfo.getBgElementNumber();
                            params[10] = adjustDateInfo.getCurrencyNumber();
                            params[11] = adjustDateInfo.getBgScenarioNumber();
                            params[12] = adjustDateInfo.getBgVersionNumber();
                            String[] dimNumbers = adjustDateInfo.getBgItemNumber().split(",");
                            for (int d = 0; d < dimNumbers.length; ++d) {
                                params[13 + d] = dimNumbers[d];
                            }
                        }
                    }
                    MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
                }
                this.allType(conn, mainTable);
                this.adjustFormType(conn, mainTable);
                this.rollFormType(conn, mainTable);
                this.regulateBillType(conn, mainTable);
                this.adjustBillType(conn, mainTable);
                HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
                pstmt = conn.prepareStatement("Select FID, SUM(FAdjustValue) FAdjustValue FROM " + mainTable + " Where FAdjustValue IS NOT NULL GROUP BY FID");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    result.put(rst.getInt("FID"), rst.getBigDecimal("FAdjustValue"));
                }
                hashMap = result;
                if (mainTable == null) break block16;
            }
            catch (Throwable throwable) {
                if (mainTable != null) {
                    pool.releaseTable(mainTable);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            pool.releaseTable(mainTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }

    private void adjustBillType(Connection conn, String mainTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 2 + "," + 3 + ") AND (t3.FCreateTime >= t1.FBeginAdjustTime and t3.FCreateTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "adjustBill" + "'and FAdjustDateType = " + 1 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 2 + "," + 3 + ") AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "adjustBill" + "'and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_MBG_BgAdjustBill t5 on entry.FFormId = t5.FID where t1.FbgDataid = tmpData.FID and t5.FType in (" + 2 + "," + 3 + ") AND (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))Where FAdjustType = '" + "adjustBill" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 2 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_MBG_BgAdjustBill t5 on entry.FFormId = t5.FID where t1.FbgDataid = tmpData.FID and t5.FType in (" + 2 + "," + 3 + ") AND (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime)) where FAdjustType = '" + "adjustBill" + "' and FAdjustDateState = " + 0 + " and FAdjustDateType = " + 0 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = isNull(FAdjustValue,0) + isNull((Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 2 + "," + 3 + ") AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)),0) Where FAdjustType = '" + "adjustBill" + "'and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 0 + ""));
    }

    private void regulateBillType(Connection conn, String mainTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 0 + "," + 1 + ") AND (t3.FCreateTime >= t1.FBeginAdjustTime and t3.FCreateTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "regulateBill" + "' and FAdjustDateType = " + 1 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 0 + "," + 1 + ") AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "regulateBill" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_MBG_BgAdjustBill t5 on entry.FFormId = t5.FID where t1.FBgDataId = tmpData.FID and t5.FType in (" + 0 + "," + 1 + ") AND (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))Where FAdjustType = '" + "regulateBill" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 2 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_MBG_BgAdjustBill t5 on entry.FFormId = t5.FID where t1.FBgDataId = tmpData.FID and t5.FType in (" + 0 + "," + 1 + ") AND (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime)) where FAdjustType = '" + "regulateBill" + "' and FAdjustDateState = " + 0 + " and  FAdjustDateType = " + 0 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = isNull(FAdjustValue,0) + isNull((Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgAdjustBill t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t5.FType IN (" + 0 + "," + 1 + ") AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)),0) Where FAdjustType = '" + "regulateBill" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 0 + ""));
    }

    private void rollFormType(Connection conn, String mainTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t3.FCreateTime >= t1.FBeginAdjustTime and t3.FCreateTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "rollForm" + "' and FAdjustDateType = " + 1 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND  (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "rollForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (Select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_Mbg_BgForm t5 on t5.FID = entry.FFormId where t1.FBgDataId = tmpData.FID and t5.FState  = " + 6 + " and (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))Where FAdjustType = '" + "rollForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 2 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (Select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_Mbg_BgForm t5 on t5.FID = entry.FFormId where t1.FBgDataId = tmpData.FID and t5.FState  = " + 6 + " and (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime)) where FAdjustType = '" + "rollForm" + "' and FAdjustDateState = " + 0 + " and FAdjustDateType = " + 0 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = isNull(FAdjustValue,0) + isNull((Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND  (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)),0) Where FAdjustType = '" + "rollForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 0 + ""));
    }

    private void adjustFormType(Connection conn, String mainTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource not in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t3.FCreateTime >= t1.FBeginAdjustTime and t3.FCreateTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "adjustForm" + "' and FAdjustDateType = " + 1 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource not in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "adjustForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (Select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_Mbg_BgForm t5 on t5.FID = entry.FFormId where tmpData.FID = t1.FbgDataId and t5.FState not in ('" + 6 + "')  and  (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))Where FAdjustType = '" + "adjustForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 2 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (Select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry on tmpData.FID = entry.FDataID left join T_Mbg_BgForm t5 on t5.FID = entry.FFormId where tmpData.FID = t1.FbgDataId and t5.FState not in ('" + 6 + "')and  (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))where FAdjustType = '" + "adjustForm" + "' and FAdjustDateState = " + 0 + " and FAdjustDateType = " + 0 + " "));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue  = isNull(FAdjustValue,0) + isNull((Select SUM(FPastValue) FROM T_MBG_BgPastData t2, T_Mbg_BgPastRecord t3, T_Mbg_BgForm t5 Where t2.FBgDataId = t1.FBgDataId AND T2.FPastRecordID = t3.FID AND t3.FBgFormId = t5.FID AND t3.FPastSource not in ('" + BgPastSourceEnum.ROLL.getValue() + "') AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)),0) Where FAdjustType = '" + "adjustForm" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 0 + ""));
    }

    private void allType(Connection conn, String mainTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2 left join T_MBG_BgPastRecord record  on t2.FPastRecordID = record.FID Where t2.FBgDataId = t1.FBgDataId AND (record.FCreateTime >= t1.FBeginAdjustTime and record.FCreateTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "all" + "' and FAdjustDateType = " + 1 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = (Select SUM(FPastValue) FROM T_MBG_BgPastData t2 Where t2.FBgDataId = t1.FBgDataId AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)) Where FAdjustType = '" + "all" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 1 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry ON tmpData.FID = entry.FDataID where tmpData.FID = t1.FBgDataID and  (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime))Where FAdjustType = '" + "all" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 2 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("update " + mainTable + " t1 set FAdjustValue = (select SUM(FValue -FoldValue) from T_MBG_BgTmpData tmpData left join T_MBG_BgTmpDataEntry entry ON tmpData.FID = entry.FDataID where tmpData.FID = t1.FBgDataID and  (tmpData.FCreateTime >= t1.FBeginAdjustTime and tmpData.FCreateTime <= t1.FEndAdjustTime)) where FAdjustType = '" + "all" + "' and FAdjustDateState = " + 0 + " and FAdjustDateType = " + 0 + ""));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + mainTable + " t1 Set FAdjustValue = isNull(FAdjustValue,0) + isNull((Select SUM(FPastValue) FROM T_MBG_BgPastData t2 Where t2.FBgDataId = t1.FBgDataId AND (t2.FAdjustTime >= t1.FBeginAdjustTime and t2.FAdjustTime <= t1.FEndAdjustTime)),0) Where FAdjustType = '" + "all" + "' and FAdjustDateType = " + 0 + " and FAdjustDateState = " + 0 + ""));
    }

    private void dealTmpAdjustFromTmpTable(Connection conn, String mainTable, BgSchemeInfo bgSchemeInfo, int processType, List<IFormula> formulas, Map<String, BgOrgUnitInfo> orgUnitMap) throws SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder sql = new StringBuilder();
        sql.append("Insert Into ").append(mainTable).append("(FID,FAdjustType,FAdjustDateType,FAdjustDateState,FBeginAdjustTime,FEndAdjustTime, FBgDataId ) ");
        sql.append(" Select ?, ?, ?, ?,bgPeriod.FBeginDate,bgPeriod.FEndDate,bgData.FID FROM T_MBG_BgTmpData bgData ");
        sql.append(" inner join T_MBG_BgPeriod bgPeriod on bgPeriod.FID = bgData.FBgPeriodId");
        sql.append(" inner join T_MBG_BgElement bgElement on bgElement.FID = bgData.FBgElementId");
        sql.append(" inner join T_BD_Currency currency on currency.FID = bgData.FCurrencyId");
        sql.append(" inner join T_MBG_BgScenario scen on scen.FScenarioID = bgData.FScenario");
        sql.append(" inner join T_MBG_BgVersion ver on ver.FVersionID = bgData.FVersion");
        sql.append(" Where not exists (select * from " + mainTable + " tmp where FID  = ? and tmp.FBgDataId = bgData.FBgDataId) and  bgData.FBgSchemeRootId = '" + bgSchemeInfo.getId().toString() + "' and bgData.FProcessType = " + processType + " and  bgData.FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where (FNumber = ? OR FLongNumber like ?) AND FViewId = ?)");
        sql.append(" AND bgElement.FNumber = ?");
        sql.append(" AND currency.FNumber = ?");
        sql.append(" AND scen.FNumber = ?");
        sql.append(" AND ver.FNumber = ?");
        sql.append("  AND FBgItemCombination = ?");
        for (int f = 0; f < formulas.size(); ++f) {
            BgAdjustDateInfo adjustDateInfo = (BgAdjustDateInfo)formulas.get(f);
            if (!adjustDateInfo.isCalculate() || !orgUnitMap.containsKey(adjustDateInfo.getOrgUnitNumber())) continue;
            for (int p = 0; p < adjustDateInfo.getFormulas().length; ++p) {
                Object[] params = new Object[13];
                paramList.add(params);
                params[0] = adjustDateInfo.getId();
                params[1] = adjustDateInfo.getAdjustType();
                params[2] = adjustDateInfo.getAdjustDateType().getName();
                params[3] = adjustDateInfo.getAdjustDateState().getName();
                params[4] = adjustDateInfo.getId();
                params[5] = adjustDateInfo.getOrgUnitNumber();
                params[6] = orgUnitMap.get(adjustDateInfo.getOrgUnitNumber()).getLongNumber() + "!%";
                params[7] = bgSchemeInfo.getEditOrgViewId().toString();
                params[8] = adjustDateInfo.getBgElementNumber();
                params[9] = adjustDateInfo.getCurrencyNumber();
                params[10] = adjustDateInfo.getBgScenarioNumber();
                params[11] = adjustDateInfo.getBgVersionNumber();
                params[12] = adjustDateInfo.getBgItemNumber();
            }
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
        }
    }

    private Set<String> getPeriodNumberByParams(List<Object[]> paramList, int periodIndex) {
        HashSet<String> periodNumbers = new HashSet<String>(paramList.size());
        for (int i = 0; i < paramList.size(); ++i) {
            Object[] params = paramList.get(i);
            periodNumbers.add(params[periodIndex].toString());
        }
        return periodNumbers;
    }

    private Map<String, BgOrgUnitInfo> queryOrgUnit(BgSchemeInfo schemeInfo) throws BOSException {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (schemeInfo == null || schemeInfo.getEditOrgViewId() == null) {
            return orgUnitMap;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustDateInfo adjustInfo = (BgAdjustDateInfo)this.getCalculator().getFormula().get(i);
            if (!adjustInfo.isCalculate() || !adjustInfo.getBgSchemeNumber().equals(schemeInfo.getNumber())) continue;
            numbers.add(adjustInfo.getOrgUnitNumber());
        }
        if (!numbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)schemeInfo.getEditOrgViewId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("longNumber");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(this.getCalculator().getContext()).getBgOrgUnitCollection(view);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    orgUnitMap.put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        return orgUnitMap;
    }

    private Map<String, List<IFormula>> getBatchKeyMap() {
        HashMap<String, List<IFormula>> batchKeyMap = new HashMap<String, List<IFormula>>();
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustDateInfo adjustInfo = (BgAdjustDateInfo)this.getCalculator().getFormula().get(i);
            adjustInfo.setBgSchemeInfo();
            String key = adjustInfo.getExecCalKey();
            if (!batchKeyMap.containsKey(key)) {
                batchKeyMap.put(key, new ArrayList());
            }
            ((List)batchKeyMap.get(key)).add(adjustInfo);
        }
        return batchKeyMap;
    }

    private Map<String, List<String>> queryBgDataFields(Connection conn, Map<String, BgSchemeInfo> bgSchemeMap, boolean isPostgresql) throws BOSException {
        final HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        if (isPostgresql) {
            sql.append("select c.relname,a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where a.attnum > 0 and c.relname  in(");
        } else {
            sql.append("SELECT KSQL_COL_TABNAME,KSQL_COL_NAME from KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME IN(");
        }
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        ArrayList<String> bgDataTableNames = new ArrayList<String>();
        for (BgSchemeInfo bgSchemeInfo : bgSchemeMap.values()) {
            if (StringUtils.isEmpty((String)bgSchemeInfo.getRefCube())) continue;
            if (isPostgresql) {
                bgDataTableNames.add(bgSchemeInfo.getRefCube().toLowerCase());
                continue;
            }
            bgDataTableNames.add(bgSchemeInfo.getRefCube());
        }
        List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgDataTableNames.toArray(), (int)50);
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String tableName = res.getString(1);
                String field = res.getString(2);
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new ArrayList());
                }
                ((List)result.get(tableName)).add(field);
            }
        });
        return result;
    }

    private Map<String, MbgDimInfo> queryDimensionSources(Map<String, List<IFormula>> batchKeyMap) throws BOSException {
        HashSet dimSrcNumbers = new HashSet();
        HashMap<String, MbgDimInfo> sources = new HashMap<String, MbgDimInfo>();
        Map<String, MbgDimInfo> tmpSources = null;
        String tmpKey = null;
        Iterator<String> it = batchKeyMap.keySet().iterator();
        while (it.hasNext()) {
            String srcNumbers = BgAdjustDateInfo.getSrcNumbers(it.next());
            if (srcNumbers == null) continue;
            dimSrcNumbers.addAll(Arrays.asList((Object[])srcNumbers.split(",")));
        }
        if (!dimSrcNumbers.isEmpty()) {
            tmpSources = DimUtils.getDimInfoMap(this.getCalculator().getContext());
            it = dimSrcNumbers.iterator();
            while (it.hasNext()) {
                tmpKey = it.next().toString();
                if (!tmpSources.containsKey(tmpKey)) continue;
                sources.put(tmpKey, tmpSources.get(tmpKey));
            }
        }
        return sources;
    }

    private Map<String, BgSchemeInfo> queryBgSchemeInfo() throws BOSException {
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        HashSet<String> bgSchemeIds = new HashSet<String>();
        Iterator<String> it = this.getCalculator().getCacheManager().getBatchKeyMap().keySet().iterator();
        while (it.hasNext()) {
            bgSchemeIds.add(this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(BgAdjustDateInfo.getSchemeMapKey(it.next()))[0]);
        }
        if (bgSchemeIds.isEmpty()) {
            return bgSchemeMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgSchemeIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("refCube");
        evi.getSelector().add("periodType");
        evi.getSelector().add("bgDimSettings");
        evi.getSelector().add("bgDimSettings.dimnumber");
        evi.getSelector().add("bgDimSettings.members.type");
        evi.getSelector().add("bgDimSettings.members.memberID");
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                bgSchemeMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return bgSchemeMap;
    }

    @Override
    public void fillValue(Object value) {
        if (this.getCalculator().getFormula() == null || this.getCalculator().getFormula().isEmpty()) {
            return;
        }
        Map data = (Map)value;
        for (int i = 0; i < this.getCalculator().getFormula().size(); ++i) {
            BgAdjustDateInfo adjustDateInfo = (BgAdjustDateInfo)this.getCalculator().getFormula().get(i);
            if (!adjustDateInfo.isCalculate()) continue;
            if (data != null && data.containsKey(adjustDateInfo.getId())) {
                adjustDateInfo.getParameter().setValue(data.get(adjustDateInfo.getId()));
                continue;
            }
            adjustDateInfo.getParameter().setValue((Object)BgNConstants.ZERO);
        }
    }
}

