/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.MbgAdjustDateStateEnum;
import com.kingdee.eas.ma.mbg.MbgAdjustDateTypeEnum;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate.BgAdjustDateCalculator;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BgAdjustDateInfo
extends FormulaInfo {
    private int id = 0;
    private String adjustType = "all";
    private String[] bgSchemeInfo = null;
    private String processType = null;
    private Timestamp beginDate = null;
    private Timestamp endDate = null;
    private String srcNumbers;
    private MbgAdjustDateTypeEnum adjustDateType = MbgAdjustDateTypeEnum.adjustDate;
    private MbgAdjustDateStateEnum adjustDateState = MbgAdjustDateStateEnum.all;
    private String batchKey = null;

    public MbgAdjustDateStateEnum getAdjustDateState() {
        return this.adjustDateState;
    }

    public void setAdjustDateState(MbgAdjustDateStateEnum adjustDateState) {
        this.adjustDateState = adjustDateState;
    }

    public MbgAdjustDateTypeEnum getAdjustDateType() {
        return this.adjustDateType;
    }

    public void setAdjustDateType(MbgAdjustDateTypeEnum adjustDateType) {
        this.adjustDateType = adjustDateType;
    }

    public int getId() {
        return this.id;
    }

    public String[] getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public String getBgSchemeRootId() {
        return this.bgSchemeInfo == null ? null : this.bgSchemeInfo[0];
    }

    public void setAdjustType(String adjustType) {
        this.adjustType = adjustType;
    }

    public String getAdjustType() {
        return this.adjustType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public int getProcessTypeValue() {
        if (StringUtils.isEmpty((String)this.processType)) {
            return -1;
        }
        BgProcessEnum process = BgProcessEnum.getEnum(this.getProcessType());
        if (process == null) {
            return -1;
        }
        return process.getValue();
    }

    public Timestamp getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Timestamp beginDate) {
        this.beginDate = beginDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp endDate) {
        this.endDate = endDate;
    }

    public BgAdjustDateInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    public String getExecCalKey() {
        return this.getBgSchemeRootId() + "!" + this.getProcessTypeValue() + "!" + this.srcNumbers;
    }

    public static String getBgSchemeRootId(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0) {
            return key.substring(0, key.indexOf("!"));
        }
        return key;
    }

    public static String getSrcNumbers(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.indexOf("!") > 0 && !key.endsWith("!")) {
            return key.substring(key.lastIndexOf("!") + 1);
        }
        return null;
    }

    public static int getProcessType(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return 1;
        }
        if (key.indexOf("!") > 0 && !key.endsWith("!")) {
            return Integer.parseInt(key.substring(key.indexOf("!") + 1, key.lastIndexOf("!")));
        }
        return 1;
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getProcessTypeValue();
        }
        return this.batchKey;
    }

    public static String getSchemeMapKey(String batchKey) {
        if (!StringUtils.isEmpty((String)batchKey)) {
            return batchKey.substring(0, batchKey.lastIndexOf("!"));
        }
        return batchKey;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = FormulaUtils.updateParams("MbgAdjustDate", this.getParameter());
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgItemNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            try {
                this.beginDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(variant.toString()).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            try {
                this.endDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(variant.toString()).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setBgVersionNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[9]).getValue() != null) {
            this.adjustType = variant.getValue().toString();
        }
        if ((variant = (Variant)params[10]).getValue() != null) {
            this.adjustDateType = MbgAdjustDateTypeEnum.getEnum((String)variant.getValue());
        }
        if ((variant = (Variant)params[11]).getValue() != null) {
            this.adjustDateState = MbgAdjustDateStateEnum.getEnum((String)variant.getValue());
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)(variant = (Variant)params[12]).getValue()))) {
            this.setProcessType(StringUtils.cnulls((Object)variant.getValue()).toUpperCase());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        if (this.getBeginDate() == null) {
            Date startDate = (Date)this.getCalculator().getProvider().getReportAdapter().getReportProperty("Report_StartDate");
            this.setBeginDate(new Timestamp(BgNPeriodHelper.getDayBegin((Date)startDate).getTime()));
        } else {
            this.setBeginDate(new Timestamp(BgNPeriodHelper.getDayBegin((Date)new Date(this.getBeginDate().getTime())).getTime()));
        }
        if (this.getEndDate() == null) {
            Date endDate = (Date)this.getCalculator().getProvider().getReportAdapter().getReportProperty("Report_EndDate");
            this.setEndDate(new Timestamp(BgNPeriodHelper.getDayEnd((Date)endDate).getTime()));
        } else {
            this.setEndDate(new Timestamp(BgNPeriodHelper.getDayEnd((Date)new Date(this.getEndDate().getTime())).getTime()));
        }
        if (this.getProcessType() == null) {
            this.setProcessType(value.getProcessType().getName());
        }
    }

    @Override
    protected void pretreatmentParameter() {
        super.pretreatmentParameter();
        this.id = ((BgAdjustDateCalculator)this.getCalculator()).index++;
    }

    public void setBgSchemeInfo() {
        this.bgSchemeInfo = this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(BgAdjustDateInfo.getSchemeMapKey(this.getBatchCalculateKey()));
        if (this.getBgItemNumber() != null) {
            StringBuffer str = new StringBuffer();
            String[] numbers = DimensionFormulaHelper.splitCombinations(this.getBgItemNumber());
            for (int i = 0; i < numbers.length; ++i) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(DimensionFormulaHelper.getSrcNumber(numbers[i]));
            }
            this.srcNumbers = str.toString();
        }
    }
}

