/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.aggregate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateInfo;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceResult;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgDataQueryUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgDataMultiQuery;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAggregateCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.actual.BgAggregateCalculateUtils");
    public static final String ISCALCBIZ = "isCalcBiz";
    private boolean calcTmpValue = false;
    private String periodStandardNumber = null;

    public void setCalcTmpValue(boolean calcTmpValue) {
        this.calcTmpValue = calcTmpValue;
    }

    public boolean isCalcTmpValue() {
        return this.calcTmpValue;
    }

    public BgAggregateCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgAggregateInfo(this.getCalculator(), parameter);
    }

    @Override
    protected DefaultFormulaValue getDefaultFormulaValue() {
        return new BgAggregateFormulaValue();
    }

    @Override
    public void beforeCommonInit() throws Exception {
        super.beforeCommonInit();
        ExpressionUtils.queryDimInfo(this.getCalculator());
        IReportPropertyAdapter adapter = this.getCalculator().getProvider().getReportAdapter();
        if (adapter.getReportProperty("BG_FORM_STATE") instanceof Integer) {
            int state = (Integer)adapter.getReportProperty("BG_FORM_STATE");
            if (state == 4 || state == 6) {
                this.setCalcTmpValue(true);
            } else {
                this.setCalcTmpValue(false);
            }
        } else {
            this.setCalcTmpValue(false);
        }
        this.periodStandardNumber = adapter.getReportProperty("BG_PERIOD_NUMBER") != null ? (String)adapter.getReportProperty("BG_PERIOD_NUMBER") : this.getDefaultPeriodNumByReport(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        IDimensionParameter parameter = null;
        String batchKey = null;
        String orgUnitNum = null;
        String schemeNum = null;
        String orgUnitId = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap<String, Map<String, HashMap<String, Map>>> schValueMap = new HashMap<String, Map<String, HashMap<String, Map>>>();
        Map<String, HashMap<String, Map>> orgValueMap = null;
        HashMap<String, IObjectValue> scenObjMap = new HashMap<String, IObjectValue>();
        Object value = null;
        BgAggregateInfo formula = null;
        AggregateDataTypeEnum type = null;
        BgProcessEnum processType = null;
        String dataState = null;
        BgNDataInfo _bgData = null;
        Object bgDataKey = null;
        Connection conn = null;
        conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
        long st = System.currentTimeMillis();
        scenObjMap.putAll(BgScenarioHelper.getScenariooObjMap((Connection)conn, (Locale)this.getCalculator().getContext().getLocale()));
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        HashMap<String, Set<String>> bgSchemeMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            batchKey = entry2.getKey();
            formulaList = entry2.getValue();
            orgAndSchStr = batchKey.split("!");
            orgUnitNum = orgAndSchStr[0];
            schemeNum = orgAndSchStr[1];
            if (!bgSchemeMap.containsKey(schemeNum)) {
                bgSchemeMap.put(schemeNum, new HashSet());
            }
            if (orgUnitNum.contains(";")) {
                String[] orgUnitNums;
                for (String orgNum : orgUnitNums = orgUnitNum.split(";")) {
                    ((Set)bgSchemeMap.get(schemeNum)).add(orgNum.trim());
                }
                continue;
            }
            ((Set)bgSchemeMap.get(schemeNum)).add(orgUnitNum);
        }
        Map<String, Map<String, BgOrgUnitInfo>> orgUnitMap = this.queryOrgUnitMap(this.getCalculator().getContext(), bgSchemeMap);
        logger.debug((Object)("queryOrgUnitMap " + (System.currentTimeMillis() - st)));
        HashMap multiOrgKey = new HashMap();
        HashMap<String, IDimensionParameter> paramMap = new HashMap<String, IDimensionParameter>();
        String errorMsg = null;
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            batchKey = entry2.getKey();
            formulaList = entry2.getValue();
            orgAndSchStr = batchKey.split("!");
            orgUnitNum = orgAndSchStr[0];
            schemeNum = orgAndSchStr[1];
            type = this.getEnum(orgAndSchStr[2]);
            processType = BgProcessEnum.getEnum(Integer.parseInt(orgAndSchStr[3]));
            dataState = orgAndSchStr.length >= 5 ? orgAndSchStr[4] : "";
            if (AggregateDataTypeEnum.actual.equals((Object)type)) {
                dataState = "Approved";
            }
            if ("".equals(dataState) && AggregateDataTypeEnum.addActual.equals((Object)type)) {
                dataState = "Approved";
            }
            parameter = null;
            errorMsg = null;
            if (processType == null) {
                errorMsg = "Process type no found(" + orgAndSchStr[3] + ")";
            } else if (type == null) {
                errorMsg = "Data type no found(" + orgAndSchStr[2] + ")";
            } else if (!orgUnitMap.containsKey(schemeNum)) {
                errorMsg = "Budget scheme no found(" + schemeNum + ")";
            } else if (!StringUtils.isEmpty((String)dataState)) {
                if (!(!AggregateDataTypeEnum.budget.equals((Object)type) || "Adjust".equalsIgnoreCase(dataState) || "Approved".equalsIgnoreCase(dataState) || "Approving".equalsIgnoreCase(dataState) || "Edited".equalsIgnoreCase(dataState))) {
                    dataState = "";
                }
            } else if (orgUnitNum.contains(";")) {
                String[] orgUnitNums;
                for (String orgNum : orgUnitNums = orgUnitNum.split(";")) {
                    if (orgUnitMap.get(schemeNum).containsKey(orgNum.trim())) continue;
                    errorMsg = "org. no found(" + orgNum + ")";
                }
            } else if (!orgUnitMap.get(schemeNum).containsKey(orgUnitNum)) {
                errorMsg = "org. no found(" + orgUnitNum + ")";
            }
            if (errorMsg != null) {
                int in = formulaList.size();
                for (int i = 0; i < in; ++i) {
                    formula = (BgAggregateInfo)formulaList.get(i);
                    formula.setCalculate(false);
                    formula.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)errorMsg));
                }
                continue;
            }
            if (processType == null || type == null || !orgUnitMap.containsKey(schemeNum)) continue;
            int valueType = this.getValueType(type, dataState);
            if (DimensionCommonHelper.isDecompose(processType)) {
                if (!AggregateDataTypeEnum.budget.equals((Object)type)) continue;
                valueType = DimensionCommonHelper.getDataType(processType);
            }
            if (orgUnitNum.contains(";")) {
                String[] orgUnitNums;
                if (!multiOrgKey.containsKey(batchKey)) {
                    multiOrgKey.put(batchKey, new HashSet());
                }
                for (String orgNum : orgUnitNums = orgUnitNum.split(";")) {
                    String newBatchKey = null;
                    newBatchKey = !StringUtils.isEmpty((String)orgAndSchStr[3]) ? orgNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + orgAndSchStr[3] + "!" + dataState : orgNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + dataState;
                    ArrayList<IFormula> newFormulaList = new ArrayList<IFormula>();
                    int in = formulaList.size();
                    for (int i = 0; i < in; ++i) {
                        formula = (BgAggregateInfo)formulaList.get(i);
                        formula.setOrgUnitNumber(orgNum.trim());
                        newFormulaList.add(formula);
                    }
                    parameter = this.transDimParameter(orgNum.trim(), schemeNum, newFormulaList, valueType, type, orgUnitMap, errorMsg);
                    if (parameter == null) continue;
                    if (paramMap.containsKey(newBatchKey)) {
                        parameter = this.mergeParameter(parameter, (IDimensionParameter)paramMap.get(newBatchKey));
                        paramMap.put(newBatchKey, parameter);
                    } else {
                        paramMap.put(newBatchKey, parameter);
                    }
                    parameter.getControlManager().setHasQueryDataState(false);
                    parameter.addPeriodStandardNumber(this.periodStandardNumber);
                    this.setCustState(parameter, dataState);
                    if (!parameter.getControlManager().isAdjust()) {
                        if (this.isCalcTmpValue()) {
                            parameter.getControlManager().setAdjust(true);
                        } else {
                            parameter.getControlManager().setAdjust(false);
                        }
                    }
                    ((Set)multiOrgKey.get(batchKey)).add(newBatchKey);
                }
                int in = formulaList.size();
                for (int i = 0; i < in; ++i) {
                    formula = (BgAggregateInfo)formulaList.get(i);
                    formula.setOrgUnitNumber(orgUnitNum);
                    if (type == null) {
                        formula.setCalculate(false);
                        formula.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)("dataType no found(" + orgAndSchStr[2] + ")")));
                        continue;
                    }
                    formula.setDataType(type.getValue());
                }
                continue;
            }
            parameter = this.transDimParameter(orgUnitNum, schemeNum, formulaList, valueType, type, orgUnitMap, errorMsg);
            String newBatchKey = null;
            newBatchKey = !StringUtils.isEmpty((String)orgAndSchStr[3]) ? orgUnitNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + orgAndSchStr[3] + "!" + dataState : orgUnitNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + dataState;
            if (parameter == null) continue;
            this.setCustState(parameter, dataState);
            if (paramMap.containsKey(newBatchKey)) {
                parameter = this.mergeParameter(parameter, (IDimensionParameter)paramMap.get(newBatchKey));
                paramMap.put(newBatchKey, parameter);
                continue;
            }
            paramMap.put(newBatchKey, parameter);
        }
        logger.debug((Object)("parameter " + (System.currentTimeMillis() - st)));
        MbgDataMultiQuery query = new MbgDataMultiQuery(this.getCalculator().getContext());
        Map<String, Object> dataMap = null;
        try {
            dataMap = query.query(paramMap);
        }
        catch (Exception ex) {
            logger.error((Object)"bgAggregate Calculate Error:", (Throwable)ex);
            SyntaxErrorException error = null;
            error = ex instanceof BgPeriodException ? new SyntaxErrorException(128L, (Object)(ex.getMessage() + "(" + ex.getCause().getMessage() + ")")) : new SyntaxErrorException(128L, (Object)ex.getMessage());
            for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                formulaList = entry2.getValue();
                int in = formulaList.size();
                for (int i = 0; i < in; ++i) {
                    formula = (BgAggregateInfo)formulaList.get(i);
                    formula.getParameter().setValue((Object)error);
                }
            }
            HashMap<String, Map<String, HashMap<String, Map>>> iter = schValueMap;
            SQLUtils.cleanup((Connection)conn);
            return iter;
        }
        try {
            logger.debug((Object)("MbgDataMultiQuery " + (System.currentTimeMillis() - st)));
            for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                batchKey = entry2.getKey();
                formulaList = entry2.getValue();
                orgAndSchStr = batchKey.split("!");
                orgUnitNum = orgAndSchStr[0];
                schemeNum = orgAndSchStr[1];
                type = this.getEnum(orgAndSchStr[2]);
                processType = BgProcessEnum.getEnum(Integer.parseInt(orgAndSchStr[3]));
                int valueType = this.getValueType(type, dataState);
                if (DimensionCommonHelper.isDecompose(processType) && AggregateDataTypeEnum.budget.equals((Object)type)) {
                    valueType = DimensionCommonHelper.getDataType(processType);
                }
                dataState = orgAndSchStr.length >= 5 ? orgAndSchStr[4] : "";
                if (AggregateDataTypeEnum.actual.equals((Object)type)) {
                    dataState = "Approved";
                }
                if (orgUnitNum.contains(";")) {
                    String[] orgUnitNums;
                    for (String orgNum : orgUnitNums = orgUnitNum.split(";")) {
                        BgNDataInfo dataInfo;
                        String newBatchKey = null;
                        newBatchKey = !StringUtils.isEmpty((String)orgAndSchStr[3]) ? orgNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + orgAndSchStr[3] + "!" + dataState : orgNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + dataState;
                        if (orgUnitMap.get(schemeNum) == null || orgUnitMap.get(schemeNum).get(orgNum.trim()) == null) continue;
                        orgUnitId = orgUnitMap.get(schemeNum).get(orgNum.trim()).getOrgUnitID();
                        if (type == null) continue;
                        Object object = value = dataMap == null ? null : dataMap.get(newBatchKey);
                        if (!(value instanceof Map)) continue;
                        Map _tmpMap = (Map)value;
                        if (schValueMap.containsKey(schemeNum)) {
                            orgValueMap = (Map)schValueMap.get(schemeNum);
                        } else {
                            orgValueMap = new HashMap();
                            schValueMap.put(schemeNum, orgValueMap);
                        }
                        if (!_tmpMap.containsKey(orgUnitId)) continue;
                        Map tmpValue = (Map)_tmpMap.get(orgUnitId);
                        if (orgValueMap.containsKey(this.getBgDataKey(orgUnitNum, processType, dataState))) {
                            Map valueMap = (Map)orgValueMap.get(this.getBgDataKey(orgUnitNum, processType, dataState));
                            Map.Entry dEntry2 = null;
                            for (Map.Entry dEntry2 : tmpValue.entrySet()) {
                                if (valueMap.containsKey(dEntry2.getKey())) {
                                    _bgData = (BgNDataInfo)valueMap.get(dEntry2.getKey());
                                    _bgData.splitFormula();
                                    BigDecimal v1 = DimUtils.getValue(_bgData, valueType, scenObjMap) != null ? DimUtils.getValue(_bgData, valueType, scenObjMap) : BigDecimal.ZERO;
                                    BigDecimal v2 = DimUtils.getValue((IBgNData)dEntry2.getValue(), valueType, scenObjMap) != null ? DimUtils.getValue((IBgNData)dEntry2.getValue(), valueType, scenObjMap) : BigDecimal.ZERO;
                                    BigDecimal multiValue = v1.add(v2);
                                    DimUtils.setValue(_bgData, multiValue, valueType, scenObjMap);
                                    continue;
                                }
                                dataInfo = new BgNDataInfo();
                                dataInfo.copyValue((IBgNData)dEntry2.getValue());
                                dataInfo.setBgVersion(((IBgNData)dEntry2.getValue()).getBgVersion());
                                dataInfo.setOrgUnitId(((BgNDataInfo)dEntry2.getValue()).getOrgUnitId());
                                dataInfo.setFormula(((IBgNData)dEntry2.getValue()).getFormula());
                                valueMap.put(dEntry2.getKey(), dataInfo);
                            }
                            continue;
                        }
                        if (tmpValue.isEmpty()) continue;
                        HashMap<String, BgNDataInfo> newTmpValue = new HashMap<String, BgNDataInfo>();
                        for (String keyFormmula : tmpValue.keySet()) {
                            _bgData = (BgNDataInfo)tmpValue.get(keyFormmula);
                            dataInfo = new BgNDataInfo();
                            dataInfo.copyValue(_bgData);
                            dataInfo.setBgVersion(_bgData.getBgVersion());
                            dataInfo.setOrgUnitId(_bgData.getOrgUnitId());
                            dataInfo.setFormula(_bgData.getFormula());
                            newTmpValue.put(keyFormmula, dataInfo);
                        }
                        orgValueMap.put(this.getBgDataKey(orgUnitNum, processType, dataState), newTmpValue);
                    }
                    continue;
                }
                if (orgUnitMap.get(schemeNum) == null || orgUnitMap.get(schemeNum).get(orgUnitNum) == null) continue;
                orgUnitId = orgUnitMap.get(schemeNum).get(orgUnitNum).getOrgUnitID();
                String newBatchKey = null;
                newBatchKey = !StringUtils.isEmpty((String)orgAndSchStr[3]) ? orgUnitNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + orgAndSchStr[3] + "!" + dataState : orgUnitNum.trim() + "!" + orgAndSchStr[1] + "!" + orgAndSchStr[2] + "!" + dataState;
                if (type == null || !((value = dataMap == null ? null : dataMap.get(newBatchKey)) instanceof Map)) continue;
                Map _tmpMap = (Map)value;
                if (schValueMap.containsKey(schemeNum)) {
                    orgValueMap = (Map)schValueMap.get(schemeNum);
                } else {
                    orgValueMap = new HashMap();
                    schValueMap.put(schemeNum, orgValueMap);
                }
                if (!_tmpMap.containsKey(orgUnitId)) continue;
                Map tmpValue = (Map)_tmpMap.get(orgUnitId);
                if (orgValueMap.containsKey(this.getBgDataKey(orgUnitNum, processType, dataState))) {
                    Map valueMap = (Map)orgValueMap.get(this.getBgDataKey(orgUnitNum, processType, dataState));
                    Map.Entry dEntry3 = null;
                    for (Map.Entry dEntry3 : tmpValue.entrySet()) {
                        if (valueMap.containsKey(dEntry3.getKey())) {
                            _bgData = (BgNDataInfo)valueMap.get(dEntry3.getKey());
                            DimUtils.setValue(_bgData, DimUtils.getValue((IBgNData)dEntry3.getValue(), valueType, scenObjMap), valueType, scenObjMap);
                            continue;
                        }
                        valueMap.put(dEntry3.getKey(), dEntry3.getValue());
                    }
                    continue;
                }
                orgValueMap.put(this.getBgDataKey(orgUnitNum, processType, dataState), (HashMap<String, Map>)tmpValue);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(conn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)conn);
        return schValueMap;
    }

    protected void setCustState(IDimensionParameter parameter, String dataState) {
        if ("Edited".equalsIgnoreCase(dataState)) {
            parameter.getDataManager().getCustomState().add(1);
        } else if ("Approving".equalsIgnoreCase(dataState)) {
            parameter.getDataManager().getCustomState().add(3);
        } else if ("Approved".equalsIgnoreCase(dataState)) {
            parameter.getDataManager().getCustomState().add(9);
            parameter.getDataManager().getCustomState().add(13);
            parameter.getDataManager().getCustomState().add(11);
        } else if ("Adjust".equalsIgnoreCase(dataState)) {
            parameter.getDataManager().getCustomState().add(9);
            parameter.getDataManager().getCustomState().add(13);
            parameter.getDataManager().getCustomState().add(11);
            parameter.getDataManager().getCustomState().add(5);
            parameter.getControlManager().setAdjust(true);
        }
    }

    protected IDimensionParameter transDimParameter(String orgUnitNum, String schemeNum, List<IFormula> formulaList, int valueType, AggregateDataTypeEnum type, Map<String, Map<String, BgOrgUnitInfo>> orgUnitMap, String errorMsg) throws Exception {
        IDimensionParameter parameter = null;
        BgAggregateInfo formula = null;
        parameter = ExpressionUtils.transDimParameter(this.getCalculator(), orgUnitNum, schemeNum, formulaList, valueType);
        if (parameter != null) {
            parameter.getControlManager().setHasQueryDataState(false);
            parameter.addPeriodStandardNumber(this.periodStandardNumber);
            if (this.getDefaultValue() != null && this.getDefaultValue().getTemplateId() != null) {
                parameter.setBgTemplateId(new BOSUuid[]{BOSUuid.read((String)this.getDefaultValue().getTemplateId())});
            }
            if (this.isCalcTmpValue()) {
                parameter.getControlManager().setAdjust(true);
            } else {
                parameter.getControlManager().setAdjust(false);
            }
            int in = formulaList.size();
            for (int i = 0; i < in; ++i) {
                formula = (BgAggregateInfo)formulaList.get(i);
                formula.setDataType(type.getValue());
            }
            parameter.getDataManager().setBgOrgUnit(orgUnitMap.get(schemeNum).get(orgUnitNum));
            this.dealBizCalcTrace(parameter);
        }
        if (this.getCalculator().getContext().get((Object)ISCALCBIZ) instanceof Boolean && !((Boolean)this.getCalculator().getContext().get((Object)ISCALCBIZ)).booleanValue()) {
            parameter.setCalcBiz(false);
        }
        return parameter;
    }

    public void dealBizCalcTrace(IDimensionParameter parameter) {
        if (parameter != null && this.getCalculator().getContext().get((Object)"BizCalcTraceResult") != null) {
            BizCalcTraceResult calcResult = (BizCalcTraceResult)this.getCalculator().getContext().get((Object)"BizCalcTraceResult");
            BizCalcStrategy calcStrategy = null;
            if (parameter.getDataManager().getCalcStrategy() == null) {
                calcStrategy = new BizCalcStrategy();
                parameter.getDataManager().setCalcStrategy(calcStrategy);
            } else {
                calcStrategy = parameter.getDataManager().getCalcStrategy();
            }
            calcStrategy.setBizCalcTraceResult(calcResult);
        }
    }

    public boolean checkIsSelfBgForm() throws EASBizException, BOSException {
        BgTemplateInfo bgTemplateInfo;
        String bgTemplateId;
        return this.getCalculator().getProvider() != null && this.getCalculator().getProvider().getReportAdapter() != null && this.getCalculator().getProvider().getReportAdapter().getReportProperty("BG_TEMPLATE_ID") != null && !StringUtils.isEmpty((String)(bgTemplateId = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("BG_TEMPLATE_ID"))) && (bgTemplateInfo = BgTemplateFactory.getLocalInstance(this.getCalculator().getContext()).getBgTemplateInfo("select id, bgType.number where id = '" + bgTemplateId + "'")) != null && bgTemplateInfo.getBgType() != null && bgTemplateInfo.getBgType().getNumber().equals("SelfDefineAnalysisTemplateGroup");
    }

    private String getBgDataKey(String orgUnitNum, BgProcessEnum processType, String dataState) {
        return orgUnitNum + "!" + (processType == null ? -1 : processType.getValue()) + "!" + dataState;
    }

    private Map<String, Map<String, BgOrgUnitInfo>> queryOrgUnitMap(Context context, Map<String, Set<String>> bgSchemeMap) throws BOSException {
        final HashMap<String, Map<String, BgOrgUnitInfo>> orgUnitMap = new HashMap<String, Map<String, BgOrgUnitInfo>>();
        if (bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return orgUnitMap;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)context);
            final HashMap schemeViewIdMap = new HashMap();
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgScheme.FNumber, dimMember.FMemberId FROM T_MBG_BgScheme bgScheme, T_MBg_BgDimSettings dimSettings, T_MBG_BgDimSettingsMember dimMember Where bgScheme.FID = dimSettings.FBgSchemeId AND ");
            sql.append("dimSettings.FID = dimMember.FBgDimSettingsId AND dimMember.FType = ").append(2).append(" AND bgScheme.FNumber IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgSchemeMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String number = res.getString("FNumber");
                    String id = res.getString("FMemberId");
                    if (!schemeViewIdMap.containsKey(id)) {
                        schemeViewIdMap.put(id, new HashSet());
                    }
                    ((Set)schemeViewIdMap.get(id)).add(number);
                }
            });
            HashSet<String> orgNumbers = new HashSet<String>();
            for (Set<String> set : bgSchemeMap.values()) {
                orgNumbers.addAll(set);
            }
            sql.setLength(0);
            sql.append("Select FID, FOrgUnitId, FNumber, FViewId, FLongNumber, FLevel, FIsLeaf FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 and  FViewId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)schemeViewIdMap.size()).append(") AND FNumber IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])schemeViewIdMap.keySet().toArray(), (Object[])orgNumbers.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String number = res.getString("FNumber");
                    String id = res.getString("FID");
                    String orgUnitId = res.getString("FOrgUnitId");
                    String viewId = res.getString("FViewId");
                    BgOrgUnitInfo orgUnit = new BgOrgUnitInfo();
                    orgUnit.setLongNumber(res.getString("FLongNumber"));
                    orgUnit.setIsLeaf(res.getBoolean("FIsLeaf"));
                    orgUnit.setLevel(res.getInt("FLevel"));
                    orgUnit.setId(BOSUuid.read((String)id));
                    orgUnit.setNumber(number);
                    orgUnit.setOrgUnitID(orgUnitId);
                    orgUnit.setViewID(viewId);
                    for (String schemNumber : (Set)schemeViewIdMap.get(viewId)) {
                        if (!orgUnitMap.containsKey(schemNumber)) {
                            orgUnitMap.put(schemNumber, new HashMap());
                        }
                        ((Map)orgUnitMap.get(schemNumber)).put(number, orgUnit);
                    }
                }
            });
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnitMap;
    }

    private AggregateDataTypeEnum getEnum(String dataType) {
        if (StringUtils.isEmpty((String)dataType)) {
            return null;
        }
        AggregateDataTypeEnum _enum = null;
        List list = AggregateDataTypeEnum.getEnumList();
        int in = list.size();
        for (int i = 0; i < in; ++i) {
            _enum = (AggregateDataTypeEnum)((Object)list.get(i));
            if (!_enum.getName().equals(dataType)) continue;
            return _enum;
        }
        return null;
    }

    private int getValueType(AggregateDataTypeEnum enumType, String dataState) {
        int valueType = 1;
        if ("1".equals(enumType.getValue())) {
            valueType = 4;
        } else if ("3".equals(enumType.getValue())) {
            if (StringUtils.isEmpty((String)dataState) || "Approved".equalsIgnoreCase(dataState)) {
                valueType = 32;
            } else if ("All".equalsIgnoreCase(dataState)) {
                valueType = 16;
            } else if ("Edited".equalsIgnoreCase(dataState)) {
                valueType = 2048;
            }
        }
        return valueType;
    }

    protected Map<String, BigDecimal> queryDetailData(Connection conn, String bgSchemeNum, String orgUnitNum, List<IFormula> formulas, int valueType) throws Exception {
        Map<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        if (conn == null || StringUtils.isEmpty((String)bgSchemeNum) || StringUtils.isEmpty((String)orgUnitNum) || formulas == null) {
            return valueMap;
        }
        if (valueType == 4) {
            return valueMap;
        }
        BgDataQueryUtils utils = BgDataQueryUtils.getInstance();
        utils.setQueryTmpData(this.isCalcTmpValue() && this.checkHasBudget(valueType));
        Map<String, BigDecimal> tmpMap = utils.queryDetailData(this.getCalculator().getContext(), bgSchemeNum, orgUnitNum, formulas, valueType);
        if (tmpMap != null) {
            valueMap = tmpMap;
        }
        return valueMap;
    }

    private boolean checkHasBudget(int valueType) {
        return valueType == 1 || valueType == 2;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map schValueMap = (Map)value;
            Map orgValueMap = null;
            Map valueMap = null;
            IBgNData bgData = null;
            BgAggregateInfo formula = null;
            BigDecimal val = null;
            String dimNumber2 = null;
            String refField = null;
            String[] formulas = null;
            String[] params = null;
            String[] dimNums = null;
            String[] tmpStrs = null;
            HashMap<String, String> dimMember = new HashMap<String, String>();
            MbgDimInfo dimensionInfo = null;
            IFormulaCacheManager cache = this.getCalculator().getCacheManager();
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgAggregateInfo)this.getCalculator().getFormula().get(i);
                val = BgNConstants.ZERO;
                if (!formula.isCalculate() || formula.getParameter().getValue() != null) continue;
                orgValueMap = (Map)schValueMap.get(formula.getBgSchemeNumber());
                if (orgValueMap == null) {
                    formula.getParameter().setValue((Object)val);
                    continue;
                }
                if (formula.getDataType().equals(AggregateDataTypeEnum.actual.getValue())) {
                    formula.setDataState("Approved");
                }
                if ((valueMap = (Map)orgValueMap.get(this.getBgDataKey(formula.getOrgUnitNumber(), BgProcessEnum.getEnum(formula.getProcessTypeValue()), formula.getDataState()))) == null) {
                    formula.getParameter().setValue((Object)val);
                    continue;
                }
                formulas = formula.getFormulas();
                int jn = formulas.length;
                for (int j = 0; j < jn; ++j) {
                    params = BgNFSHelper.parseFormulaPara(formulas[j]);
                    dimMember.clear();
                    dimNums = params[0].split(",");
                    if (dimNums != null) {
                        for (String dimNumber2 : dimNums) {
                            tmpStrs = dimNumber2.split(":");
                            if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = cache.getMbgDimMap().get(tmpStrs[0])) == null) continue;
                            dimMember.put(dimensionInfo.getRefField(), dimNumber2);
                        }
                        int xn = cache.getRefFields(formula.getBgSchemeNumber()).size();
                        for (int x = 0; x < xn; ++x) {
                            refField = cache.getRefFields(formula.getBgSchemeNumber()).get(x);
                            dimNumber2 = dimMember.containsKey(refField) ? (String)dimMember.get(refField) : cache.getDefaultMember().get(refField);
                            params[0] = x == 0 ? dimNumber2 : params[0] + "," + dimNumber2;
                        }
                        formulas[j] = BgNFSHelper.getFormulaFromParam(params);
                    }
                    if ((bgData = (IBgNData)valueMap.get(DimUtils.getDimDataKey(formulas[j], formula.getBgVersionNumber()))) == null) continue;
                    if (formula.getDataType().equals(AggregateDataTypeEnum.budget.getValue())) {
                        val = val.add(bgData.getBudgetValue());
                        continue;
                    }
                    if (formula.getDataType().equals(AggregateDataTypeEnum.actual.getValue())) {
                        val = val.add(bgData.getBizActual());
                        continue;
                    }
                    if (!formula.getDataType().equals(AggregateDataTypeEnum.addActual.getValue())) continue;
                    val = val.add(bgData.getAddActualValue());
                }
                formula.getParameter().setValue((Object)val);
            }
        }
    }

    protected IDimensionParameter mergeParameter(IDimensionParameter oldParameter, IDimensionParameter newParameter) {
        Map<String, IDimension> newDimMap = newParameter.getDimensionMap();
        String key2 = null;
        IDimension dim = null;
        for (String key2 : newDimMap.keySet()) {
            if (oldParameter.getDimensionMap().containsKey(key2)) {
                dim = newDimMap.get(key2);
                if (dim.getDimensionMember().isEmpty()) continue;
                for (int i = 0; i < dim.getDimensionMember().size(); ++i) {
                    oldParameter.getDimensionMap().get(key2).addMember(dim.getDimensionMember().get(i));
                }
                continue;
            }
            oldParameter.getDimensionMap().put(key2, newDimMap.get(key2));
        }
        oldParameter.getExpressionParams().addAll(newParameter.getExpressionParams());
        return oldParameter;
    }

    @Override
    protected void afterSetDefaultValue(IReportPropertyAdapter adapter, DefaultFormulaValue value) {
        super.afterSetDefaultValue(adapter, value);
        if (value instanceof BgAggregateFormulaValue) {
            BgAggregateFormulaValue _value = (BgAggregateFormulaValue)value;
            String defOrgTree = (String)adapter.getReportProperty("CSLReport_OrgTree_Number");
            String defOrgGroup = (String)adapter.getReportProperty("CSLReport_OrgUnit_Group");
            String defOrgTreeId = (String)adapter.getReportProperty("CSLReport_OrgTree_ID");
            if (!StringUtils.isEmpty((String)defOrgTreeId)) {
                if (!StringUtils.isEmpty((String)defOrgGroup)) {
                    this.setOrgUnitNumberForTree(_value, defOrgTreeId, defOrgGroup, true);
                }
            } else if (!StringUtils.isEmpty((String)defOrgTree) && !StringUtils.isEmpty((String)defOrgGroup)) {
                this.setOrgUnitNumberForTree(_value, defOrgTree, defOrgGroup, false);
            }
        }
    }

    private void setOrgUnitNumberForTree(BgAggregateFormulaValue _value, String defOrgTree, String defOrgGroup, boolean isTreeId) {
        Context ctx = this.getCalculator().getContext();
        StringBuffer querySql = new StringBuffer();
        String longnumber = null;
        String number = "";
        boolean isUnion = true;
        IRowSet rs = null;
        try {
            querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,ORGSTRUCTURE.FLONGNUMBER,UNIT.FISUNION FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID");
            if (isTreeId) {
                querySql.append(" WHERE TREE.FID  = '");
            } else {
                querySql.append(" WHERE TREE.FNUMBER  = '");
            }
            querySql.append(defOrgTree).append("' AND UNIT.FNUMBER  = '").append(defOrgGroup).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (rs.next()) {
                longnumber = rs.getString("FLONGNUMBER");
                isUnion = rs.getBoolean("FISUNION");
            }
            if (isUnion && longnumber != null) {
                querySql = new StringBuffer();
                querySql.append("SELECT UNIT.FID,UNIT.FNUMBER FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID");
                if (isTreeId) {
                    querySql.append(" WHERE TREE.FID  = '");
                } else {
                    querySql.append(" WHERE TREE.FNUMBER  = '");
                }
                querySql.append(defOrgTree).append("' AND UNIT.FISUNION =0 AND ORGSTRUCTURE.FLONGNUMBER  LIKE '").append(longnumber).append("!%'");
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                while (rs.next()) {
                    number = rs.getString("FNUMBER") + ";" + number;
                }
                number = number.substring(0, number.length() - 1);
                _value.setOrgUnitNumber(number);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }
}

