/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.aggregate;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateFormulaValue;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BgAggregateInfo
extends FormulaInfo {
    private String dataType = null;
    private String batchKey = null;
    private String processType = null;
    private String dataState = "";
    public static final String DATASTATE_ALL = "All";
    public static final String DATASTATE_Edited = "Edited";
    public static final String DATASTATE_Approving = "Approving";
    public static final String DATASTATE_Approved = "Approved";
    public static final String DATASTATE_Adjust = "Adjust";

    public BgAggregateInfo() {
    }

    public BgAggregateInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    public void setDataState(String dataState) {
        this.dataState = dataState == null ? "" : dataState;
    }

    public String getDataState() {
        return this.dataState;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public int getProcessTypeValue() {
        if (StringUtils.isEmpty((String)this.processType)) {
            return -1;
        }
        BgProcessEnum process = BgProcessEnum.getEnum(this.getProcessType());
        if (process == null) {
            return -1;
        }
        return process.getValue();
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        super.parseParameter(value);
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = FormulaUtils.updateParams("MbgAggregate", this.getParameter());
        Variant variant = (Variant)params[3];
        if (variant.getValue() != null) {
            this.setBgItemNumber(this.getBgDimNumber(variant.getValue().toString()));
        }
        if ((variant = (Variant)params[9]).getValue() != null) {
            this.setDataType(variant.getValue().toString());
        }
        if (this.getDataType().equalsIgnoreCase(AggregateDataTypeEnum.addActual.getName())) {
            this.setBgVersionNumber("Ve");
        }
        if (AggregateDataTypeEnum.budget.getName().equalsIgnoreCase(this.getDataType()) || AggregateDataTypeEnum.addActual.getName().equalsIgnoreCase(this.getDataType())) {
            variant = (Variant)params[10];
            this.setDataState(StringUtils.cnulls((Object)variant.getValue()));
        } else {
            this.setDataState("");
        }
        variant = (Variant)params[11];
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)variant.getValue()))) {
            this.setProcessType(StringUtils.cnulls((Object)variant.getValue()).toUpperCase());
        }
    }

    private String getBgDimNumber(String bgDimNumber) {
        if (StringUtils.isEmpty((String)bgDimNumber)) {
            return bgDimNumber;
        }
        Map<String, MbgDimInfo> mbgDimMap = this.getCalculator().getCacheManager().getMbgDimMap();
        TreeMap<String, String> dimMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] tmpNums = bgDimNumber.split(",");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            String[] tmpStr = tmpNums[i].split(":");
            if (!mbgDimMap.containsKey(tmpStr[0])) {
                this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)new DimensionException(DimensionException.MEMBERNOTFIND, new Object[]{tmpStr[0]}).getMessage()));
                return "";
            }
            dimMap.put(mbgDimMap.get(tmpStr[0]).getRefField(), tmpNums[i]);
        }
        StringBuffer dimNumber = new StringBuffer();
        Iterator iter = dimMap.values().iterator();
        while (iter.hasNext()) {
            dimNumber.append((String)iter.next() + ",");
        }
        dimNumber = dimNumber.delete(dimNumber.length() - 1, dimNumber.length());
        return dimNumber.toString();
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            Map<String, MbgDimInfo> dimInfoMap = this.getCalculator().getCacheManager().getMbgDimMap();
            this.batchKey = this.getOrgUnitNumber().trim() + "!" + this.getBgSchemeNumber() + "!" + this.getDataType() + "!" + this.getProcessTypeValue() + "!" + this.getDataState();
        }
        return this.batchKey;
    }

    private String getDimRefFieldKey(String bgItemNumber, Map<String, MbgDimInfo> dimInfoMap) {
        if (bgItemNumber == null || dimInfoMap == null) {
            return null;
        }
        String dimField = "";
        String[] tmpNums = this.getBgItemNumber().split(",");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            String[] tmpStr = tmpNums[i].split(":");
            dimField = dimField + dimInfoMap.get(tmpStr[0]).getRefField();
        }
        return dimField;
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        if (StringUtils.isEmpty((String)this.getDataType())) {
            this.setDataType(AggregateDataTypeEnum.budget.getName());
        }
        if (this.getProcessType() == null) {
            this.setProcessType(value.getProcessType().getName());
        }
        if (value.getOrgUnitNumber() != null && this.getOrgUnitNumber() != null && !this.getOrgUnitNumber().equals(value.getOrgUnitNumber()) && this.getOrgUnitNumber().contains("\\$")) {
            this.setOrgUnitNumber(value.getOrgUnitNumber());
        }
        String nPeriodNum = null;
        if (!this.getBeginPeriodNumber().equals(this.getEndPeriodNumber())) {
            String pKey = this.getBeginPeriodNumber() + "_" + this.getEndPeriodNumber();
            BgAggregateFormulaValue _value = (BgAggregateFormulaValue)value;
            if (_value.getAggPeriodMap().containsKey(pKey)) {
                nPeriodNum = _value.getAggPeriodMap().get(pKey);
            } else {
                nPeriodNum = this.optimisingPeriod(BgPeriodHelper.getPeriodType((Context)this.getCalculator().getContext(), (String)this.getBeginPeriodNumber()), this.getBeginPeriodNumber(), this.getEndPeriodNumber());
                _value.getAggPeriodMap().put(pKey, nPeriodNum);
            }
            if (!StringUtils.isEmpty((String)nPeriodNum)) {
                this.setBeginPeriodNumber(nPeriodNum);
                this.setEndPeriodNumber(nPeriodNum);
            }
        }
    }

    protected String optimisingPeriod(int periodType, String beginPeriodNum, String endPeirodNum) {
        if (periodType == 4) {
            return this.optimisingMonth(beginPeriodNum, endPeirodNum);
        }
        if (periodType == 3) {
            return this.optimisingQuarter(beginPeriodNum, endPeirodNum);
        }
        return null;
    }

    protected String optimisingQuarter(String beginPeriodNum, String endPeirodNum) {
        int endYear;
        String nPeriodNum = null;
        Date begin = BgNPeriodHelper.getPeriodDate((String)beginPeriodNum);
        Date end = BgNPeriodHelper.getPeriodDate((String)endPeirodNum);
        CalendarHelper helper = new CalendarHelper();
        int beginYear = helper.getCurrentlyYear(begin);
        if (beginYear == (endYear = helper.getCurrentlyYear(end))) {
            int beginQuarter = helper.getCurrentlyQuarter(begin);
            int endQuarter = helper.getCurrentlyQuarter(end);
            if (beginQuarter == 1 && endQuarter == 2) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
            } else if (beginQuarter == 3 && endQuarter == 4) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
            } else if (beginQuarter == 1 && endQuarter == 4) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.YEAR);
            }
        }
        return nPeriodNum;
    }

    protected String optimisingMonth(String beginPeriodNum, String endPeirodNum) {
        int endYear;
        String nPeriodNum = null;
        Date begin = BgNPeriodHelper.getPeriodDate((String)beginPeriodNum);
        Date end = BgNPeriodHelper.getPeriodDate((String)endPeirodNum);
        CalendarHelper helper = new CalendarHelper();
        int beginYear = helper.getCurrentlyYear(begin);
        if (beginYear == (endYear = helper.getCurrentlyYear(end))) {
            int beginMonth = helper.getCurrentlyMonth(begin);
            int endMonth = helper.getCurrentlyMonth(end);
            if (beginMonth == 1) {
                if (endMonth == 3) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                } else if (endMonth == 6) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
                } else if (endMonth == 12) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.YEAR);
                }
            } else if (beginMonth == 4) {
                if (endMonth == 6) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                }
            } else if (beginMonth == 7) {
                if (endMonth == 9) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                } else if (endMonth == 12) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
                }
            } else if (beginMonth == 10 && endMonth == 12) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
            }
        }
        return nPeriodNum;
    }
}

