/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.avlbal;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.IBgControlFacade;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.avlbal.BgAvlBalInfo;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAvlBalCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.avlbal.BgAvlBalCalculateUtils");

    public BgAvlBalCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgAvlBalInfo(this.getCalculator(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        String batchKey = null;
        String orgUnitNum = null;
        String schemeNum = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList2 = null;
        ArrayList<String> formulas = new ArrayList<String>();
        Map.Entry<String, List<IFormula>> entry2 = null;
        BgAvlBalInfo formula = null;
        BgControlParam controlParam = null;
        BOSUuid orgUnitId = null;
        BOSUuid schemeId = null;
        HashMap valueMap = new HashMap();
        Map<String, BgControlParam> controlMap = null;
        Map<String, List<IFormula>> batchMap = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            IBgControlFacade BgControlFacade = BgControlFacadeFactory.getLocalInstance((Context)this.getCalculator().getContext());
            batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
            for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                batchKey = entry2.getKey();
                formulaList2 = entry2.getValue();
                orgAndSchStr = batchKey.split("!");
                orgUnitNum = orgAndSchStr[0];
                schemeNum = orgAndSchStr[1];
                orgUnitId = MbgDataHelper.getBaseOrgUnitByNumber(conn, this.getCalculator().getContext().getLocale(), orgUnitNum).getId();
                schemeId = MbgDataHelper.getBgSchemeByNumber(conn, this.getCalculator().getContext().getLocale(), schemeNum).getId();
                int in = formulaList2.size();
                for (int i = 0; i < in; ++i) {
                    formula = (BgAvlBalInfo)formulaList2.get(i);
                    if (formula.getFormulas() == null || formula.getFormulas().length <= 0) continue;
                    formulas.add(formula.getFormulas()[formula.getFormulas().length - 1] + "_" + formula.getAcScenarioNumber());
                }
                IBudgetBalance balance = BgControlFacade.queryBalance(schemeId, orgUnitId, formulas, false);
                if (valueMap.containsKey(batchKey)) {
                    controlMap = (Map)valueMap.get(batchKey);
                } else {
                    controlMap = new HashMap();
                    valueMap.put(batchKey, controlMap);
                }
                if (balance == null) continue;
                int jn = balance.getBalance().size();
                for (int j = 0; j < jn; ++j) {
                    controlParam = (BgControlParam)balance.getBalance().get(j);
                    controlMap.put(controlParam.getFormula(), controlParam);
                }
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"bgAvlBal Calculate Error:", (Throwable)ex);
                SyntaxErrorException error = new SyntaxErrorException(128L);
                for (List<IFormula> formulaList2 : this.getCalculator().getCacheManager().getBatchKeyMap().values()) {
                    int in = formulaList2.size();
                    for (int i = 0; i < in; ++i) {
                        formula = (BgAvlBalInfo)formulaList2.get(i);
                        formula.getParameter().setValue((Object)error);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup((Connection)conn);
        return valueMap;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map dataMap = (Map)value;
            Map controlMap = null;
            BgControlParam controlParam = null;
            BgAvlBalInfo formula = null;
            String[] formulas = null;
            String formulaStr = null;
            String key = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgAvlBalInfo)this.getCalculator().getFormula().get(i);
                if (!formula.isCalculate() || formula.getParameter().getValue() != null) continue;
                key = formula.getOrgUnitNumber() + "!" + formula.getBgSchemeNumber();
                controlMap = (Map)dataMap.get(key);
                if (controlMap == null || controlMap.isEmpty()) {
                    formula.getParameter().setValue((Object)BigDecimal.ZERO);
                    continue;
                }
                formulas = formula.getFormulas();
                formulaStr = formulas[formulas.length - 1];
                if (!controlMap.containsKey(formulaStr)) continue;
                controlParam = (BgControlParam)controlMap.get(formulaStr);
                if (controlParam.getExtBalance() != null) {
                    formula.getParameter().setValue((Object)controlParam.getExtBalance());
                    continue;
                }
                if (controlParam.getBalance() != null) {
                    formula.getParameter().setValue((Object)controlParam.getBalance());
                    continue;
                }
                formula.getParameter().setValue((Object)BigDecimal.ZERO);
            }
        }
    }
}

