/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.bgcreatedate;

import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.bgcreatedate.BgCreateDateInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgCreateDateCalculateUtils
extends AbstractCalculateUtils {
    public BgCreateDateCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgCreateDateInfo(this.getCalculator(), parameter);
    }

    @Override
    public void beforeCommonInit() throws Exception {
    }

    @Override
    protected void beforeCalculate() throws Exception {
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        String batchKey = null;
        String formateKey = null;
        Object bgPeriodId = null;
        List<IFormula> formulas = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Date date = new Date();
        String value = null;
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            SimpleDateFormat dateFormat;
            batchKey = entry2.getKey();
            formulas = entry2.getValue();
            date = ((BgCreateDateInfo)formulas.get(0)).getCreateDate();
            Calendar calendar = Calendar.getInstance();
            if (!"l1".equalsIgnoreCase(this.getCalculator().getContext().getLocale().getDisplayName())) {
                calendar.setFirstDayOfWeek(2);
            }
            calendar.setTime(date);
            if (batchKey.equalsIgnoreCase("yyyy")) {
                formateKey = "yyyy";
                value = new SimpleDateFormat(formateKey).format(date);
            } else if (batchKey.equalsIgnoreCase("mm")) {
                formateKey = "MM";
                value = new SimpleDateFormat(formateKey).format(date);
            } else if (batchKey.equalsIgnoreCase("dd")) {
                formateKey = "dd";
                value = new SimpleDateFormat(formateKey).format(date);
            } else if (batchKey.equalsIgnoreCase("yyyy-mm")) {
                formateKey = "yyyy-MM";
                value = new SimpleDateFormat(formateKey).format(date);
            } else if (batchKey.equalsIgnoreCase("yyyy-mm-dd")) {
                formateKey = "yyyy-MM-dd";
                value = new SimpleDateFormat(formateKey).format(date);
            } else if (batchKey.equalsIgnoreCase("yyyy-mm-ww")) {
                formateKey = "yyyy-MM-WW";
                dateFormat = new SimpleDateFormat(formateKey);
                dateFormat.setCalendar(calendar);
                value = dateFormat.format(date);
            } else if (batchKey.equalsIgnoreCase("yyyy-ww")) {
                dateFormat = new SimpleDateFormat("yyyy-ww");
                dateFormat.setCalendar(calendar);
                Calendar maxSundayOfYear = this.getMaxSundayOfYear(calendar.get(1));
                value = calendar.after(maxSundayOfYear) ? new SimpleDateFormat("yyyy").format(maxSundayOfYear.getTime()) + "-" + (maxSundayOfYear.get(3) + 1) : dateFormat.format(date);
            }
            valueMap.put(batchKey, value);
        }
        return valueMap;
    }

    private Calendar getMaxSundayOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        int dayOfWeek = c.get(7);
        ((Calendar)c).add(6, dayOfWeek * -1);
        return c;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map dataMap = (Map)value;
            BgCreateDateInfo formula = null;
            String val = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgCreateDateInfo)this.getCalculator().getFormula().get(i);
                if (formula.isCalculate()) {
                    val = (String)dataMap.get(formula.getBatchCalculateKey());
                    formula.getParameter().setValue((Object)val);
                    continue;
                }
                formula.getParameter().setValue((Object)BgCreateDateInfo.badException);
            }
        }
    }
}

