/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.bgcsl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.bgcsl.BgCslFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.bgcsl.BgCslInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslCalculateUtils
extends AbstractCalculateUtils {
    private DimensionCacheHelper cacheHelper = null;
    private static final Logger logger = CoreUIObject.getLogger(BgCslCalculateUtils.class);
    private OrgTreeInfo orgTreeInfo = null;
    private String periodStandardNumber = null;
    private Map<String, List<String>> schemeRefFieldsMap = new HashMap<String, List<String>>();

    public BgCslCalculateUtils(IBgCalculator calculator) {
        super(calculator);
        this.cacheHelper = new DimensionCacheHelper(calculator.getContext());
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgCslInfo(this.getCalculator(), parameter);
    }

    @Override
    public void beforeCommonInit() throws Exception {
        super.beforeCommonInit();
        ExpressionUtils.queryDimInfo(this.getCalculator());
        this.initCslInfo();
    }

    private void initCslInfo() throws ParseException {
        Object orgTreeNumberObj = this.getCalculator().getProvider().getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        Object orgUnitNumberObj = this.getCalculator().getProvider().getReportAdapter().getReportProperty("CSLReport_OrgUnit_Group");
        Object orgTreeIdObj = this.getCalculator().getProvider().getReportAdapter().getReportProperty("CSLReport_OrgTree_ID");
        String orgTreeNumber = null;
        if (orgTreeNumberObj != null) {
            orgTreeNumber = orgTreeNumberObj.toString();
            this.orgTreeInfo = this.cacheHelper.getOrgTreeInfoByNumber(this.getCalculator().getContext(), orgTreeNumber);
        } else if (orgTreeIdObj != null) {
            this.orgTreeInfo = this.cacheHelper.getOrgTreeInfoById(this.getCalculator().getContext(), orgTreeIdObj.toString());
            orgTreeNumber = this.orgTreeInfo.getNumber();
        }
        IReportPropertyAdapter adapter = this.getCalculator().getProvider().getReportAdapter();
        this.periodStandardNumber = adapter.getReportProperty("BG_PERIOD_NUMBER") != null ? (String)adapter.getReportProperty("BG_PERIOD_NUMBER") : this.getDefaultPeriodNumByReport(adapter);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getOrgTreeNumber() {
        String orgTreeNumber = null;
        orgTreeNumber = this.orgTreeInfo == null && this.getDefaultValue() != null ? ((BgCslFormulaValue)this.getDefaultValue()).getOrgTreeNumber() : this.orgTreeInfo.getNumber();
        return orgTreeNumber;
    }

    private Map<String, Map<String, OrgUnitInfo>> queryUnionDebtByNumber(Connection conn, Set<String> batchKey) throws Exception {
        HashMap<String, Map<String, OrgUnitInfo>> orgNumInfoMap = new HashMap<String, Map<String, OrgUnitInfo>>();
        if (batchKey == null || batchKey.isEmpty()) {
            return orgNumInfoMap;
        }
        String curKey22 = null;
        String orgUnionNumber = null;
        String orgTreeNumber = null;
        String[] orgAndSchStr = null;
        OrgUnitInfo orgUnitInfo = null;
        HashSet<String> unionNumSet = null;
        StringBuffer querySql = new StringBuffer();
        HashMap orgTreeNumMap = new HashMap();
        IRowSet rs = null;
        try {
            OrgTreeInfo orgTree = null;
            String orgTreeId = null;
            for (String curKey22 : batchKey) {
                orgAndSchStr = curKey22.split("!");
                orgUnionNumber = orgAndSchStr[0];
                orgTreeNumber = orgAndSchStr[2];
                orgTree = this.cacheHelper.getOrgTreeInfoByNumber(this.getCalculator().getContext(), orgTreeNumber);
                if (orgTree == null) continue;
                orgTreeId = orgTree.getId().toString();
                if (orgTreeNumMap.containsKey(orgTreeId)) {
                    if (orgUnionNumber.contains(";")) {
                        String[] stringArray;
                        for (String orgNumber : stringArray = orgUnionNumber.split(";")) {
                            ((Set)orgTreeNumMap.get(orgTreeId)).add(orgNumber);
                        }
                        continue;
                    }
                    ((Set)orgTreeNumMap.get(orgTreeId)).add(orgUnionNumber);
                    continue;
                }
                unionNumSet = new HashSet<String>();
                orgTreeNumMap.put(orgTreeId, unionNumSet);
                if (orgUnionNumber.contains(";")) {
                    String[] stringArray;
                    for (String orgNumber : stringArray = orgUnionNumber.split(";")) {
                        unionNumSet.add(orgNumber);
                    }
                    continue;
                }
                ((Set)orgTreeNumMap.get(orgTreeId)).add(orgUnionNumber);
            }
            for (Map.Entry entry : orgTreeNumMap.entrySet()) {
                orgNumInfoMap.put((String)entry.getKey(), new HashMap());
                querySql.setLength(0);
                querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append((String)entry.getKey()).append("' AND UNIT.FNUMBER  IN ").append(this.getAppendStrByColls((Set)entry.getValue()));
                rs = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString());
                while (rs.next()) {
                    orgUnitInfo = new OrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    orgUnitInfo.setName(rs.getString("FNAME_l2"));
                    orgUnitInfo.setNumber(rs.getString("FNUMBER"));
                    ((Map)orgNumInfoMap.get(entry.getKey())).put(orgUnitInfo.getNumber(), orgUnitInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return orgNumInfoMap;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Set actScenarios = null;
            try {
                actScenarios = BgScenarioHelper.getAcScenarioNumbers((Context)this.getCalculator().getContext());
            }
            catch (SQLException e1) {
                logger.error((Object)"", (Throwable)e1);
                throw new RuntimeException(e1);
            }
            Map curOrgDataMap = null;
            Map queryBgDataMap = (Map)value;
            BgCslInfo formula = null;
            String[] formulas = null;
            IBgNData bgData = null;
            BigDecimal val = null;
            IFormulaCacheManager cache = this.getCalculator().getCacheManager();
            OrgTreeInfo orgTree = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgCslInfo)this.getCalculator().getFormula().get(i);
                try {
                    orgTree = this.cacheHelper.getOrgTreeInfoByNumber(this.getCalculator().getContext(), formula.getOrgTreeNumber());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                curOrgDataMap = null;
                if (orgTree != null && queryBgDataMap.containsKey(orgTree.getId().toString())) {
                    curOrgDataMap = (Map)((Map)queryBgDataMap.get(orgTree.getId().toString())).get(formula.getOrgUnitNumber());
                }
                formulas = formula.getFormulas();
                this.fillDefaultDimItemNumber(this.schemeRefFieldsMap.get(formula.getBgSchemeNumber()), cache, formulas);
                val = BgNConstants.ZERO;
                if (curOrgDataMap != null) {
                    for (int k = 0; k < formulas.length; ++k) {
                        bgData = (IBgNData)curOrgDataMap.get(DimUtils.getDimDataKey(formulas[k], formula.getBgVersionNumber()));
                        if (bgData == null) continue;
                        val = actScenarios != null && actScenarios.contains(formula.getBgScenarioNumber()) ? val.add(bgData.getBizActual()) : val.add(bgData.getBudgetValue());
                    }
                }
                formula.getParameter().setValue((Object)val);
            }
        }
    }

    private void fillDefaultDimItemNumber(List<String> schemeRefFieldsList, IFormulaCacheManager cacheManager, String[] formulas) {
        if (schemeRefFieldsList == null || cacheManager == null || formulas == null || formulas.length == 0) {
            return;
        }
        String dimNumber2 = null;
        String refField = null;
        String[] params = null;
        String[] dimNums = null;
        String[] tmpStrs = null;
        HashMap<String, String> dimMember = new HashMap<String, String>();
        MbgDimInfo dimensionInfo = null;
        int jn = formulas.length;
        for (int j = 0; j < jn; ++j) {
            params = BgNFSHelper.parseFormulaPara(formulas[j]);
            dimMember.clear();
            dimNums = params[0].split(",");
            if (dimNums == null) continue;
            for (String dimNumber2 : dimNums) {
                tmpStrs = dimNumber2.split(":");
                if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = cacheManager.getMbgDimMap().get(tmpStrs[0])) == null) continue;
                dimMember.put(dimensionInfo.getRefField(), dimNumber2);
            }
            int xn = schemeRefFieldsList.size();
            for (int x = 0; x < xn; ++x) {
                refField = schemeRefFieldsList.get(x);
                dimNumber2 = dimMember.containsKey(refField) ? (String)dimMember.get(refField) : cacheManager.getDefaultMember().get(refField);
                params[0] = x == 0 ? dimNumber2 : params[0] + "," + dimNumber2;
            }
            formulas[j] = BgNFSHelper.getFormulaFromParam(params);
        }
    }

    private String getAppendStrByColls(Set<String> unionNumberSet) {
        if (unionNumberSet == null || unionNumberSet.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<String> it = unionNumberSet.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    private OrgUnitInfo getOrgUnitInfoByOrgTree(Context ctx, String orgTreeNumber, String orgUnitNumber) {
        if (ctx == null || StringUtils.isEmpty((String)orgTreeNumber) || StringUtils.isEmpty((String)orgUnitNumber)) {
            return null;
        }
        StringBuffer querySql = new StringBuffer();
        OrgUnitInfo orgUnitInfo = null;
        IRowSet rs = null;
        try {
            querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FNUMBER  = '").append(orgTreeNumber).append("' AND UNIT.FNUMBER  = '").append(orgUnitNumber).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (rs.next()) {
                orgUnitInfo = new OrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                orgUnitInfo.setName(rs.getString("FNAME_l2"));
                orgUnitInfo.setNumber(rs.getString("FNUMBER"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orgUnitInfo;
    }

    @Override
    protected DefaultFormulaValue getDefaultFormulaValue() {
        return new BgCslFormulaValue();
    }

    @Override
    protected void afterSetDefaultValue(IReportPropertyAdapter adapter, DefaultFormulaValue value) {
        super.afterSetDefaultValue(adapter, value);
        BgCslFormulaValue _value = (BgCslFormulaValue)value;
        String defOrgTree = (String)adapter.getReportProperty("CSLReport_OrgTree_Number");
        String defOrgGroup = (String)adapter.getReportProperty("CSLReport_OrgUnit_Group");
        if (!StringUtils.isEmpty((String)defOrgTree)) {
            _value.setOrgTreeNumber(defOrgTree);
        }
        if (!StringUtils.isEmpty((String)defOrgGroup)) {
            _value.setOrgUnitNumber(defOrgGroup);
        }
    }
}

