/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.bgcsl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.bgcsl.BgCslFormulaValue;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BgCslInfo
extends FormulaInfo {
    private String orgTreeNumber = null;

    public BgCslInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = this.getParameter().getArgs();
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgTreeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            this.setBgItemNumber(this.getBgDimNumber(variant.getValue().toString()));
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            this.setBeginPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setEndPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setBgVersionNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[9]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
    }

    private String getBgDimNumber(String bgDimNumber) {
        if (StringUtils.isEmpty((String)bgDimNumber)) {
            return bgDimNumber;
        }
        Map<String, MbgDimInfo> mbgDimMap = this.getCalculator().getCacheManager().getMbgDimMap();
        TreeMap<String, String> dimMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] tmpNums = bgDimNumber.split(",");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            String[] tmpStr = tmpNums[i].split(":");
            if (!mbgDimMap.containsKey(tmpStr[0])) {
                this.getParameter().setValue((Object)badException);
                return "";
            }
            dimMap.put(mbgDimMap.get(tmpStr[0]).getRefField(), tmpNums[i]);
        }
        StringBuffer dimNumber = new StringBuffer();
        Iterator iter = dimMap.values().iterator();
        while (iter.hasNext()) {
            dimNumber.append((String)iter.next() + ",");
        }
        dimNumber = dimNumber.delete(dimNumber.length() - 1, dimNumber.length());
        return dimNumber.toString();
    }

    public String getOrgTreeNumber() {
        return this.orgTreeNumber;
    }

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        BgCslFormulaValue bgCslFormula = (BgCslFormulaValue)value;
        if (StringUtils.isEmpty((String)this.getOrgTreeNumber())) {
            this.setOrgTreeNumber(bgCslFormula.getOrgTreeNumber());
        }
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber())) {
            this.setOrgUnitNumber(bgCslFormula.getOrgUnitNumber());
        }
    }

    @Override
    public String getBatchCalculateKey() {
        return this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getOrgTreeNumber();
    }

    @Override
    protected boolean checkParseParameter(DefaultFormulaValue value) {
        if (StringUtils.isEmpty((String)this.getBgVersionNumber())) {
            badException.setExtData((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgMessageResource", (String)"noBgVerion"));
            this.getParameter().setValue((Object)badException);
            return false;
        }
        boolean isGroupUnion = this.checkOrgIsUnionGroup(this.getCalculator().getContext(), this.getOrgUnitNumber());
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber()) && !isGroupUnion) {
            badException.setExtData((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgMessageResource", (String)"noUnionDebt"));
            this.getParameter().setValue((Object)badException);
            return false;
        }
        return super.checkParseParameter(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkOrgIsUnionGroup(Context ctx, String orgUnitNumber) {
        boolean check;
        block8: {
            IRowSet rowSet;
            check = false;
            if (ctx == null || StringUtils.isEmpty((String)orgUnitNumber)) {
                return check;
            }
            IFormulaCacheManager cache = this.getCalculator().getCacheManager();
            if (cache.getGroupUnit().containsKey(orgUnitNumber)) {
                check = cache.getGroupUnit().get(orgUnitNumber);
            } else {
                block7: {
                    rowSet = null;
                    rowSet = BgDBUtils.executeQuery((Context)ctx, (String)"SELECT top 1 FID FROM T_ORG_BaseUnit WHERE FISGROUPING = 1 AND FNUMBER = ?", (Object[])new Object[]{orgUnitNumber});
                    if (!rowSet.next()) break block7;
                    check = true;
                }
                SQLUtils.cleanup((ResultSet)rowSet);
                cache.getGroupUnit().put(orgUnitNumber, check);
            }
            break block8;
            catch (Exception exception) {
                SQLUtils.cleanup(rowSet);
                cache.getGroupUnit().put(orgUnitNumber, check);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rowSet);
                    cache.getGroupUnit().put(orgUnitNumber, check);
                    throw throwable;
                }
            }
        }
        return check;
    }
}

