/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.control;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.control.MbgControlInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgControlCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.control.MbgControlCalculateUtils");
    public static final String BG_VERSION_NUMBER = "bg_version_number";
    public static final String BG_SCENARIO_NUMBER = "bg_scenarioPeriod_number";
    public static final String BG_BEGINPERIOD_NUMBER = "bg_beginPeriod_number";
    public static final String BG_ENDPERIOD_NUMBER = "bg_endPeriod_number";
    public static final String BG_CURRENCY_NUMBER = "bg_currency_number";
    public static final String BG_ACCOUNT_NUMBER = "bg_account_number";
    public static final String BG_ASSITANT_NUMBER = "bg_assitant_number";
    public static final String BG_ELEMENT_NUMBER = "bg_element_number";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public MbgControlCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new MbgControlInfo(this.getCalculator(), parameter);
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        String batchKey = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap valueMap = new HashMap();
        Map<String, Map<String, IBgNData>> value = null;
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            batchKey = entry2.getKey();
            formulaList = entry2.getValue();
            orgAndSchStr = batchKey.split("!");
            String[] orgSchStrs = this.getCalculator().getCacheManager().getBgSchemeNumberMap().get(orgAndSchStr[0] + "!" + orgAndSchStr[1]);
            BOSUuid schemeId = BOSUuid.read((String)orgSchStrs[0]);
            BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), BgCubeUtils.getRefDimSelector());
            String controlCube = BgCubeUtils.getControlCubeName(schemeInfo.getRefCube());
            value = this.getResultValue(this.getCalculator().getContext(), formulaList, controlCube);
            MultiThreadQuery.mergeData(valueMap, value);
        }
        return valueMap;
    }

    public Map<String, Map<String, IBgNData>> getValue(MbgControlInfo mbgControlInfo, BigDecimal result, String orgUnitId, String formula) {
        HashMap<String, Map<String, IBgNData>> value = new HashMap<String, Map<String, IBgNData>>();
        HashMap<String, BgNViewDataInfo> innerValue = new HashMap<String, BgNViewDataInfo>();
        String[] formulas = mbgControlInfo.getFormulas();
        String innerKey = formula + "_" + mbgControlInfo.getBgVersionNumber();
        BgNViewDataInfo info = new BgNViewDataInfo();
        info.setBizActual(result);
        info.setBgElementNumber(mbgControlInfo.getBgElementNumber());
        String[] indexArray = null;
        if (mbgControlInfo.getBgItemNumber().contains(",")) {
            indexArray = mbgControlInfo.getBgItemNumber().split(",");
            info.setBgIndexNum(indexArray[0]);
        } else {
            info.setBgIndexNum(mbgControlInfo.getBgItemNumber());
        }
        info.setBgItemNumber(mbgControlInfo.getBgItemNumber());
        info.setBgScenario(mbgControlInfo.getBgScenarioNumber());
        info.setBgElementNumber(mbgControlInfo.getBgElementNumber());
        info.setBgVersion(mbgControlInfo.getBgVersionNumber());
        info.setCurrencyNumber(mbgControlInfo.getCurrencyNumber());
        info.setFormula(formula);
        info.setBgPeriodNumber(mbgControlInfo.getBeginPeriodNumber());
        info.setOrgUnitId(orgUnitId);
        innerValue.put(innerKey, info);
        value.put(orgUnitId, innerValue);
        return value;
    }

    public String getSourceOrgActul(Map<String, List<IFormula>> batchMap, IDimensionParameter parameter) throws Exception {
        HashMap resultMap = new HashMap();
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        ExeFilterParam filterParam = new ExeFilterParam();
        HashMap queryData = new HashMap();
        BgSchemeInfo schemeInfo = parameter.getDataManager().getBgScheme();
        BgOrgUnitInfo bgOrgUnitInfo = parameter.getDataManager().getBgOrgUnit();
        String controlCube = BgCubeUtils.getControlCubeName(schemeInfo.getRefCube());
        Object result = null;
        StringBuffer sql = new StringBuffer();
        BigDecimal value = new BigDecimal(0);
        String orgUnitId = new String();
        String resultString = new String();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            formulaList = entry2.getValue();
            for (IFormula iFormula : formulaList) {
            }
        }
        return resultString;
    }

    private static final String currentTime() {
        return format.format(System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Map<String, IBgNData>> getResultValue(Context ctx, List<IFormula> formulaList, String controlCube) throws Exception {
        Connection conn;
        HashMap<String, Map<String, IBgNData>> value;
        IRowSet result;
        block7: {
            result = null;
            value = new HashMap();
            String tmpOrg = null;
            String tmpBgItem = null;
            ArrayList<String> tmpTables = new ArrayList<String>();
            HashSet<String> bgOrgNumbers = new HashSet<String>();
            HashSet bgItemNumbers = new HashSet();
            HashSet<String> BgItemSet = new HashSet<String>();
            HashMap<String, String> orgUnitIdMap = new HashMap<String, String>();
            ArrayList<String> tmpNums = new ArrayList<String>();
            StringBuffer sql = new StringBuffer();
            TempTablePool pool = TempTablePool.getInstance((Context)this.getCalculator().getContext());
            conn = null;
            MbgControlInfo temp = null;
            for (int i = 0; i < formulaList.size(); ++i) {
                temp = (MbgControlInfo)formulaList.get(i);
                bgOrgNumbers.add(temp.getOrgUnitNumber());
                BgItemSet.addAll(Arrays.asList(temp.getFormulas()));
            }
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                logger.debug((Object)("deal org begin time:" + MbgControlCalculateUtils.currentTime()));
                tmpOrg = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80),ForgUnitId VARCHAR(44))");
                tmpTables.add(tmpOrg);
                tmpNums.addAll(bgOrgNumbers);
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrg + " (FNumber) values (?)"), bgOrgNumbers);
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + tmpOrg + " set ForgUnitId = (select distinct ForgUnitId from T_MBG_BgOrgUnit where FNumber = ?)"), new ArrayList(bgOrgNumbers));
                result = BgDBUtils.executeQuery((Connection)conn, (String)("select * from " + tmpOrg));
                while (result.next()) {
                    orgUnitIdMap.put(result.getString(1), result.getString(2));
                }
                logger.debug((Object)("org finish time:" + MbgControlCalculateUtils.currentTime()));
                result.close();
                logger.debug((Object)("deal bgItem begin time:" + MbgControlCalculateUtils.currentTime()));
                tmpBgItem = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))");
                tmpTables.add(tmpBgItem);
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgItem + " (FFormula) values (?)"), BgItemSet);
                logger.debug((Object)("deal bgItem begin time:" + MbgControlCalculateUtils.currentTime()));
                sql.append("select FReqOrgUnitID,FACTAULAMOUNT,FFormula from " + controlCube + " where ");
                sql.append("FReqOrgUnitID in (select ForgUnitId from " + tmpOrg + ")");
                sql.append(" and FFormula in (select FFormula from " + tmpBgItem + ")");
                result = DbUtil.executeQuery((Context)this.getCalculator().getContext(), (String)sql.toString());
                logger.debug((Object)("finish get result begin time:" + MbgControlCalculateUtils.currentTime()));
                value = this.getValueMap((ResultSet)result, formulaList, orgUnitIdMap);
                if (pool == null) break block7;
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"query DataState Error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTables);
                    }
                    SQLUtils.cleanup(result, null, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTables);
        }
        SQLUtils.cleanup((ResultSet)result, null, (Connection)conn);
        return value;
    }

    public Map<String, Map<String, IBgNData>> getValueMap(ResultSet result, List<IFormula> formulaList, Map orgUnitIdMap) throws Exception {
        Map<Object, Object> value = new HashMap();
        HashMap<String, Map<String, IBgNData>> valueMap = new HashMap<String, Map<String, IBgNData>>();
        BigDecimal bigValue = null;
        MbgControlInfo temp = null;
        String innerKey = null;
        String outKey = null;
        Map innerMap = null;
        HashMap tempResultMap = new HashMap();
        while (result.next()) {
            outKey = result.getString(1);
            if (tempResultMap.containsKey(outKey)) {
                innerMap = (HashMap<String, BigDecimal>)tempResultMap.get(outKey);
                bigValue = innerMap.containsKey(innerKey = result.getString("FFormula")) ? ((BigDecimal)innerMap.get(innerKey)).add(result.getBigDecimal("FACTAULAMOUNT")) : result.getBigDecimal("FACTAULAMOUNT");
                innerMap.put(innerKey, bigValue);
            } else {
                innerKey = result.getString("FFormula");
                innerMap = new HashMap<String, BigDecimal>();
                innerMap.put(innerKey, result.getBigDecimal("FACTAULAMOUNT"));
            }
            tempResultMap.put(outKey, innerMap);
        }
        String[] tempFormula = null;
        for (int i = 0; i < formulaList.size(); ++i) {
            bigValue = new BigDecimal(0);
            temp = (MbgControlInfo)formulaList.get(i);
            if (orgUnitIdMap.get(temp.getOrgUnitNumber()) == null || !tempResultMap.containsKey(outKey = orgUnitIdMap.get(temp.getOrgUnitNumber()).toString())) continue;
            innerMap = (Map)tempResultMap.get(outKey);
            tempFormula = temp.getFormulas();
            for (int index = 0; index < tempFormula.length; ++index) {
                if (!innerMap.containsKey(tempFormula[index])) continue;
                bigValue = (BigDecimal)innerMap.get(tempFormula[index]);
                value = this.getValue(temp, bigValue, outKey, tempFormula[index]);
                MultiThreadQuery.mergeData(valueMap, value);
            }
        }
        return valueMap;
    }

    public String getBgPeriodString(String beginPeriodNumber, String endPeriodNumber) {
        String periodKey = beginPeriodNumber + "!" + endPeriodNumber;
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        List<String> tmpList = null;
        tmpList = cache.getPeriodBEMap().get(periodKey);
        StringBuffer bf = new StringBuffer();
        if (tmpList != null && tmpList.size() > 0) {
            bf.append("(");
            Iterator<String> ite = tmpList.iterator();
            while (ite.hasNext()) {
                bf.append("'" + ite.next() + "',");
            }
            bf.setLength(bf.length() - 1);
            bf.append(")");
        }
        return bf.toString();
    }

    public BgVersionInfo getBgVersionInfo(BgSchemeInfo schemeInfo, MbgControlInfo mbgControlInfo) {
        BgDimSettingsCollection dimSettingsCollection = schemeInfo.getBgDimSettings();
        BgVersionInfo result = new BgVersionInfo();
        for (int i = 0; i < dimSettingsCollection.size(); ++i) {
            if (!dimSettingsCollection.get(i).getDimNumber().equals("BG_Version")) continue;
            for (int index = 0; index < dimSettingsCollection.get(i).getMembers().size(); ++index) {
                if (!mbgControlInfo.getBgVersionNumber().equals(dimSettingsCollection.get(i).getMembers().get(index).getNumber())) continue;
                BgDimSettingsMemberInfo temp = dimSettingsCollection.get(i).getMembers().get(index);
                result.setId(temp.getId());
                result.setName(temp.getName());
                result.setNumber(temp.getNumber());
                result.setVersionId(temp.getSeq());
                return result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map orgValMap = null;
            Map dataMap = (Map)value;
            IBgNData bgData = null;
            MbgControlInfo formula = null;
            BigDecimal val = null;
            String dimNumber2222222 = null;
            String refField = null;
            String[] formulas = null;
            String[] params = null;
            String[] dimNums = null;
            String[] tmpStrs = null;
            HashMap<String, String> dimMember = new HashMap<String, String>();
            MbgDimInfo dimensionInfo = null;
            IFormulaCacheManager cache = this.getCalculator().getCacheManager();
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
                Map<String, OrgUnitInfo> orgUnitMap = MbgDataHelper.getOrgUnitMapByNum(this.getCalculator().getContext(), conn, dataMap.keySet());
                int in = this.getCalculator().getFormula().size();
                for (int i = 0; i < in; ++i) {
                    formula = (MbgControlInfo)this.getCalculator().getFormula().get(i);
                    val = BgNConstants.ZERO;
                    if (formula.isCalculate() && orgUnitMap.containsKey(formula.getOrgUnitNumber())) {
                        int j;
                        orgValMap = (Map)dataMap.get(orgUnitMap.get(formula.getOrgUnitNumber()).getId().toString());
                        if (orgValMap == null) {
                            formula.getParameter().setValue((Object)val);
                            continue;
                        }
                        formulas = formula.getFormulas();
                        int jn = formulas.length;
                        for (j = 0; j < jn; ++j) {
                            params = BgNFSHelper.parseFormulaPara(formulas[j]);
                            dimMember.clear();
                            dimNums = params[0].split(",");
                            if (dimNums == null) continue;
                            for (String dimNumber2222222 : dimNums) {
                                tmpStrs = dimNumber2222222.split(":");
                                if (tmpStrs == null || tmpStrs.length != 2 || (dimensionInfo = cache.getMbgDimMap().get(tmpStrs[0])) == null) continue;
                                dimMember.put(dimensionInfo.getRefField(), dimNumber2222222);
                            }
                            int xn = cache.getRefFields(formula.getBgSchemeNumber()).size();
                            for (int x = 0; x < xn; ++x) {
                                refField = cache.getRefFields(formula.getBgSchemeNumber()).get(x);
                                dimNumber2222222 = dimMember.containsKey(refField) ? (String)dimMember.get(refField) : cache.getDefaultMember().get(refField);
                                params[0] = x == 0 ? dimNumber2222222 : params[0] + "," + dimNumber2222222;
                            }
                            formulas[j] = BgNFSHelper.getFormulaFromParam(params);
                        }
                        jn = formulas.length;
                        for (j = 0; j < jn; ++j) {
                            bgData = (IBgNData)orgValMap.get(DimUtils.getDimDataKey(formulas[j], formula.getBgVersionNumber()));
                            if (bgData == null) continue;
                            val = val.add(bgData.getBizActual());
                        }
                        formula.getParameter().setValue((Object)val);
                        continue;
                    }
                    formula.getParameter().setValue((Object)val);
                }
            }
            catch (SQLDataException ex) {
                logger.error((Object)"", (Throwable)ex);
                SQLUtils.cleanup((Connection)conn);
            }
            catch (Exception ex2) {
                logger.error((Object)"", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

