/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.corunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.corunit.MbgCorUnitFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.corunit.MbgCorUnitInfo;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgCorUnitCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger(MbgCorUnitCalculateUtils.class);
    private DimensionCacheHelper cacheHelper = null;

    public MbgCorUnitCalculateUtils(IBgCalculator calculator) {
        super(calculator);
        this.cacheHelper = new DimensionCacheHelper(calculator.getContext());
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new MbgCorUnitInfo(this.getCalculator(), parameter);
    }

    @Override
    protected DefaultFormulaValue getDefaultFormulaValue() {
        return new MbgCorUnitFormulaValue();
    }

    @Override
    public void beforeCommonInit() throws Exception {
        super.beforeCommonInit();
        ExpressionUtils.queryDimInfo(this.getCalculator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        String batchKey = null;
        String miltuOrgUnitNum = null;
        String schemeNum = null;
        String orgTreeNum = null;
        String corUnitNum = null;
        String[] orgAndSchStr = null;
        List<IFormula> formulaList = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap formulaListMap = new HashMap();
        HashMap scenObjMap = new HashMap();
        Map<Object, Object> orgNumInfoMap = new HashMap();
        MbgCorUnitInfo formula = null;
        Connection conn = null;
        HashMap<String, Set<String>> corUnitMap = new HashMap<String, Set<String>>();
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            scenObjMap.putAll(BgScenarioHelper.getScenariooObjMap((Connection)conn, (Locale)this.getCalculator().getContext().getLocale()));
            Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
            orgNumInfoMap = this.queryBaseOrgUnitMap(conn, batchMap.keySet());
            for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                batchKey = entry2.getKey();
                orgAndSchStr = batchKey.split("!");
                miltuOrgUnitNum = orgAndSchStr[0];
                schemeNum = orgAndSchStr[1];
                orgTreeNum = orgAndSchStr[2];
                corUnitNum = orgAndSchStr[3];
                if (StringUtils.isEmpty((String)corUnitNum)) continue;
                if (miltuOrgUnitNum.contains(";")) {
                    String[] miltOrgUnitNums;
                    for (String orgUnitNum : miltOrgUnitNums = miltuOrgUnitNum.split(";")) {
                        Set<String> corOrgUnitMap = this.queryCorOrgUnitMap(conn, schemeNum, corUnitNum, (Map)orgNumInfoMap.get(orgUnitNum + "_" + orgTreeNum));
                        corUnitMap.put(this.getCorUnitMapKey(orgUnitNum, schemeNum, orgTreeNum, corUnitNum), corOrgUnitMap);
                    }
                    continue;
                }
                Set<String> corOrgUnitMap = this.queryCorOrgUnitMap(conn, schemeNum, corUnitNum, (Map)orgNumInfoMap.get(miltuOrgUnitNum + "_" + orgTreeNum));
                corUnitMap.put(this.getCorUnitMapKey(miltuOrgUnitNum, schemeNum, orgTreeNum, corUnitNum), corOrgUnitMap);
            }
            BgAggregateCalculator bgAggregate = null;
            String corSrcnumber = null;
            Map orgUnitInfoMap = null;
            for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                batchKey = entry2.getKey();
                formulaList = entry2.getValue();
                orgAndSchStr = batchKey.split("!");
                miltuOrgUnitNum = orgAndSchStr[0];
                schemeNum = orgAndSchStr[1];
                orgTreeNum = orgAndSchStr[2];
                corUnitNum = orgAndSchStr[3];
                corSrcnumber = this.queryCorSrcnumber(this.getCalculator().getContext(), corUnitNum);
                if (StringUtils.isEmpty((String)corUnitNum) || StringUtils.isEmpty((String)corSrcnumber)) continue;
                if (!formulaListMap.containsKey(batchKey)) {
                    formulaListMap.put(batchKey, new HashMap());
                }
                SortedParameterArray parameterArray = new SortedParameterArray();
                if (miltuOrgUnitNum.contains(";")) {
                    String[] miltOrgUnitNums = miltuOrgUnitNum.split(";");
                    for (String orgUnitNum : miltOrgUnitNums) {
                        orgUnitInfoMap = (Map)orgNumInfoMap.get(this.getOrgMapKey(orgUnitNum, orgTreeNum));
                        if (orgUnitInfoMap == null || orgUnitInfoMap.isEmpty() || !corUnitMap.containsKey(this.getCorUnitMapKey(orgUnitNum, schemeNum, orgTreeNum, corUnitNum))) continue;
                        Set corUnitNums = (Set)corUnitMap.get(this.getCorUnitMapKey(orgUnitNum, schemeNum, orgTreeNum, corUnitNum));
                        for (IFormula iFormula : formulaList) {
                            if (!((Map)formulaListMap.get(batchKey)).containsKey(iFormula)) {
                                ((Map)formulaListMap.get(batchKey)).put(iFormula, new ArrayList());
                            }
                            formula = (MbgCorUnitInfo)iFormula;
                            parameterArray.clear();
                            this.getParame(parameterArray, orgUnitInfoMap, corUnitNums, corUnitNums, formula, schemeNum, corSrcnumber, this.getDataType(formula.getBgScenarioNumber()));
                            if (parameterArray.isEmpty()) continue;
                            try {
                                this.getCalculator().getContext().put((Object)"isCalcBiz", (Object)Boolean.FALSE);
                                bgAggregate = new BgAggregateCalculator(this.getCalculator().getContext(), this.getCalculator().getProvider());
                                bgAggregate.setClearFormula(false);
                                bgAggregate.execute(parameterArray);
                                ((List)((Map)formulaListMap.get(batchKey)).get(formula)).addAll(bgAggregate.getFormula());
                            }
                            catch (Exception e) {
                                logger.error((Object)"", (Throwable)e);
                                throw new BOSException((Throwable)e);
                            }
                            finally {
                                this.getCalculator().getContext().remove((Object)"isCalcBiz");
                            }
                        }
                    }
                    continue;
                }
                orgUnitInfoMap = (Map)orgNumInfoMap.get(this.getOrgMapKey(miltuOrgUnitNum, orgTreeNum));
                if (orgUnitInfoMap == null || orgUnitInfoMap.isEmpty() || !corUnitMap.containsKey(this.getCorUnitMapKey(miltuOrgUnitNum, schemeNum, orgTreeNum, corUnitNum))) continue;
                Set corUnitNums = (Set)corUnitMap.get(this.getCorUnitMapKey(miltuOrgUnitNum, schemeNum, orgTreeNum, corUnitNum));
                for (IFormula iFormula : formulaList) {
                    if (!((Map)formulaListMap.get(batchKey)).containsKey(iFormula)) {
                        ((Map)formulaListMap.get(batchKey)).put(iFormula, new ArrayList());
                    }
                    formula = (MbgCorUnitInfo)iFormula;
                    parameterArray.clear();
                    this.getParame(parameterArray, orgUnitInfoMap, corUnitNums, corUnitNums, formula, schemeNum, corSrcnumber, this.getDataType(formula.getBgScenarioNumber()));
                    if (parameterArray.isEmpty()) continue;
                    try {
                        this.getCalculator().getContext().put((Object)"isCalcBiz", (Object)Boolean.FALSE);
                        bgAggregate = new BgAggregateCalculator(this.getCalculator().getContext(), this.getCalculator().getProvider());
                        bgAggregate.setClearFormula(false);
                        bgAggregate.execute(parameterArray);
                        ((List)((Map)formulaListMap.get(batchKey)).get(formula)).addAll(bgAggregate.getFormula());
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        this.getCalculator().getContext().remove((Object)"isCalcBiz");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(conn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)conn);
        return formulaListMap;
    }

    private String getCorUnitMapKey(String miltuOrgUnitNum, String schemeNum, String orgTreeNum, String corUnitNum) {
        return miltuOrgUnitNum + "_" + schemeNum + "_" + orgTreeNum + "_" + corUnitNum;
    }

    private void getParame(SortedParameterArray parameterArray, Map<String, OrgUnitInfo> orgUnitInfoMap, Set<String> corUnitNums, Set<String> originalCorUnitNums, MbgCorUnitInfo formula, String schemeNum, String corSrcnumber, String dataType) {
        if (corUnitNums.isEmpty() || originalCorUnitNums.isEmpty() || formula == null) {
            return;
        }
        OrgUnitInfo orgUnitInfo = null;
        Object[] param = null;
        Parameter parameter = null;
        HashSet<String> newCorUnit = new HashSet<String>();
        for (Map.Entry<String, OrgUnitInfo> entry : orgUnitInfoMap.entrySet()) {
            orgUnitInfo = entry.getValue();
            if (Boolean.FALSE.equals(entry.getValue().isIsGrouping())) {
                for (String corNum : corUnitNums) {
                    if (orgUnitInfo.getNumber().equals(corNum)) continue;
                    param = new Object[]{new Variant((Object)orgUnitInfo.getNumber()), new Variant((Object)schemeNum), new Variant((Object)formula.getBgScenarioNumber()), new Variant((Object)(formula.getBgItemNumber() + "," + corSrcnumber + ":" + corNum)), new Variant((Object)formula.getBeginPeriodNumber()), new Variant((Object)formula.getEndPeriodNumber()), new Variant((Object)formula.getBgVersionNumber()), new Variant((Object)formula.getCurrencyNumber()), new Variant((Object)formula.getBgElementNumber()), new Variant((Object)dataType), new Variant((Object)formula.getDataState()), new Variant((Object)formula.getProcessType())};
                    parameter = new Parameter(param, "Sheet1");
                    parameterArray.append((Object)parameter);
                }
                continue;
            }
            if (!(orgUnitInfo.get("children") instanceof Map)) continue;
            newCorUnit.clear();
            Map childrenMap = (Map)orgUnitInfo.get("children");
            for (String corUnitNum : originalCorUnitNums) {
                if (childrenMap.containsKey(corUnitNum)) continue;
                newCorUnit.add(corUnitNum);
            }
            this.getParame(parameterArray, childrenMap, newCorUnit, originalCorUnitNums, formula, schemeNum, corSrcnumber, dataType);
        }
    }

    private String getDataType(String bgScenarioNumber) {
        if (StringUtils.isEmpty((String)bgScenarioNumber)) {
            return "";
        }
        try {
            BgScenarioInfo bgScenarioInfo = BgScenarioFactory.getLocalInstance((Context)this.getCalculator().getContext()).getBgScenarioInfo("select id, number, type where number = '" + bgScenarioNumber + "'");
            if (bgScenarioInfo != null) {
                if (BgScenarioType.BudgetData.equals((Object)bgScenarioInfo.getType())) {
                    return AggregateDataTypeEnum.budget.getName();
                }
                return AggregateDataTypeEnum.actual.getName();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getDataType error", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"getDataType error", (Throwable)e);
        }
        return "";
    }

    private String queryCorSrcnumber(Context context, String corUnitNum) throws BOSException {
        if (StringUtils.isEmpty((String)corUnitNum)) {
            return "";
        }
        Connection conn = null;
        IRowSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)context);
            StringBuffer sql = new StringBuffer();
            sql.append("select FSRCNUMBER from T_MBG_MbgDim where FNUMBER = '").append(corUnitNum).append("'");
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            if (rs.next()) {
                String string = rs.getString("FSRCNUMBER");
                return string;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return "";
    }

    private Set<String> queryCorOrgUnitMap(Connection conn, String schemeNum, String corUnitNum, Map<String, OrgUnitInfo> orgUnitMapKey) throws BOSException {
        final HashSet<String> corUnitNums = new HashSet<String>();
        if (orgUnitMapKey == null || orgUnitMapKey.isEmpty()) {
            return corUnitNums;
        }
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgUnitNums(orgNums, orgUnitMapKey);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mbgMember.FNUMBER ").append(" FROM T_MBG_MbgMember mbgMember, T_MBG_BgScheme bgScheme, T_MBg_BgDimSettings dimSettings, T_MBG_BgDimSettingsMember dimMember ").append(" Where mbgMember.FVIEWID = dimMember.FMEMBERID and bgScheme.FID = dimSettings.FBgSchemeId AND dimSettings.FID = dimMember.FBgDimSettingsId ").append(" AND dimMember.FType = ").append(1).append(" AND bgScheme.FNumber = '").append(schemeNum).append("'").append(" and dimSettings.FDIMNUMBER = '").append(corUnitNum).append("'").append(" and mbgMember.FNUMBER in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)orgNums.size()).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])orgNums.toArray(), (int)orgNums.size()), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException, BOSException {
                corUnitNums.add(res.getString("FNumber"));
            }
        });
        return corUnitNums;
    }

    private void getOrgUnitNums(Set<String> orgNums, Object orgUnit) {
        if (orgUnit instanceof Map) {
            Map orgUnitMap = (Map)orgUnit;
            for (Map.Entry entry : orgUnitMap.entrySet()) {
                if (Boolean.FALSE.equals(((OrgUnitInfo)entry.getValue()).isIsGrouping())) {
                    orgNums.add((String)entry.getKey());
                    continue;
                }
                this.getOrgUnitNums(orgNums, ((OrgUnitInfo)entry.getValue()).get("children"));
            }
        }
    }

    private Map<String, Map<String, OrgUnitInfo>> queryBaseOrgUnitMap(Connection conn, Set<String> batchMap) throws Exception {
        HashMap<String, Map<String, OrgUnitInfo>> orgNumInfoMap = new HashMap<String, Map<String, OrgUnitInfo>>();
        if (batchMap == null || batchMap.isEmpty()) {
            return orgNumInfoMap;
        }
        String batchKey2 = null;
        String orgUnionNumber = null;
        String orgTreeNumber = null;
        String[] orgAndSchStr = null;
        OrgUnitInfo orgUnitInfo = null;
        StringBuffer querySql = new StringBuffer();
        IRowSet rs = null;
        try {
            OrgTreeInfo orgTree = null;
            String orgTreeId = null;
            for (String batchKey2 : batchMap) {
                orgAndSchStr = batchKey2.split("!");
                orgUnionNumber = orgAndSchStr[0];
                orgTreeNumber = orgAndSchStr[2];
                orgTree = this.cacheHelper.getOrgTreeInfoByNumber(this.getCalculator().getContext(), orgTreeNumber);
                if (orgTree == null) continue;
                orgTreeId = orgTree.getId().toString();
                if (orgUnionNumber.contains(";")) {
                    String[] orgUnions;
                    for (String orgUnion : orgUnions = orgUnionNumber.split(";")) {
                        orgNumInfoMap.put(this.getOrgMapKey(orgUnion, orgTreeNumber), new HashMap());
                        querySql.setLength(0);
                        querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 ,UNIT.FISGROUPING AS FISGROUPING FROM T_ORG_Structure AS ORGSTRUCTURE ").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'").append(" and ORGSTRUCTURE.FPARENTID in ").append(" ( ").append(" SELECT ORGSTRUCTURE.FID  FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'");
                        if (!StringUtils.isEmpty((String)orgUnion) && !orgUnion.equals("-1")) {
                            querySql.append(" AND UNIT.FNUMBER = '").append(orgUnion).append("'");
                        }
                        querySql.append(" ) ");
                        rs = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString());
                        while (rs.next()) {
                            orgUnitInfo = new OrgUnitInfo();
                            orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                            orgUnitInfo.setName(rs.getString("FNAME_l2"));
                            orgUnitInfo.setNumber(rs.getString("FNUMBER"));
                            orgUnitInfo.setIsGrouping(rs.getBoolean("FISGROUPING"));
                            if (Boolean.TRUE.equals(rs.getBoolean("FISGROUPING"))) {
                                orgUnitInfo.put("hasChildren", (Object)true);
                                orgUnitInfo.put("children", this.querySubordinateOrgUnitMap(conn, rs.getString("FNUMBER"), orgTreeId));
                            }
                            ((Map)orgNumInfoMap.get(this.getOrgMapKey(orgUnion, orgTreeNumber))).put(orgUnitInfo.getNumber(), orgUnitInfo);
                        }
                    }
                    continue;
                }
                orgNumInfoMap.put(this.getOrgMapKey(orgUnionNumber, orgTreeNumber), new HashMap());
                querySql.setLength(0);
                querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 ,UNIT.FISGROUPING AS FISGROUPING FROM T_ORG_Structure AS ORGSTRUCTURE ").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'").append(" and ORGSTRUCTURE.FPARENTID in ").append(" ( ").append(" SELECT ORGSTRUCTURE.FID  FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'");
                if (!StringUtils.isEmpty((String)orgUnionNumber) && !orgUnionNumber.equals("-1")) {
                    querySql.append(" AND UNIT.FNUMBER = '").append(orgUnionNumber).append("'");
                }
                querySql.append(" ) ");
                rs = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString());
                while (rs.next()) {
                    orgUnitInfo = new OrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    orgUnitInfo.setName(rs.getString("FNAME_l2"));
                    orgUnitInfo.setNumber(rs.getString("FNUMBER"));
                    orgUnitInfo.setIsGrouping(rs.getBoolean("FISGROUPING"));
                    if (Boolean.TRUE.equals(rs.getBoolean("FISGROUPING"))) {
                        orgUnitInfo.put("hasChildren", (Object)true);
                        orgUnitInfo.put("children", this.querySubordinateOrgUnitMap(conn, rs.getString("FNUMBER"), orgTreeId));
                    }
                    ((Map)orgNumInfoMap.get(this.getOrgMapKey(orgUnionNumber, orgTreeNumber))).put(orgUnitInfo.getNumber(), orgUnitInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return orgNumInfoMap;
    }

    private String getOrgMapKey(String orgUnionNumber, String orgTreeNumber) {
        return orgUnionNumber + "_" + orgTreeNumber;
    }

    private Map<String, OrgUnitInfo> querySubordinateOrgUnitMap(Connection conn, String orgUnionNumber, String orgTreeId) throws Exception {
        HashMap<String, OrgUnitInfo> SubordinateOrgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (StringUtils.isEmpty((String)orgTreeId)) {
            return SubordinateOrgUnitMap;
        }
        OrgUnitInfo orgUnitInfo = null;
        StringBuffer querySql = new StringBuffer();
        IRowSet rs = null;
        try {
            querySql.setLength(0);
            querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 ,UNIT.FISGROUPING AS FISGROUPING FROM T_ORG_Structure AS ORGSTRUCTURE ").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'").append(" and ORGSTRUCTURE.FPARENTID in ").append(" ( ").append(" SELECT ORGSTRUCTURE.FID  FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FID  = '").append(orgTreeId).append("'");
            if (!StringUtils.isEmpty((String)orgUnionNumber) && !orgUnionNumber.equals("-1")) {
                querySql.append(" AND UNIT.FNUMBER = '").append(orgUnionNumber).append("'");
            }
            querySql.append(" ) ");
            rs = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString());
            while (rs.next()) {
                orgUnitInfo = new OrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                orgUnitInfo.setName(rs.getString("FNAME_l2"));
                orgUnitInfo.setNumber(rs.getString("FNUMBER"));
                orgUnitInfo.setIsGrouping(rs.getBoolean("FISGROUPING"));
                if (Boolean.TRUE.equals(rs.getBoolean("FISGROUPING"))) {
                    orgUnitInfo.put("hasChildren", (Object)true);
                    orgUnitInfo.put("children", this.querySubordinateOrgUnitMap(conn, rs.getString("FNUMBER"), orgTreeId));
                }
                SubordinateOrgUnitMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return SubordinateOrgUnitMap;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map formulaListMap = (Map)value;
            List formulaList = null;
            BigDecimal val = null;
            for (IFormula iFormula : this.getCalculator().getFormula()) {
                val = BgNConstants.ZERO;
                if (iFormula.getParameter().getValue() != null || !formulaListMap.containsKey(iFormula.getBatchCalculateKey())) continue;
                formulaList = (List)((Map)formulaListMap.get(iFormula.getBatchCalculateKey())).get(iFormula);
                if (formulaList != null && formulaList.size() > 0) {
                    for (IFormula iFormula2 : formulaList) {
                        if (!(iFormula2.getParameter().getValue() instanceof BigDecimal)) continue;
                        val = val.add((BigDecimal)iFormula2.getParameter().getValue());
                    }
                }
                iFormula.getParameter().setValue((Object)val);
            }
        }
    }
}

