/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.corunit;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.corunit.MbgCorUnitFormulaValue;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MbgCorUnitInfo
extends FormulaInfo {
    private String batchKey = null;
    private String orgTreeNumber = null;
    private String corUnitNumber = null;
    private String dataState = "";
    private String processType = BgProcessEnum.C01.getName();

    public MbgCorUnitInfo() {
    }

    public MbgCorUnitInfo(IBgCalculator bgCalculator, Parameter parameter) {
        super(bgCalculator, parameter);
    }

    public String getBatchKey() {
        return this.batchKey;
    }

    public void setBatchKey(String batchKey) {
        this.batchKey = batchKey;
    }

    public String getOrgTreeNumber() {
        return this.orgTreeNumber;
    }

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public String getCorUnitNumber() {
        return this.corUnitNumber;
    }

    public void setCorUnitNumber(String corUnitNumber) {
        this.corUnitNumber = corUnitNumber;
    }

    public void setDataState(String dataState) {
        this.dataState = dataState == null ? "" : dataState;
    }

    public String getDataState() {
        return this.dataState;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public int getProcessTypeValue() {
        if (StringUtils.isEmpty((String)this.processType)) {
            return -1;
        }
        BgProcessEnum process = BgProcessEnum.getEnum(this.getProcessType());
        if (process == null) {
            return -1;
        }
        return process.getValue();
    }

    public String getParamStr() {
        return this.getOrgTreeNumber() + "!" + this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getBgScenarioNumber() + "!" + this.getCorUnitNumber() + "!" + this.getBgItemNumber() + "!" + this.getBeginPeriodNumber() + "!" + this.getEndPeriodNumber() + "!" + this.getBgVersionNumber() + "!" + this.getCurrencyNumber() + "!" + this.getBgElementNumber() + "!" + this.getDataState();
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = this.getParameter().getArgs();
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgTreeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgScenarioNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            this.setCorUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            this.setBgItemNumber(this.getBgDimNumber(variant.getValue().toString()));
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setBeginPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setEndPeriodNumber(variant.getValue().toString().replaceAll(BgNConstants.BLANK_STR, ""));
        }
        if ((variant = (Variant)params[8]).getValue() != null) {
            this.setBgVersionNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[9]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[10]).getValue() != null) {
            this.setBgElementNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[11]).getValue() != null) {
            this.setDataState(StringUtils.cnulls((String)variant.getValue().toString()));
        } else {
            this.setDataState("");
        }
    }

    private String getBgDimNumber(String bgDimNumber) {
        if (StringUtils.isEmpty((String)bgDimNumber) || StringUtils.isEmpty((String)this.getCorUnitNumber())) {
            return bgDimNumber;
        }
        Map<String, MbgDimInfo> mbgDimMap = this.getCalculator().getCacheManager().getMbgDimMap();
        TreeMap<String, String> dimMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] tmpNums = bgDimNumber.split(",");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            String[] tmpStr = tmpNums[i].split(":");
            if (!mbgDimMap.containsKey(tmpStr[0])) {
                this.getParameter().setValue((Object)new SyntaxErrorException(128L, (Object)new DimensionException(DimensionException.MEMBERNOTFIND, new Object[]{tmpStr[0]}).getMessage()));
                return "";
            }
            dimMap.put(mbgDimMap.get(tmpStr[0]).getRefField(), tmpNums[i]);
        }
        StringBuffer dimNumber = new StringBuffer();
        Iterator iter = dimMap.values().iterator();
        while (iter.hasNext()) {
            dimNumber.append((String)iter.next()).append(",");
        }
        dimNumber.delete(dimNumber.length() - 1, dimNumber.length());
        return dimNumber.toString();
    }

    @Override
    public String getBatchCalculateKey() {
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getOrgTreeNumber() + "!" + this.getCorUnitNumber() + "!" + this.getProcessTypeValue() + "!" + this.getDataState();
        }
        return this.batchKey;
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        super.fillParameter(value);
        MbgCorUnitFormulaValue mbgCorUnitFormula = (MbgCorUnitFormulaValue)value;
        if (StringUtils.isEmpty((String)this.getOrgTreeNumber())) {
            this.setOrgTreeNumber(mbgCorUnitFormula.getOrgTreeNumber());
        }
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber())) {
            this.setOrgUnitNumber("-1");
        }
        String nPeriodNum = null;
        if (!this.getBeginPeriodNumber().equals(this.getEndPeriodNumber())) {
            String pKey = this.getBeginPeriodNumber() + "_" + this.getEndPeriodNumber();
            if (mbgCorUnitFormula.getAggPeriodMap().containsKey(pKey)) {
                nPeriodNum = mbgCorUnitFormula.getAggPeriodMap().get(pKey);
            } else {
                nPeriodNum = this.optimisingPeriod(BgPeriodHelper.getPeriodType((Context)this.getCalculator().getContext(), (String)this.getBeginPeriodNumber()), this.getBeginPeriodNumber(), this.getEndPeriodNumber());
                mbgCorUnitFormula.getAggPeriodMap().put(pKey, nPeriodNum);
            }
            if (!StringUtils.isEmpty((String)nPeriodNum)) {
                this.setBeginPeriodNumber(nPeriodNum);
                this.setEndPeriodNumber(nPeriodNum);
            }
        }
    }

    protected String optimisingPeriod(int periodType, String beginPeriodNum, String endPeirodNum) {
        if (periodType == 4) {
            return this.optimisingMonth(beginPeriodNum, endPeirodNum);
        }
        if (periodType == 3) {
            return this.optimisingQuarter(beginPeriodNum, endPeirodNum);
        }
        return null;
    }

    protected String optimisingQuarter(String beginPeriodNum, String endPeirodNum) {
        int endYear;
        String nPeriodNum = null;
        Date begin = BgNPeriodHelper.getPeriodDate((String)beginPeriodNum);
        Date end = BgNPeriodHelper.getPeriodDate((String)endPeirodNum);
        CalendarHelper helper = new CalendarHelper();
        int beginYear = helper.getCurrentlyYear(begin);
        if (beginYear == (endYear = helper.getCurrentlyYear(end))) {
            int beginQuarter = helper.getCurrentlyQuarter(begin);
            int endQuarter = helper.getCurrentlyQuarter(end);
            if (beginQuarter == 1 && endQuarter == 2) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
            } else if (beginQuarter == 3 && endQuarter == 4) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
            } else if (beginQuarter == 1 && endQuarter == 4) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.YEAR);
            }
        }
        return nPeriodNum;
    }

    protected String optimisingMonth(String beginPeriodNum, String endPeirodNum) {
        int endYear;
        String nPeriodNum = null;
        Date begin = BgNPeriodHelper.getPeriodDate((String)beginPeriodNum);
        Date end = BgNPeriodHelper.getPeriodDate((String)endPeirodNum);
        CalendarHelper helper = new CalendarHelper();
        int beginYear = helper.getCurrentlyYear(begin);
        if (beginYear == (endYear = helper.getCurrentlyYear(end))) {
            int beginMonth = helper.getCurrentlyMonth(begin);
            int endMonth = helper.getCurrentlyMonth(end);
            if (beginMonth == 1) {
                if (endMonth == 3) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                } else if (endMonth == 6) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
                } else if (endMonth == 12) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.YEAR);
                }
            } else if (beginMonth == 4) {
                if (endMonth == 6) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                }
            } else if (beginMonth == 7) {
                if (endMonth == 9) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
                } else if (endMonth == 12) {
                    nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.HALFYEAR);
                }
            } else if (beginMonth == 10 && endMonth == 12) {
                nPeriodNum = BgNPeriodHelper.getPeriodNum((Date)begin, (BgPeriodEnum)BgPeriodEnum.QUARTER);
            }
        }
        return nPeriodNum;
    }
}

