/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.formula;

import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.formula.BgFormulaInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import java.math.BigDecimal;
import java.util.Map;

public class BgFormulaCalculateUtils
extends AbstractCalculateUtils {
    public BgFormulaCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgFormulaInfo(this.getCalculator(), parameter);
    }

    public boolean isQueryData() {
        return true;
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        if (this.isQueryData()) {
            return ExpressionUtils.calcExpression(this.getCalculator(), 1);
        }
        return null;
    }

    @Override
    public void afterCalculate() throws Exception {
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map orgValMap = null;
            Map dataMap = (Map)value;
            IBgNData bgData = null;
            BgFormulaInfo formula = null;
            BigDecimal val = null;
            String[] formulas = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgFormulaInfo)this.getCalculator().getFormula().get(i);
                val = BgNConstants.ZERO;
                if (formula.isCalculate()) {
                    orgValMap = (Map)dataMap.get(formula.getOrgUnitNumber());
                    if (orgValMap == null) {
                        formula.getParameter().setValue((Object)val);
                        continue;
                    }
                    formulas = formula.getFormulas();
                    int jn = formulas.length;
                    for (int j = 0; j < jn; ++j) {
                        bgData = (IBgNData)orgValMap.get(DimUtils.getDimDataKey(formulas[j], formula.getBgVersionNumber()));
                        if (bgData == null) continue;
                        val = val.add(bgData.getBudgetValue());
                    }
                }
                formula.getParameter().setValue((Object)val);
            }
        }
    }
}

