/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.org;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.org.BgGetCurrentOrgInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.org.BgGetOrgNumInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BgGetCurrentOrgCalculateUtils
extends AbstractCalculateUtils {
    public static final String CSLReport_OrgUnit_Group_Name = "CSLReport_OrgUnit_Group_Name";

    public BgGetCurrentOrgCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgGetCurrentOrgInfo(this.getCalculator(), parameter);
    }

    @Override
    public void beforeCommonInit() throws Exception {
    }

    @Override
    protected void beforeCalculate() throws Exception {
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        HashMap<String, FullOrgUnitInfo> valueMap = new HashMap<String, FullOrgUnitInfo>();
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        if (batchMap == null || batchMap.isEmpty()) {
            return valueMap;
        }
        HashMap orgUnitMap = new HashMap();
        HashSet<String> orgUnits = new HashSet<String>();
        String bgOrgviewId = null;
        String bgSchemeId = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        evi.getSelector().add("orgUnit.name");
        evi.getSelector().add("bgScheme.id");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(batchMap.keySet()), CompareType.INCLUDE));
        BgFormCollection col = BgFormFactory.getLocalInstance(this.getCalculator().getContext()).getBgFormCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                valueMap.put(col.get(i).getId().toString(), col.get(i).getOrgUnit());
                orgUnits.add(col.get(i).getOrgUnit().getId().toString());
                if (bgSchemeId != null) continue;
                bgSchemeId = col.get(i).getBgScheme().getId().toString();
            }
        }
        if (!StringUtils.isEmpty(bgSchemeId)) {
            try {
                BgSchemeCollection colSch = BgSchemeFactory.getLocalInstance(this.getCalculator().getContext()).getBgSchemeCollection("select id, number, name, isfiling, isFormal,dataFrom,dataTo,orgUnit.id,orgUnit.name,bgDimSettings.*,bgDimSettings.Members.* where id = '" + bgSchemeId + "'");
                if (col != null && !col.isEmpty()) {
                    bgOrgviewId = colSch.get(0).getEditOrgViewId().toString();
                }
            }
            catch (BOSException e) {
                new BOSException((Throwable)e);
            }
        }
        evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("orgUnitID");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("displayName");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgviewId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", orgUnits, CompareType.INCLUDE));
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(this.getCalculator().getContext()).getBgOrgUnitCollection(evi);
        block3: for (String key : valueMap.keySet()) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)valueMap.get(key);
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                if (!bgOrgUnitCollection.get(i).getOrgUnitID().equals(fullOrgUnitInfo.getId().toString())) continue;
                valueMap.put(key, bgOrgUnitCollection.get(i).castToFullOrgUnitInfo());
                continue block3;
            }
        }
        return valueMap;
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            FullOrgUnitInfo currOrg = null;
            FullOrgUnitCollection orgs = new FullOrgUnitCollection();
            StringBuffer querySql = new StringBuffer();
            IRowSet rs = null;
            try {
                Locale locale = this.getCalculator().getContext().getLocale();
                String number = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("CSLReport_OrgUnit_Group");
                String orgTreeNumber = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
                if (number == null) {
                    number = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty("BG_ORG_NUMBER");
                    orgs = FullOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext()).getFullOrgUnitCollection("select id, number, name where number = '" + number + "'");
                } else {
                    String name = (String)this.getCalculator().getProvider().getReportAdapter().getReportProperty(CSLReport_OrgUnit_Group_Name);
                    querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_" + locale + ", UNIT.FDISPLAYNAME_" + locale + " FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" WHERE exists(select 1 from T_ORG_Tree AS TREE where  ORGSTRUCTURE.FTreeId = TREE.FID and TREE.fnumber='" + orgTreeNumber + "')").append(" AND UNIT.FNUMBER  = '").append(number).append("'");
                    if (!StringUtils.isEmpty((String)name)) {
                        querySql.append(" AND UNIT.FNAME_" + locale + " ='" + name + "'");
                    }
                    if ((rs = DbUtil.executeQuery((Context)this.getCalculator().getContext(), (String)querySql.toString())).next()) {
                        currOrg = new FullOrgUnitInfo();
                        currOrg.setId(BOSUuid.read((String)rs.getString("FID")));
                        currOrg.setName(rs.getString("FNAME_" + locale));
                        currOrg.setNumber(rs.getString("FNUMBER"));
                        currOrg.setDisplayName(rs.getString("FDISPLAYNAME_" + locale));
                    }
                    if (currOrg != null) {
                        orgs.add(currOrg);
                    }
                }
                if (orgs != null && !orgs.isEmpty()) {
                    currOrg = orgs.get(0);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Map dataMap = (Map)value;
            BgGetCurrentOrgInfo formula = null;
            FullOrgUnitInfo orgUnit = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                formula = (BgGetCurrentOrgInfo)this.getCalculator().getFormula().get(i);
                String result = null;
                if (formula.isCalculate()) {
                    orgUnit = (FullOrgUnitInfo)dataMap.get(formula.getBatchCalculateKey());
                    if (orgUnit == null && currOrg != null) {
                        orgUnit = currOrg;
                    }
                    if (orgUnit != null) {
                        if ("number".equalsIgnoreCase(formula.getReturnType())) {
                            result = orgUnit.getNumber();
                        } else if ("longName".equalsIgnoreCase(formula.getReturnType())) {
                            result = orgUnit.getName();
                            if (orgUnit.getDisplayName() != null) {
                                result = orgUnit.getDisplayName();
                            }
                        } else {
                            result = orgUnit.getName();
                        }
                    }
                    formula.getParameter().setValue(result);
                    continue;
                }
                formula.getParameter().setValue((Object)BgGetOrgNumInfo.badException);
            }
        }
    }
}

