/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.org;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.BgOrgTypeEnum;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.org.BgGetOrgAttrInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgGetOrgAttrCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.formula.impl.org.BgGetOrgAttrCalculateUtils");
    private Map<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
    private Map<String, Set<String>> orgBizMap = new HashMap<String, Set<String>>();

    public BgGetOrgAttrCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map<String, Set<String>> getOrgBizMap() {
        return this.orgBizMap;
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgGetOrgAttrInfo(this.getCalculator(), parameter);
    }

    @Override
    public void beforeCommonInit() throws Exception {
    }

    @Override
    public void queryBaseInfo() throws Exception {
        this.queryOrgUnitInfo();
    }

    public void queryOrgUnitInfo() throws Exception {
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        HashSet<String> orgUnitNum = new HashSet<String>();
        orgUnitNum.addAll(cache.getOrgUnitNumberMap().keySet());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", orgUnitNum, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgUnitCollection colls = this.getOrgUnitInterface().getOrgUnitCollection(view);
        if (colls != null) {
            OrgUnitInfo orgUnitInfo = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                orgUnitInfo = colls.get(i);
                this.getOrgUnitMap().put(orgUnitInfo.getNumber(), orgUnitInfo);
            }
        }
    }

    @Override
    protected Object invokeCalculate() throws Exception {
        String orgUnitNumber = null;
        String bizUnitType = null;
        List<IFormula> formulas = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        Set<String> orgBizIds = null;
        BgGetOrgAttrInfo orgAttrInfo = null;
        OrgUnitInfo orgUnitInfo = null;
        Method method = null;
        Map<String, List<IFormula>> batchMap = this.getCalculator().getCacheManager().getBatchKeyMap();
        for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
            orgUnitNumber = entry2.getKey();
            formulas = entry2.getValue();
            if (!this.getOrgUnitMap().containsKey(orgUnitNumber)) continue;
            orgUnitInfo = this.getOrgUnitMap().get(orgUnitNumber);
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                orgAttrInfo = (BgGetOrgAttrInfo)formulas.get(i);
                orgAttrInfo.setOrgUnitInfo(orgUnitInfo);
                try {
                    method = orgAttrInfo.getClass().getMethod(orgAttrInfo.getOrgUnitType(), new Class[0]);
                    if (method != null) {
                        method.invoke((Object)orgAttrInfo, new Object[0]);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"invokeCalculate Error", (Throwable)ex);
                }
                if (this.getOrgBizMap().containsKey(orgAttrInfo.getOrgUnitType())) {
                    orgBizIds = this.getOrgBizMap().get(orgAttrInfo.getOrgUnitType());
                } else {
                    orgBizIds = new HashSet<String>();
                    this.getOrgBizMap().put(orgAttrInfo.getOrgUnitType(), orgBizIds);
                }
                orgBizIds.add(orgUnitInfo.getId().toString());
            }
        }
        HashMap valueMap = new HashMap();
        Map<String, Boolean> typeMap = null;
        if (orgBizIds != null && !orgBizIds.isEmpty()) {
            ICoreBase face = null;
            IObjectValue model = null;
            CoreBaseCollection colls = null;
            Map.Entry<String, Set<String>> bizEntry2 = null;
            EntityViewInfo view = null;
            FilterInfo filter = null;
            for (Map.Entry<String, Set<String>> bizEntry2 : this.getOrgBizMap().entrySet()) {
                bizUnitType = bizEntry2.getKey();
                orgBizIds = bizEntry2.getValue();
                face = this.getInterface(BgOrgTypeEnum.getEnum(bizUnitType).getValue());
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", orgBizIds, CompareType.INCLUDE));
                view.setFilter(filter);
                view.setSelector(this.getSelectors());
                colls = face.getCollection(view);
                if (colls == null) continue;
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    model = colls.getObject(i);
                    if (valueMap.containsKey(model.getString("id"))) {
                        typeMap = (Map)valueMap.get(model.getString("id"));
                    } else {
                        typeMap = new HashMap();
                        valueMap.put(model.getString("id"), typeMap);
                    }
                    typeMap.put(bizUnitType, model.getBoolean("isBizUnit"));
                }
            }
        }
        return valueMap;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("isBizUnit");
        return sic;
    }

    protected ICoreBase getInterface(int orgTypeEnum) throws Exception {
        ICompanyOrgUnit _interface = null;
        switch (orgTypeEnum) {
            case 1: {
                _interface = this.getCompanyInterface();
                break;
            }
            case 2: {
                _interface = this.getSaleInterface();
                break;
            }
            case 3: {
                _interface = this.getPurchaseInterface();
                break;
            }
            case 4: {
                _interface = this.getStorageInterface();
                break;
            }
            case 5: {
                _interface = this.getCostCenterInterface();
                break;
            }
            case 6: {
                _interface = this.getProfitCenterInterface();
                break;
            }
            case 16: {
                _interface = this.getHRInterface();
                break;
            }
            case 24: {
                _interface = this.getTransportInterface();
                break;
            }
            case 32: {
                _interface = this.getQualityInterface();
                break;
            }
            case 10: {
                _interface = this.getOrgUnitInterface();
            }
        }
        return _interface;
    }

    private IFullOrgUnit getOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private ICompanyOrgUnit getCompanyInterface() throws Exception {
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private ISaleOrgUnit getSaleInterface() throws Exception {
        return SaleOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private IPurchaseOrgUnit getPurchaseInterface() throws Exception {
        return PurchaseOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private IStorageOrgUnit getStorageInterface() throws Exception {
        return StorageOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private ICostCenterOrgUnit getCostCenterInterface() throws Exception {
        return CostCenterOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private IProfitCenterOrgUnit getProfitCenterInterface() throws Exception {
        return ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private IHROrgUnit getHRInterface() throws Exception {
        return HROrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private ITransportOrgUnit getTransportInterface() throws Exception {
        return TransportOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    private IQualityOrgUnit getQualityInterface() throws Exception {
        return QualityOrgUnitFactory.getLocalInstance((Context)this.getCalculator().getContext());
    }

    @Override
    public void fillValue(Object value) {
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            Map typeMap = null;
            String orgUnitId = null;
            Boolean isBizUnit = null;
            BgGetOrgAttrInfo orgAttrInfo = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                orgAttrInfo = (BgGetOrgAttrInfo)this.getCalculator().getFormula().get(i);
                if (orgAttrInfo.isCalculate()) {
                    orgUnitId = orgAttrInfo.getOrgUnitInfo().getId().toString();
                    if (valueMap.containsKey(orgUnitId) && (typeMap = (Map)valueMap.get(orgUnitId)).containsKey(orgAttrInfo.getOrgUnitType())) {
                        isBizUnit = (Boolean)typeMap.get(orgAttrInfo.getOrgUnitType());
                        orgAttrInfo.setVirtual(isBizUnit);
                    }
                    orgAttrInfo.getParameter().setValue((Object)orgAttrInfo.isValue());
                    continue;
                }
                orgAttrInfo.getParameter().setValue((Object)BgGetOrgAttrInfo.badException);
            }
        }
    }
}

