/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.ref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.AbstractCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.BgRefInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.BgRefTemInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractBgRefCalculateUtils
extends AbstractCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)AbstractBgRefCalculateUtils.class.getName());
    private Map<String, BgFormInfo> bgFormCacheMap = new HashMap<String, BgFormInfo>();

    public AbstractBgRefCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    public Map<String, BgFormInfo> getBgFormCacheMap() {
        return this.bgFormCacheMap;
    }

    @Override
    public void beforeCommonInit() throws Exception {
    }

    @Override
    public List<IFormula> parseCalculateParam(SortedParameterArray paramOuts) throws Exception {
        Parameter parameter = null;
        HashSet<String> tmpSet = new HashSet<String>();
        DefaultFormulaValue value = this.getDefaultFormulaValue();
        IReportPropertyAdapter adapter = this.getCalculator().getProvider().getReportAdapter();
        String bgSchemeNumber = null;
        if (adapter.getReportProperty("BG_SCHEME_NUMBER") != null) {
            bgSchemeNumber = adapter.getReportProperty("BG_SCHEME_NUMBER").toString();
        }
        StringBuffer sb = new StringBuffer();
        int in = paramOuts.size();
        for (int i = 0; i < in; ++i) {
            parameter = paramOuts.getParameter(i);
            Object[] params = parameter.getArgs();
            Variant variant1 = (Variant)params[1];
            Variant variant2 = (Variant)params[2];
            if (variant1.getValue() != null && !variant1.getValue().toString().equalsIgnoreCase("")) {
                sb.append(variant1.toString()).append("!");
            } else {
                sb.append(bgSchemeNumber).append("!");
            }
            sb.append(variant2.toString());
            tmpSet.add(sb.toString());
            sb.setLength(0);
        }
        this.queryBgSpecialItemsOfBgForm();
        this.queryBgTemplatesOfFormula(tmpSet);
        return super.parseCalculateParam(paramOuts);
    }

    @Override
    public void queryBaseInfo() throws Exception {
        this.queryBgFormInfo();
    }

    protected abstract void queryBgFormInfo() throws Exception;

    protected abstract void queryBgSpecialItemsOfBgForm() throws Exception;

    protected abstract void queryBgTemplatesOfFormula(Set var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeCalculate() throws Exception {
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        Map<String, List<IFormula>> batchMap = cache.getBatchKeyMap();
        String batchKey = null;
        String batchKeyInFormMap = null;
        List<IFormula> formulas = null;
        Map.Entry<String, List<IFormula>> entry2 = null;
        HashMap<String, Map<String, Map<String, Object>>> valueMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap valueMap1 = new HashMap();
        Map sheetMap = null;
        Map<String, Object> cellMap = null;
        BgFormInfo bgFormInfo = null;
        BgRefInfo refInfo = null;
        byte[] bytes = null;
        Rect rect = null;
        Book book = null;
        Sheet sheet = null;
        Cell cell = null;
        Connection conn = null;
        Map<String, Map<String, List<IFormula>>> multiBatchMap = this.beforeSplitMultiBatchKey(batchMap);
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            logger.error((Object)("AbstractBgRefCalculateUtils batchMap : " + batchMap));
            for (Map.Entry<String, Map<String, List<IFormula>>> multiEntry : multiBatchMap.entrySet()) {
                batchMap = multiEntry.getValue();
                for (Map.Entry<String, List<IFormula>> entry2 : batchMap.entrySet()) {
                    batchKey = entry2.getKey();
                    formulas = entry2.getValue();
                    batchKeyInFormMap = this.IsformulaKeyInFormMap(batchKey);
                    if (!this.getBgFormCacheMap().containsKey(batchKeyInFormMap)) continue;
                    bgFormInfo = this.getBgFormCacheMap().get(batchKeyInFormMap);
                    if ((bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormInfo.getId(), true)) == null) continue;
                    String specialDimensionNumber = bgFormInfo.getSpecialItemNumber();
                    bytes = bgFormInfo.getZipData();
                    if (bytes == null || bytes.length == 0) continue;
                    try {
                        book = bgFormInfo.getBook();
                        BgNFSHelper.disableCal(book);
                        BgNFSHelper.disableUndo(book);
                        HashMap formulaSet = new HashMap();
                        String formula = null;
                        int in = formulas.size();
                        for (int i = 0; i < in; ++i) {
                            refInfo = (BgRefInfo)formulas.get(i);
                            if (refInfo instanceof BgRefTemInfo && specialDimensionNumber != null && !this.isStringArrayElementSame(specialDimensionNumber, ((BgRefTemInfo)refInfo).getSpecialDimensionNumber())) continue;
                            sheet = book.getSheet(refInfo.getSheetName());
                            if (sheet == null) {
                                try {
                                    sheet = book.getSheetByName(refInfo.getSheetName());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (sheet == null) continue;
                            if (valueMap.containsKey(batchKey)) {
                                sheetMap = (Map)valueMap.get(batchKey);
                            } else {
                                sheetMap = new HashMap();
                                valueMap.put(batchKey, sheetMap);
                            }
                            rect = TableToolkit.range2xy((String)refInfo.getCellPos());
                            if (rect == null || (cell = sheet.getCell(rect.getYBase(), rect.getXBase(), false)) == null) continue;
                            if (cell.getValue() != null && cell.getValue().getValue() instanceof String && "".equals(cell.getValue().toString().trim())) {
                                cell.setValue(new Variant(0));
                            }
                            if (sheetMap.containsKey(refInfo.getSheetName())) {
                                cellMap = (Map)sheetMap.get(refInfo.getSheetName());
                            } else {
                                cellMap = new HashMap();
                                sheetMap.put(refInfo.getSheetName(), cellMap);
                            }
                            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                                formula = BgNFSHelper.getFormulaOfCell(cell);
                                if (!formulaSet.containsKey(formula)) {
                                    formulaSet.put(formula, new HashMap());
                                }
                                if (!((Map)formulaSet.get(formula)).containsKey(refInfo.getSheetName())) {
                                    ((Map)formulaSet.get(formula)).put(refInfo.getSheetName(), new HashSet());
                                }
                                ((Set)((Map)formulaSet.get(formula)).get(refInfo.getSheetName())).add(refInfo.getCellPos());
                            }
                            cellMap.put(refInfo.getCellPos(), BgNFSHelper.getValue(cell));
                        }
                        if (formulaSet.isEmpty() || sheetMap == null) continue;
                        Map<String, BigDecimal> realValueMap = this.getRealValueByScheme(conn, bgFormInfo, formulaSet.keySet(), batchKey);
                        for (String formula1 : formulaSet.keySet()) {
                            for (String sheetName : ((Map)formulaSet.get(formula1)).keySet()) {
                                cellMap = (HashMap)sheetMap.get(sheetName);
                                for (String pos : (Set)((Map)formulaSet.get(formula1)).get(sheetName)) {
                                    cellMap.put(pos, realValueMap.get(formula1) != null ? realValueMap.get(formula1) : BigDecimal.ZERO);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"book Parse Error:", (Throwable)ex);
                    }
                    finally {
                        book = null;
                    }
                }
            }
        }
        catch (SQLDataException ex) {
            try {
                logger.error((Object)"queryBgTemplateInfo SQL Error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        if (valueMap.isEmpty()) {
            return valueMap;
        }
        return this.mergeMultiOrgValueMap(valueMap, multiBatchMap);
    }

    private Map<String, Map<String, Map<String, Object>>> mergeMultiOrgValueMap(Map<String, Map<String, Map<String, Object>>> valueMap, Map<String, Map<String, List<IFormula>>> multiBatchMap) {
        StringBuilder builder = new StringBuilder();
        HashMap<String, Map<String, Map<String, Object>>> data = new HashMap<String, Map<String, Map<String, Object>>>();
        for (String multiEntryKey : multiBatchMap.keySet()) {
            String[] strs = multiEntryKey.split("!");
            String orgNumber = strs[0];
            if (orgNumber.contains(";")) {
                String[] splitNumbers = orgNumber.split(";");
                int in = splitNumbers.length;
                for (int i = 0; i < in; ++i) {
                    String[] params = Arrays.copyOf(strs, strs.length);
                    params[0] = splitNumbers[i].trim();
                    for (String param : params) {
                        builder.append(param).append("!");
                    }
                    String singleEntryKey = builder.deleteCharAt(builder.length() - 1).toString();
                    Map<String, Object> sheetNameMap = valueMap.get(singleEntryKey);
                    if (data.containsKey(multiEntryKey)) {
                        Map multiSheetMap = (Map)data.get(multiEntryKey);
                        this.toMergeChild(sheetNameMap, multiSheetMap);
                    } else {
                        data.put(multiEntryKey, this.deepCopyMap(sheetNameMap));
                    }
                    builder.setLength(0);
                }
                continue;
            }
            if (valueMap.get(multiEntryKey) == null) continue;
            data.put(multiEntryKey, this.deepCopyMap(valueMap.get(multiEntryKey)));
        }
        return data;
    }

    private Map deepCopyMap(Map map) {
        HashMap copy = new HashMap();
        if (map == null || map.isEmpty()) {
            return copy;
        }
        Set set = map.keySet();
        for (Object obj : set) {
            if (copy.containsKey(obj)) continue;
            Object o = map.get(obj);
            if (o instanceof Map) {
                copy.put(obj, this.deepCopyMap((Map)o));
                continue;
            }
            copy.put(obj, o);
        }
        return copy;
    }

    private void toMergeChild(Map<String, Object> sourceValueMap, Map mergeValueMap) {
        if (sourceValueMap == null || mergeValueMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : sourceValueMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (mergeValueMap.containsKey(key)) {
                if (value instanceof BigDecimal) {
                    Object o = mergeValueMap.get(key);
                    BigDecimal sum = ((BigDecimal)value).add((BigDecimal)o);
                    mergeValueMap.put(key, sum);
                    continue;
                }
                if (!(value instanceof Map)) continue;
                this.toMergeChild((Map)value, (Map)mergeValueMap.get(key));
                continue;
            }
            mergeValueMap.put(key, this.deepCopyMap((Map)value));
        }
    }

    protected Map<String, Map<String, List<IFormula>>> beforeSplitMultiBatchKey(Map<String, List<IFormula>> batchMap) {
        HashMap<String, Map<String, List<IFormula>>> multiBatchMap = new HashMap<String, Map<String, List<IFormula>>>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<IFormula>> entry : batchMap.entrySet()) {
            String key = entry.getKey();
            List<IFormula> value = entry.getValue();
            String[] strs = key.split("!");
            String orgNumber = strs[0];
            HashMap<String, List<IFormula>> childBatchMap = new HashMap<String, List<IFormula>>();
            if (orgNumber.contains(";")) {
                String[] splitNumbers = orgNumber.split(";");
                int in = splitNumbers.length;
                for (int i = 0; i < in; ++i) {
                    String[] params = Arrays.copyOf(strs, strs.length);
                    params[0] = splitNumbers[i].trim();
                    for (String param : params) {
                        builder.append(param).append("!");
                    }
                    String singleKey = builder.deleteCharAt(builder.length() - 1).toString();
                    ArrayList<IFormula> iFormulas = new ArrayList<IFormula>(value);
                    for (IFormula formula : iFormulas) {
                        BgRefTemInfo refTemInfo = new BgRefTemInfo(this.getCalculator(), formula.getParameter());
                        refTemInfo.setBatchKey(null);
                        refTemInfo.setOrgUnitNumber(params[0]);
                    }
                    childBatchMap.put(singleKey, iFormulas);
                    builder.setLength(0);
                }
                multiBatchMap.put(key, childBatchMap);
                continue;
            }
            childBatchMap.put(key, value);
            multiBatchMap.put(key, childBatchMap);
        }
        return multiBatchMap;
    }

    private String IsformulaKeyInFormMap(String batchKey) {
        String[] batchKeyNumbs = batchKey.split("!");
        Set<String> formKeySet = this.getBgFormCacheMap().keySet();
        String formKey = batchKey;
        for (String temp : formKeySet) {
            String[] bgFormCacheMapNums = temp.split("!");
            if (bgFormCacheMapNums.length != batchKeyNumbs.length || !this.isStringArrayElementSame(temp, batchKey)) continue;
            formKey = temp;
        }
        return formKey;
    }

    private boolean isStringArrayElementSame(String batchKey, String bgFormCacheMap) {
        boolean flag = true;
        String[] o1 = batchKey.split("!");
        String[] o2 = bgFormCacheMap.split("!");
        List<String> list = Arrays.asList(o1);
        for (int i = 0; i < o2.length; ++i) {
            if (o2[i].contains(DimensionConstants.COMMA_SEPARATOR)) {
                String[] specialItems2;
                String[] specialItems1 = o1[i].split(DimensionConstants.COMMA_SEPARATOR);
                if (specialItems1.length != (specialItems2 = o2[i].split(DimensionConstants.COMMA_SEPARATOR)).length) {
                    flag = false;
                }
                List<String> o3 = Arrays.asList(specialItems1);
                for (int j = 0; j < specialItems2.length; ++j) {
                    if (o3.contains(specialItems2[j])) continue;
                    flag = false;
                }
                continue;
            }
            if (o1[i].equals(o2[i])) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private Map<String, BigDecimal> getRealValueByScheme(Connection conn, BgFormInfo bgFormInfo, Set<String> formulaSet, String batchKey) throws EASBizException, BOSException {
        String[] orgBgFormNum = batchKey.split("!");
        String orgNum = orgBgFormNum[0];
        BgFormInfo bgformInfo = BgViewServerHelper.getBgFormInfo(this.getCalculator().getContext(), bgFormInfo.getId(), false);
        BgScenarioCollection collection = BgScenarioFactory.getLocalInstance((Context)this.getCalculator().getContext()).getBgScenarioCollection();
        HashMap<String, BgScenarioType> map = new HashMap<String, BgScenarioType>();
        for (BgScenarioInfo info : collection) {
            map.put(info.getNumber(), info.getType());
        }
        SortedParameterArray param = new SortedParameterArray();
        HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
        for (String formula : formulaSet) {
            String item = null;
            String period = null;
            String element = null;
            String currency = null;
            String versionNumber = bgformInfo.getBgVersion().getNumber();
            String schemeNumber = bgformInfo.getBgScheme().getNumber();
            String scenNumber = null;
            String[] params = BgNFSHelper.parseFormulaPara(null, formula);
            if (params.length == 4) {
                item = params[0];
                period = params[1];
                element = params[2];
                currency = params[4];
            } else if (params.length == 6) {
                item = params[0];
                period = params[1];
                element = params[2];
                currency = params[5];
                scenNumber = params[3];
            }
            Object[] args = new Variant[11];
            args[0] = new Variant((Object)orgNum, 11);
            args[1] = new Variant((Object)schemeNumber, 11);
            args[2] = new Variant((Object)scenNumber, 11);
            args[3] = new Variant((Object)item, 11);
            args[4] = new Variant((Object)period, 11);
            args[5] = new Variant((Object)period, 11);
            args[6] = new Variant((Object)versionNumber, 11);
            args[7] = new Variant((Object)currency, 11);
            args[8] = new Variant((Object)element, 11);
            args[9] = map != null && !map.isEmpty() && map.containsKey(scenNumber) ? (((BgScenarioType)map.get(scenNumber)).getValue() == 1 ? new Variant((Object)"actual", 11) : new Variant((Object)"budget", 11)) : new Variant((Object)"budget", 11);
            args[10] = new Variant((Object)bgformInfo.getProcessType().getName(), 11);
            Parameter para = new Parameter(args, "Sheet1");
            parameterMap.put(formula, para);
            param.append((Object)para);
        }
        BgAggregateCalculator calculator = new BgAggregateCalculator(this.getCalculator().getContext(), this.getCalculator().getProvider());
        BgAggregateCalculateUtils utils = (BgAggregateCalculateUtils)calculator.getUtils();
        if (utils.getDefaultValue() == null) {
            DefaultFormulaValue value = this.getDefaultFormulaValue();
            utils.setDefaultValue(value);
        }
        utils.getDefaultValue().setBgFormId(bgFormInfo.getId().toString());
        utils.getDefaultValue().setTemplateId(bgFormInfo.getBgTemplate().getId().toString());
        utils.getDefaultValue().setProcessType(bgFormInfo.getProcessType());
        calculator.execute(param);
        HashMap<String, BigDecimal> realValueMap = new HashMap<String, BigDecimal>();
        for (String formula : parameterMap.keySet()) {
            if (!(((Parameter)parameterMap.get(formula)).getValue() instanceof BigDecimal)) continue;
            realValueMap.put(formula, (BigDecimal)((Parameter)parameterMap.get(formula)).getValue());
        }
        return realValueMap;
    }

    @Override
    public void fillValue(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            Map sheetMap = null;
            Map cellMap = null;
            BgRefInfo bgRefInfo = null;
            int in = this.getCalculator().getFormula().size();
            for (int i = 0; i < in; ++i) {
                bgRefInfo = (BgRefInfo)this.getCalculator().getFormula().get(i);
                if (valueMap.containsKey(bgRefInfo.getBatchCalculateKey()) && (sheetMap = (Map)valueMap.get(bgRefInfo.getBatchCalculateKey())).containsKey(bgRefInfo.getSheetName()) && (cellMap = (Map)sheetMap.get(bgRefInfo.getSheetName())).containsKey(bgRefInfo.getCellPos())) {
                    bgRefInfo.getParameter().setValue(cellMap.get(bgRefInfo.getCellPos()));
                }
                if (bgRefInfo.getParameter().getValue() != null) continue;
                bgRefInfo.getParameter().setValue((Object)BigDecimal.ZERO);
            }
        }
    }
}

