/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.ref;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.AbstractBgRefCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.BgRefFormInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgRefFormCalculateUtils
extends AbstractBgRefCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)BgRefFormCalculateUtils.class.getName());

    public BgRefFormCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgRefFormInfo(this.getCalculator(), parameter);
    }

    @Override
    protected void queryBgFormInfo() throws Exception {
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        ArrayList<String> temList = new ArrayList<String>();
        temList.addAll(cache.getBatchKeyMap().keySet());
        String key = null;
        String _fid = null;
        String _uNumber = null;
        String _fNumber = null;
        String _sNumber = null;
        String[] number = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo tmpInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 10;
        int size = temList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT f.FID, u.FNumber, f.FNumber, f.FVersionNo,s.FNumber FROM T_MBG_BgForm f LEFT JOIN T_ORG_CostCenter u on f.FOrgUnitId = u.FID LEFT JOIN T_mbg_BgScheme s on f.FbgSchemeid = s.FID WHERE (u.FNumber = ? AND s.FNumber = ? AND f.FNumber = ?)");
        for (int i = 1; i < batchSize; ++i) {
            sql.append(" OR (u.FNumber = ? AND s.FNumber = ? AND f.FNumber = ?)");
        }
        sql.append(" AND f.FState NOT IN (15)");
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 0;
                while (x < batchSize) {
                    if (pos < size) {
                        key = (String)temList.get(pos);
                        number = key.split("!");
                        pstmt.setString(x * 3 + 1, number[0]);
                        pstmt.setString(x * 3 + 2, number[1]);
                        pstmt.setString(x * 3 + 3, number[2]);
                    } else {
                        pstmt.setString(x * 3 + 1, "#");
                        pstmt.setString(x * 3 + 2, "#");
                        pstmt.setString(x * 3 + 3, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _uNumber = rst.getString(2);
                    _fNumber = rst.getString(3);
                    _sNumber = rst.getString(5);
                    key = new StringBuffer(_uNumber).append("!").append(_sNumber).append("!").append(_fNumber).toString();
                    bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)_fid));
                    bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                    if (this.getBgFormCacheMap().containsKey(key)) {
                        tmpInfo = this.getBgFormCacheMap().get(key);
                        if (bgFormInfo.getVersionNo().compareTo(tmpInfo.getVersionNo()) <= 0) continue;
                        this.getBgFormCacheMap().put(key, bgFormInfo);
                        continue;
                    }
                    this.getBgFormCacheMap().put(key, bgFormInfo);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgTemplateInfo SQL Error:", (Throwable)ex);
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void queryBgSpecialItemsOfBgForm() throws Exception {
    }

    @Override
    protected void queryBgTemplatesOfFormula(Set tmpSet) throws Exception {
    }
}

