/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.ref;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsCollection;
import com.kingdee.eas.ma.mbg.BgSpecialItemsFactory;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.AbstractBgRefCalculateUtils;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.BgRefTemInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgRefTemCalculateUtils
extends AbstractBgRefCalculateUtils {
    private static final Logger logger = Logger.getLogger((String)BgRefTemCalculateUtils.class.getName());

    public BgRefTemCalculateUtils(IBgCalculator calculator) {
        super(calculator);
    }

    @Override
    public IFormula createFormula(Parameter parameter) {
        return new BgRefTemInfo(this.getCalculator(), parameter);
    }

    @Override
    protected void queryBgFormInfo() throws Exception {
        IFormulaCacheManager cache = this.getCalculator().getCacheManager();
        List<String> temList = new ArrayList<String>();
        temList.addAll(cache.getBatchKeyMap().keySet());
        StringBuilder builder = new StringBuilder();
        temList = this.splitMultiOrg(temList, builder);
        String key = null;
        StringBuffer keytem = null;
        String _fid = null;
        String _uNumber = null;
        String _sNumber = null;
        String _tNumber = null;
        String _pNumber = null;
        String _cNumber = null;
        String _vNumber = null;
        String _specialDimensionItemNumber = null;
        String[] number = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo tmpInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 10;
        int size = temList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT f.FID, u.FNumber, s.FNumber, t.FNumber, p.FNumber, v.FNumber, c.FNumber, f.FVersionNo, specialItem.FDimensionNumber, f.FProcessType FROM T_MBG_BgForm f LEFT JOIN T_ORG_CostCenter u on f.FOrgUnitId = u.FID LEFT JOIN T_MBG_BgScheme s on f.fbgschemeId = s.FID LEFT JOIN T_MBG_BgTemplate t on f.FBgtemplateId = t.FID LEFT JOIN T_MBG_BgPeriod p on f.FBgPeriodId = p.FID LEFT JOIN T_BD_Currency c on f.FCurrencyId = c.FID left join T_MBG_BgVersion v on f.FBgVersionId = v.FID left join T_MBG_BgSpecialItems specialItem  on specialItem.fBgformID = f.FID WHERE ((u.FNumber = ? AND s.FNumber = ? AND t.FNumber = ? AND p.FNumber = ? and v.FNumber = ? AND c.FNumber = ? AND f.FProcessType = ?)");
        for (int i = 1; i < batchSize; ++i) {
            sql.append(" OR (u.FNumber = ? AND s.FNumber = ? AND t.FNumber = ? AND p.FNumber = ? and v.FNumber = ? AND c.FNumber = ? AND f.FProcessType = ?)");
        }
        sql.append(") AND f.FState NOT IN (15)");
        int _processType = 0;
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 0;
                while (x < batchSize) {
                    if (pos < size) {
                        key = temList.get(pos);
                        number = key.split("!");
                        pstmt.setString(x * 7 + 1, number[0]);
                        pstmt.setString(x * 7 + 2, number[1]);
                        pstmt.setString(x * 7 + 3, number[2]);
                        pstmt.setString(x * 7 + 4, number[3]);
                        pstmt.setString(x * 7 + 5, number[4]);
                        pstmt.setString(x * 7 + 6, number[5]);
                        pstmt.setInt(x * 7 + 7, Integer.parseInt(number[6]));
                    } else {
                        pstmt.setString(x * 7 + 1, "#");
                        pstmt.setString(x * 7 + 2, "#");
                        pstmt.setString(x * 7 + 3, "#");
                        pstmt.setString(x * 7 + 4, "#");
                        pstmt.setString(x * 7 + 5, "#");
                        pstmt.setString(x * 7 + 6, "#");
                        pstmt.setInt(x * 7 + 7, 1);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _uNumber = rst.getString(2);
                    _sNumber = rst.getString(3);
                    _tNumber = rst.getString(4);
                    _pNumber = rst.getString(5);
                    _vNumber = rst.getString(6);
                    _cNumber = rst.getString(7);
                    _specialDimensionItemNumber = rst.getString("FDimensionNumber");
                    _processType = rst.getInt(10);
                    keytem = new StringBuffer(_uNumber).append("!").append(_sNumber).append("!").append(_tNumber).append("!").append(_pNumber).append("!").append(_vNumber).append("!").append(_cNumber).append("!").append(_processType);
                    if (_specialDimensionItemNumber != null) {
                        keytem.append("!").append(_specialDimensionItemNumber);
                    }
                    key = keytem.toString();
                    keytem.setLength(0);
                    bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)_fid));
                    bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                    if (this.getBgFormCacheMap().containsKey(key)) {
                        tmpInfo = this.getBgFormCacheMap().get(key);
                        if (bgFormInfo.getVersionNo().compareTo(tmpInfo.getVersionNo()) <= 0) continue;
                        this.getBgFormCacheMap().put(key, bgFormInfo);
                        continue;
                    }
                    this.getBgFormCacheMap().put(key, bgFormInfo);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgTemplateInfo SQL Error:", (Throwable)ex);
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    private List<String> splitMultiOrg(List<String> temList, StringBuilder builder) {
        ArrayList<String> data = new ArrayList<String>();
        for (String key : temList) {
            String[] strs = key.split("!");
            String orgNumber = strs[0];
            if (!orgNumber.contains(";")) {
                data.add(key);
                continue;
            }
            String[] splitNumbers = orgNumber.split(";");
            int in = splitNumbers.length;
            for (int i = 0; i < in; ++i) {
                String[] params = Arrays.copyOf(strs, strs.length);
                params[0] = splitNumbers[i].trim();
                for (String param : params) {
                    builder.append(param).append("!");
                }
                data.add(builder.deleteCharAt(builder.length() - 1).toString());
                builder.setLength(0);
            }
        }
        return data;
    }

    @Override
    protected void queryBgSpecialItemsOfBgForm() throws Exception {
        IReportPropertyAdapter adapter = this.getCalculator().getProvider().getReportAdapter();
        String bgFormId = null;
        if (adapter.getReportProperty("BG_FORM_ID") == null) {
            return;
        }
        bgFormId = adapter.getReportProperty("BG_FORM_ID").toString();
        FormulaCacheManager cache = (FormulaCacheManager)this.getCalculator().getCacheManager();
        BgSpecialItemsInfo bgSpecialItemsInfo = null;
        BgSpecialItemsCollection colls = BgSpecialItemsFactory.getLocalInstance(this.getCalculator().getContext()).getBgSpecialItemsCollection("select id, dimensionNumber, dimensionName, memberName, memberDisplayName, dimensionAlias where bgForm.id = '" + bgFormId + "'");
        if (colls != null && !colls.isEmpty()) {
            bgSpecialItemsInfo = colls.get(0);
        }
        if (!cache.getbgSpecialItemsInfoOfBgform().containsKey(bgFormId)) {
            cache.getbgSpecialItemsInfoOfBgform().put(bgFormId, bgSpecialItemsInfo);
        }
    }

    @Override
    protected void queryBgTemplatesOfFormula(Set tmpSet) throws Exception {
        ArrayList temList = new ArrayList();
        temList.addAll(tmpSet);
        String key = null;
        StringBuffer keytem = null;
        String _uNumber = null;
        String _sNumber = null;
        String _specialDimensionItemNumber = null;
        String[] number = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        FormulaCacheManager cache = (FormulaCacheManager)this.getCalculator().getCacheManager();
        int batchSize = 10;
        int size = temList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT s.FNumber,t.FNumber, specialItem.FDimensionNumber FROM T_MBG_BgSpecialItems specialItem  LEFT JOIN T_MBG_BgTemplate t on specialItem.FBgTemplateId = t.FID LEFT JOIN T_MBG_BgScheme s on s.FId = t.FBgSchemeID  WHERE ((t.FNumber = ? AND s.FNumber = ?)");
        for (int i = 1; i < batchSize; ++i) {
            sql.append(" OR (t.FNumber = ? AND s.FNumber = ? )");
        }
        sql.append(")");
        try {
            conn = BgDBUtils.getConnection((Context)this.getCalculator().getContext());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 0;
                while (x < batchSize) {
                    if (pos < size) {
                        key = (String)temList.get(pos);
                        number = key.split("!");
                        pstmt.setString(x * 2 + 1, number[1]);
                        pstmt.setString(x * 2 + 2, number[0]);
                        System.out.println();
                    } else {
                        pstmt.setString(x * 2 + 1, "#");
                        pstmt.setString(x * 2 + 2, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _uNumber = rst.getString(1);
                    _sNumber = rst.getString(2);
                    _specialDimensionItemNumber = rst.getString(3);
                    keytem = new StringBuffer(_uNumber).append("!").append(_sNumber);
                    key = keytem.toString();
                    keytem.setLength(0);
                    if (cache.getbgSpecialItemsInfoOfBgform().containsKey(key)) continue;
                    cache.getFormulaOfBgTemplateSpecialItem().put(key, _specialDimensionItemNumber);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgTemplateInfo SQL Error:", (Throwable)ex);
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }
}

