/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.formula.impl.ref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.impl.DefaultFormulaValue;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaCacheManager;
import com.kingdee.eas.ma.mbg.app.formula.impl.ref.AbstractBgRefTemInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;

public class BgRefTemInfo
extends AbstractBgRefTemInfo {
    private String batchKey = null;
    private String processType = null;

    public void setBatchKey(String batchKey) {
        this.batchKey = batchKey;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getProcessType() {
        return this.processType;
    }

    public int getProcessTypeValue() {
        if (StringUtils.isEmpty((String)this.processType)) {
            return -1;
        }
        BgProcessEnum process = BgProcessEnum.getEnum(this.getProcessType());
        if (process == null) {
            return -1;
        }
        return process.getValue();
    }

    public BgRefTemInfo(IBgCalculator calculator, Parameter parameter) {
        super(calculator, parameter);
    }

    @Override
    public String getBatchCalculateKey() {
        StringBuffer sb = new StringBuffer();
        if (this.batchKey == null) {
            this.batchKey = this.getOrgUnitNumber() + "!" + this.getBgSchemeNumber() + "!" + this.getBgTemplateNumber() + "!" + this.getBgPeriodNumber() + "!" + this.getBgVersionNum() + "!" + this.getCurrencyNumber() + "!" + this.getProcessTypeValue();
            if (this.getSpecialDimensionNumber() != null) {
                sb.append("!").append(this.getSpecialDimensionNumber());
            }
            this.batchKey = this.batchKey + sb.toString();
        }
        return this.batchKey;
    }

    @Override
    protected void parseParameter(DefaultFormulaValue value) {
        if (this.getParameter() == null) {
            return;
        }
        Object[] params = FormulaUtils.updateParams("MbgRefBgTem", this.getParameter());
        Variant variant = (Variant)params[0];
        if (variant.getValue() != null) {
            this.setOrgUnitNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[1]).getValue() != null) {
            this.setBgSchemeNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[2]).getValue() != null) {
            this.setBgTemplateNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[3]).getValue() != null) {
            this.setBgPeriodNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[4]).getValue() != null) {
            this.setBgVersionNum(variant.getValue().toString());
        }
        if ((variant = (Variant)params[5]).getValue() != null) {
            this.setCurrencyNumber(variant.getValue().toString());
        }
        if ((variant = (Variant)params[6]).getValue() != null) {
            this.setSheetName(variant.getValue().toString());
        }
        if ((variant = (Variant)params[7]).getValue() != null) {
            this.setCellPos(variant.getValue().toString());
        }
        if (params.length >= 9 && (variant = (Variant)params[8]).getValue() != null && !variant.toString().equalsIgnoreCase("")) {
            this.setSpecialDimensionNumber(variant.getValue().toString());
        }
        if (params.length >= 10 && (variant = (Variant)params[9]).getValue() != null && !variant.toString().equalsIgnoreCase("")) {
            this.setProcessType(variant.getValue().toString());
        }
    }

    @Override
    protected void fillParameter(DefaultFormulaValue value) {
        if (value == null) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getOrgUnitNumber())) {
            this.setOrgUnitNumber(value.getOrgUnitNumber());
        }
        if (StringUtils.isEmpty((String)this.getBgSchemeNumber())) {
            this.setBgSchemeNumber(value.getBgSchemeNumber());
        }
        if (StringUtils.isEmpty((String)this.getBgVersionNum())) {
            this.setBgVersionNum(value.getBgVersionNumber());
        }
        if (StringUtils.isEmpty((String)this.getCurrencyNumber())) {
            this.setCurrencyNumber(value.getCurrencyNumber());
        }
        if (StringUtils.isEmpty((String)this.getBgPeriodNumber())) {
            this.setBgPeriodNumber(value.getBgPeriodNumber());
        } else {
            int periodType = BgNPeriodHelper.parserBgPeriodType((String)value.getBgPeriodNumber());
            try {
                String bgPeriodByN = BgPeriodNVariableHelper.getBgPeriodByN((String)value.getBgPeriodNumber(), (String)this.getBgPeriodNumber(), (int)periodType);
                this.setBgPeriodNumber(bgPeriodByN);
            }
            catch (BgPeriodException e) {
                e.printStackTrace();
            }
        }
        BgSpecialItemsInfo bgSpecialItemsInfo = null;
        String bgTemplateSpecialItem = null;
        FormulaCacheManager cache = (FormulaCacheManager)this.getCalculator().getCacheManager();
        if (cache.getbgSpecialItemsInfoOfBgform().containsKey(value.getBgFormId())) {
            bgSpecialItemsInfo = cache.getbgSpecialItemsInfoOfBgform().get(value.getBgFormId());
        }
        if (cache.getFormulaOfBgTemplateSpecialItem().containsKey(this.getBgSchemeNumber() + "!" + this.getBgTemplateNumber())) {
            bgTemplateSpecialItem = cache.getFormulaOfBgTemplateSpecialItem().get(this.getBgSchemeNumber() + "!" + this.getBgTemplateNumber());
        }
        this.setSpecialDimensionNumber(this.fillSpecialDimensionNumber(this.getSpecialDimensionNumber(), bgSpecialItemsInfo, bgTemplateSpecialItem));
        if (StringUtils.isEmpty((String)this.getProcessType())) {
            this.setProcessType(value.getProcessType().getName());
        }
    }

    private BgTemplateInfo getBgTemplateInfo() {
        BgTemplateCollection bgTemplateInfoCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)this.getBgSchemeNumber()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getBgTemplateNumber()));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgTemplate.id");
        sic.add("formType");
        sic.add("bgSpecialItems.*");
        view.setSelector(sic);
        try {
            bgTemplateInfoCollection = BgTemplateFactory.getLocalInstance(this.getCalculator().getContext()).getBgTemplateCollection(view);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e, (String)"fill Bgform property SpecialItem error");
            e.printStackTrace();
        }
        return bgTemplateInfoCollection.get(0);
    }

    private String fillSpecialDimensionNumber(String seleSpecialDimensionNumber, BgSpecialItemsInfo bgSpecialItemsInfo, String bgtemplateInfo) {
        if (bgtemplateInfo == null) {
            return null;
        }
        StringBuffer specialDimensionNumber = new StringBuffer();
        String bgFormSpecialDimensionNumber = null;
        String[] bgformSpecialNums = null;
        String[] bgSeleSpecialNums = null;
        if (bgSpecialItemsInfo != null) {
            bgFormSpecialDimensionNumber = bgSpecialItemsInfo.getDimensionNumber();
            bgformSpecialNums = bgFormSpecialDimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
        }
        if (seleSpecialDimensionNumber != null) {
            bgSeleSpecialNums = seleSpecialDimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
        }
        String[] bgBgTemplateSpecialNums = bgtemplateInfo.split(DimensionConstants.COMMA_SEPARATOR);
        if (bgSeleSpecialNums != null && bgSeleSpecialNums.length == bgBgTemplateSpecialNums.length) {
            return seleSpecialDimensionNumber;
        }
        for (int i = 0; i < bgBgTemplateSpecialNums.length; ++i) {
            String[] singleSpecialNum = bgBgTemplateSpecialNums[i].split(DimensionConstants.COLON_SEPARATOR);
            if (specialDimensionNumber.toString().contains(DimensionConstants.COMMA_SEPARATOR) || !specialDimensionNumber.toString().isEmpty()) {
                specialDimensionNumber.append(DimensionConstants.COMMA_SEPARATOR);
            }
            if (seleSpecialDimensionNumber != null) {
                if (seleSpecialDimensionNumber.contains(singleSpecialNum[0])) {
                    if (seleSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, seleSpecialDimensionNumber.indexOf(singleSpecialNum[0])) != -1) {
                        specialDimensionNumber.append(seleSpecialDimensionNumber.substring(seleSpecialDimensionNumber.indexOf(singleSpecialNum[0]), seleSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, seleSpecialDimensionNumber.indexOf(singleSpecialNum[0]))));
                        continue;
                    }
                    specialDimensionNumber.append(seleSpecialDimensionNumber.substring(seleSpecialDimensionNumber.indexOf(singleSpecialNum[0])));
                    continue;
                }
                if (bgFormSpecialDimensionNumber == null || !bgFormSpecialDimensionNumber.contains(singleSpecialNum[0])) continue;
                if (bgFormSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0])) != -1) {
                    specialDimensionNumber.append(bgFormSpecialDimensionNumber.substring(bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0]), bgFormSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0]))));
                    continue;
                }
                specialDimensionNumber.append(bgFormSpecialDimensionNumber.substring(bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0])));
                continue;
            }
            if (bgFormSpecialDimensionNumber == null || !bgFormSpecialDimensionNumber.contains(singleSpecialNum[0])) continue;
            if (bgFormSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0])) != -1) {
                specialDimensionNumber.append(bgFormSpecialDimensionNumber.substring(bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0]), bgFormSpecialDimensionNumber.indexOf(DimensionConstants.COMMA_SEPARATOR, bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0]))));
                continue;
            }
            specialDimensionNumber.append(bgFormSpecialDimensionNumber.substring(bgFormSpecialDimensionNumber.indexOf(singleSpecialNum[0])));
        }
        if (specialDimensionNumber.toString().endsWith("!") || specialDimensionNumber.toString().endsWith(",")) {
            return specialDimensionNumber.substring(0, specialDimensionNumber.length() - 1);
        }
        return specialDimensionNumber.toString();
    }

    @Override
    protected boolean checkParseParameter(DefaultFormulaValue value) {
        if (StringUtils.isEmpty((String)this.getBgTemplateNumber())) {
            this.getParameter().setValue((Object)badException);
            return false;
        }
        if (StringUtils.isEmpty((String)this.getSheetName())) {
            this.getParameter().setValue((Object)badException);
            return false;
        }
        if (StringUtils.isEmpty((String)this.getCellPos())) {
            this.getParameter().setValue((Object)badException);
            return false;
        }
        return true;
    }

    @Override
    protected void pretreatmentParameter() {
    }
}

