/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.accintolap;

import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.JoinSql;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.Table;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.TableDefTableSource;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.TableManager;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.CubeDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.SchemaDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.InOutSqlUtil;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccIntOlapBatchTable
implements Table,
Serializable,
JoinSql {
    private static final long serialVersionUID = 7798564770565556152L;
    private static Logger logger = Logger.getLogger((String)AccIntOlapBatchTable.class.getName());
    private Connection conn = null;
    private String name = null;
    private int batchCount = 1;
    private String sql = null;
    private Map<String, List<Object[]>> paramList = null;
    private List<String> refCubes = null;
    private String baseCube = null;
    private boolean hasUnion = false;
    protected boolean isEmpty = false;
    protected boolean isAdjustPastData = false;
    protected PreparedStatement pstmt = null;
    protected ResultSet rst = null;
    int batchIndex = -1;
    int refCubeIndex = 0;
    private long startTime = -1L;
    private String[] columnNames;
    private Map<String, Integer> columnTypes = new HashMap<String, Integer>();
    private Map<String, Integer> columnIndexes = new HashMap<String, Integer>();
    private Object[] data;
    private static final Null nullObject = new Null();
    private Map<String, Integer> orgIntMap = new HashMap<String, Integer>();
    public Map<String, Map<Integer, String>> dimIntMap = new HashMap<String, Map<Integer, String>>();
    private boolean isConvert = false;

    public String getSql() {
        return this.sql;
    }

    public void nullData() {
        int size = this.columnNames.length;
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = nullObject;
        }
    }

    public Map<String, Integer> getOrgIntMap() {
        return this.orgIntMap;
    }

    public void setBaseCube(String baseCube) {
        this.baseCube = baseCube;
    }

    public void setHasUnion(boolean hasUnion) {
        this.hasUnion = hasUnion;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setParamList(Map<String, List<Object[]>> paramList) {
        this.paramList = paramList;
        this.refCubes = new ArrayList<String>(paramList.keySet());
    }

    public Map<String, List<Object[]>> getParamList() {
        return this.paramList;
    }

    public void setDimIntMap(Map<String, Map<String, Integer>> intMap, Map<String, String> fieldSrcMap) {
        if (intMap != null) {
            Map<String, Integer> subIntMap = null;
            HashMap<Integer, String> subDimIntMap = null;
            String srcNumber = null;
            for (String field : intMap.keySet()) {
                srcNumber = !DimUtils.checkBaseDimensionByField(field) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field) ? fieldSrcMap.get(field) : null;
                subIntMap = intMap.get(field);
                subDimIntMap = new HashMap<Integer, String>();
                this.dimIntMap.put(field, subDimIntMap);
                for (Map.Entry<String, Integer> entry : subIntMap.entrySet()) {
                    if (srcNumber == null) {
                        subDimIntMap.put(entry.getValue(), entry.getKey());
                        continue;
                    }
                    subDimIntMap.put(entry.getValue(), DimensionFormulaHelper.getCombination(srcNumber, entry.getKey()));
                }
            }
        }
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void setAdjustPastData(boolean isAdjustPastData) {
        this.isAdjustPastData = isAdjustPastData;
    }

    @Override
    public void joinSql(TableManager manager, SchemaDef schemaDef, CubeDef cubeDef) throws SQLException, CUBAException {
        this.sql = TableDefTableSource.joinSql(manager, schemaDef, cubeDef, this.name, this.sql);
    }

    protected void init() throws CUBAException {
        try {
            if (this.pstmt == null) {
                this.startTime = System.currentTimeMillis();
                MbgLoggerUtils.logger((String)"start batch table");
                this.createPstmt();
                this.nextBatch();
            }
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    protected void createPstmt() throws SQLException {
        if (this.pstmt != null) {
            SQLUtils.cleanup((Statement)this.pstmt);
        }
        String bSql = this.sql.replaceAll(DimensionConstants.CUBE_NAME, this.refCubes.get(this.refCubeIndex));
        if (this.isAdjustPastData) {
            bSql = this.sql.replaceFirst(DimensionConstants.CUBE_NAME, this.refCubes.get(this.refCubeIndex) + " Inner Join (Select FPastValue, FBgDataId FROM T_MBG_BgPastData) past ON past.FBgDataId = " + this.refCubes.get(this.refCubeIndex) + ".FID").replaceAll(DimensionConstants.CUBE_NAME, this.refCubes.get(this.refCubeIndex));
            bSql = bSql.indexOf("sum(") > 0 ? bSql.replace("sum(FVALUE)", "sum(FPastValue)").replace("sum(FTMPVALUE)", "sum(FPastValue)") : bSql.replace("FVALUE", "FPastValue FValue").replace("FTMPVALUE", "FPastValue FTmpValue");
        }
        if (this.refCubes.get(this.refCubeIndex).length() == 21) {
            this.isConvert = true;
            if (this.hasUnion) {
                bSql = bSql + " and FScenario in (select FSCENARIOID from T_MBG_BGSCENARIO where FTYPE = 0)";
            }
            bSql = bSql.replaceAll("FOrgUnitID IN \\(select FID from", "FOrgUnitID IN \\(select FIntID from");
            for (String id : this.getOrgIntMap().keySet()) {
                bSql = bSql.replace("'" + id + "'", String.valueOf(this.getOrgIntMap().get(id)));
            }
            bSql = bSql.replace("'\"", "'");
        } else {
            this.isConvert = false;
        }
        String cType = DimUtils.getCurProcessType(this.refCubes.get(this.refCubeIndex));
        bSql = bSql.replace("'C01'", "'" + cType + "'");
        logger.error((Object)("batch sql:" + bSql));
        this.pstmt = this.conn.prepareStatement(bSql);
    }

    protected void readColumn() throws SQLException {
        ResultSetMetaData md = null;
        if (this.rst != null) {
            md = this.rst.getMetaData();
        }
        if (md == null || md.getColumnCount() == 0) {
            this.columnNames = new String[0];
        } else {
            this.columnNames = new String[md.getColumnCount()];
            for (int i = 0; i < md.getColumnCount(); ++i) {
                this.columnNames[i] = md.getColumnName(i + 1);
                this.columnTypes.put(this.columnNames[i].toUpperCase(), md.getColumnType(i + 1));
                this.columnIndexes.put(this.columnNames[i].toUpperCase(), i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean nextBatch() throws CUBAException {
        if (this.isEmpty) {
            return false;
        }
        try {
            long st = System.currentTimeMillis();
            if (this.rst != null) {
                SQLUtils.cleanup((ResultSet)this.rst);
            }
            if (this.paramList == null || this.paramList.isEmpty()) {
                if (this.batchIndex != -1) return false;
                this.rst = this.pstmt.executeQuery();
                logger.info((Object)("nextBatch cost time(ms):" + (System.currentTimeMillis() - st)));
            } else {
                boolean isOneBatch;
                boolean bl = isOneBatch = this.batchIndex >= this.paramList.get(this.refCubes.get(this.refCubeIndex)).size() - 1;
                if (isOneBatch && this.refCubeIndex >= this.refCubes.size() - 1) {
                    return false;
                }
                if (isOneBatch) {
                    ++this.refCubeIndex;
                    this.batchIndex = -1;
                    this.createPstmt();
                }
                ++this.batchIndex;
                for (int i = 0; i < this.batchCount; ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)this.pstmt, (int)(this.paramList.get(this.refCubes.get(this.refCubeIndex)).get(this.batchIndex).length * i + 1), (Object[])this.paramList.get(this.refCubes.get(this.refCubeIndex)).get(this.batchIndex));
                }
                logger.info((Object)("nextBatch param:" + Arrays.toString(this.paramList.get(this.refCubes.get(this.refCubeIndex)).get(this.batchIndex))));
                this.rst = this.pstmt.executeQuery();
                logger.info((Object)("nextBatch cost time(ms):" + (System.currentTimeMillis() - st)));
            }
            this.readColumn();
            return true;
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public int getColumnCount() throws CUBAException {
        this.init();
        return this.columnNames.length;
    }

    @Override
    public int getColumnType(int index) throws CUBAException {
        this.init();
        return this.columnTypes.get(this.columnNames[index].toUpperCase());
    }

    @Override
    public int getColumnIndex(String name) throws CUBAException {
        this.init();
        Integer index = this.columnIndexes.get(name.toUpperCase());
        if (index == null) {
            throw new CUBAException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public String[] getColumnNames() throws CUBAException {
        this.init();
        return this.columnNames;
    }

    @Override
    public boolean next() throws CUBAException {
        if (this.isEmpty) {
            return false;
        }
        this.init();
        this.nullData();
        try {
            if (this.rst.next()) {
                return true;
            }
            while (this.nextBatch()) {
                if (!this.rst.next()) continue;
                return true;
            }
            MbgLoggerUtils.logger((String)("end batch table " + (System.currentTimeMillis() - this.startTime)));
            return false;
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public Object getValue(int index) throws CUBAException {
        this.init();
        if (this.data[index] != nullObject) {
            return this.data[index];
        }
        try {
            this.data[index] = InOutSqlUtil.getValue(this.rst, this.getColumnType(index), index + 1);
            if (this.isConvert) {
                this.data[index] = this.convertData(this.data[index], index);
            }
            return this.data[index];
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    private Object convertData(Object obj, int index) {
        if (index < this.columnNames.length && obj instanceof Number) {
            String columnname = this.columnNames[index];
            if ("FBGPERIODID".equalsIgnoreCase(columnname)) {
                columnname = DimensionConstants.DEF_PERIOD_FIELD;
            } else if ("FBGELEMENTID".equalsIgnoreCase(columnname)) {
                columnname = DimensionConstants.DEF_ELEMENT_FIELD;
            } else if ("FORGUNITID".equalsIgnoreCase(columnname)) {
                columnname = DimensionConstants.DEF_ORGUNIT_FIELD;
            }
            if (this.dimIntMap != null && this.dimIntMap.containsKey(columnname)) {
                Map<Integer, String> subMap = this.dimIntMap.get(columnname);
                return subMap.get(new Integer(((Number)obj).intValue()));
            }
        }
        return obj;
    }

    @Override
    public Object[] getValues() throws CUBAException {
        this.init();
        for (int i = 0; i < this.data.length; ++i) {
            if (nullObject != this.data[i]) continue;
            this.data[i] = this.getValue(i);
        }
        return this.data;
    }

    @Override
    public void close() {
        SQLUtils.cleanup((ResultSet)this.rst);
        SQLUtils.cleanup((Statement)this.pstmt);
    }

    private static class Null {
        private Null() {
        }
    }
}

