/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.accintolap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.ISplitData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BgSchemeAccIntHelper {
    private Context ctx = null;
    private String bgSchemeId = null;
    private String bgDataTable = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Boolean isUseAccInt = null;
    private Map<String, String> splitMap = null;
    private Map<String, Map<String, Integer>> dimIntMap = null;
    private Map<String, Map<String, String>> dimStringMap = null;

    public BgSchemeAccIntHelper(Context ctx, String bgSchemeId, String bgDataTable) {
        this.ctx = ctx;
        this.bgDataTable = bgDataTable;
        this.bgSchemeId = bgSchemeId;
    }

    public BgSchemeAccIntHelper(Context ctx, BgSchemeDimensionHelper schemeHelper, String bgDataTable) {
        this.ctx = ctx;
        this.bgDataTable = bgDataTable;
        this.bgSchemeId = schemeHelper.getBgSchemeId();
        this.schemeHelper = schemeHelper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.bgSchemeId);
        }
        return this.schemeHelper;
    }

    public String getBgDataTable() {
        return this.bgDataTable;
    }

    public boolean isUseAccInt() throws EASBizException, BOSException {
        if (this.isUseAccInt == null) {
            if (this.bgDataTable != null) {
                IBgScheme biz = null;
                biz = this.ctx == null ? BgSchemeFactory.getRemoteInstance() : BgSchemeFactory.getLocalInstance(this.ctx);
                this.isUseAccInt = biz.exists("where useAccInt > 0 AND id = '" + this.bgSchemeId + "' and refCube = '" + this.bgDataTable + "'");
            } else {
                this.isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt(this.ctx, this.bgSchemeId);
            }
        }
        return this.isUseAccInt;
    }

    public Map<String, String> getSplitMap() throws EASBizException, BOSException {
        if (this.splitMap == null && this.isUseAccInt()) {
            this.splitMap = BgSchemeConvertToAccIntUtils.querySplit(this.ctx, this.bgDataTable);
        }
        return this.splitMap;
    }

    public Map<String, Map<String, Integer>> getDimIntMap() throws EASBizException, BOSException {
        if (this.dimIntMap == null) {
            this.dimIntMap = new HashMap<String, Map<String, Integer>>();
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                BgSchemeConvertToAccIntUtils.queryDimInt(conn, this.dimIntMap, this.getSchemeHelper());
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return this.dimIntMap;
    }

    public Map<String, Map<String, String>> getDimStringMap() throws EASBizException, BOSException {
        if (this.dimStringMap == null) {
            this.dimStringMap = new HashMap<String, Map<String, String>>();
            Map<String, Map<String, Integer>> dimIntMap = this.getDimIntMap();
            HashMap<String, String> subMap = null;
            for (String field : dimIntMap.keySet()) {
                subMap = new HashMap<String, String>();
                this.dimStringMap.put(field, subMap);
                for (String number : dimIntMap.get(field).keySet()) {
                    subMap.put(String.valueOf(dimIntMap.get(field).get(number)), number);
                }
            }
        }
        return this.dimStringMap;
    }

    public Set<String> getSplitTablesByFormula(Collection<String> formulas) throws EASBizException, BOSException {
        return BgSchemeConvertToAccIntUtils.getSplitTablesByFormula(this.isUseAccInt(), this.bgDataTable, formulas, this.getSplitMap());
    }

    public Set<String> getSplitTablesByAcc(Collection<String> accNumbers) throws EASBizException, BOSException {
        return BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(this.isUseAccInt(), this.bgDataTable, accNumbers, this.getSplitMap());
    }

    public Integer convertInt(String field, String number) throws EASBizException, BOSException {
        return (Integer)BgSchemeConvertToAccIntUtils.convertInt(field, number, this.getDimIntMap());
    }

    public String convertStringForOrg(String intId) throws EASBizException, BOSException {
        return this.convertString(DimensionConstants.DEF_ORGUNIT_FIELD, intId);
    }

    public String convertString(String field, String intId) throws EASBizException, BOSException {
        if (!this.isUseAccInt()) {
            return intId;
        }
        String number = this.getDimStringMap().get(field).get(intId);
        if (DimUtils.checkBaseDimensionByField(field)) {
            return number;
        }
        return DimensionFormulaHelper.getCombination(this.getSchemeHelper().getSrcNumberByRefField(field), number);
    }

    public void insertToTmpTable(Connection conn, String tmpTable, Set<String> idOrNumbers, String dimField, boolean isId) throws BOSException, EASBizException {
        if (this.isUseAccInt()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String idnumber : idOrNumbers) {
                params.add(new Object[]{idnumber, this.convertInt(dimField, idnumber)});
            }
            try {
                BgDBUtils.executeBatch((Connection)conn, (String)("Insert Into " + tmpTable + " (" + (isId ? "FID" : "FNumber") + ", FIntId) values (?, ?)"), params);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (" + (isId ? "FID" : "FNumber") + ") values (?)"), idOrNumbers);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public final <T extends ISplitData> Map<String, Map<String, T>> splitBgDatas(Connection conn, Map<String, T> calcMap, Set<String> hasFormulas) throws BOSException, EASBizException {
        return BgSchemeConvertToAccIntUtils.splitBgDatas(conn, this.isUseAccInt(), this.getSchemeHelper(), this.bgDataTable, calcMap, this.getSplitMap(), hasFormulas);
    }

    public void setParam(PreparedStatement pstmt, int index, String value, String dimField) throws EASBizException, BOSException, SQLException {
        pstmt.setObject(index, this.convertObject(dimField, value));
    }

    public Object convertOrgObject(String number) throws EASBizException, BOSException {
        return this.convertObject(DimensionConstants.DEF_ORGUNIT_FIELD, number);
    }

    public Object convertObject(String field, String number) throws EASBizException, BOSException {
        if (this.isUseAccInt()) {
            return this.convertInt(field, number);
        }
        return number;
    }
}

