/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.accintolap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.progress.MbgProgressInfo;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.MbgConvertSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.CheckCancelThread;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewBase;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.ISplitData;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.impl.CubeSqlStrategy;
import com.kingdee.eas.ma.mbg.cube.utils.MbgSchemeSplitInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class BgSchemeConvertToAccIntUtils {
    private static Logger logger = Logger.getLogger((String)BgSchemeConvertToAccIntUtils.class.getName());
    private static final int MAX_TABLE_COUNT = 26;
    private static final int TOTALCOUNT_READSPLIT = 4;
    public static final int NO_ACCTINT = 0;
    public static final int SPLITING_ACCTINT = 1;
    private static final int MAX_INDEX_SIZE = 8;

    public static MbgSchemeSplitInfo readSplitInfo(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        MbgSchemeSplitInfo splitInfo = new MbgSchemeSplitInfo();
        MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "readCube", null), 0, 6));
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId.toString());
        Connection conn = null;
        Object tmpAccTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        CheckCancelThread thread = new CheckCancelThread(ctx, bgSchemeId, true);
        try {
            thread.conn = conn = EJBFactory.getConnection((Context)ctx);
            thread.start();
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "readCube", null), 0, 6));
            String oldRefCube = BgSchemeConvertToAccIntUtils.getRefCube(ctx, schemeHelper);
            List cubeFields = BgDBUtils.getColumns((Context)ctx, (String)oldRefCube);
            MbgUpdateDataBaseCopyHelper.toUpperCase(cubeFields);
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "readAccCount", null), 1, 6));
            logger.error((Object)"BgSchemeConvertToAccUtils Start readAccCount");
            Map<String, Integer> accCount = BgSchemeConvertToAccIntUtils.readAccCount(ctx, oldRefCube);
            logger.error((Object)"BgSchemeConvertToAccUtils End readAccCount");
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "readAcctMap", null), 2, 6));
            logger.error((Object)"BgSchemeConvertToAccUtils Start readBaseDataMap");
            Map<String, String> accMap = BgSchemeConvertToAccIntUtils.readAcctMap(conn, "T_MBG_BgAccount", "FNumber", "FBgAccountViewId", schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId());
            logger.error((Object)"BgSchemeConvertToAccUtils End readBaseDataMap");
            Map<String, Set<String>> accChildMap = BgSchemeConvertToAccIntUtils.getAccChildMap(accMap);
            Map<String, String> accRootMap = BgSchemeConvertToAccIntUtils.getAccRootMap(accMap);
            Map<String, Integer> rootCountMap = BgSchemeConvertToAccIntUtils.getRootChildMap(accCount, accChildMap);
            int totalCount = BgSchemeConvertToAccIntUtils.getTotalCount(rootCountMap);
            int ONE_TABLE_COUNT = 1000000;
            int maxCount = 5000000;
            if (totalCount < maxCount) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgConvertSchemeResource", (String)"littleCount", (Object[])new Object[]{maxCount})});
            }
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "getBizRefMap", null), 3, 6));
            logger.error((Object)"BgSchemeConvertToAccUtils Start getBizRefMap");
            Map<String, Set<String>> acctBizRef = BgSchemeConvertToAccIntUtils.getBizRefMap(ctx, conn, schemeHelper, accRootMap);
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "getBgFormRef", null), 4, 6));
            logger.error((Object)"BgSchemeConvertToAccUtils Start getBgFormRef");
            Map<String, Set<String>> bgFormRef = BgSchemeConvertToAccIntUtils.getBgFormRef(ctx, conn, schemeHelper, accRootMap, acctBizRef, accChildMap);
            int tableCount = totalCount / 1000000 + 1;
            if (tableCount > 26) {
                tableCount = 26;
            }
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "getBgFormRef", null), 5, 6));
            List<Set<String>> splitList = BgSchemeConvertToAccIntUtils.splitData(rootCountMap, accChildMap, tableCount, totalCount, bgFormRef);
            splitInfo.bgFormRef = bgFormRef;
            splitInfo.bgScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select id, number, name where id = '" + bgSchemeId + "'");
            BgAccountCollection col = BgAccountFactory.getLocalInstance((Context)ctx).getBgAccountCollection("select id, number, name where level = 1 and bgAccountView.id = '" + schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId() + "'");
            splitInfo.rootAccount = BgCommHelper.transeToMap((IObjectCollection)col, (String[])new String[]{"number"});
            splitInfo.rootCountMap = rootCountMap;
            splitInfo.splitData = splitList;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            if (!thread.isEnd) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (thread != null) {
                thread.isEnd = true;
            }
            MbgProgressInfo.removeProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId));
            SQLUtils.cleanup((Connection)conn);
        }
        return splitInfo;
    }

    public static String getMessage(Context ctx, String key, Object[] param) {
        if (param == null || param.length == 0) {
            return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgConvertSchemeResource", (String)key, (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgConvertSchemeResource", (String)key, (Locale)ctx.getLocale(), (Object[])param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Set<String>> getBgFormRef(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, Map<String, String> accRootMap, Map<String, Set<String>> acctBizRef, Map<String, Set<String>> accChildMap) throws Exception {
        MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(schemeHelper.getBgSchemeId()), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "queryBgForm", null), 4, 6));
        CoreBaseCollection formEntry = new CoreBaseCollection();
        ResultSet rst = null;
        HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("Select FID, FFormType from T_MBG_BgTemplate Where FBgSchemeId = ?");
            pstmt.setString(1, schemeHelper.getBgSchemeId());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgTemplateInfo info = new BgTemplateInfo();
                info.setId(BOSUuid.read((String)rst.getString("FID")));
                info.setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
                bgTemplateMap.put(info.getId().toString(), info);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("Select bgForm.FID bgForm_FID, bgFormEntry.FID bgFormEntry_FID, bgForm.FNumber, bgForm.FOrgUnitId, bgForm.FBgTemplateId, bgFormEntry.FID, bgFormEntry.FDimensionData from T_MBG_BgForm bgForm, T_MBG_BgFormEntry bgFormEntry Where bgForm.FID = bgFormEntry.FBgFormId AND bgForm.FBgSchemeId = ?");
            pstmt.setString(1, schemeHelper.getBgSchemeId());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgFormEntryInfo entryInfo = new BgFormEntryInfo();
                BgFormInfo info = new BgFormInfo();
                info.setId(BOSUuid.read((String)rst.getString("bgForm_FID")));
                info.setNumber(rst.getString("FNumber"));
                info.setOrgUnit(new FullOrgUnitInfo());
                info.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitId")));
                if (!bgTemplateMap.containsKey(rst.getString("FBgTemplateId"))) continue;
                info.setBgTemplate((BgTemplateInfo)bgTemplateMap.get(rst.getString("FBgTemplateId")));
                entryInfo.setBgForm(info);
                entryInfo.setId(BOSUuid.read((String)rst.getString("bgFormEntry_FID")));
                entryInfo.setDimensionData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FDimensionData"));
                formEntry.add((CoreBaseInfo)entryInfo);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ViewListMemberCacheHelper memberCache = new ViewListMemberCacheHelper();
        memberCache.setCtx(ctx);
        memberCache.setSchemeHelper(schemeHelper);
        BgFormEntryInfo entryInfo = null;
        HashSet<String> parseDimNumbers = new HashSet<String>();
        parseDimNumbers.add(DimensionConstants.DEF_ACCOUNT_NUMBER);
        for (int i = 0; i < formEntry.size(); ++i) {
            IMbgViewBase manager;
            entryInfo = (BgFormEntryInfo)formEntry.get(i);
            MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(schemeHelper.getBgSchemeId()), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "processBgForm", new Object[]{entryInfo.getBgForm().getNumber(), i + 1, formEntry.size()}), 4, 6));
            if (entryInfo.getDimensionData() == null || entryInfo.getDimensionData().length == 0) continue;
            String bgTemplateId = entryInfo.getBgForm().getBgTemplate().getId().toString();
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)entryInfo.getBgForm().getBgTemplate().getFormType())) {
                manager = new MbgViewListXMLParser(ctx).parse(entryInfo.getDimensionData());
                ((AbstractMbgViewBase)manager).setParseDimensions(parseDimNumbers);
                ViewListMemberParserServerHelper parser2 = new ViewListMemberParserServerHelper(ctx, schemeHelper, entryInfo.getBgForm().getOrgUnit().getId().toString());
                parser2.setMemberCacheHelper(memberCache);
                parser2.parseMember(conn, entryInfo.getBgForm().getOrgUnit().getId().toString(), (MbgViewListManager)manager, false);
                for (MbgViewListSheetManager sheet : ((AbstractMbgViewBase)manager).getSheetManagers()) {
                    List<MbgViewListDimensionInfo> dimensions = sheet.getDimensionManager().getAllDimensions();
                    BgSchemeConvertToAccIntUtils.addMember(bgTemplateId, dimensions, result, accRootMap, acctBizRef, accChildMap);
                }
                continue;
            }
            manager = new MbgXMLParser(ctx).parse(entryInfo.getDimensionData());
            manager.setParseDimensions(parseDimNumbers);
            TemplateFacadeFactory.getLocalInstance(ctx).loadViewManager(entryInfo.getBgForm().getOrgUnit().getId().toString(), schemeHelper.getBgSchemeId(), (IMbgViewManager)manager);
            for (IMbgSheetManager sheet : manager.getSheetManagers()) {
                BgSchemeConvertToAccIntUtils.addMember(bgTemplateId, sheet.getDimensionManager().getDimension(), result, accRootMap, acctBizRef, accChildMap);
            }
        }
        return result;
    }

    private static void addMember(String bgTemplateId, List dimensions, Map<String, Set<String>> result, Map<String, String> accRootMap, Map<String, Set<String>> acctBizRef, Map<String, Set<String>> accChildMap) {
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        for (Object d : dimensions) {
            BgDimensionBaseInfo dimension;
            if (!(d instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_ACCOUNT_NUMBER.equals((dimension = (BgDimensionBaseInfo)d).getNumber())) continue;
            for (Object m : dimension.getMember()) {
                if (!(m instanceof BgDimensionMember)) continue;
                BgSchemeConvertToAccIntUtils.addMember(bgTemplateId, ((BgDimensionMember)m).getNumber(), result, accRootMap, acctBizRef, accChildMap);
            }
        }
    }

    private static void addMember(String bgTemplateId, String number, Map<String, Set<String>> result, Map<String, String> accRootMap, Map<String, Set<String>> acctBizRef, Map<String, Set<String>> accChildMap) {
        if (!result.containsKey(bgTemplateId)) {
            result.put(bgTemplateId, new HashSet());
        }
        if (accRootMap.containsKey(number)) {
            result.get(bgTemplateId).add(accRootMap.get(number));
        } else {
            result.get(bgTemplateId).add(number);
        }
        if (acctBizRef != null && !acctBizRef.isEmpty() && accChildMap.containsKey(number)) {
            for (String child : accChildMap.get(number)) {
                if (!acctBizRef.containsKey(child)) continue;
                for (String ref : acctBizRef.get(child)) {
                    if (child.equals(ref)) continue;
                    BgSchemeConvertToAccIntUtils.addMember(bgTemplateId, ref, result, accRootMap, acctBizRef, accChildMap);
                }
            }
        }
    }

    private static Map<String, Set<String>> getBizRefMap(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, Map<String, String> accRootMap) throws BOSException, UuidException, EASBizException {
        BizCalcQuery query = new BizCalcQuery(ctx);
        Map<String, String> srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap(ctx, schemeHelper);
        HashMap refDimMap = new HashMap();
        try {
            Map variateMap = query.queryVariate(conn, BOSUuid.read((String)schemeHelper.getBgSchemeId()));
            List calcs = query.queryBizCalc(conn, BOSUuid.read((String)schemeHelper.getBgSchemeId()), (BOSUuid)null, (BOSUuid[])null, (List)null, false, (Set)null, (Set)null);
            BizCalcMember member = null;
            HashSet<String> queryFields = new HashSet<String>();
            queryFields.add(DimensionConstants.DEF_BGINDEX_FIELD);
            if (calcs != null && !calcs.isEmpty()) {
                for (BizCalcInfo calc : calcs) {
                    int in = calc.getBizCalcSubset().size();
                    for (int i = 0; i < in; ++i) {
                        BizCalcSubsetInfo subCalc = calc.getBizCalcSubset().get(i);
                        member = new BizCalcMember();
                        HashMap mdxNumMap = new HashMap();
                        member.setMdxNumMap(mdxNumMap);
                        member.setSrcFieldMap(srcFieldMap);
                        member.setCalc(calc);
                        member.queryRefRelation(ctx, null, BOSUuid.read((String)schemeHelper.getBgSchemeId()), subCalc, refDimMap, variateMap, true, null, queryFields);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (refDimMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
            Map indexRef = (Map)refDimMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
            Set subSet = null;
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            String leftRoot = null;
            for (String left : indexRef.keySet()) {
                subSet = (Set)indexRef.get(left);
                leftRoot = left;
                if (accRootMap.containsKey(left)) {
                    leftRoot = accRootMap.get(left);
                }
                if (!result.containsKey(leftRoot)) {
                    result.put(leftRoot, new HashSet());
                }
                for (String right : subSet) {
                    if (accRootMap.containsKey(right)) {
                        ((Set)result.get(leftRoot)).add(accRootMap.get(right));
                        continue;
                    }
                    ((Set)result.get(leftRoot)).add(right);
                }
            }
            return result;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convert(Context ctx, MbgSchemeSplitInfo bgSchemeSplitInfo) throws BOSException, EASBizException {
        Object cubeFields;
        String bgSchemeId = bgSchemeSplitInfo.bgScheme.getId().toString();
        MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "convertSplitMsg", null), 0, bgSchemeSplitInfo.splitData.size()));
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId.toString());
        Connection conn = null;
        String tmpAccTable = null;
        String bgDataTmpSql = null;
        HashMap<String, String> intTableMap = new HashMap<String, String>();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        ArrayList tmpAccTables = new ArrayList();
        String spIndex = null;
        String oldRefCube = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            oldRefCube = BgSchemeConvertToAccIntUtils.getRefCube(ctx, schemeHelper);
            cubeFields = BgDBUtils.getColumns((Context)ctx, (String)oldRefCube);
            MbgUpdateDataBaseCopyHelper.toUpperCase((Collection<String>)cubeFields);
            logger.error((Object)"BgSchemeConvertToAccUtils Start readBaseDataMap");
            Map<String, Map<String, Integer>> baseDataMap = BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, schemeHelper);
            Map<String, String> accMap = BgSchemeConvertToAccIntUtils.readAcctMap(conn, "T_MBG_BgAccount", "FNumber", "FBgAccountViewId", schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId());
            logger.error((Object)"BgSchemeConvertToAccUtils End readBaseDataMap");
            Map<String, Set<String>> accChildMap = BgSchemeConvertToAccIntUtils.getAccChildMap(accMap);
            List<Set<String>> splitList = bgSchemeSplitInfo.splitData;
            Object rootAcct = null;
            String newRefCube = null;
            HashSet<String> accSet = new HashSet<String>();
            logger.error((Object)"BgSchemeConvertToAccUtils Start createSplitRecordTable");
            BgSchemeConvertToAccIntUtils.createSplitRecordTable(ctx, oldRefCube, splitList, accChildMap);
            logger.error((Object)"BgSchemeConvertToAccUtils End createSplitRecordTable");
            for (int i = 0; i < 26; ++i) {
                newRefCube = BgSchemeConvertToAccIntUtils.getNewRefCube(oldRefCube, i);
                BgSchemeConvertToAccIntUtils.createBgDataTable(ctx, conn, schemeHelper, newRefCube, i);
            }
            bgDataTmpSql = BgSchemeConvertToAccIntUtils.createTmpBgDataTable(ctx, conn, pool, schemeHelper, newRefCube);
            HashSet<String> refFields = new HashSet<String>();
            for (String refField : schemeHelper.getAccAndOtherDim(false)) {
                refFields.add(schemeHelper.getRefField(refField));
            }
            Iterator it = cubeFields.iterator();
            while (it.hasNext()) {
                String field = (String)it.next();
                if (!field.matches("F\\d+") || refFields.contains(field)) continue;
                it.remove();
            }
            String tmp = BgSchemeConvertToAccIntUtils.createIntTmp(pool, intTableMap, DimensionConstants.DEF_ORGUNIT_FIELD, true);
            BgSchemeConvertToAccIntUtils.readIntMap(conn, "T_MBG_BgOrgUnit", "FOrgUnitId", "FViewId", schemeHelper.getBgOrgViewId(), tmp, null);
            tmp = BgSchemeConvertToAccIntUtils.createIntTmp(pool, intTableMap, DimensionConstants.DEF_PERIOD_FIELD, true);
            BgSchemeConvertToAccIntUtils.readIntMap(conn, "T_MBG_BgPeriod", "FID", null, null, tmp, null);
            tmp = BgSchemeConvertToAccIntUtils.createIntTmp(pool, intTableMap, DimensionConstants.DEF_ELEMENT_FIELD, true);
            BgSchemeConvertToAccIntUtils.readIntMap(conn, "T_MBG_BgElement", "FID", null, null, tmp, null);
            String srcNumber = null;
            Object dimNumber = null;
            String refField = null;
            for (String dim : schemeHelper.getAccAndOtherDim(false)) {
                srcNumber = schemeHelper.getSrcNumber(dim);
                refField = schemeHelper.getRefField(dim);
                tmp = BgSchemeConvertToAccIntUtils.createIntTmp(pool, intTableMap, refField, false);
                if (DimensionConstants.DEF_BGINDEX_FIELD.equals(refField)) {
                    BgSchemeConvertToAccIntUtils.readIntMap(conn, "T_MBG_BgAccount", "FNumber", "FBgAccountViewId", schemeHelper.getDimension(dim).getViewId(), tmp, srcNumber);
                    continue;
                }
                BgSchemeConvertToAccIntUtils.readIntMap(conn, "T_MBG_MbgMember", "FNumber", "FViewId", schemeHelper.getDimension(dim).getViewId(), tmp, srcNumber);
            }
            spIndex = "IX_MBG_BSP" + BgSchemeConvertToAccIntUtils.getCodeNumber(oldRefCube);
            if (BgDBUtils.existIndexNew((Context)ctx, (String)oldRefCube, (String)spIndex) == BgDBUtils.NO) {
                logger.error((Object)"BgSchemeConvertToAccUtils Start Create F2 Index");
                BgDBUtils.executeUpdate((Context)ctx, (String)("Create Index " + spIndex + " ON " + oldRefCube + "(F2)"));
                logger.error((Object)"BgSchemeConvertToAccUtils End Create F2 Index");
            }
            int poolSize = 1;
            tmpAccTable = "T_MBG_TMPACCT" + BgSchemeConvertToAccIntUtils.getCodeNumber(oldRefCube);
            tmpAccTable = pool.createTempTable("Create Table " + tmpAccTable + "(FID NVarchar(84) Not Null Primary Key)");
            for (int i = 0; i < splitList.size(); i += poolSize) {
                BgSchemeConvertToAccIntUtils.convertByTmpTable(ctx, bgSchemeSplitInfo, bgSchemeId, schemeHelper, conn, tmpAccTable, oldRefCube, (List<String>)cubeFields, baseDataMap, accChildMap, splitList, accSet, i, bgDataTmpSql, intTableMap);
            }
            cubeFields = tmpAccTables.iterator();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                MbgConvertSchemeFacadeFactory.getLocalInstance(ctx).setSplitState(bgSchemeId, 0);
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    MbgConvertSchemeFacadeFactory.getLocalInstance(ctx).setSplitState(bgSchemeId, 0);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                for (String t : tmpAccTables) {
                    pool.releaseTable(t);
                }
                if (tmpAccTable != null) {
                    pool.releaseTable(tmpAccTable);
                }
                if (bgDataTmpSql != null) {
                    pool.releaseTable(bgDataTmpSql);
                }
                if (BgDBUtils.existIndexNew((Context)ctx, (String)oldRefCube, spIndex) == BgDBUtils.YES) {
                    try {
                        BgDBUtils.executeUpdate((Context)ctx, (String)("Drop Index " + oldRefCube + "." + spIndex));
                    }
                    catch (SQLException e3) {
                        logger.error((Object)"", (Throwable)e3);
                    }
                }
                BgDBUtils.releaseTmpTable((TempTablePool)pool, intTableMap.values());
                throw throwable;
            }
        }
        while (cubeFields.hasNext()) {
            String t = (String)cubeFields.next();
            pool.releaseTable(t);
        }
        if (tmpAccTable != null) {
            pool.releaseTable(tmpAccTable);
        }
        if (bgDataTmpSql != null) {
            pool.releaseTable(bgDataTmpSql);
        }
        if (BgDBUtils.existIndexNew((Context)ctx, (String)oldRefCube, (String)spIndex) == BgDBUtils.YES) {
            try {
                BgDBUtils.executeUpdate((Context)ctx, (String)("Drop Index " + oldRefCube + "." + spIndex));
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, intTableMap.values());
    }

    public static String createTmpBgDataTable(Context ctx, Connection conn, TempTablePool pool, BgSchemeDimensionHelper schemeHelper, String newRefCube) throws Exception {
        String bgDataTmpSql = BgSchemeConvertToAccIntUtils.getTmpBgDataSql(ctx, conn, schemeHelper, newRefCube);
        bgDataTmpSql = pool.createTempTable(bgDataTmpSql);
        DbUtil.execute((Context)ctx, (String)("Alter Table " + bgDataTmpSql + " Add FOrgUnitIntID INT"));
        DbUtil.execute((Context)ctx, (String)("Alter Table " + bgDataTmpSql + " Add FBgPeriodIntID INT"));
        DbUtil.execute((Context)ctx, (String)("Alter Table " + bgDataTmpSql + " Add FBgElementIntID INT"));
        List<String> refDims = schemeHelper.getAccAndOtherDim(false);
        HashSet<String> refFields = new HashSet<String>();
        for (String refField : refDims) {
            DbUtil.execute((Context)ctx, (String)("Alter Table " + bgDataTmpSql + " Add F" + schemeHelper.getRefField(refField) + " INT"));
            refFields.add(schemeHelper.getRefField(refField));
        }
        return bgDataTmpSql;
    }

    protected static void convert(Context ctx, MbgSchemeSplitInfo bgSchemeSplitInfo, String bgSchemeId, BgSchemeDimensionHelper schemeHelper, Connection conn, String tmpAccTable, String oldRefCube, List<String> cubeFields, Map<String, Map<String, Integer>> baseDataMap, Map<String, Set<String>> accChildMap, List<Set<String>> splitList, Set<String> accSet, int index) throws BOSException, EASBizException, SQLException {
        logger.error((Object)("BgSchemeConvertToAccUtils Start Convert " + (index + 1) + "/" + splitList.size()));
        MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "convertSplitMsg", null), index + 1, bgSchemeSplitInfo.splitData.size()));
        Set<String> rootAcct = splitList.get(index);
        accSet.clear();
        String newRefCube = BgSchemeConvertToAccIntUtils.getNewRefCube(oldRefCube, index);
        for (String rootNumber : rootAcct) {
            Set<String> childSet = accChildMap.get(rootNumber);
            if (childSet == null) continue;
            for (String child : childSet) {
                accSet.add(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_INDEX_SRCNUMBER, child));
            }
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)("Delete " + tmpAccTable));
        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpAccTable + "(FID) Values(?)"), accSet);
        logger.error((Object)"BgSchemeConvertToAccUtils Start readBgDataIds");
        Set<String> batchIds = BgSchemeConvertToAccIntUtils.readBgDataIds(conn, oldRefCube, tmpAccTable);
        logger.error((Object)"BgSchemeConvertToAccUtils End readBgDataIds");
        logger.error((Object)("BgSchemeConvertToAccUtils Start Convert Table: " + newRefCube + " bgDataSize:" + batchIds.size()));
        List paramList = MbgSqlHelper.getBatchParams(null, (Object[])batchIds.toArray(), (int)1000);
        for (int b = 0; b < paramList.size(); ++b) {
            logger.error((Object)("BgSchemeConvertToAccUtils Start Convert One Table " + (b + 1) + "/" + paramList.size()));
            BgSchemeConvertToAccIntUtils.convertBgData(ctx, conn, oldRefCube, newRefCube, cubeFields, (Object[])paramList.get(b), baseDataMap);
        }
        BgSchemeConvertToAccIntUtils.createIndex(ctx, newRefCube, schemeHelper, index);
        logger.error((Object)("BgSchemeConvertToAccUtils End Convert " + (index + 1) + "/" + splitList.size()));
    }

    protected static void convertByTmpTable(Context ctx, MbgSchemeSplitInfo bgSchemeSplitInfo, String bgSchemeId, BgSchemeDimensionHelper schemeHelper, Connection conn, String tmpAccTable, String oldRefCube, List<String> cubeFields, Map<String, Map<String, Integer>> baseDataMap, Map<String, Set<String>> accChildMap, List<Set<String>> splitList, Set<String> accSet, int index, String bgDataTmpTable, Map<String, String> intTableMap) throws BOSException, EASBizException, SQLException {
        logger.error((Object)("BgSchemeConvertToAccUtils Start Convert " + (index + 1) + "/" + splitList.size()));
        MbgProgressInfo.addProgressInfo((String)ctx.getAIS(), (String)MbgSchemeSplitInfo.getProgressKey(bgSchemeId), (MbgProgressInfo)new MbgProgressInfo(BgSchemeConvertToAccIntUtils.getMessage(ctx, "convertSplitMsg", null), index + 1, bgSchemeSplitInfo.splitData.size()));
        Set<String> rootAcct = splitList.get(index);
        accSet.clear();
        String newRefCube = BgSchemeConvertToAccIntUtils.getNewRefCube(oldRefCube, index);
        for (String rootNumber : rootAcct) {
            Set<String> childSet = accChildMap.get(rootNumber);
            if (childSet == null) continue;
            for (String child : childSet) {
                accSet.add(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_INDEX_SRCNUMBER, child));
            }
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)("Delete " + tmpAccTable));
        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpAccTable + "(FID) Values(?)"), accSet);
        BgSchemeConvertToAccIntUtils.convertBgDataByTmpTable(ctx, conn, schemeHelper, oldRefCube, newRefCube, cubeFields, tmpAccTable, baseDataMap, bgDataTmpTable, intTableMap);
        BgSchemeConvertToAccIntUtils.createIndex(ctx, newRefCube, schemeHelper, index);
        logger.error((Object)("BgSchemeConvertToAccUtils End Convert " + (index + 1) + "/" + splitList.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readBgDataIds(Connection conn, String oldRefCube, String tmpAccTable) throws SQLException {
        HashSet<String> bgDataIds = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("Select FID FROM " + oldRefCube + " Where F2 IN(Select FID FROM " + tmpAccTable + ")");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgDataIds.add(rst.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgDataIds;
    }

    private static void createSplitRecordTable(Context ctx, String refCube, List<Set<String>> splitList, Map<String, Set<String>> accChildMap) throws SQLDataException, SQLException {
        String splitCube = BgSchemeConvertToAccIntUtils.getSplitCube(refCube);
        if (BgDBUtils.existTable((Context)ctx, (String)splitCube) == BgDBUtils.YES) {
            BgDBUtils.executeUpdate((Context)ctx, (String)("Delete FROM " + splitCube));
        } else {
            BgDBUtils.executeUpdate((Context)ctx, (String)("Create Table " + splitCube + " (FAcctNumber NVarchar(84) NOT NULL Primary Key, FRefCube Varchar(30) NOT NULL)"));
        }
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        String newRefCube = null;
        Set<String> subSet = null;
        for (int i = 0; i < splitList.size(); ++i) {
            newRefCube = BgSchemeConvertToAccIntUtils.getNewRefCube(refCube, i);
            subSet = splitList.get(i);
            for (String acc : subSet) {
                for (String child : accChildMap.get(acc)) {
                    paramList.add(new String[]{child, newRefCube});
                }
            }
        }
        BgDBUtils.executeBatch((Context)ctx, (String)("Insert Into " + splitCube + "(FAcctNumber, FRefCube) Values(?, ?)"), paramList);
    }

    public static String getSplitCube(String oldRefCube) {
        return "T_MBG_BGSPLIT" + BgSchemeConvertToAccIntUtils.getCodeNumber(oldRefCube);
    }

    private static List<Set<String>> splitData(Map<String, Integer> rootCountMap, Map<String, Set<String>> accChildMap, int tableCount, int totalCount, Map<String, Set<String>> bgFormRef) {
        int count = 0;
        int oneCount = totalCount / tableCount;
        HashSet<String> subSet = null;
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        HashSet<String> hasSplitRootNumbers = new HashSet<String>();
        HashSet<String> refNumbers = new HashSet<String>();
        for (String rootNumber : accChildMap.keySet()) {
            refNumbers.clear();
            BgSchemeConvertToAccIntUtils.getRefNumbers(rootNumber, refNumbers, bgFormRef);
            for (String refNumber : refNumbers) {
                if (hasSplitRootNumbers.contains(refNumber)) continue;
                hasSplitRootNumbers.add(refNumber);
                if (rootCountMap.containsKey(refNumber)) {
                    count += rootCountMap.get(refNumber).intValue();
                }
                if (subSet == null) {
                    subSet = new HashSet<String>();
                    result.add(subSet);
                }
                subSet.add(refNumber);
                if (count <= oneCount * 3) continue;
                subSet = null;
                count = 0;
            }
            if (count <= oneCount) continue;
            subSet = null;
            count = 0;
        }
        return result;
    }

    private static void getRefNumbers(String rootNumber, Set<String> refNumbers, Map<String, Set<String>> bgFormRef) {
        if (refNumbers.contains(rootNumber)) {
            return;
        }
        refNumbers.add(rootNumber);
        if (bgFormRef.containsKey(rootNumber)) {
            for (String ref : bgFormRef.get(rootNumber)) {
                BgSchemeConvertToAccIntUtils.getRefNumbers(ref, refNumbers, bgFormRef);
            }
        }
    }

    private static int getTotalCount(Map<String, Integer> rootCountMap) {
        int count = 0;
        for (Integer value : rootCountMap.values()) {
            count += value.intValue();
        }
        return count;
    }

    private static Map<String, Integer> getRootChildMap(Map<String, Integer> accCount, Map<String, Set<String>> accChildMap) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String rootNumber : accChildMap.keySet()) {
            int count = 0;
            for (String number : accChildMap.get(rootNumber)) {
                if (!accCount.containsKey(number)) continue;
                count += accCount.get(number).intValue();
            }
            result.put(rootNumber, count);
        }
        return result;
    }

    private static Map<String, String> getAccRootMap(Map<String, String> accMap) {
        ArrayList<String> accLongNumbers = new ArrayList<String>(accMap.values());
        Collections.sort(accLongNumbers);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String[] lns = null;
        for (String longNumber : accLongNumbers) {
            lns = longNumber.split("!");
            result.put(lns[lns.length - 1], lns[0]);
        }
        return result;
    }

    private static Map<String, Set<String>> getAccChildMap(Map<String, String> accMap) {
        ArrayList<String> accLongNumbers = new ArrayList<String>(accMap.values());
        Collections.sort(accLongNumbers);
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        String[] lns = null;
        for (String longNumber : accLongNumbers) {
            lns = longNumber.split("!");
            if (!result.containsKey(lns[0])) {
                result.put(lns[0], new HashSet());
            }
            ((Set)result.get(lns[0])).add(lns[lns.length - 1]);
        }
        return result;
    }

    private static Map<String, Integer> readAccCount(Context ctx, String refCube) throws BOSException, SQLException {
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)("Select F2, Count(FID) FROM " + refCube + " Group By F2"));
        String accNumber = null;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        while (rst.next()) {
            accNumber = DimensionFormulaHelper.getMemberNumber(rst.getString(1));
            result.put(accNumber, rst.getInt(2));
        }
        return result;
    }

    private static void createIndex(Context ctx, String newRefCube, BgSchemeDimensionHelper schemeHelper, int index) throws BOSException, SQLException {
        String index4;
        String index3;
        String index2;
        String index1;
        String codeNumber = BgSchemeConvertToAccIntUtils.getCodeNumber(newRefCube);
        String ixQuery = "IX_MBG_BQ" + BgSchemeConvertToAccIntUtils.getSplitString(index) + codeNumber;
        String sql = null;
        if (BgDBUtils.existIndexNew((Context)ctx, (String)newRefCube, (String)ixQuery) == BgDBUtils.NO) {
            sql = "CREATE INDEX " + ixQuery + " ON " + newRefCube + " (FOrgUnitID, ";
            List<String> refDims = schemeHelper.getAccAndOtherDim(false);
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    sql = sql + schemeHelper.getRefField(refDims.get(i)) + ", ";
                }
            } else {
                for (String field : refDims) {
                    sql = sql + schemeHelper.getRefField(field) + ", ";
                }
            }
            sql = sql + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
            BgDBUtils.executeUpdate((Context)ctx, (String)sql);
        }
        if (BgDBUtils.existIndexNew((Context)ctx, (String)newRefCube, (String)(index1 = "IX_MBG_BO" + BgSchemeConvertToAccIntUtils.getSplitString(index) + codeNumber)) == BgDBUtils.NO) {
            sql = "CREATE UNIQUE INDEX " + index1 + " ON " + newRefCube + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
            BgDBUtils.executeUpdate((Context)ctx, (String)sql);
        }
        if (BgDBUtils.existIndexNew((Context)ctx, (String)newRefCube, (String)(index2 = "IX_MBG_BI" + BgSchemeConvertToAccIntUtils.getSplitString(index) + codeNumber)) == BgDBUtils.NO) {
            sql = "CREATE INDEX " + index2 + " ON " + newRefCube + " (FBgItemCombination ASC)";
            BgDBUtils.executeUpdate((Context)ctx, (String)sql);
        }
        if (BgDBUtils.existIndexNew((Context)ctx, (String)newRefCube, (String)(index3 = "IX_MBG_BA" + BgSchemeConvertToAccIntUtils.getSplitString(index) + codeNumber)) == BgDBUtils.NO) {
            sql = "CREATE INDEX " + index3 + " ON " + newRefCube + " (FAudOrgUnitID ASC)";
            BgDBUtils.executeUpdate((Context)ctx, (String)sql);
        }
        if (BgDBUtils.existIndexNew((Context)ctx, (String)newRefCube, (String)(index4 = "IX_MBG_BR" + BgSchemeConvertToAccIntUtils.getSplitString(index) + codeNumber)) == BgDBUtils.NO) {
            sql = "CREATE INDEX " + index4 + " ON " + newRefCube + " (FReportOrgUnitID ASC)";
            BgDBUtils.executeUpdate((Context)ctx, (String)sql);
        }
    }

    private static void convertBgData(Context ctx, Connection conn, String oldRefCube, String newRefCube, List<String> cubeFields, Object[] batchIds, Map<String, Map<String, Integer>> baseDataMap) throws BOSException {
        ArrayList<Object[]> bgDatas = new ArrayList<Object[]>();
        Object[] bgData = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int i;
            logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData Start Read BgData");
            StringBuffer sql = new StringBuffer();
            sql.append("Select * FROM " + oldRefCube + " Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)batchIds.length).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])batchIds);
            rst = pstmt.executeQuery();
            logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData end executeQuery");
            String field = null;
            while (rst.next()) {
                bgData = new Object[cubeFields.size()];
                for (i = 0; i < cubeFields.size(); ++i) {
                    field = cubeFields.get(i);
                    bgData[i] = field.equalsIgnoreCase("FOrgUnitId") ? BgSchemeConvertToAccIntUtils.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, rst.getString(field), baseDataMap) : (field.equalsIgnoreCase("FBgPeriodId") ? BgSchemeConvertToAccIntUtils.convertInt(DimensionConstants.DEF_PERIOD_FIELD, rst.getString(field), baseDataMap) : (field.equalsIgnoreCase("FBgElementId") ? BgSchemeConvertToAccIntUtils.convertInt(DimensionConstants.DEF_ELEMENT_FIELD, rst.getString(field), baseDataMap) : (baseDataMap.containsKey(field) ? BgSchemeConvertToAccIntUtils.convertInt(field, rst.getString(field), baseDataMap) : rst.getObject(field))));
                }
                bgDatas.add(bgData);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData End Read BgData");
            sql.setLength(0);
            sql.append("Insert /*+append*/ Into " + newRefCube + "(");
            for (i = 0; i < cubeFields.size(); ++i) {
                field = cubeFields.get(i);
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(field);
            }
            sql.append(") Values (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)cubeFields.size()).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < bgDatas.size(); ++i) {
                bgData = (Object[])bgDatas.get(i);
                boolean hasEmpty = false;
                for (int f = 0; f < cubeFields.size(); ++f) {
                    field = cubeFields.get(f);
                    if (!field.equalsIgnoreCase("FOrgUnitId") && !field.equalsIgnoreCase("FBgPeriodId") && !field.equalsIgnoreCase("FBgElementId") && !baseDataMap.containsKey(field) || bgData[f] != null) continue;
                    logger.error((Object)("isEmpty(" + field + "):" + Arrays.toString(bgData)));
                    hasEmpty = true;
                }
                if (hasEmpty) continue;
                for (int v = 0; v < bgData.length; ++v) {
                    pstmt.setObject(v + 1, bgData[v]);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData End Insert BgData");
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    private static void convertBgDataByTmpTable(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, String oldRefCube, String newRefCube, List<String> cubeFields, String tmpAccTable, Map<String, Map<String, Integer>> baseDataMap, String bgDataTmpTable, Map<String, String> intTableMap) throws BOSException {
        int i;
        int i2;
        logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData Start Insert To Temp Table");
        MbgSqlHelper.execute((Connection)conn, (String)("Truncate Table " + bgDataTmpTable));
        StringBuffer sql = new StringBuffer();
        List<String> refDims = schemeHelper.getAccAndOtherDim(false);
        HashSet<String> refFields = new HashSet<String>();
        String refField = null;
        for (String refDim : refDims) {
            refField = schemeHelper.getRefField(refDim);
            refFields.add(refField);
        }
        sql.append("Insert Into ").append(bgDataTmpTable).append(" (");
        for (i2 = 0; i2 < cubeFields.size(); ++i2) {
            if (i2 > 0) {
                sql.append(", ");
            }
            sql.append(cubeFields.get(i2));
        }
        sql.append(") Select ");
        for (i2 = 0; i2 < cubeFields.size(); ++i2) {
            if (i2 > 0) {
                sql.append(", ");
            }
            sql.append(cubeFields.get(i2));
        }
        sql.append(" FROM ").append(oldRefCube).append(" Where F2 IN(Select FID FROM " + tmpAccTable + ")");
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
        logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData End Insert To Temp Table");
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " t0 Set FOrgUnitIntId = (Select FIntId FROM " + intTableMap.get(DimensionConstants.DEF_ORGUNIT_FIELD) + " Where FNumber = t0.FOrgUnitId)"));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " t0 Set FBgElementIntId = (Select FIntId FROM T_MBG_BgElement Where FId = t0.FBgElementId)"));
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " t0 Set FBgPeriodIntId = (Select FIntId FROM T_MBG_BgPeriod Where FId = t0.FBgPeriodId)"));
        for (String refDim : refDims) {
            refField = schemeHelper.getRefField(refDim);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " t0 Set F" + refField + " = (Select FIntId FROM " + intTableMap.get(refField) + " Where FNumber = t0." + refField + ")"));
        }
        logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData End Update Int ID");
        sql.setLength(0);
        sql.append("Insert /*+ append */ Into ").append(newRefCube).append(" (");
        for (i = 0; i < cubeFields.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(cubeFields.get(i));
        }
        sql.append(") Select ");
        for (i = 0; i < cubeFields.size(); ++i) {
            refField = cubeFields.get(i);
            if (i > 0) {
                sql.append(", ");
            }
            if (refFields.contains(refField)) {
                sql.append("F").append(refField);
                continue;
            }
            if ("FOrgUnitId".equalsIgnoreCase(refField)) {
                sql.append("FOrgUnitIntID");
                continue;
            }
            if ("FBgElementId".equalsIgnoreCase(refField)) {
                sql.append("FBgElementIntID");
                continue;
            }
            if ("FBgPeriodId".equalsIgnoreCase(refField)) {
                sql.append("FBgPeriodIntID");
                continue;
            }
            sql.append(refField);
        }
        sql.append(" FROM " + bgDataTmpTable + " Where ");
        boolean isFirst = true;
        for (String r : refFields) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(" And ");
            }
            sql.append("F").append(r).append(" IS NOT NULL");
        }
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
        logger.error((Object)"BgSchemeConvertToAccIntUtils convertBgData End Insert BgData");
    }

    protected static Object convertInt(String field, String number, Map<String, Map<String, Integer>> baseDataMap) {
        if (number.indexOf(":") > 0) {
            number = DimensionFormulaHelper.getMemberNumber(number);
        }
        return baseDataMap.get(field).get(number);
    }

    private static Map<String, Map<String, Integer>> readBaseDataMap(Connection conn, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        HashMap<String, Map<String, Integer>> baseDataMap = new HashMap<String, Map<String, Integer>>();
        try {
            baseDataMap.put(DimensionConstants.DEF_ORGUNIT_FIELD, BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, "T_MBG_BgOrgUnit", "FOrgUnitId", "FViewId", schemeHelper.getBgOrgViewId()));
            baseDataMap.put(DimensionConstants.DEF_PERIOD_FIELD, BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, "T_MBG_BgPeriod", "FID", null, null));
            baseDataMap.put(DimensionConstants.DEF_ELEMENT_FIELD, BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, "T_MBG_BgElement", "FID", null, null));
            baseDataMap.put(DimensionConstants.DEF_BGINDEX_FIELD, BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, "T_MBG_BgAccount", "FNumber", "FBgAccountViewId", schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()));
            List<String> otherDims = schemeHelper.getAccAndOtherDim(true);
            if (otherDims != null) {
                for (String dim : otherDims) {
                    baseDataMap.put(schemeHelper.getRefField(dim), BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, "T_MBG_MbgMember", "FNumber", "FViewId", schemeHelper.getDimension(dim).getViewId()));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"BgSchemeConvertToIntUtils", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return baseDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readAcctMap(Connection conn, String tableName, String keyField, String filterField, String filterValue) throws SQLException {
        HashMap<String, String> baseData = new HashMap<String, String>();
        IRowSet rst = null;
        try {
            rst = StringUtils.isEmpty((String)filterField) ? BgDBUtils.executeQuery((Connection)conn, (String)("Select " + keyField + ", FLongNumber FROM " + tableName)) : BgDBUtils.executeQuery((Connection)conn, (String)("Select " + keyField + ", FLongNumber FROM " + tableName + " Where " + filterField + " = ?"), (Object[])new Object[]{filterValue});
            while (rst.next()) {
                baseData.put(rst.getString(1), rst.getString(2));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return baseData;
    }

    public static void readIntMap(Connection conn, String tableName, String keyField, String filterField, String filterValue, String tmpTable, String srcNumber) throws SQLException {
        if (!StringUtils.isEmpty((String)srcNumber)) {
            keyField = "'" + srcNumber + ":' || " + keyField;
        }
        if (StringUtils.isEmpty((String)filterField)) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber, FIntID) Select " + keyField + ", FIntID FROM " + tableName));
        } else {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber, FIntID) Select distinct " + keyField + ", FIntID FROM " + tableName + " Where " + filterField + " = ?"), (Object[])new Object[]{filterValue});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> readBaseDataMap(Connection conn, String tableName, String keyField, String filterField, String filterValue) throws SQLException {
        HashMap<String, Integer> baseData = new HashMap<String, Integer>();
        IRowSet rst = null;
        try {
            rst = StringUtils.isEmpty((String)filterField) ? BgDBUtils.executeQuery((Connection)conn, (String)("Select " + keyField + ", FIntID FROM " + tableName)) : BgDBUtils.executeQuery((Connection)conn, (String)("Select " + keyField + ", FIntID FROM " + tableName + " Where " + filterField + " = ?"), (Object[])new Object[]{filterValue});
            while (rst.next()) {
                baseData.put(rst.getString(1), rst.getInt(2));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return baseData;
    }

    public static String getNewRefCube(String oldRefCube, int index) {
        return "T_MBG_BgData" + BgSchemeConvertToAccIntUtils.getSplitString(index) + BgSchemeConvertToAccIntUtils.getCodeNumber(oldRefCube);
    }

    public static boolean isAccIntTable(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return false;
        }
        return tableName.toUpperCase(Locale.ENGLISH).startsWith("T_MBG_BGDATA") && tableName.toUpperCase().length() == "T_MBG_BGDATA".length() + CubeConstants.CODE_LENGTH + 1;
    }

    protected static String getSplitString(int index) {
        return String.valueOf((char)(65 + index));
    }

    public static String getSplitString(String refCube) {
        return refCube.substring(refCube.length() - CubeConstants.CODE_LENGTH - 1, refCube.length() - CubeConstants.CODE_LENGTH);
    }

    public static String getCodeNumber(String tableName) {
        return tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
    }

    private static String getRefCube(Context ctx, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            List refCubes = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select FRefCube FROM T_MBG_BgScheme Where FID = '" + schemeHelper.getBgSchemeId() + "'"), null);
            String string = (String)refCubes.get(0);
            return string;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static String createIntTmp(TempTablePool pool, Map<String, String> intTableMap, String field, boolean isId) throws BOSException, EASBizException {
        String sql = BgSchemeConvertToAccIntUtils.getTmpIntSql(field, isId);
        try {
            String tmpTable = pool.createTempTable(sql);
            intTableMap.put(field, tmpTable);
            return tmpTable;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static String getTmpIntSql(String field, boolean isId) throws BOSException, EASBizException {
        if (isId) {
            return "Create Table T_MBG_Int" + field + " (FNumber Varchar(44) NOT NULL Primary Key, FIntId INT NOT NULL)";
        }
        return "Create Table T_MBG_Int" + field + " (FNumber NVarchar(84) NOT NULL Primary Key, FIntId INT NOT NULL)";
    }

    public static String getTmpBgDataSql(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, String newRefCube) throws BOSException, EASBizException {
        List<String> refDims = schemeHelper.getRefDims();
        CubeSqlStrategy strategy = new CubeSqlStrategy();
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, newRefCube + "Tmp");
        sqlMap.put(CubeConstants.CUBE_TYPE, 1);
        String[] sqls = strategy.getCubeSql(conn, sqlMap, refDims);
        return sqls[0];
    }

    private static void createBgDataTable(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, String newRefCube, int index) throws BOSException, EASBizException {
        logger.error((Object)("BgSchemeConvertToIntUtils createBgDataTable " + newRefCube));
        boolean hasConn = conn == null;
        try {
            if (!hasConn) {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            List<String> refDims = schemeHelper.getRefDims();
            CubeSqlStrategy strategy = new CubeSqlStrategy();
            strategy.setInt(true);
            HashMap<String, Object> sqlMap = new HashMap<String, Object>();
            sqlMap.put(CubeConstants.CUBE_NAME, newRefCube);
            sqlMap.put(CubeConstants.CUBE_TYPE, 1);
            strategy.getCubeSql(conn, sqlMap, refDims);
            if (BgDBUtils.existTable((Connection)conn, (String)newRefCube) == BgDBUtils.YES) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Drop Table " + newRefCube));
            }
            String[] sqls = strategy.getCubeSql(conn, sqlMap, refDims);
            BgDBUtils.executeUpdate((Connection)conn, (String)sqls[0]);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!hasConn) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    public static Map<String, String> querySplit(Context ctx, String refCube) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Map<String, String> map = BgSchemeConvertToAccIntUtils.querySplit(conn, refCube);
            return map;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static Map<String, String> querySplit(Connection conn, String refCube) throws SQLException {
        HashMap<String, String> splitMap = new HashMap<String, String>();
        BgSchemeConvertToAccIntUtils.querySplit(conn, refCube, splitMap);
        return splitMap;
    }

    public static void querySplit(Connection conn, String refCube, Map<String, String> splitMap) throws SQLException {
        String splitCube = BgSchemeConvertToAccIntUtils.getSplitCube(refCube);
        IRowSet rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FAcctNumber, FRefCube FROM " + splitCube));
        while (rst.next()) {
            splitMap.put(rst.getString(1), rst.getString(2));
        }
    }

    public static boolean isUseAccInt(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        return BgSchemeFactory.getLocalInstance(ctx).exists("where id = '" + bgSchemeId + "' and useAccInt > 0");
    }

    public static boolean isUseAccInt(BgSchemeInfo bgScheme, String cubeName) {
        return bgScheme.getUseAccInt() > 0 && bgScheme.getRefCube().equals(cubeName);
    }

    public static boolean isUseAccIntByRefCube(Connection conn, String refCube) throws BOSException {
        boolean bl;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("Select FID FROM T_MBG_BgScheme Where FRefCube = ? and FUseAccInt > 0");
            pstmt.setString(1, refCube);
            rst = pstmt.executeQuery();
            bl = rst.next();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bl;
    }

    public static Set<String> getSplitTablesByFormula(boolean isUseAccInt, String bgDataTable, Collection<String> formulaSet, Map<String, String> splitMap) {
        HashSet<String> accNumbers = new HashSet<String>();
        if (isUseAccInt) {
            for (String formula : formulaSet) {
                accNumbers.add(DimensionFormulaHelper.getMemberNumber(DimensionFormulaHelper.splitCombinations(BgNFSHelper.parseFormulaPara(formula)[0])[0]));
            }
        }
        return BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, bgDataTable, accNumbers, splitMap);
    }

    public static Set<String> getSplitTablesByAcc(boolean isUseAccInt, String bgDataTable, Collection<String> accNumbers, Map<String, String> splitMap) {
        HashSet<String> bgDataTables = new HashSet<String>();
        if (isUseAccInt) {
            if (accNumbers == null) {
                return new HashSet<String>(splitMap.values());
            }
            for (String accNumber : accNumbers) {
                if (accNumber.indexOf(":") > 0) {
                    accNumber = DimensionFormulaHelper.getMemberNumber(accNumber);
                }
                if (!splitMap.containsKey(accNumber)) continue;
                bgDataTables.add(splitMap.get(accNumber));
            }
        } else {
            bgDataTables.add(bgDataTable);
        }
        return bgDataTables;
    }

    public static Map<String, Set<Integer>> splitAcct(Set<String> accNumbers, Map<String, String> splitMap, Map<String, Integer> dimIntMap) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        if (accNumbers == null || accNumbers.isEmpty() || splitMap == null || splitMap.isEmpty()) {
            return result;
        }
        String number = null;
        String refCube = null;
        for (String accNumber : accNumbers) {
            number = DimUtils.getNumber(accNumber);
            refCube = splitMap.get(number);
            if (refCube == null) continue;
            if (!result.containsKey(refCube)) {
                result.put(refCube, new HashSet());
            }
            ((Set)result.get(refCube)).add(dimIntMap.get(number));
        }
        return result;
    }

    public static final <T extends ISplitData> Map<String, Map<String, T>> splitBgDatas(Connection conn, BgSchemeInfo bgScheme, BgSchemeDimensionHelper schemeHelper, String cubeName, Map<String, T> calcMap, Map<String, String> splitMap, Set<String> hasFormulas) throws BOSException {
        boolean isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt(bgScheme, cubeName);
        return BgSchemeConvertToAccIntUtils.splitBgDatas(conn, isUseAccInt, schemeHelper, cubeName, calcMap, splitMap, hasFormulas);
    }

    public static final <T extends ISplitData> Map<String, Map<String, T>> splitBgDatas(Connection conn, boolean isUseAccInt, BgSchemeDimensionHelper schemeHelper, String cubeName, Map<String, T> calcMap, Map<String, String> splitMap, Set<String> hasFormulas) throws BOSException {
        Set<String> hasTables = BgSchemeConvertToAccIntUtils.getSplitTablesByFormula(isUseAccInt, cubeName, hasFormulas, splitMap);
        HashMap<String, Map<String, T>> splitCalcMap = new HashMap<String, Map<String, T>>();
        Map<String, String> accRootMap = null;
        ArrayList<String[]> addNewSplitList = new ArrayList<String[]>();
        HashSet addNewSplit = new HashSet();
        HashMap addNewCalcMap = new HashMap();
        ISplitData calcData = null;
        String[] tmpStrs = null;
        String srcNumber = null;
        String number = null;
        String bgDataTable = null;
        String key2 = null;
        int newIndex = -1;
        if (isUseAccInt) {
            try {
                for (String key2 : calcMap.keySet()) {
                    calcData = (ISplitData)calcMap.get(key2);
                    tmpStrs = calcData.getDimItemNumber().split(",");
                    if (tmpStrs == null) continue;
                    int in = tmpStrs.length;
                    for (int i = 0; i < in; ++i) {
                        srcNumber = DimUtils.getSrcNumber(tmpStrs[i]);
                        if (!DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) continue;
                        number = DimUtils.getNumber(tmpStrs[i]);
                        break;
                    }
                    if ((bgDataTable = splitMap.get(number)) == null) {
                        if (accRootMap == null) {
                            Map<String, String> accMap = BgSchemeConvertToAccIntUtils.readAcctMap(conn, "T_MBG_BgAccount", "FNumber", "FBgAccountViewId", schemeHelper.getDimension(DimensionConstants.DEF_INDEX_NUMBER).getViewId());
                            accRootMap = BgSchemeConvertToAccIntUtils.getAccRootMap(accMap);
                        }
                        if (accRootMap.get(number) == null) continue;
                        bgDataTable = splitMap.get(accRootMap.get(number));
                        if (bgDataTable == null) {
                            if (!hasTables.isEmpty()) {
                                bgDataTable = hasTables.iterator().next();
                            } else {
                                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgScheme Set FUseAccInt = FUseAccInt + 1 Where FID = ?", (Object)new Object[]{schemeHelper.getBgSchemeId()});
                                List values = MbgSqlHelper.executeQuery((Connection)conn, (String)"Select FUseAccInt FROM T_MBG_BgScheme Where FID = ?", (Object[])new Object[]{schemeHelper.getBgSchemeId()});
                                int count = ((Number)values.get(0)).intValue();
                                BgSchemeConvertToAccIntUtils.querySplit(conn, cubeName, splitMap);
                                if (count > 26) {
                                    MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgScheme Set FUseAccIn = FUseAccInt - 1 Where FID = ?", (Object)new Object[]{schemeHelper.getBgSchemeId()});
                                    ArrayList<String> accNumbers = new ArrayList<String>(splitMap.keySet());
                                    accNumbers.retainAll(accRootMap.values());
                                    Collections.sort(accNumbers);
                                    String last = (String)accNumbers.get(0);
                                    for (int ai = 1; ai < accNumbers.size() && (number == null || number.compareTo((String)accNumbers.get(ai)) >= 0); ++ai) {
                                        last = (String)accNumbers.get(ai);
                                    }
                                    bgDataTable = splitMap.get(last);
                                } else {
                                    bgDataTable = splitMap.get(number);
                                    if (bgDataTable == null) {
                                        bgDataTable = splitMap.get(accRootMap.get(number));
                                    }
                                    if (bgDataTable == null) {
                                        newIndex = count - 1;
                                        bgDataTable = BgSchemeConvertToAccIntUtils.getNewRefCube(cubeName, newIndex);
                                    }
                                }
                            }
                        }
                        if (!splitMap.containsKey(number)) {
                            addNewSplitList.add(new String[]{number, bgDataTable, number, bgDataTable});
                            splitMap.put(number, bgDataTable);
                            String root = accRootMap.get(number);
                            if (!splitMap.containsKey(root)) {
                                addNewSplitList.add(new String[]{root, bgDataTable, root, bgDataTable});
                                splitMap.put(root, bgDataTable);
                            }
                        }
                        if (!addNewSplitList.isEmpty()) {
                            String splitTable = BgSchemeConvertToAccIntUtils.getSplitCube(cubeName);
                            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + splitTable + "(FAcctNumber, FRefCube) Select Top 1 ?, ? FROM " + splitTable + " Where NOT EXISTS(Select FAcctNumber FROM " + splitTable + " Where FAcctNumber = ? AND FRefCube = ?)"), addNewSplitList);
                        }
                    }
                    hasTables.add(bgDataTable);
                    if (!splitCalcMap.containsKey(bgDataTable)) {
                        splitCalcMap.put(bgDataTable, new HashMap());
                    }
                    ((Map)splitCalcMap.get(bgDataTable)).put(key2, calcData);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            splitCalcMap.put(cubeName, calcMap);
        }
        return splitCalcMap;
    }

    public static void queryDimInt(Connection conn, Map<String, Map<String, Integer>> dimIntMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, dimIntMap, DimensionConstants.DEF_ORGUNIT_FIELD, "T_MBG_BgOrgUnit", "FOrgUnitId", "FIntId", "FViewId", schemeHelper.getBgOrgViewId());
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, dimIntMap, DimensionConstants.DEF_BGINDEX_FIELD, "T_MBG_BgAccount", "FNumber", "FIntId", "FBgAccountViewId", schemeHelper.getDimension(DimensionConstants.DEF_INDEX_NUMBER).getViewId());
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, dimIntMap, DimensionConstants.DEF_ELEMENT_FIELD, "T_MBG_BgElement", "FID", "FIntId", null, null);
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, dimIntMap, DimensionConstants.DEF_PERIOD_FIELD, "T_MBG_BgPeriod", "FID", "FIntId", null, null);
        List<String> otherDims = schemeHelper.getAccAndOtherDim(true);
        for (String dimNumber : otherDims) {
            BgSchemeConvertToAccIntUtils.queryDimInt(conn, dimIntMap, schemeHelper.getRefField(dimNumber), "T_MBG_MbgMember", "FNumber", "FIntId", "FViewId", schemeHelper.getDimension(dimNumber).getViewId());
        }
    }

    public static void queryDimInt(Connection conn, IDimensionParameter parameter) throws Exception {
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter.getDataManager().getDimIntMap(), DimensionConstants.DEF_ORGUNIT_FIELD, "T_MBG_BgOrgUnit", "FOrgUnitId", "FIntId", "FViewId", parameter.getBgOrgViewId().toString());
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter.getDataManager().getDimIntMap(), DimensionConstants.DEF_BGINDEX_FIELD, "T_MBG_BgAccount", "FNumber", "FIntId", "FBgAccountViewId", parameter.getDataManager().getBgScheme().getViewId(DimensionConstants.DEF_INDEX_NUMBER).toString());
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter.getDataManager().getDimIntMap(), DimensionConstants.DEF_ELEMENT_FIELD, "T_MBG_BgElement", "FID", "FIntId", null, null);
        BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter.getDataManager().getDimIntMap(), DimensionConstants.DEF_PERIOD_FIELD, "T_MBG_BgPeriod", "FID", "FIntId", null, null);
        for (IDimension dimension : parameter.getDimensionMap().values()) {
            if (DimUtils.checkBaseDimension(dimension) || DimensionConstants.DEF_BGINDEX_FIELD.equals(dimension.getField())) continue;
            BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter.getDataManager().getDimIntMap(), dimension.getField(), "T_MBG_MbgMember", "FNumber", "FIntId", "FViewId", parameter.getDataManager().getBgScheme().getViewId(dimension.getNumber()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryDimInt(Connection conn, Map<String, Map<String, Integer>> dimIntMap, String dimField, String tableName, String numberField, String intField, String filterField, String filterValue) throws Exception {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        dimIntMap.put(dimField, result);
        IRowSet rst = null;
        try {
            rst = !StringUtils.isEmpty((String)filterField) ? BgDBUtils.executeQuery((Connection)conn, (String)("Select " + numberField + ", " + intField + " FROM " + tableName + " Where " + filterField + " = ?"), (Object[])new Object[]{filterValue}) : BgDBUtils.executeQuery((Connection)conn, (String)("Select " + numberField + ", " + intField + " FROM " + tableName + ""));
            while (rst.next()) {
                result.put(rst.getString(1), rst.getInt(2));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    public static void checkIsCancel(Context ctx, String bgSchemeId) throws BgFormException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("Select FUseAccInt FROM T_MBG_BgScheme Where FID = ?");
            pstmt.setString(1, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                logger.error((Object)("checkIsCancel " + rst.getInt(1)));
                if (rst.getInt(1) != 0) continue;
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{"user cacnel"});
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    static class ConvertThread
    implements Callable<Object> {
        Context ctx;
        MbgSchemeSplitInfo bgSchemeSplitInfo;
        String bgSchemeId;
        BgSchemeDimensionHelper schemeHelper;
        Connection conn;
        String tmpAccTable;
        String oldRefCube;
        List<String> cubeFields;
        Map<String, Map<String, Integer>> baseDataMap;
        Map<String, Set<String>> accChildMap;
        List<Set<String>> splitList;
        Set<String> accSet;
        int index;

        public ConvertThread(Context ctx, MbgSchemeSplitInfo bgSchemeSplitInfo, String bgSchemeId, BgSchemeDimensionHelper schemeHelper, Connection conn, String tmpAccTable, String oldRefCube, List<String> cubeFields, Map<String, Map<String, Integer>> baseDataMap, Map<String, Set<String>> accChildMap, List<Set<String>> splitList, Set<String> accSet, int index) {
            this.ctx = ctx;
            this.bgSchemeSplitInfo = bgSchemeSplitInfo;
            this.bgSchemeId = bgSchemeId;
            this.schemeHelper = schemeHelper;
            this.conn = conn;
            this.tmpAccTable = tmpAccTable;
            this.oldRefCube = oldRefCube;
            this.cubeFields = cubeFields;
            this.baseDataMap = baseDataMap;
            this.accChildMap = accChildMap;
            this.splitList = splitList;
            this.accSet = accSet;
            this.index = index;
        }

        @Override
        public Object call() throws Exception {
            BgSchemeConvertToAccIntUtils.convert(this.ctx, this.bgSchemeSplitInfo, this.bgSchemeId, this.schemeHelper, this.conn, this.tmpAccTable, this.oldRefCube, this.cubeFields, this.baseDataMap, this.accChildMap, this.splitList, this.accSet, this.index);
            return null;
        }
    }
}

