/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.algo;

import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.util.InOutSqlUtil;
import org.apache.log4j.Logger;

public class KDAlgoBatchTable
implements Table,
Serializable {
    private static final long serialVersionUID = 7798564770565556152L;
    private static Logger logger = Logger.getLogger((String)KDAlgoBatchTable.class.getName());
    private Connection conn = null;
    private String name = null;
    private String sql = null;
    private List<Object[]> paramList = null;
    protected boolean isEmpty = false;
    protected PreparedStatement pstmt = null;
    protected ResultSet rst = null;
    int batchIndex = -1;
    private String[] columnNames;
    private Map<String, Integer> columnTypes = new HashMap<String, Integer>();
    private Map<String, Integer> columnIndexes = new HashMap<String, Integer>();
    private Object[] data;
    private static final Null nullObject = new Null();

    public void nullData() {
        int size = this.columnNames.length;
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = nullObject;
        }
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setParamList(List<Object[]> paramList) {
        this.paramList = paramList;
    }

    public List<Object[]> getParamList() {
        return this.paramList;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    protected void init() throws OlapException {
        try {
            if (this.pstmt == null) {
                logger.error((Object)("batch sql:" + this.sql));
                this.pstmt = this.conn.prepareStatement(this.sql);
                this.nextBatch();
                this.readColumn();
            }
        }
        catch (SQLException e) {
            throw new OlapException((Throwable)e);
        }
    }

    private void readColumn() throws SQLException {
        ResultSetMetaData md = null;
        if (this.rst != null) {
            md = this.rst.getMetaData();
        }
        if (md == null || md.getColumnCount() == 0) {
            this.columnNames = new String[0];
        } else {
            this.columnNames = new String[md.getColumnCount()];
            for (int i = 0; i < md.getColumnCount(); ++i) {
                this.columnNames[i] = md.getColumnName(i + 1);
                this.columnTypes.put(this.columnNames[i].toUpperCase(), md.getColumnType(i + 1));
                this.columnIndexes.put(this.columnNames[i].toUpperCase(), i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean nextBatch() throws OlapException {
        if (this.isEmpty) {
            return false;
        }
        try {
            long st = System.currentTimeMillis();
            if (this.rst != null) {
                SQLUtils.cleanup((ResultSet)this.rst);
            }
            if (this.paramList == null || this.paramList.isEmpty()) {
                if (this.batchIndex != -1) return false;
                this.rst = this.pstmt.executeQuery();
                logger.info((Object)("nextBatch cost time(ms):" + (System.currentTimeMillis() - st)));
                return true;
            } else {
                if (this.batchIndex >= this.paramList.size() - 1) {
                    return false;
                }
                ++this.batchIndex;
                MbgSqlHelper.setParams((PreparedStatement)this.pstmt, (Object[])this.paramList.get(this.batchIndex));
                logger.info((Object)("nextBatch param:" + Arrays.toString(this.paramList.get(this.batchIndex))));
                this.rst = this.pstmt.executeQuery();
                logger.info((Object)("nextBatch cost time(ms):" + (System.currentTimeMillis() - st)));
            }
            return true;
        }
        catch (SQLException e) {
            throw new OlapException((Throwable)e);
        }
    }

    public int getColumnCount() throws OlapException {
        this.init();
        return this.columnNames.length;
    }

    public int getColumnType(int index) throws OlapException {
        this.init();
        return this.columnTypes.get(this.columnNames[index].toUpperCase());
    }

    public int getColumnIndex(String name) throws OlapException {
        this.init();
        Integer index = this.columnIndexes.get(name.toUpperCase());
        if (index == null) {
            throw new OlapException("Column '" + name + "' not found.");
        }
        return index;
    }

    public String[] getColumnNames() throws OlapException {
        this.init();
        return this.columnNames;
    }

    public boolean next() throws OlapException {
        if (this.isEmpty) {
            return false;
        }
        this.init();
        this.nullData();
        try {
            if (this.rst.next()) {
                return true;
            }
            while (this.nextBatch()) {
                if (!this.rst.next()) continue;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new OlapException((Throwable)e);
        }
    }

    public Object getValue(int index) throws OlapException {
        this.init();
        if (this.data[index] != nullObject) {
            return this.data[index];
        }
        try {
            this.data[index] = InOutSqlUtil.getValue((ResultSet)this.rst, (int)this.getColumnType(index), (int)(index + 1));
            return this.data[index];
        }
        catch (SQLException e) {
            throw new OlapException((Throwable)e);
        }
    }

    public Object[] getValues() throws OlapException {
        this.init();
        for (int i = 0; i < this.data.length; ++i) {
            if (nullObject != this.data[i]) continue;
            this.data[i] = this.getValue(i);
        }
        return this.data;
    }

    public void close() {
        SQLUtils.cleanup((ResultSet)this.rst);
        SQLUtils.cleanup((Statement)this.pstmt);
    }

    private static class Null {
        private Null() {
        }
    }
}

