/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.algo;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.utils.BizAlgoParam;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberScope;
import com.kingdee.eas.ma.mbg.BgCommonException;
import com.kingdee.eas.ma.mbg.app.olap.impl.MDXStrategy;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.MetadataAPI;
import org.apache.log4j.Logger;

public class KDAlgoMDXStrategy
extends MDXStrategy {
    private static final Logger logger = Logger.getLogger((String)KDAlgoMDXStrategy.class.getName());

    @Override
    public void transCalcMdx(Context ctx, IDimensionParameter parameter) throws Exception {
        super.transCalcMdx(ctx, parameter);
    }

    public void transCalcMdx(Context ctx, IDimensionParameter parameter, MetadataAPI api) throws Exception {
        Set<String> refPeriods;
        if (ctx == null || parameter == null) {
            return;
        }
        parameter.getDataManager().getCalcStrategy().bizCalcMdx(ctx, parameter, api);
        boolean isPeriodFlag = BgParamNHelper.isPeriodAlgorithm((Context)ctx);
        if ((parameter.getDataManager().getOpeningNumber() == null || parameter.getDataManager().getOpeningNumber().isEmpty()) && (parameter.getDataManager().getEndNumber() == null || parameter.getDataManager().getEndNumber().isEmpty())) {
            return;
        }
        Map<String, IMember> perMemberMap = this.getPeriodMemberMap(ctx, parameter);
        Map<String, IMember> accMemberMap = this.getAccMemberMap(ctx, parameter);
        String parent = null;
        for (String child : parameter.getBgPeriodParentMap().keySet()) {
            parent = parameter.getBgPeriodParentMap().get(child);
            if (!parameter.getBgPeriodChildMap().containsKey(parent)) {
                parameter.getBgPeriodChildMap().put(parent, new ArrayList());
            }
            if (parameter.getBgPeriodChildMap().get(parent).contains(child)) continue;
            parameter.getBgPeriodChildMap().get(parent).add(child);
        }
        if (parameter.getDataManager().getCalcStrategy() != null && parameter.getDataManager().getCalcStrategy().getRefNumMap() != null && (refPeriods = parameter.getDataManager().getCalcStrategy().getRefNumMap().get(DimensionConstants.DEF_PERIOD_FIELD)) != null && !refPeriods.isEmpty()) {
            String[] lns = null;
            String pNumber = null;
            String cNumber = null;
            HashMap<String, Set<String>> allParentChildMap = new HashMap<String, Set<String>>();
            for (IMember member : perMemberMap.values()) {
                lns = member.getMdxNumber().split("!");
                if (lns.length == 1) continue;
                pNumber = lns[lns.length - 2];
                cNumber = lns[lns.length - 1];
                if (!allParentChildMap.containsKey(pNumber)) {
                    allParentChildMap.put(pNumber, new HashSet());
                }
                ((Set)allParentChildMap.get(pNumber)).add(cNumber);
            }
            this.addToParentChildMap(refPeriods, allParentChildMap, parameter.getBgPeriodChildMap());
        }
        Iterator<List<String>> itC = parameter.getBgPeriodChildMap().values().iterator();
        while (itC.hasNext()) {
            Collections.sort(itC.next());
        }
        this.transPeriodMdx(ctx, parameter.getDataManager().getEndNumber(), false, isPeriodFlag, parameter, api, perMemberMap, accMemberMap);
        this.transPeriodMdx(ctx, parameter.getDataManager().getOpeningNumber(), true, isPeriodFlag, parameter, api, perMemberMap, accMemberMap);
    }

    private void transPeriodMdx(Context ctx, Set<String> accNumbers, boolean isOpenPeriod, boolean isPeriodFlag, IDimensionParameter parameter, MetadataAPI api, Map<String, IMember> perMemberMap, Map<String, IMember> accMemberMap) throws Exception {
        if (accNumbers == null || accNumbers.isEmpty()) {
            return;
        }
        if (!isPeriodFlag) {
            return;
        }
        if (parameter.getDimension(DimensionConstants.DEF_BGINDEX_FIELD) == null) {
            logger.error((Object)"KDAlgoMDXStrategy.transPeriodMdx Not Period Dimension");
            return;
        }
        HashMap mdxNumMap = new HashMap();
        BizMemberScope memberScope = null;
        IMember pMember = null;
        IMember accMember = null;
        IMember cMember = null;
        int calcSeq = 0;
        int calcSubSeq = 0;
        int exprSeq = 0;
        int subSeq = 0;
        List<String> childPeriods = null;
        String parent2 = null;
        for (String parent2 : parameter.getBgPeriodChildMap().keySet()) {
            pMember = this.getPeriodMember(parent2, perMemberMap);
            if (pMember == null) {
                pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, parent2));
            }
            if (pMember == null) {
                logger.error((Object)("KDAlgoMDXStrategy.transPeriodMdx Parent Period Not Exitst: " + parent2));
                continue;
            }
            childPeriods = parameter.getBgPeriodChildMap().get(parent2);
            if (childPeriods == null || childPeriods.isEmpty()) continue;
            String cPeriod = null;
            cPeriod = isOpenPeriod ? childPeriods.get(0) : childPeriods.get(childPeriods.size() - 1);
            cMember = this.getPeriodMember(cPeriod, perMemberMap);
            if (cMember == null) {
                logger.error((Object)("KDAlgoMDXStrategy.transPeriodMdx Child Period Not Exitst: " + cPeriod));
                continue;
            }
            memberScope = new BizMemberScope("period", parent2);
            memberScope.setExpression(BizExprUtils.replaceAll((String)(BizExprUtils.getMdxField((String)DimensionConstants.DEF_PERIOD_FIELD) + BizExprUtils.getMdxNumber((String)pMember.getMdxNumber()))));
            subSeq = 0;
            for (String accNumber : accNumbers) {
                accMember = accMemberMap.get(accNumber);
                if (accMember == null) {
                    logger.error((Object)("KDAlgoMDXStrategy.transPeriodMdx Account Member Not Exitst: " + accNumber));
                    continue;
                }
                BizAlgoParam algoParam = new BizAlgoParam();
                algoParam.getMemberScopes().add(memberScope);
                algoParam.setScopeName(BizExprUtils.getCalcNumber((String)("PAlGO" + (isOpenPeriod ? "O" : "E")), (int)calcSeq, (int)calcSubSeq, (int)exprSeq, (int)subSeq));
                algoParam.setUniqueName(BizExprUtils.replaceAll((String)(BizExprUtils.getMdxField((String)DimensionConstants.DEF_BGINDEX_FIELD) + BizExprUtils.getMdxNumber((String)DimensionConstants.DEF_BGINDEX_FIELD, (String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)accMember.getMdxNumber(), mdxNumMap, null, (boolean)false))));
                algoParam.setExpression(BizExprUtils.replaceAll((String)(BizExprUtils.getMdxField((String)DimensionConstants.DEF_PERIOD_FIELD) + BizExprUtils.getMdxNumber((String)cMember.getMdxNumber()))));
                BizCalcMember.calcAlgo((Object)api, (BizAlgoParam)algoParam, mdxNumMap, (boolean)parameter.isOrgLongNumber());
                ++subSeq;
            }
            ++calcSeq;
        }
    }

    private void addToParentChildMap(Set<String> periods, Map<String, Set<String>> allParentChildMap, Map<String, List<String>> periodChildMap) {
        for (String period : periods) {
            Set<String> childs = allParentChildMap.get(period);
            if (childs == null || childs.isEmpty()) continue;
            periodChildMap.put(period, new ArrayList<String>(childs));
            this.addToParentChildMap(childs, allParentChildMap, periodChildMap);
        }
    }

    private IMember getPeriodMember(String period, Map<String, IMember> perMemberMap) {
        if (StringUtils.isEmpty((String)period)) {
            return null;
        }
        IMember pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(BizConstants.BGPERIOD_DIMENSION_CODE, period));
        if (pMember == null) {
            pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, period));
        }
        if (pMember == null) {
            pMember = perMemberMap.get(period);
        }
        return pMember;
    }

    @Override
    protected void checkMaxCellSize(int rowCount, int colCount, IDimensionParameter parameter) throws Exception {
        if (rowCount > parameter.getControlManager().getMaxAxisSize() && colCount > parameter.getControlManager().getMaxAxisSize()) {
            throw new BgCommonException(BgCommonException.CHECKMAXAXISSIZE, new Object[]{parameter.getControlManager().getMaxAxisSize()});
        }
        if ((long)rowCount * (long)colCount > parameter.getControlManager().getMaxCellSize()) {
            throw new BgCommonException(BgCommonException.CHECKMAXCELLSIZE, new Object[]{parameter.getControlManager().getMaxCellSize()});
        }
    }
}

