/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.algo;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.mbg.app.olap.algo.KDAlgoMDXStrategy;
import com.kingdee.eas.ma.mbg.app.olap.algo.KDAlgoResultStrategy;
import com.kingdee.eas.ma.mbg.app.olap.face.IMDXStrategy;
import com.kingdee.eas.ma.mbg.app.olap.face.IResultStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.OlapService;
import com.kingdee.eas.ma.mbg.app.olap.impl.QueryStrategy;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.Driver;
import kd.bos.algo.olap.MdxResult;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.OlapConfig;
import org.apache.log4j.Logger;

public class KDAlgoQueryStrategy
extends QueryStrategy {
    private static Logger logger = Logger.getLogger(KDAlgoQueryStrategy.class);
    private final String SEPARATOR_LEFT_STR = "\\[";
    private final String SEPARATOR_RIGTH_STR = "\\]";
    private final String SEPARATOR_STR = "\\`";

    public KDAlgoQueryStrategy(OlapService service) {
        super(service);
    }

    @Override
    public IMDXStrategy createMdxStrategy() {
        return new KDAlgoMDXStrategy();
    }

    @Override
    public IResultStrategy createRstStrategy() {
        return new KDAlgoResultStrategy();
    }

    @Override
    public Map<String, Object> query(Context ctx, Connection pConn, IDimensionParameter parameter, Map<String, Object> olapParamsMap) throws Exception {
        Map<String, Object> bgDataMap = new HashMap<String, Object>();
        if (ctx == null || parameter == null || olapParamsMap == null) {
            return bgDataMap;
        }
        Map cubeParam = (Map)olapParamsMap.get(DimensionConstants.OLAP_SCHEME);
        if (cubeParam == null) {
            return bgDataMap;
        }
        String mdx = null;
        InputStream input = null;
        kd.bos.algo.olap.Connection olapConn = null;
        MdxResult rst = null;
        OlapConfig config = new OlapConfig();
        config.supportSelfData = true;
        config.useSelfData = false;
        config.BUILD_AUTOJOINFACTSQL = false;
        try {
            config.FOREAS = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (128 != parameter.getValueType() && 64 != parameter.getValueType() || parameter.getUnionId() != null) {
            // empty if block
        }
        try {
            olapParamsMap.put("JdbcConnection", pConn);
            String cubeScheme = this.getService().getSchemeCube().getSchemeCube(ctx, pConn, cubeParam, olapParamsMap, parameter);
            input = new ByteArrayInputStream(cubeScheme.getBytes());
            this.getDebug().debugBegin("begin get Connection");
            olapConn = Driver.openConnection((InputStream)input, olapParamsMap, (OlapConfig)config);
            this.getDebug().debugUseTime("end get Connection");
            try {
                this.bizCalc(ctx, olapConn, parameter);
                mdx = this.getMdxStrategy().transMdx(ctx, parameter);
                if (mdx != null) {
                    mdx = mdx.replaceAll("\\[", "\\`").replaceAll("\\]", "\\`");
                }
                if (!StringUtils.isEmpty((String)mdx)) {
                    logger.error((Object)"MDX IS ");
                    logger.error((Object)mdx);
                    this.getDebug().debugBegin("begin executeMdxQuery");
                    rst = olapConn.executeMdxQuery(mdx, (List[])this.convertKDAlgoFilters(parameter.getDataManager().getMdxFilters(parameter)));
                    this.getDebug().debugUseTime("end executeMdxQuery");
                    bgDataMap = this.getRstStrategy().transResult(ctx, parameter, rst, bgDataMap);
                }
                if (!parameter.getQuerys().isEmpty()) {
                    IQueryData query = null;
                    int in = parameter.getQuerys().size();
                    for (int i = 0; i < in; ++i) {
                        query = parameter.getQuerys().get(i);
                        mdx = this.getMdxStrategy().transMdx(ctx, parameter, query);
                        if (mdx != null) {
                            mdx = mdx.replaceAll("\\[", "\\`").replaceAll("\\]", "\\`");
                        }
                        if (StringUtils.isEmpty((String)mdx)) continue;
                        logger.error((Object)"MDX IS ");
                        logger.error((Object)mdx);
                        this.getDebug().debugBegin("begin executeMdxQuery");
                        rst = olapConn.executeMdxQuery(mdx, (List[])this.convertKDAlgoFilters(query.getMdxFilters(parameter)));
                        this.getDebug().debugUseTime("end executeMdxQuery");
                        bgDataMap = this.getRstStrategy().transResult(ctx, parameter, query, rst, bgDataMap);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("dimense Query Error:" + mdx));
                logger.error((Object)"dimense Query Error:", (Throwable)ex);
                throw ex;
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (olapConn != null) {
                try {
                    olapConn.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        if (bgDataMap != null && bgDataMap.size() <= 1000) {
            logger.error((Object)("KDAlgoQueryStrategy query bgDataMap:" + bgDataMap));
        }
        return bgDataMap;
    }

    private List<String[]>[] convertKDAlgoFilters(List<String[]>[] mdxFilters) {
        if (mdxFilters == null) {
            return mdxFilters;
        }
        List[] result = new List[mdxFilters.length];
        ArrayList<String[]> newSubList = null;
        List<String[]> subList = null;
        String[] relation = null;
        for (int l = 0; l < mdxFilters.length; ++l) {
            subList = mdxFilters[l];
            if (subList == null) continue;
            result[l] = newSubList = new ArrayList<String[]>(subList.size());
            if (subList.isEmpty()) continue;
            for (int s = 0; s < subList.size(); ++s) {
                relation = new String[subList.get(s).length];
                System.arraycopy(subList.get(s), 0, relation, 0, relation.length);
                newSubList.add(relation);
                if (s != 0) continue;
                for (int r = 0; r < relation.length; ++r) {
                    relation[r] = DimUtils.getDimensionTag(relation[r]);
                }
            }
        }
        return result;
    }

    protected void bizCalc(Context ctx, kd.bos.algo.olap.Connection olapConn, IDimensionParameter parameter) throws Exception {
        MetadataAPI api = olapConn.getMetadataAPI();
        ((KDAlgoMDXStrategy)this.getMdxStrategy()).transCalcMdx(ctx, parameter, api);
    }
}

