/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcExpreUtils;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.CslCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceResult;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.OptimizeUtils;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcStrategy {
    private static Logger logger = Logger.getLogger(BizCalcStrategy.class);
    private List<ICalcMember> members = new ArrayList<ICalcMember>();
    private Set<String> standbyDim = null;
    private Map<String, Set<String>> refNumMap = null;
    private BizCalcExpreUtils utils = null;
    private BizCalcTraceResult bizCalcTraceResult = null;
    private BizCalcQuery bizCalcQuery = null;

    public List<ICalcMember> getMembers() {
        return this.members;
    }

    public void setStandbyDim(Set<String> standbyDim) {
        this.standbyDim = standbyDim;
    }

    public Set<String> getStandbyDim() {
        return this.standbyDim;
    }

    public Map<String, Set<String>> getRefNumMap() {
        return this.refNumMap;
    }

    public void setRefNumMap(Map<String, Set<String>> refNumMap) {
        this.refNumMap = refNumMap;
    }

    public BizCalcExpreUtils getUtils() {
        return this.utils;
    }

    public void setUtils(BizCalcExpreUtils utils) {
        this.utils = utils;
    }

    public BizCalcTraceResult getBizCalcTraceResult() {
        return this.bizCalcTraceResult;
    }

    public void setBizCalcTraceResult(BizCalcTraceResult bizCalcTraceResult) {
        this.bizCalcTraceResult = bizCalcTraceResult;
    }

    public BizCalcQuery getBizCalcQuery() {
        return this.bizCalcQuery;
    }

    public void setBizCalcQuery(BizCalcQuery bizCalcQuery) {
        this.bizCalcQuery = bizCalcQuery;
    }

    public void queryCalc(Context ctx, IDimensionParameter parameter) throws Exception {
        if (ctx == null || parameter == null) {
            return;
        }
        this.getMembers().clear();
        BizCalcQuery query = new BizCalcQuery(ctx);
        this.setBizCalcQuery(query);
        Connection conn = null;
        try {
            String type;
            conn = BgDBUtils.getConnection((Context)ctx);
            query.queryPeriodCalc(conn, parameter);
            List<ICalcMember> tmpMems = query.queryBaseCalc(conn, parameter, this.getStandbyDim());
            if (tmpMems != null) {
                this.getMembers().addAll((Collection<ICalcMember>)tmpMems);
            }
            if (parameter.getUnionId() != null && parameter.getBillId() != null && "9E7BD5E2".equals(type = parameter.getBillId().getType().toString())) {
                this.getMembers().add((ICalcMember)new CslCalcMember());
            }
            Map variateMap = query.queryVariate(conn, parameter.getBgSchemeId());
            parameter.getDataManager().setVariate(variateMap);
            if (!parameter.isCalcBiz()) {
                return;
            }
            tmpMems = this.queryBizCalc(ctx, conn, parameter, query, variateMap);
            if (tmpMems != null) {
                this.getMembers().addAll(tmpMems);
            }
            long begin = System.currentTimeMillis();
            this.calc(ctx, conn, parameter);
            logger.debug((Object)("calc exprs! use = " + (System.currentTimeMillis() - begin) + " ms."));
        }
        catch (Exception ex) {
            logger.error((Object)"bizCalcMdx error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bizCalcMdx(Context ctx, IDimensionParameter parameter) {
        if (ctx == null || parameter == null || this.getMembers().isEmpty()) {
            return null;
        }
        StringBuffer calcMdx = new StringBuffer();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            String tmpStr = this.translateBizMember(ctx, conn, parameter, this.getMembers());
            if (!StringUtils.isEmpty((String)tmpStr)) {
                calcMdx.append("WITH ").append(tmpStr);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"bizCalcMdx error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return calcMdx.toString();
    }

    public String bizCalcMdx(Context ctx, IDimensionParameter parameter, Object api) {
        if (ctx == null || parameter == null || this.getMembers().isEmpty()) {
            return null;
        }
        ICalcMember member = null;
        List<ICalcMember> members = this.getMembers();
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member == null) continue;
            member.calcMeber(ctx, parameter, i + 1, api);
        }
        return null;
    }

    private List<ICalcMember> queryBizCalc(Context ctx, Connection conn, IDimensionParameter parameter, BizCalcQuery query, Map<String, String> variateMap) throws Exception {
        ArrayList<ICalcMember> members = new ArrayList<ICalcMember>();
        if (conn == null || parameter == null || parameter.getControlManager().isControlData() || !parameter.getControlManager().hasCalcBiz() || query == null) {
            return members;
        }
        List calcs = null;
        BizCalcMember member = null;
        MbgDimInfo mbgDim = null;
        Map mdxNumMap = null;
        HashMap<String, Set<String>> refNumMap = new HashMap<String, Set<String>>();
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        Map<String, String> fieldSrcMap = parameter.getDataManager().getFieldSrcMap();
        HashMap tmpRefNumMap = new HashMap();
        HashMap<String, Map<String, Set<String>>> calcRefNumMap = new HashMap<String, Map<String, Set<String>>>();
        String dimNumber22 = null;
        String srcNumber = null;
        String field = null;
        Set<String> standardNumber = DimUtils.getPeriodStandardNumber(parameter);
        String[] tmpStrs = null;
        String orgViewId = parameter.getBgOrgViewId() != null ? parameter.getBgOrgViewId().toString() : null;
        String orgUnitNum = null;
        if (parameter.getDataManager().getBgOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getBgOrgUnit().getNumber();
        } else if (parameter.getDataManager().getOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getOrgUnit().getNumber();
        }
        try {
            for (String dimNumber22 : variateMap.values()) {
                tmpStrs = dimNumber22.split(":");
                if (tmpStrs == null || tmpStrs.length != 2 || !srcFieldMap.containsKey(srcNumber = tmpStrs[0])) continue;
                field = parameter.getDataManager().getSrcFieldMap().get(srcNumber);
            }
            Object var23_24 = null;
            Map<String, String> tmpMap = null;
            Set tmpSet = null;
            calcs = query.queryBizCalc(parameter, conn, parameter.getBgSchemeId(), parameter.getUnionId(), parameter.getBgTemplateId(), parameter.getCalcIds(), parameter.getControlManager().isBackCalc(), standardNumber, parameter.getPeriodCheckScope(), orgViewId, orgUnitNum);
            if (calcs != null && !calcs.isEmpty()) {
                for (BizCalcInfo calc : calcs) {
                    try {
                        member = new BizCalcMember();
                        mdxNumMap = new HashMap();
                        member.setMdxNumMap(mdxNumMap);
                        member.setSrcFieldMap(parameter.getDataManager().getSrcFieldMap());
                        member.setNumInnMap(parameter.getDataManager().getNumInnMap());
                        member.setCalc(calc);
                        if (!this.checkisInOrgScope(ctx, parameter, (ICalcMember)member)) continue;
                        member.queryRefMbgMember(ctx, parameter, parameter.getBgSchemeId(), tmpRefNumMap);
                        members.add((ICalcMember)member);
                        calcRefNumMap.put(calc.getId().toString(), new HashMap(tmpRefNumMap));
                        for (String fie : tmpRefNumMap.keySet()) {
                            if (refNumMap.containsKey(fie)) {
                                ((Set)refNumMap.get(fie)).addAll((Collection)tmpRefNumMap.get(fie));
                                continue;
                            }
                            refNumMap.put(fie, (Set<String>)tmpRefNumMap.get(fie));
                        }
                        for (int i = 0; i < calc.getBizCalcSubset().size(); ++i) {
                            BizCalcSubsetInfo subSet = calc.getBizCalcSubset().get(i);
                            int in = subSet.getScope().size();
                            for (int s = 0; s < in; ++s) {
                                String scopeNum;
                                BizScopeInfo scope = subSet.getScope().get(s);
                                if (scope.getBgMemberType() == BizConstants.BIZ_BGORGUNIT_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGINDEX_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_BGINDEX_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_CURRENCY_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_CURRENCY_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGVERSION_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_VERSION_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGSCENARIO_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_SCENARIO_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_PERIOD_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGELEMENT_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_ELEMENT_FIELD;
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_EXTDIM_TYPE_VALUE) {
                                    field = scope.getRefField();
                                } else if (scope.getBgMemberType() == BizConstants.BIZ_PROCESS_TYPE_VALUE) {
                                    field = DimensionBaseConstants.DEF_PROCESS_FIELD;
                                }
                                int valueType = scope.getBizDataType().getValue();
                                if (valueType != 4 || DimensionConstants.DEF_ORGUNIT_FIELD.equals(field) || StringUtils.isEmpty((String)(scopeNum = BizExprUtils.getScopeNumByScopeMemNum((String)scope.getBgMemberNum()))) || !scopeNum.startsWith(fieldSrcMap.get(field))) continue;
                                if (!tmpRefNumMap.containsKey(field)) {
                                    tmpRefNumMap.put(field, new HashSet());
                                }
                                ((Set)tmpRefNumMap.get(field)).add(scopeNum);
                            }
                        }
                        Iterator<Object> iter = tmpRefNumMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = (Map.Entry)iter.next();
                            if (!parameter.getDataManager().getMbgDims().containsKey(entry.getKey()) || !DimensionConstants.DEF_ACCOUNT_NUMBER.equals((mbgDim = parameter.getDataManager().getMbgDims().get(entry.getKey())).getNumber())) continue;
                            tmpSet = BizExprUtils.transFunFormatToMember((Set)((Set)entry.getValue()));
                            tmpMap = DimUtils.queryItemLongNumber(ctx, parameter, mbgDim, tmpSet);
                            if (tmpMap != null) {
                                mdxNumMap.put(entry.getKey(), tmpMap);
                            }
                            if (!DimUtils.checkFunFormatToMember((Set)entry.getValue())) continue;
                            iter.remove();
                        }
                        tmpRefNumMap.clear();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"queryBizCalc error:", (Throwable)ex);
                    }
                }
                Set<String> memberSet = null;
                com.kingdee.eas.ma.mbg.dimension.face.IDimension periodDim = parameter.getPeriodDimension();
                if (refNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                    memberSet = (Set)refNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                } else {
                    memberSet = new HashSet();
                    refNumMap.put(DimensionBaseConstants.DEF_PERIOD_FIELD, memberSet);
                }
                if (memberSet != null && periodDim != null) {
                    int in = periodDim.getDimensionMember().size();
                    for (int i = 0; i < in; ++i) {
                        memberSet.add(periodDim.getDimensionMember().get(i).getNumber());
                    }
                } else if (((Set)refNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD)).isEmpty()) {
                    refNumMap.remove(DimensionBaseConstants.DEF_PERIOD_FIELD);
                }
                if (memberSet != null && parameter.getQuerys() != null && !parameter.getQuerys().isEmpty()) {
                    List<IQueryData> querys = parameter.getQuerys();
                    for (IQueryData queryData : querys) {
                        Map<String, IDimension> mbgDimMap = queryData.getMbgDimMap();
                        IDimension dimension = mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                        if (dimension == null) continue;
                        List<IMember> dimMembers = dimension.getMembers();
                        int in = dimMembers.size();
                        for (int i = 0; i < in; ++i) {
                            memberSet.add(dimMembers.get(i).getNumber());
                        }
                    }
                }
                if (refNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD) != null && ((Set)refNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD)).isEmpty()) {
                    refNumMap.remove(DimensionBaseConstants.DEF_PERIOD_FIELD);
                }
                HashMap<String, Set<String>> refNumMapTmp = new HashMap<String, Set<String>>(refNumMap);
                HashMap<Object, Object> mdxNumMapOrgNotUnion = new HashMap();
                for (int m = 0; m < members.size(); ++m) {
                    member = (BizCalcMember)members.get(m);
                    mdxNumMap = member.getMdxNumMap();
                    for (Map.Entry entry : refNumMapTmp.entrySet()) {
                        if (!parameter.getDataManager().getMbgDims().containsKey(entry.getKey())) continue;
                        mbgDim = parameter.getDataManager().getMbgDims().get(entry.getKey());
                        if (parameter.getUnionId() != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(mbgDim.getNumber())) continue;
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) {
                            tmpSet = BizExprUtils.transFunFormatToMember((Set)((Set)entry.getValue()));
                            tmpMap = DimUtils.queryItemLongNumber(ctx, parameter, mbgDim, tmpSet);
                            if (tmpMap != null) {
                                mdxNumMap.put(entry.getKey(), tmpMap);
                            }
                        } else if (mdxNumMapOrgNotUnion.isEmpty()) {
                            tmpSet = BizExprUtils.transFunFormatToMember((Set)((Set)entry.getValue()));
                            tmpMap = DimUtils.queryItemLongNumber(ctx, parameter, mbgDim, tmpSet);
                            if (tmpMap != null) {
                                mdxNumMap.put(entry.getKey(), tmpMap);
                            }
                            mdxNumMapOrgNotUnion = new HashMap<String, String>(tmpMap);
                        } else {
                            mdxNumMap.put(entry.getKey(), mdxNumMapOrgNotUnion);
                        }
                        if (!DimUtils.checkFunFormatToMember((Set)entry.getValue()) || !refNumMap.containsKey(entry.getKey())) continue;
                        refNumMap.remove(entry.getKey());
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"queryBizCalc error:", (Throwable)exception);
            throw exception;
        }
        this.setRefNumMap(this.filterRefNumMap(parameter, refNumMap, calcRefNumMap));
        return members;
    }

    protected Map<String, Set<String>> filterRefNumMap(IDimensionParameter parameter, Map<String, Set<String>> refNumMap, Map<String, Map<String, Set<String>>> calcRefNumMap) {
        if (calcRefNumMap.keySet().size() == 1) {
            return refNumMap;
        }
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>(refNumMap);
        Map<String, Set<String>> tmpMap = null;
        String field = null;
        Iterator itr = refMap.keySet().iterator();
        block0: while (itr.hasNext()) {
            field = (String)itr.next();
            Iterator<String> ite = calcRefNumMap.keySet().iterator();
            while (ite.hasNext()) {
                tmpMap = calcRefNumMap.get(ite.next());
                if (tmpMap.containsKey(field) || !refMap.containsKey(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field)) continue;
                itr.remove();
                continue block0;
            }
        }
        return refMap;
    }

    protected boolean checkisInOrgScope(Context ctx, IDimensionParameter parameter, ICalcMember iCalcMember) throws BOSException {
        boolean isInOrgScope = false;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
        if (dimension != null && dimension.getDimensionMember().size() > 1) {
            return true;
        }
        String orgUnitNum = null;
        if (parameter.getDataManager().getBgOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getBgOrgUnit().getNumber();
        } else if (parameter.getDataManager().getOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getOrgUnit().getNumber();
        }
        if (!(iCalcMember instanceof BizCalcMember)) {
            return true;
        }
        BizCalcSubsetInfo subCalc = null;
        String orgViewID = parameter.getBgOrgViewId().toString();
        String bgSchemeID = parameter.getBgSchemeId().toString();
        Set<String> bgPeriodNums = DimUtils.getPeriodStandardNumber(parameter);
        int formProcessType = DimUtils.getProcessType(ctx, parameter);
        Map scopeMap = null;
        Map.Entry entry2 = null;
        BizCalcMember calcMember = (BizCalcMember)iCalcMember;
        int jn = calcMember.getCalc().getBizCalcSubset().size();
        for (int j = 0; j < jn; ++j) {
            subCalc = calcMember.getCalc().getBizCalcSubset().get(j);
            if (!subCalc.hasCalc || subCalc == null) continue;
            try {
                subCalc.getScopeData(parameter.getDataManager().getVariate(), bgPeriodNums, parameter.getPeriodCheckScope(), true, true, ctx, parameter.getDataManager().getBgScheme(), parameter.getDataManager().getDimensions());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (!subCalc.checkHasOrgScope(ctx, orgUnitNum, orgViewID, bgSchemeID, parameter.getUnionId()) && parameter.getBillId() != null) {
                subCalc.hasCalc = false;
            }
            if ((scopeMap = subCalc.getScopeMap()) != null && !scopeMap.isEmpty()) {
                for (Map.Entry entry2 : scopeMap.entrySet()) {
                    if (!DimensionBaseConstants.DEF_PROCESS_FIELD.equals(entry2.getKey()) || ((Set)entry2.getValue()).isEmpty() || ((Set)entry2.getValue()).contains(BgProcessEnum.getEnum(formProcessType).getName())) continue;
                    subCalc.hasCalc = false;
                    break;
                }
            }
            if (!subCalc.hasCalc) continue;
            isInOrgScope = true;
        }
        return isInOrgScope;
    }

    protected void filterBizMember(Context ctx, IDimensionParameter parameter, List<ICalcMember> members) throws BOSException {
        OptimizeUtils.filterBizMember(ctx, parameter, members);
    }

    private String translateBizMember(Context ctx, Connection conn, IDimensionParameter parameter, List<ICalcMember> members) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        String _mdx = null;
        ICalcMember member = null;
        StringBuffer calcMdx = new StringBuffer();
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member == null || StringUtils.isEmpty((String)(_mdx = member.getCalcMdx(ctx, conn, parameter, i + 1)))) continue;
            calcMdx.append(_mdx).append(" \r\n");
        }
        return calcMdx.toString();
    }

    public void calc(Context ctx, Connection conn, IDimensionParameter parameter) throws Exception {
        if (this.getMembers().isEmpty()) {
            return;
        }
        this.calcLogicExpress();
        this.calcExpress(ctx, conn, parameter);
    }

    public void calcExpress(Context ctx, Connection conn, IDimensionParameter parameter) throws Exception {
        if (parameter.getControlManager().isExpressionCalc()) {
            return;
        }
        if (parameter.getQueryOrgIds() != null && !parameter.getQueryOrgIds().isEmpty()) {
            BOSUuid orgUnitId = parameter.getOrgUnitId();
            for (String orgId : parameter.getQueryOrgIds()) {
                parameter.setOrgUnitId(BOSUuid.read((String)orgId));
                BizCalcExpreUtils utils = new BizCalcExpreUtils(ctx, conn, parameter);
                utils.calc(this.getMembers());
                this.setUtils(utils);
                parameter.setOrgUnitId(orgUnitId);
            }
        } else {
            BizCalcExpreUtils utils = new BizCalcExpreUtils(ctx, conn, parameter);
            utils.calc(this.getMembers());
            this.setUtils(utils);
        }
    }

    public void calcLogicExpress() throws Exception {
    }

    public boolean hasBizCalc() {
        boolean hasBizCalc = false;
        for (ICalcMember calcMember : this.getMembers()) {
            if (!(calcMember instanceof BizCalcMember)) continue;
            hasBizCalc = true;
            break;
        }
        return hasBizCalc;
    }

    public BizCalcStrategy getClone() {
        BizCalcStrategy strategy = new BizCalcStrategy();
        if (!this.getMembers().isEmpty()) {
            ICalcMember distMember = null;
            BizCalcMember srcCalc = null;
            BizCalcMember distCalc = null;
            BizCalcSubsetInfo srcSub = null;
            BizCalcSubsetInfo distSub = null;
            for (ICalcMember member : this.getMembers()) {
                try {
                    distMember = (ICalcMember)ObjectUtils.createCopy((Object)member);
                    if (distMember instanceof BizCalcMember) {
                        distCalc = (BizCalcMember)distMember;
                        srcCalc = (BizCalcMember)member;
                        int in = distCalc.getCalc().getBizCalcSubset().size();
                        for (int i = 0; i < in; ++i) {
                            distSub = distCalc.getCalc().getBizCalcSubset().get(i);
                            srcSub = srcCalc.getCalc().getBizCalcSubset().get(i);
                            distSub.hasCalc = srcSub.hasCalc;
                            distSub.getExpres().clear();
                            distSub.getExpres(false).addAll(srcSub.getExpres());
                        }
                    }
                    strategy.getMembers().add(distMember);
                }
                catch (CloneNotSupportedException ex) {
                    logger.error((Object)"clone error:", (Throwable)ex);
                }
                catch (ParseException ex) {
                    logger.error((Object)"clone error:", (Throwable)ex);
                }
            }
        }
        if (this.getStandbyDim() != null && !this.getStandbyDim().isEmpty()) {
            strategy.setStandbyDim(new HashSet<String>());
            strategy.getStandbyDim().addAll(this.getStandbyDim());
        }
        if (this.getUtils() != null) {
            strategy.setUtils(this.getUtils());
        }
        strategy.setRefNumMap(this.getRefNumMap());
        strategy.setBizCalcTraceResult(this.getBizCalcTraceResult());
        return strategy;
    }
}

