/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.app.olap.face.IDataFilter;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class DataFilter
implements IDataFilter {
    private static Logger logger = Logger.getLogger(DataFilter.class);

    @Override
    public boolean checkHasFilter(Context ctx, DimensionInfo dimension, String dimFactTable) {
        if (ctx == null || dimension == null || StringUtils.isEmpty((String)dimFactTable)) {
            return false;
        }
        if (DimUtils.checkBaseDimension(dimension.getNumber())) {
            return false;
        }
        BOSObjectType mateType = new MaterialInfo().getBOSType();
        DimensionSourceInfo source = null;
        DimensionSourceCollection colls = dimension.getSrcs();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            source = colls.get(i);
            if (!mateType.equals((Object)BOSObjectType.create((String)source.getSrcID()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String filterBaseDimensionData(Context ctx, IDimensionParameter parameter, IDimension dimension) {
        if (ctx == null || parameter == null || dimension == null) {
            return null;
        }
        String factTable = null;
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            factTable = DimensionConstants.ORG_FACTTABLE_NAME;
        } else if (DimensionConstants.DEF_SCHEME_NUMBER.equals(dimension.getNumber())) {
            factTable = DimensionConstants.SCHEME_FACTTABLE_NAME;
        } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
            factTable = DimensionConstants.PERIOD_FACTTABLE_NAME;
        } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
            factTable = DimensionConstants.ELEMENT_FACTTABLE_NAME;
        } else if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
            factTable = DimensionConstants.CURRENCY_FACTTABLE_NAME;
        }
        return factTable;
    }

    @Override
    public String filterDimensionData(Context ctx, IDimensionParameter parameter, IDimension dimension, String dimFactTable) {
        return dimFactTable;
    }

    private void dealMemberNumber(List<String> dimMember, IMember member) {
        if (dimMember == null || member == null) {
            return;
        }
        if (member.getMdxNumber().indexOf("!") == -1) {
            dimMember.add(member.getDimNumber());
        } else {
            String[] tmpStr = member.getDimNumber().split(":");
            if (tmpStr != null && tmpStr.length == 2) {
                String srcNumber = tmpStr[0];
                String[] mdxNum = member.getMdxNumber().split("!");
                if (mdxNum != null) {
                    int in = mdxNum.length;
                    for (int i = 0; i < in; ++i) {
                        dimMember.add(srcNumber + ":" + mdxNum[i]);
                    }
                }
            }
        }
    }
}

